var basegrid=$('#PubContactOrg_datagrid');
var basetree=$('#PubContactOrgType_tree');
var menutree=$('#contactOrgTree_menu');
var contactType;
//单位主键
var contactOrgId = '';

$(function(){
	//流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubContactOrg();
			}
		}
	});
	$('#conType').combobox({
		editable : false,
		onChange:function(newV,oldV){
			contactType = newV;
			searchPubContactOrg();
		}
	});
	initTree();
	initGrid();
	bindEnterKey("#searchPubContactOrg",searchPubContactOrg)
});

/********************************************往来单位树-start*****************************/
//初始化左侧树
function initTree(){
	basetree.tree({
		height:$("body").height()-165,
		url : ctx + '/PubContactOrgType/treePubContactOrgTypeWithRoot?type='+type,
		onSelect : function(node) {
			searchPubContactOrg(node);
		},
//		onContextMenu: function (e, node) {
//            e.preventDefault();
//        	//右击后选择树
//            var selectnode = basetree.tree('getSelected');
//            if(selectnode !=node){
//                basetree.tree('select',node.target);
//            }
//            
//            menutree.empty();
//            menutree.menu('appendItem', {
//				text: '新增单位类别',
//				iconCls : 'icon-add iconfont blue',
//				onclick: function(){
//					addContactOrgType(node);
//				}
//			});
//            menutree.menu('appendItem', {
//				text: '修改单位类别',
//				iconCls : 'icon-edit iconfont green',
//				onclick: function(){
//					editContactOrgType(node);
//				}
//			});
//            menutree.menu('appendItem', {
//				text: '删除单位类别',
//				iconCls : 'icon-del iconfont red2',
//				onclick: function(){
//					delContactOrgType(node);
//				}
//			});
//            menutree.menu('show', {
//				left : e.pageX,
//				top : e.pageY
//			});
//        },
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('expandAll');
				$(this).tree('expand',root.target);
				$(this).tree('select',root.target);
			}
		}
	});
}


function expandNode(){
	basetree.tree('expandAll');
}

function resetPubContactOrgType(result){
	var selectnode = basetree.tree('getSelected');
//	result = jQuery.parseJSON(result);
	if (result.success) {
		// 获取选中的节点
		var resultnode = basetree.tree('find',
				result.o.contactOrgTypeId);
		if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
			basetree.tree('update', {
				target : selectnode.target,
				text : result.o.contactOrgTypeName

			});
		} else {
			basetree.tree('append', {
				parent : selectnode.target,
				data : [ {
					id : result.o.contactOrgTypeId,
					text : result.o.contactOrgTypeName
				} ]
			});
		}
		alertInfo(result.msg);
		var newnode = basetree.tree('find',
				result.o.contactOrgTypeId);
		basetree.tree('select', newnode.target);
	} else {
		alertError(result.msg);
	}

}
//新增类别维护
function addContactOrgType(node){
	openSaveDialog({
		title : '新增单位类别',
		height : 300,
		width : 400,
		contenturl:'/view/pub/PubContactOrgTypeForm',
		submiturl : '/PubContactOrgType/savePubContactOrgType',
		onload : function(){
			$('#contactOrgTypePid').combotree('setValue',node.id);
			$('#type').val(type);
		},
		callback :resetPubContactOrgType
	})
}

//编辑类别维护
function editContactOrgType(node) {
	if (node) {
		openSaveDialog({
			title : "修改单位类别",
			height : 300,
			width : 400,
			contenturl : "/view/pub/PubContactOrgTypeForm",
			submiturl : "/PubContactOrgType/savePubContactOrgType",
			onload : function(){
				$('#contactOrgType_form').form('load',ctx+"/PubContactOrgType/findPubContactOrgType?id="+node.id);
				$('#type').val(type);
			},
			callback : resetPubContactOrgType
		});
		
	} else {
		alertInfo('请选择一条单位信息进行修改');
	}
}

//删除类别维护
function delContactOrgType(node){
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点级下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/PubContactOrgType/delPubContactOrgTypeAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

/********************************************往来单位树-end*****************************/
function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		height:$("body").height()-140,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		toolbar:"#PubContactOrg_datagrid_tb",
	    url:ctx+'/PubContactOrg/pagePubContactOrg?type='+type,
	    columns:[[
         {
         field:'opt',title:'明细',width:40,align:'center',
         formatter:function(value,row,index){	//value表示字段的值,row行记录数据,index行索引
         return '<div onclick="openFormDetail('+row.contactOrgId+','+row.contactOrgTypeId+',\''+row.orgType+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
         }},
	    {field:'contactOrgId',title:'主键',hidden:true},
	    {field:'contactOrgTypeId',hidden:true},
	    {field:'contactOrgName',title:'单位名称/姓名',width:200,halign:'center',sortable:true},
	    {field:'contactOrgCode',title:'统一单位代码/身份证号',width:120,halign:'center',sortable:true},
		//	另一张表的
	    {field:'areaFullName',title:'注册地',width:120,halign:'center',sortable:true},
	    //{field:'foundDate',title:'成立日期',width:100,align:'center',sortable:true},
	    {field:'contactName',title:'联系人',width:100,halign:'center',sortable:true},
	    {field:'contactTel',title:'联系电话',width:140,halign:'center',sortable:true},
	    {field:'toFinanceCode',title:'对应财务编码',width:100,halign:'center',sortable:true},
	    //{field:'remark',title:'备注',width:180,halign:'center'},
	    {field:'contactTypeText',title:'状态',width:100,halign:'center',align:'center'},
	    {field:'workflowStatusText',title:'审批状态',width:100,halign:'center',align:'center'}
	    ]],
	    onDblClickRow :  function(index, row){
      		//查看明细
  	    	openFormDetail(row.contactOrgId,row.contactOrgTypeId,row.orgType);
  	    }
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubContactOrg_datagrid',"往来单位信息");   
	        }    
	    }]   
	}); 
}


//查看表单明细
function openFormDetail(id,contactOrgTypeId,orgType){
	var contenturl;
	contenturl = "/GenForm/form?formcode=PubContactOrg_dw&isdetail=true&id="+id+"&pk="+ id;
	openDetailDialog({
		title : "查看单位信息",
		maximized : true,
		contenturl:contenturl,
	});

}
function reloadGridPubContactOrg(){
	basegrid.datagrid('reload');
}


//单位和个人展示的datagrid不一样
function searchPubContactOrg(node){
	if(!node){
		node = basetree.tree('getSelected');
	}
//	if(node.contactOrgTypeId=='21'){
//		basegrid.datagrid('hideColumn', 'contactOrgCode');
//		basegrid.datagrid('hideColumn', 'areaFullName');
//		//basegrid.datagrid('hideColumn', 'foundDate');
//		basegrid.datagrid('hideColumn', 'contactName');
//	}else{
//		basegrid.datagrid('showColumn', 'contactOrgCode');
//		basegrid.datagrid('showColumn', 'areaFullName');
//		//basegrid.datagrid('showColumn', 'foundDate');
//		basegrid.datagrid('showColumn', 'contactName');
//	}
	var row = basetree.tree('getSelected');
	basegrid.datagrid('load',{
		search:$("#searchPubContactOrg").val(),
		contactOrgTypeId : row.id,
		contactType :contactType,
		flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
	});
}

//初始化单位类型
function initOrgType(node){
	var node = basetree.tree('getSelected');
	$('#orgType').combobox('setValue','1');
	if (node && node.attributes) {
		if (node.attributes.type == '2') {
			$('#orgType').combobox('setValue','2');
		}
	}
}

function setFormValue(){
	var row = basegrid.datagrid('getSelected');
	//数据请求
	$.ajax({
		type : 'post',
		dataType : 'json',
		url : ctx + "/PubContactOrg/findPubContactOrg?id=" + row.contactOrgId,
		success : function(data) {
			var submitform=$("#PubContactOrg_dw");
			initOrgAccountForm();
			submitform.form('load', data);
		}
	});
}

/******************************************往来单位信息********************************/
//单独保存表单
function saveContactOrg(callback){
	$("#PubContactOrg_dw").form('enableValidation');
	$("#PubContactOrg_dw").form('submit',{
		dataType : 'json',
		method : "POST",
		url : ctx + "/PubContactOrg/saveInitPubContactOrg",
		onSubmit : function() {
			if($(this).form('validate')){
				return true;
			}else{
				return false;
			}
		},
		success : function(result) {
			result=jQuery.parseJSON(result);
			if (result.success) {
				contactOrgId = 	result.o.contactOrgId;
				$('#contactOrgId').val(contactOrgId);
				(callback && typeof(callback) === "function") && callback();
			} else {
				alertError(result.msg);
			}
		}
	});
}

//增加往来单位信息
function addPubContactOrg() {
	var node=basetree.tree('getSelected');
	var str='';
	var orgtype = node.attributes.orgtype;
	str = "initFormValue()";
	if(type==1){
		if(node!=null&&node.id!='0'/*&&node.id!='103'*/){
			var	contenturl = "/GenForm/form?formcode=PubContactOrg_dw&type="+type+"&nodeId="+node.id+"&orgtype="+orgtype;
			var	submiturl = "/PubContactOrg/savePubContactOrg?formcode=PubContactOrg_dw";
			openSaveDialog({
				title:"添加供应商单位信息",
				maximized : true,
				contenturl:contenturl,
				submitType:'single',
				submiturl:submiturl,
				loadScript:str,
				callback:reloadGridPubContactOrg
			});
		}/*else if(node.id=='103'){
			alertInfo("该类别无法新增数据");
		}*/else{
			alertInfo("请选择一条供应商单位");
		}
	}else if(type==2){
		if(node!=null&&node.id!=='0'/*&&node.id!='60'*/){
			var	contenturl = "/GenForm/form?formcode=PubContactOrg_kh&type="+type+"&nodeId="+node.id+"&orgtype="+orgtype;
			var	submiturl = "/PubContactOrg/savePubContactOrg?formcode=PubContactOrg_kh";
			openSaveDialog({
				title:"添加客户管理单位",
				maximized : true,
				contenturl:contenturl,
				submitType:'single',
				submiturl:submiturl,
				loadScript:str,
				callback:reloadGridPubContactOrg
			});
		}/*else if(node.id=='60'){
			alertInfo("该类别无法新增数据");
		}*/else{
			alertInfo("请选择一条客户管理单位");
		}
	}else{
		if(node!=null&&node.id!='0'){
			var	contenturl = "/GenForm/form?formcode=PubContactOrg_dw&type="+type+"&nodeId="+node.id+"&orgtype="+orgtype;
			var	submiturl = "/PubContactOrg/savePubContactOrg?formcode=PubContactOrg_dw";
			openSaveDialog({
				title:"添加供应商单位信息",
				maximized : true,
				contenturl:contenturl,
				submitType:'single',
				submiturl:submiturl,
				loadScript:str,
				callback:reloadGridPubContactOrg
			});
		}else{
			alertInfo("请选择左侧单位类型");
		}
	}
}


//修改往来单位信息
function editPubContactOrg() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
//		if(row.workflowStatus.toString().indexOf('1')!=-1){

			contactOrgId = row.contactOrgId;
			console.log(row);
			type=row.type;
			var contenturl;
			contenturl = "/GenForm/form?formcode=PubContactOrg_dw&id="+contactOrgId+"&type="+type;
			//判断是否是是个人
			if (row.typeOrg == '2') {
				contenturl = "/GenForm/form?formcode=PubContactOrg_kh&id="+contactOrgId+"&type="+type;
			}
			openSaveDialog({
				title : "修改客商单位信息",
				maximized : true,
				contenturl:contenturl,
				submiturl : "/PubContactOrg/savePubContactOrg",
				onload:initForm,
				callback : reloadGridPubContactOrg
			});
//		}else{
//			alertInfo("数据已上报不能修改")
//		}
	} else {
		alertInfo('请选择一条客商单位');
	}
}
//修改往来单位名称。可修改已完成的单位
function editNamePubContactOrg() {
	var row = basegrid.datagrid('getSelected');
	if (row){
		openSaveDialog({
			title : "修改客商单位名称",
			// maximized : true,
			height:560,
			width:750,
			contenturl:"/GenForm/form?formcode=PubNameUsed",
			submiturl : "/PubNameUsed/savePubNameUsed",
			onload : function(){

				$('#PubNameUsed #contactOrgId').val(row.contactOrgId);
				$('#PubNameUsed #nameUsedName').textbox('setValue',row.contactOrgName);

			},
			callback : reloadGridPubContactOrg

		});
	}else {
		alertInfo("请选择一条客商单位");
	}
}

// 删除往来单位信息
function delPubContactOrg() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能删除');
			return;
		}
		var id = row.contactOrgId;
		alertConfirm('将删除该单位,确定?', function(r) {
			if (r) {
				$.ajax({
					url : ctx+ "/PubContactOrg/delPubContactOrg",
						data : {
							id : id
							
						},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的客商单位信息');
	}
}

//拉入黑名单
function pullPubContactOrg() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus==-3){
			alertInfo('数据已经被拉黑,不能再次拉黑');
			return;
		}
		var id = row.contactOrgId;
		var formcode="PubContactOrg_lh";
		alertConfirmYes('将拉黑该往来单位,确定?', function(r) {  //alertConfirmYes选择确定后直接关闭弹窗不会显示操作成功
			if (r) {		
				
				$.ajax({
					type : 'post',
					url : ctx+"/PubContactOrg/pullPubContactOrg",
					async: false,
						data : {
							id : id,
							formcode:formcode
						},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							
							openFlowDialog({
					    		processInstId:result.o.processinstid,
								businessMainId:id,
								formCode:formcode,
								callback:reloadGridPubContactOrg,
								msgtitle:row.contactOrgName
					        });
						} else {
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要拉黑的客商单位信息');
	}
}


/**************************流程**************************************/
function doFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var formCode = "PubContactOrg_dw";
		/*$.ajax({
			type : 'post',
			url : ctx+"/PubContactOrg/initFLow",
			async: false,
			data:{
				contactOrgId : row.contactOrgId,
				formcode : formCode
			},
			dataType : 'json',
			success : function(result) {
				if (result.success) {*/
					openFlowDialog({
			    		processInstId:row.processinstid,
						businessMainId:row.contactOrgId,
						formCode:formCode,
						callback:reloadGridPubContactOrg,
						msgtitle:row.contactOrgName
			        });
				/*}else{
					alertError(result.msg);
				}
			}
		});*/
		
		
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid);
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

/**********************************相关附件*******************************************/
/*******************************名称变更************************************/

function renameContactOrgName(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		//判断是否是个人
		if(row.orgType == '2'){
			alertError("外部个人不能变更!");
			return;
		}else{
			openSaveDialog({
				title : "修改记录",
				contenturl : "/GenForm/form?formcode=PubContactOrgRenameform",
				submiturl : "/PubContactOrgRename/savePubContactOrgRename?formcode=PubContactOrgRenameform",
				onload : orgRenameLoad,
				callback : reloadGridPubContactOrg
			});
		}
	}
}

