var basegrid=$('#PubAdviceFeedback_datagrid');
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubAdviceFeedback();
			}
		}
	});
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		toolbar:"#PubAdviceFeedback_datagrid_tb",
	    url:ctx+'/PubAdviceFeedback/pagePubAdviceFeedback',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.adviceFeedbackId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	   // {field:'adviceFeedbackId',title:'意见反馈ID',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'adviceMonth',title:'反馈月份',width:100,align:'center',halign:'center',sortable:true},
	    {field:'adviceTitle',title:'意见标题',width:100,align:'center',halign:'center',sortable:true},
	    {field:'adviceDate',title:'录入时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'orgIdText',title:'单位名称',width:100,align:'center',halign:'center',sortable:true},
	  //  {field:'deptId',title:'发起部门',width:100,align:'center',halign:'center',sortable:true},
	    {field:'adviceManText',title:'录入人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'adviceContact',title:'联系方式',width:100,align:'center',halign:'center',sortable:true},
	    {field:'adviceContent',title:'意见内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isResolve',hidden:true},
	    {field:'isResolveText',title:'是否已解决',width:100,align:'center',halign:'center',sortable:true},
	    {field:'resolveContent',title:'解决说明',width:100,align:'center',halign:'center',sortable:true},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isUse',hidden:true},
	    //{field:'isUseText',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	   // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	   // {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center',sortable:true},
	   // {field:'modifyAccount',title:'变更人',width:100,align:'center',halign:'center',sortable:true},
	   // {field:'modifyTime',title:'变更时间',width:100,align:'center',halign:'center',sortable:true},
	   // {field:'processinstid',title:'流程实例ID',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatus',hidden:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.adviceFeedbackId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubAdviceFeedback_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubAdviceFeedback&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchPubAdviceFeedback(){
	basegrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		search:$("#searchPubAdviceFeedback").val()
	});
}

//增加记录
function addPubAdviceFeedback() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubAdviceFeedback",
		submiturl:"/PubAdviceFeedback/savePubAdviceFeedback?formcode=PubAdviceFeedback",
		callback:reloadGrid
	});
	
}

//修改记录
function editPubAdviceFeedback() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.adviceFeedbackId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=PubAdviceFeedback&id=" + id,
			submiturl:"/PubAdviceFeedback/savePubAdviceFeedback?formcode=PubAdviceFeedback",
			//onload : "/PubAdviceFeedback/findPubAdviceFeedback?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delPubAdviceFeedback() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.adviceFeedbackId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubAdviceFeedback/delPubAdviceFeedback",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.adviceFeedbackId,
			formCode:"PubAdviceFeedback",
			callback:reloadGrid
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}