var basegrid=$('#GenForm_datagrid');
var basepanelgrid=$('#GenFormPanel_datagrid');
var GenPanelGroupDataGrid=$('#GenPanelGroup_datagrid');
$(function(){
	initGrid();
	initPanelGrid();
	initGenPanelGroupGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		toolbar:"#GenForm_datagrid_tb",
	    url:ctx+'/GenForm/pageGenForm',
	    columns:[[
	    {field:'ID',title:'ID',hidden:true},
	    {field:'FORM_CODE',title:'表单编码',width:120},
	    {field:'FORM_NAME',title:'表单名称',width:120},
	    {field:'FORM_STYLE',title:'样式',width:30,formatter:function(v,row,index){
	    	 if(v=='2'){
	    		return "<a title='oa样式,点击切换默认' onclick='switchFormStyle("+row.ID+",1)'><i class='iconfont icon-oa green'></i></a>"
	    	 }else{
	    		return "<a title='默认样式,点击切换oa' onclick='switchFormStyle("+row.ID+",2)'><i class='iconfont icon-theme blue'></i></a>"
	    	 }
	    }},
		{field:'FORM_TYPE',hidden:true},
//	    {field:'FORM_TYPE_TEXT_',title:'页面类型',width:80},
//	    {field:'CATALOG_NAME',title:'文件目录',width:80},
	    {field:'FLOW_NAME',title:'流程',width:130},
	    {field:'BUSI_TABLE',title:'表名',width:130},
	    {field:'MODEL_NAME',title:'会计凭证业务主题',width:100}
	    ]],
	    onSelect:function(index,row){
	    	basepanelgrid.datagrid('load',{
				formid:row.ID
			});
			$("#eastpanel").panel("clear");
	    }
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}
//增加数据字典
function addGenForm() {
	openSaveDialog({
		title:"新增页面",
		width:500,
		height:470,
		maximized:true,
		contenturl:"/view/gen/GenFormform",
		submiturl:"/GenForm/saveGenForm",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editGenForm() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title:"修改页面",
			width:500,
			height:470,
			maximized:true,
			contenturl : "/view/gen/GenFormform",
			submiturl : "/GenForm/saveGenForm",
			onload : "/GenForm/findGenForm?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}
function switchFormStyle(formId,style){
	alertConfirmYes('确认切换表单样式', function(r) {
		if (r) {
			$.ajax({
				url : ctx+"/GenForm/switchFormStyle",
				data : {
					id : formId,
					style:style
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basegrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
}
//删除数据字典
function delGenForm() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenForm/delGenForm",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
function searchGenForm(){
	basegrid.datagrid('load',{
		search:$("#searchGenForm").val()
	});
}

function initPanelGrid(){
	basepanelgrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		toolbar:"#GenFormPanel_datagrid_tb",
	    url:ctx+'/GenFormPanel/pageGenFormPanelByFormID',
	    columns:[[
	    {field:'PANEL_ID',title:'面板ID',hidden:true},
	    {field:'FORM_ID',title:'表单ID',hidden:true},
	    {field:'PANEL_TITLE',title:'面板标题',width:120},
	    {field:'PANEL_TYPE',hidden:true},
	    {field:'PANEL_TYPE_TEXT_',title:'面板类型',width:120}
	    ]],
	    onSelect:function(index,row){
	    	if(row.PANEL_TYPE==0||row.PANEL_TYPE==3||row.PANEL_TYPE==10){
	    		GenPanelGroupDataGrid.datagrid('clearSelections')
	    		GenPanelGroupDataGrid.datagrid('load',{
	    			panelId:row.PANEL_ID
	    		});
	    		$("#eastpanel").panel("refresh",ctx+"/GenPanelItem/PanelItem?panelid="+row.PANEL_ID);
	    	}else if(row.PANEL_TYPE==1||row.PANEL_TYPE==2||row.PANEL_TYPE==6||row.PANEL_TYPE==7){
	    		$("#eastpanel").panel("refresh",ctx+"/GenPanelItem/PanelFile?panelid="+row.PANEL_ID);
	    	}else{
	    		$("#eastpanel").panel("clear");
	    		$("#eastpanel").panel({
	    			content:"自定义页面的地址为:"+row.PANEL_URL,
	    			href:""
	    		})
	    	}
	    }
	});

}
function reloadpanelGrid(){
	basepanelgrid.datagrid('reload');
}
//增加
function addGenFormPanel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var formid=row.ID;
		openSaveDialog({
			title:"添加记录",
			height:400,
			width:680,
			contenturl:"/view/gen/GenFormPanelform?formId="+row.ID,
			submiturl:"/GenFormPanel/saveGenFormPanel",
			callback:reloadpanelGrid,
			onload:function(){
				$("#formId").val(formid);
			}
		});
	}else {
		alertInfo('请选择一个表单');
	}
	
}

//修改数据字典
function editGenFormPanel() {
	var row = basepanelgrid.datagrid('getSelected');
	if (row) {
		var id = row.PANEL_ID;
		openSaveDialog({
			height:400,
			width:680,
			title : "修改记录",
			contenturl : "/view/gen/GenFormPanelform?formId="+basegrid.datagrid('getSelected').ID,
			submiturl : "/GenFormPanel/saveGenFormPanel",
			onload : "/GenFormPanel/findGenFormPanel?id=" + id,
			callback : reloadpanelGrid
		});
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delGenFormPanel() {
	var row = basepanelgrid.datagrid('getSelected');
	if (row) {
	var id =row.PANEL_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenFormPanel/delGenFormPanel",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basepanelgrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}

function initGenPanelGroupGrid(){
	GenPanelGroupDataGrid.datagrid({
//		fit:true,
		title:"分组",
		height : 400,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
//		pagination:true,
		toolbar:"#GenPanelGroup_datagrid_tb",
	    url:ctx+'/GenPanelGroup/pageGenPanelGroup',
	    columns:[[
//	    {field:'groupId',title:'分组ID',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'panelId',title:'面板ID',width:100,align:'center',halign:'center',sortable:true},
		{field:'panelTitle',title:'面板标题',width:100,align:'center',halign:'center',sortable:true},
	    {field:'groupTitle',title:'分组标题',width:100,align:'center',halign:'center',sortable:true},
	    {field:'displayNo',title:'显示顺序',width:100,align:'center',halign:'center',sortable:true}/*,
	    {field:'isShow',title:'是否显示',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center',sortable:true}*/
	    ]],
	    onSelect:function(index, row){
	    	basepanelitemgrid.datagrid('load',{
	    		panelid:basepanelgrid.datagrid("getSelected").PANEL_ID,
	 			groupId:row.groupId
	 		});
	    },
	    onDblClickRow:function(index, row){
    		//查看明细
			GenPanelGroupFormDetail(row.groupId);
	    }
	});
    GenPanelGroupDataGrid.datagrid('doCellTip');
    var pager = GenPanelGroupDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GenPanelGroup_datagrid',"title");   
	        }    
	    }]   
	});
}
//重新加载表格
function reloadGenPanelGroup(){
	GenPanelGroupDataGrid.datagrid('reload');
}

//增加记录
function addGenPanelGroup() {
	var row = basepanelgrid.datagrid('getSelected');
	if (row&&row.PANEL_TYPE==0) {
		openSaveDialog({
			title:"添加记录",
			height:570,
			width:500,
			contenturl:"/view/gen/GenPanelGroupform",
			submiturl:"/GenPanelGroup/saveGenPanelGroup",
			callback:reloadGenPanelGroup,
			onsubmit:function(param){
				param.groupItems= JSON.stringify($('#groupItem_datagrid').datagrid('getRows'));
				return true;
			},
			onload:function(){
				$("#panelId").val(row.PANEL_ID);
				$("#panelTitle").textbox('setValue',row.PANEL_TITLE);
			}
		});
	}else {
		alertInfo('请选择一个表单面板');
	}
	

}

//修改记录
function editGenPanelGroup() {
	var row = GenPanelGroupDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.groupId;
		openSaveDialog({
			title : "修改记录",
			height:570,
			width:500,
			contenturl:"/view/gen/GenPanelGroupform?panelId="+row.panelId+"&groupId="+row.groupId,
			submiturl:"/GenPanelGroup/saveGenPanelGroup",
			onload : "/GenPanelGroup/findGenPanelGroup?id=" + id,
			callback : reloadGenPanelGroup,
			onsubmit:function(param){
				param.groupItems= JSON.stringify($('#groupItem_datagrid').datagrid('getRows'));
				return true;
			}
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGenPanelGroup() {
	var row = GenPanelGroupDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.groupId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenPanelGroup/delGenPanelGroup",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							GenPanelGroupDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function chooseTable(){
	openChooseDialog({
		title:'选择数据库表',
		contenturl:'/gen/alltable',
		width:400,
		height:500,
		okhandler:function(){
			var row=$("#alltable").datagrid('getSelected');
			if(row){
				$("#busiTable").textbox("setValue",row.code);
				$("#formName").textbox("setValue",row.name);
				$("#formCode").textbox("setValue",row.humpname);
				$("#loaddataUrl").textbox("setValue","/"+row.humpname+"/find"+row.humpname);
				$("#submitUrl").textbox("setValue","/"+row.humpname+"/save"+row.humpname);
				return true;
			}else{
				 alertInfo("请选择表名");
				 return false;
			}
		}
	});
	
}
function copyGenForm(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.ID;
		alertConfirmYes('您是否要拷贝当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenForm/copyGenForm",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请选择一条记录进行拷贝');
	}
}

//默认赋值单位comboUrl
function orgItemChange(v){
	if(v){
		$("#orgCombourl").textbox("setValue","/basorg/getComboOrg");
	}else{
		$("#orgCombourl").textbox('clear');
	}
}