var basegrid=$('#GmSpaceDefine_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GmSpaceDefine_datagrid_tb",
	    url:ctx+'/GmSpaceDefine/pageGmSpaceDefine',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+index+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'spaceType',hidden:true},
	    {field:'spaceTypeText',title:'空间类型',width:70,align:'center',halign:'center',sortable:true},
	    {field:'spaceName',title:'空间名称',width:100,align:'left',halign:'center',sortable:true},
	    {field:'spaceTemplate',title:'空间模板',width:100,align:'center',halign:'center',sortable:true},
	    {field:'creationType',hidden:true},
	    {field:'creationTypeText',title:'空间归属',width:70,align:'center',halign:'center',sortable:true},
	    {field:'orgId',hidden:true},
	    {field:'orgName',title:'所属单位',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isModify',hidden:true},
	    {field:'isModifyText',title:'是否允许自定义',width:50,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(index);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GmSpaceDefine_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(index){
	basegrid.datagrid("selectRow",index);
	var row = basegrid.datagrid('getSelected');
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmSpaceDefine&isdetail=true&id="+row.spaceId,
		onload:function(){
			
		}
	
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchGmSpaceDefine(){
	basegrid.datagrid('load',{
		search:$("#searchGmSpaceDefine").val()
	});
}

//增加记录
function addGmSpaceDefine() {
	openSaveDialog({
		title:"添加记录",	
		/*bottons : [ {
			text : "分配组件",
			id : 'allocate_GmSpaceComponent',
			iconCls : 'icon-page-printer',
			handler : function() {
				allocateGmSpaceComponent();
			}
		}],*/
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmSpaceDefine",
		submiturl:"/GmSpaceDefine/saveGmSpaceDefine?formcode=GmSpaceDefine",
//		contenturl:"/view/business/gm/GmSpaceDefine",
//		submiturl:"/GmSpaceDefine/saveGmSpaceDefine",
		callback:reloadGrid,	
	});
	
}

//修改记录
function editGmSpaceDefine() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.spaceId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GmSpaceDefine&id=" + id,
			submiturl:"/GmSpaceDefine/saveGmSpaceDefine?formcode=GmSpaceDefine",
			callback : reloadGrid,
			onload : function(){
				var n = $('#spaceType').combobox('getValue') ;
					   if(n == '2'){  //领导空间
					     $('#empLv').combobox('setValue','1');
					     setCss($('#useUserId_TEXT_'),'textbox',false,true,false,true,null);
					     //setCss($('#deptId'),'combotree',false,true,false,true,null);
					     //setCss($('#orgId'),'combotree',false,false,true,false,null);
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					   }else if(n == '3'){  //部门空间
					     $('#empLv').combobox('setValue','2');
					     setCss($('#useUserId_TEXT_'),'textbox',false,true,false,true,null);
					    // setCss($('#deptId'),'combotree',false,false,true,false,null);
					     //setCss($('#orgId'),'combotree',false,false,true,false,null);
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					   }else if(n == '4'){  //员工空间
					    $('#empLv').combobox('setValue','3');
					     setCss($('#useUserId_TEXT_'),'textbox',false,true,false,true,null);
					     //setCss($('#deptId'),'combotree',false,true,false,true,null);
					    // setCss($('#orgId'),'combotree',false,false,true,false,null);
					     setCss($('#menuId'),'combotree',false,false,true,false,null);
					  }else if(n == '5'){  //栏目空间
						     setCss($('#useUserId_TEXT_'),'textbox',false,false,false,false,null);
						    // setCss($('#deptId'),'combotree',false,false,false,false,null);
						    // setCss($('#orgId'),'combotree',false,false,false,false,null);
						     setCss($('#menuId'),'combotree',false,false,true,false,null);
						  }else{
					    $('#empLv').combobox('setValue',''); 
					    setCss($('#useUserId_TEXT_'),'textbox',false,false,true,false,null);
					    setCss($('#menuId'),'combotree',false,true,false,true,null);
					    if(n == '0'){ 
					      //setCss($('#orgId'),'combotree',false,true,false,true,null);
					      //setCss($('#deptId'),'combotree',false,true,false,true,null);
					    }
					 }
			}
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGmSpaceDefine() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.spaceId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GmSpaceDefine/delGmSpaceDefine",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}


//空间布局,  同时可以在预览中修改组件的顺序
function allocateSpace(){
	var row = basegrid.datagrid('getSelected');
	if(row){
		var url = ctx+"/GmSpaceDefine/previewSpaceDrag?spaceId=" +row.spaceId;
		window.open(url);
	}else{
		alertInfo('请先选择一条数据信息');
		return false;
	}
}

//空间预览
function previewSpace(){
	var row = basegrid.datagrid('getSelected');
	if(row){
		var url = ctx+"/GmSpaceDefine/priewSpace?spaceId=" +row.spaceId;
		window.open(url);
	}else{
		alertInfo('请先选择一条数据信息');
		return false;
	}
}


