var basegrid=$('#GmInfoRead_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GmInfoRead_datagrid_tb",
	    url:ctx+'/GmInfoRead/pageGmInfoRead',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.readId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'readId',title:'readId',width:100,align:'center',halign:'center'},
	    {field:'infoId',title:'infoId',width:100,align:'center',halign:'center'},
	    {field:'accountId',title:'阅读人',width:100,align:'center',halign:'center'},
	    {field:'readDate',title:'阅读时间',width:100,align:'center',halign:'center'},
	    {field:'infoSource',title:'信息来源',width:100,align:'center',halign:'center'},
	    {field:'orgId',title:'orgId',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.readId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GmInfoRead_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoRead&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchGmInfoRead(){
	basegrid.datagrid('load',{
		search:$("#searchGmInfoRead").val()
	});
}

//增加记录
function addGmInfoRead() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoRead",
		submiturl:"/GmInfoRead/saveGmInfoRead?formcode=GmInfoRead",
//		contenturl:"/view/business/gm/GmInfoRead",
//		submiturl:"/GmInfoRead/saveGmInfoRead",
		callback:reloadGrid
	});
	
}

//修改记录
function editGmInfoRead() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.readId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GmInfoRead&id=" + id,
			submiturl:"/GmInfoRead/saveGmInfoRead?formcode=GmInfoRead",
//			contenturl : "/view/business/gm/GmInfoRead",
//			submiturl : "/GmInfoRead/saveGmInfoRead",
//			onload : "/GmInfoRead/findGmInfoRead?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGmInfoRead() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.readId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GmInfoRead/delGmInfoRead",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
