var GmInfoPraiseDataGrid=$('#GmInfoPraise_datagrid');
$(function(){
	initGmInfoPraiseGrid();
});

function initGmInfoPraiseGrid(){
	GmInfoPraiseDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GmInfoPraise_datagrid_tb",
	    url:ctx+'/GmInfoPraise/pageGmInfoPraise',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="GmInfoPraiseFormDetail('+row.praiseId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'praiseId',title:'主键ID',width:100,align:'center',halign:'center'},
	    {field:'infoId',title:'信息ID',width:100,align:'center',halign:'center'},
	    {field:'accountId',title:'操作人ID',width:100,align:'center',halign:'center'},
	    {field:'operateDate',title:'操作时间',width:100,align:'center',halign:'center'},
	    {field:'infoSource',title:'来源',width:100,align:'center',halign:'center'},
	    {field:'orgId',title:'所属单位',width:100,align:'center',halign:'center'},
	    {field:'deptId',title:'所属部门',width:100,align:'center',halign:'center'},
	    {field:'relateId',title:'收藏关联ID',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center'},
	    {field:'isUse',hidden:true},
	    {field:'isUseText',title:'使用状态',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'变更人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'变更时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			GmInfoPraiseFormDetail(row.praiseId);
	    }
	});
    GmInfoPraiseDataGrid.datagrid('doCellTip');
    var pager = GmInfoPraiseDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GmInfoPraise_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function GmInfoPraiseFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoPraise&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGmInfoPraise(){
	GmInfoPraiseDataGrid.datagrid('reload');
}
//查询表格
function searchGmInfoPraise(){
	GmInfoPraiseDataGrid.datagrid('load',{
		search:$("#searchGmInfoPraise").val()
	});
}

//增加记录
function addGmInfoPraise() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoPraise",
		submiturl:"/GmInfoPraise/saveGmInfoPraise?formcode=GmInfoPraise",
//		contenturl:"/view/business/gm/GmInfoPraise",
//		submiturl:"/GmInfoPraise/saveGmInfoPraise",
		callback:reloadGmInfoPraise
	});
	
}

//修改记录
function editGmInfoPraise() {
	var row = GmInfoPraiseDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.praiseId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GmInfoPraise&id=" + id,
			submiturl:"/GmInfoPraise/saveGmInfoPraise?formcode=GmInfoPraise",
//			contenturl : "/view/business/gm/GmInfoPraise",
//			submiturl : "/GmInfoPraise/saveGmInfoPraise",
//			onload : "/GmInfoPraise/findGmInfoPraise?id=" + id,
			callback : reloadGmInfoPraise
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGmInfoPraise() {
	var row = GmInfoPraiseDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.praiseId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GmInfoPraise/delGmInfoPraise",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							GmInfoPraiseDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
