var GmInfoCommentDataGrid=$('#GmInfoComment_datagrid');
$(function(){
	initGmInfoCommentGrid();
});

function initGmInfoCommentGrid(){
	GmInfoCommentDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GmInfoComment_datagrid_tb",
	    url:ctx+'/GmInfoComment/pageGmInfoComment',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="GmInfoCommentFormDetail('+row.commentId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'commentId',title:'评论ID',width:100,align:'center',halign:'center'},
	    {field:'infoId',title:'新闻ID',width:100,align:'center',halign:'center'},
	    {field:'commentPid',title:'评论父ID',width:100,align:'center',halign:'center'},
	    {field:'commentBy',title:'评论人',width:100,align:'center',halign:'center'},
	    {field:'commentDate',title:'评论时间',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center'},
	    {field:'isUse',hidden:true},
	    {field:'isUseText',title:'使用状态',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'变更人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'变更时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			GmInfoCommentFormDetail(row.commentId);
	    }
	});
    GmInfoCommentDataGrid.datagrid('doCellTip');
    var pager = GmInfoCommentDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GmInfoComment_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function GmInfoCommentFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoComment&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGmInfoComment(){
	GmInfoCommentDataGrid.datagrid('reload');
}
//查询表格
function searchGmInfoComment(){
	GmInfoCommentDataGrid.datagrid('load',{
		search:$("#searchGmInfoComment").val()
	});
}

//增加记录
function addGmInfoComment() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmInfoComment",
		submiturl:"/GmInfoComment/saveGmInfoComment?formcode=GmInfoComment",
//		contenturl:"/view/business/gm/GmInfoComment",
//		submiturl:"/GmInfoComment/saveGmInfoComment",
		callback:reloadGmInfoComment
	});
	
}

//修改记录
function editGmInfoComment() {
	var row = GmInfoCommentDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.commentId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GmInfoComment&id=" + id,
			submiturl:"/GmInfoComment/saveGmInfoComment?formcode=GmInfoComment",
//			contenturl : "/view/business/gm/GmInfoComment",
//			submiturl : "/GmInfoComment/saveGmInfoComment",
//			onload : "/GmInfoComment/findGmInfoComment?id=" + id,
			callback : reloadGmInfoComment
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGmInfoComment() {
	var row = GmInfoCommentDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.commentId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GmInfoComment/delGmInfoComment",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							GmInfoCommentDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
