var basegrid=$('#BasRoles_datagrid');

$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasRoles_datagrid_tb",
	    url:ctx+'/BasRoles/pageBasRoles',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',hidden:true},
	    {field:'ROLE_CODE',title:'角色编码',width:100},
	    {field:'ROLE_NAME',title:'角色名称',width:100},
	    {field:'ROLE_TYPE',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',width:100},
//	    {field:'ORG_ID',title:'组织机构ID'},
//	    {field:'IS_USE',title:'是否使用'},
	    {field:'DISPLAY_NO',title:'显示顺序',width:100},
	    {field:'REMARK',title:'备注',width:150}
	    ]]
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasRoles_datagrid',"角色信息");   
	        }    
	    }]   
	}); 
}

function reloadGrid(){
	basegrid.datagrid('reload',{
		search:$("#searchBasRoles").val()
	});
}

function searchBasRoles(){
	reloadGrid();
}

//增加数据字典
function addBasRoles() {
	openSaveDialog({
		title:"添加角色",
		contenturl:"/view/base/BasRolesform",
		submiturl:"/BasRoles/saveBasRoles",
		onload:function(){
		},
		callback:reloadGrid
	});
	
}

//修改数据字典
function editBasRoles() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ROLE_ID;
		openSaveDialog({
			title : "修改角色",
			contenturl : "/view/base/BasRolesform",
			submiturl : "/BasRoles/saveBasRoles",
			onload : "/BasRoles/findBasRoles?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delBasRoles() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ROLE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasRoles/delBasRoles",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
