var basegrid=$('#BasModel_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasModel_datagrid_tb",
	    url:ctx+'/BasModel/pageBasModel',
	    columns:[[
	    {field:'MODEL_ID',title:'modelId',hidden:true},
	    {field:'MODEL_TITLE',title:'模块标题',width:200,align:'left'},
	    {field:'MODEL_TYPE',hidden:true},
	    {field:'MODEL_TYPE_TEXT_',title:'模块类型',width:100,align:'center',halign:'center'},
	    {field:'MODEL_URL',title:'模块地址',width:400,align:'left'},
	    {field:'MODEL_WIDTH',title:'模块宽度',width:80,align:'center',halign:'center',formatter: function(value,row,index){
					return value+"/12";
			}
		},
	    {field:'MEMO',title:'备注',width:100,align:'center',halign:'center'}
	    ]]
	});

}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasModel(){
	basegrid.datagrid('load',{
		search:$("#searchBasModel").val()
	});
}

//增加记录
function addBasModel() {
	openSaveDialog({
		title:"添加记录",
		height:400,
		width:500,
		contenturl:"/view/base/BasModelform",
		submiturl:"/BasModel/saveBasModel",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasModel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.MODEL_ID;
		openSaveDialog({
			title : "修改记录",
			height:400,
		width:500,
			contenturl : "/view/base/BasModelform",
			submiturl : "/BasModel/saveBasModel",
			onload : "/BasModel/findBasModel?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasModel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.MODEL_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasModel/delBasModel",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function formatmenuCss(row){
	var s = '<span style="font-weight:bold">' + row.text + '</span><br/>' +
	'<a style="display:inline-block; width:80px;height:80px" class="'+row.text+'"></a>';
    return s;
}