var basegrid=$('#BasMessageReceive_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasMessageReceive_datagrid_tb",
	    url:ctx+'/BasMessageReceive/pageBasMessageReceive',
	    columns:[[
	    {field:'RECIVE_ID',title:'reciveId'},
	    {field:'MSG_ID',title:'msgId'},
	    {field:'ACCOUNT_ID',title:'帐套ID'},
	    {field:'IS_DEAL',title:'是否处理'},
	    {field:'IS_READ',title:'是否已读'},
	    {field:'READ_TIME',title:'读取时间'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchBasMessageReceive(){
	basegrid.datagrid('load',{
		search:$("#searchBasMessageReceive").val()
	});
}

//增加数据字典
function addBasMessageReceive() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasMessageReceiveform",
		submiturl:"/BasMessageReceive/saveBasMessageReceive",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editBasMessageReceive() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.RECIVE_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasMessageReceiveform",
			submiturl : "/BasMessageReceive/saveBasMessageReceive",
			onload : "/BasMessageReceive/findBasMessageReceive?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delBasMessageReceive() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.RECIVE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMessageReceive/delBasMessageReceive",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
