var BasEmprecordQueryDataGrid=$('#BasEmprecordQuery_datagrid');
$(function(){
	initBasEmprecordQueryGrid();
});

function initBasEmprecordQueryGrid(){
	BasEmprecordQueryDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasEmprecordQuery_datagrid_tb",
	    url:ctx+'/BasEmprecordQuery/pageBasEmprecordQuery',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasEmprecordQueryFormDetail('+row.emprecordQueryId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	//    {field:'emprecordQueryId',title:'主键ID',width:100,align:'center',halign:'center'},
	//    {field:'isAllText',title:'是否全部授权',width:80,align:'center',halign:'center'},
	    {field:'scopeName',title:'授权范围',width:200,align:'center',halign:'center'},
		{field:'status',title:'状态',width:60,align:'center',halign:'center',formatter:function(value,row,index){
				if(value=="Y"){
					return "生效";
				}else if(value=="N"){
					return "注销";
				}else{
					return "未生效";
				}
			}},
	    {field:'remark',title:'说明',width:100,align:'center',halign:'center'},
		{field:'startDate',title:'启动日期',width:100,align:'center',halign:'center'},
	    {field:'endDate',title:'停用日期',width:100,align:'center',halign:'center'}
	    // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    // {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    // {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center'},
	    // {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center'},
	    // {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.emprecordQueryId);
	    }
	});
    BasEmprecordQueryDataGrid.datagrid('doCellTip');
    var pager = BasEmprecordQueryDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasEmprecordQuery_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasEmprecordQueryFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmprecordQuery&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasEmprecordQuery(){
	BasEmprecordQueryDataGrid.datagrid('reload');
}
//查询表格
function searchBasEmprecordQuery(){
	BasEmprecordQueryDataGrid.datagrid('load',{
		search:$("#searchBasEmprecordQuery").val()
	});
}

//增加记录
function addBasEmprecordQuery() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmprecordQuery",
		submiturl:"/BasEmprecordQuery/saveBasEmprecordQuery?formcode=BasEmprecordQuery",
//		contenturl:"/view/base/BasEmprecordQuery",
//		submiturl:"/BasEmprecordQuery/saveBasEmprecordQuery",
		callback:reloadBasEmprecordQuery
	});
	
}

//修改记录
function editBasEmprecordQuery() {
	var row = BasEmprecordQueryDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.emprecordQueryId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasEmprecordQuery&id=" + id,
			submiturl:"/BasEmprecordQuery/saveBasEmprecordQuery?formcode=BasEmprecordQuery",
//			contenturl : "/view/base/BasEmprecordQuery",
//			submiturl : "/BasEmprecordQuery/saveBasEmprecordQuery",
//			onload : "/BasEmprecordQuery/findBasEmprecordQuery?id=" + id,
			callback : reloadBasEmprecordQuery,
			onload : function(){
				$("#scope_TEXT_").textbox('setValue',row.scopeName);
			}
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasEmprecordQuery() {
	var row = BasEmprecordQueryDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.emprecordQueryId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasEmprecordQuery/delBasEmprecordQuery",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasEmprecordQueryDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}


function updateStatus(status){
	var row= BasEmprecordQueryDataGrid.datagrid('getSelected');
	if(row){
		if(status=="Y"&&status==row.status){
			alertError("已生效的数据不要重复生效");
		}else if(status=="N"&&status==row.status){
			alertError("已注销的数据不要重复注销");
		}
		$.ajax({
			url : ctx+"/BasEmprecordQuery/updateStatus",
			data : {
				id:row.emprecordQueryId,
				status:status
			},
			type : "post",
			dataType : "json",
			success : function(data) {
				if (data.success) {
					reloadBasEmprecordQuery();
				}else{
					if(status=="Y"){
						alertError("操作失败，已存在生效的授权人");
					}else{
						alertError("操作失败");
					}

				}
			}
		})
	}else{
		alertError("请先选择一条数据");
	}
}