var accountgrid=$('#BasContactOrgAccount_datagrid');

/****************************初始化***********************************/
$(function(){
	initContactOrgAccount();
});

/***********************单位账号信息模块***********************************/
function initContactOrgAccount(){
	accountgrid.datagrid({
//		fit:true,
		height : '400px',
		border:false,
		singleSelect:true,
		rownumbers:true,
//		fitColumns:true,
		pagination:true,
		toolbar:"#BasContactOrgAccount_datagrid_tb",
	    url:ctx+'/BasContactOrgAccount/pageBasContactOrgAccount',
	    queryParams: {
	    	search:$("#searchBasContactOrgAccount").val(),
			contactOrgId : contactOrgId
		},
	    columns:[[
		    {field:'ORG_ACCOUNT_ID',title:'主键',width:100,align:'center',halign:'center',hidden:true},
		    {field:'CONTACT_ORG_ID',title:'往来单位主键',width:100,align:'center',halign:'center',hidden:true},
		    {field:'ORG_USERNAME',title:'户名',width:100,align:'center',halign:'center'},
		    {field:'ORG_BANK_ACCOUNT',title:'银行账号',width:100,align:'center',halign:'center'},
		    {field:'ORG_OPEN_BANK',title:'开户行',width:100,align:'center',halign:'center'},
		    {field:'ORG_UNIONPAY_NO',title:'银联号',width:100,align:'center',halign:'center'},
		    {field:'STATUS_TEXT_',title:'状态',width:100,align:'center',halign:'center'},
		    {field:'MEMO',title:'备注',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow : editBasContactOrgAccount
	});
}

function reloadAccountGrid(){
	accountgrid.datagrid('reload');
}

function searchBasContactOrgAccount(){
	accountgrid.datagrid('load',{
		search:$("#searchBasContactOrgAccount").val(),
		contactOrgId : contactOrgId
	});
}

function initAccountForm(){
	$('#acontactOrgId').val(contactOrgId);
}

//增加账号信息
function addBasContactOrgAccount() {
	openSaveDialog({
		title:"添加账号信息",
		contenturl:"/view/base/BasContactOrgAccountform",
		submiturl:"/BasContactOrgAccount/saveBasContactOrgAccount",
		submitbtn : 'BasContactOrgAccount_Form',
		onload : initAccountForm,
		callback:searchBasContactOrgAccount
	});
	
}

//修改账号信息
function editBasContactOrgAccount() {
	var row = accountgrid.datagrid('getSelected');
	if (row) {
		var id = row.ORG_ACCOUNT_ID;
		openSaveDialog({
			title : "修改账号信息",
			contenturl : "/view/base/BasContactOrgAccountform",
			submiturl : "/BasContactOrgAccount/saveBasContactOrgAccount",
			onload : "/BasContactOrgAccount/findBasContactOrgAccount?id=" + id,
			submitbtn : 'BasContactOrgAccount_Form',
			callback : reloadAccountGrid
		});
		
	} else {
		alertInfo('请选择一条账号信息进行修改');
	}
}

//删除账号信息
function delBasContactOrgAccount() {
	var row = accountgrid.datagrid('getSelected');
	if (row) {
		var id =row.ORG_ACCOUNT_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasContactOrgAccount/delBasContactOrgAccount",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							accountgrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的账号信息');
	}
}

