package ${table.bizpack}.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.controller.BaseController;

import ${table.bizpack}.entity.${table.entityName};
import ${table.bizpack}.service.${table.entityName}Service;

/**   
 * @Title: Controller
 * @Description: ${table.description}
 * @author sys
 * @date ${table.date}
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/${table.entityName}")
public class ${table.entityName}Controller extends BaseController {

	@Autowired
	private ${table.entityName}Service ${table.entityName?uncap_first}Service;
	

	/**
	 * 分页查询数据,带分页和模糊搜索
	 */
	@RequestMapping(value="/page${table.entityName}")
	@ResponseBody
	public Object page${table.entityName}(@RequestParam(value="search",defaultValue="") String search,@RequestParam(value="page",defaultValue="1") int page,@RequestParam(value="rows",defaultValue="50")  int rows) {
		return ${table.entityName?uncap_first}Service.PageAll(search,page,rows);
	}

	/**
	 * 查找单条数据
	 */
	@RequestMapping(value = "/find${table.entityName}")
	@ResponseBody
	public Object find${table.entityName}( Long id) {
		return ${table.entityName?uncap_first}Service.find${table.entityName}(id);
	}


	/**
	 * 保存数据
	 */
	@RequestMapping(value = "/save${table.entityName}")
	@ResponseBody
	public Object save${table.entityName}(${table.entityName} entity,HttpServletRequest request) {
		JsonMsg msg=new JsonMsg();
		entity.setModifyAccount(getLoginUser(request).getAccountid());
		entity.setModifyTime(new Date());
		entity.setIsUse(SysContent.IS_USE_Y);
		${table.entityName?uncap_first}Service.save${table.entityName}(entity);
		msg.setO(entity);
		return msg;
	}
	
	
	/**
	 * 删除数据
	 */
	@RequestMapping(value = "/del${table.entityName}")
	@ResponseBody
	public Object del${table.entityName}(Long id) {
		${table.entityName} entity=${table.entityName?uncap_first}Service.find${table.entityName}(id);
		${table.entityName?uncap_first}Service.del${table.entityName}(id);//直接删除
		${table.entityName?uncap_first}Service.save${table.entityName}(entity);
		return new JsonMsg();
	}
	
	/**
	 * 查询树形结构会自动构造一个空的根节点方便维护界面的添加新节点
	 */
	@RequestMapping(value="/tree${table.entityName}WithRoot")
	@ResponseBody
	public Object tree${table.entityName}WithRoot(@RequestParam(value="pid",defaultValue="0") Long pid, Long detailId) {
		List<ComBoxTreeNode> treelist = ${table.entityName?uncap_first}Service.tree${table.entityName}(pid);
			ComBoxTreeNode root=new ComBoxTreeNode();

			if (detailId != null) {// 明细使用

			}
			root.setId("0"); 
			root.setText("根节点");
			root.setChecked(false); 
			root.setChildren(treelist);
			List<ComBoxTreeNode> list=new ArrayList<ComBoxTreeNode>();
			list.add(root);
			return list;
	}
	
	/**
	 * 查询树形结构
	 */
	@RequestMapping(value="/tree${table.entityName}")
	@ResponseBody
	public Object tree${table.entityName}(@RequestParam(value="pid",defaultValue="0") Long pid, Long detailId) {


		List<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
		ComBoxTreeNode root = new ComBoxTreeNode();
		if (detailId != null) {// 明细使用
		}

		return ${table.entityName?uncap_first}Service.tree${table.entityName}(pid);
	}
	
	/**
	 * 删除数据
	 */
	@RequestMapping(value = "/del${table.entityName}AndChild")
	@ResponseBody
	public Object del${table.entityName}AndChild(Long id) {
		${table.entityName?uncap_first}Service.del${table.entityName}AndChild(id);
		return new JsonMsg();
		
	}
}
