package ${table.bizpack}.service;

import java.util.*;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.BasMessageService;
import ${table.bizpack}.dao.${table.entityName}Dao;
import ${table.bizpack}.entity.${table.entityName};
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.workflow.service.FlowUtilService;

/**   
 * @Title: Service
 * @Description: ${table.description}
 * @author sys
 * @date ${table.date}
 * @version V1.0   
 *
 */
@Component
@Transactional
public class ${table.entityName}Service{
	
	@Autowired
	private BeetlSQLHelper bSqlHelper;
	@Autowired
	private BasMessageService msgService;
	@Autowired
	private ${table.entityName}Dao ${table.entityName?uncap_first}Dao;
	@Autowired
	private DocFormFileService docFormFileService;
	@Autowired
	private FlowUtilService flowUtilService;
	//根据ID查找实体bean
	public ${table.entityName} find${table.entityName}(Long id){
		${table.entityName} entity=${table.entityName?uncap_first}Dao.findById(id).get();
		return entity;
	}
	
	//持久化实体bean
	public void save${table.entityName}(${table.entityName} entity){
		${table.entityName?uncap_first}Dao.save(entity);
	}
	//持久化实体bean 带附件
	public void save${table.entityName}(${table.entityName} entity,FormFileBean formfile){
		${table.entityName?uncap_first}Dao.save(entity);
		//保存附件信息
		if(formfile!=null){
		    <#list table.columns as po>
		    <#if po.fieldDbName == table.pk>
			formfile.setPrimaryKey(entity.get${po.fieldName?cap_first}());
			</#if>
			</#list>
			formfile.setAccountid(entity.getModifyAccount());
			docFormFileService.SaveFormFileBean(formfile);
		}
	}
	//删除实体bean  
	public void del${table.entityName}(Long id){
		${table.entityName} entity=${table.entityName?uncap_first}Dao.findById(id).get();
		entity.setIsUse(SysContent.IS_USE_N);
		entity.setModifyTime(new Date());
		${table.entityName?uncap_first}Dao.save(entity);
		
		//删除待办消息
		msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
	}
	
	public PageObject PageAll(Long flowDone,String search,String startDate,String endDate,String applyPerson,String applyDept,int page,int rows,String sort,String order){
		Map<String, Object> params =  new HashMap<String, Object>();
		if(!StringUtils.isEmpty(search)){
			params.put("search", "%"+search.toUpperCase()+"%");
		}
		if(!StringUtils.isEmpty(sort)){
			params.put("sort", DBPropertyUtil.underscoreName(sort));
		}
		if(!StringUtils.isEmpty(order)){
			params.put("order", order);
		}
		if (flowDone != null){
			params.put("flowsql"," and t.processinstid in ("+flowUtilService.queryDealedProcess("${table.entityName}",flowDone)+") \n");
		}
		if(!StringUtils.isEmpty(startDate)){
			params.put("startDate", startDate);
		}
		if(!StringUtils.isEmpty(endDate)){
			params.put("endDate", endDate);
		}
		if(!StringUtils.isEmpty(applyPerson)){
			params.put("applyPerson", "%"+applyPerson.toUpperCase().replace("%", "/%")+"%");
		}
		if(applyDept!=null){
			params.put("applyDept", applyDept);

		}
		return bSqlHelper.serachPage("${table.bizpack?replace('com.ustc.','')}.${table.entityName}.select", params,PageRequest.of(page, rows));
	}
	
}