var ${table.entityName}DataGrid=$('#${table.entityName}_datagrid');
$(function(){
	init${table.entityName}Grid();
});

function init${table.entityName}Grid(){
	${table.entityName}DataGrid.datagrid({
		height:$("body").height()-200,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#${table.entityName}_datagrid_tb",
	    url:ctx+'/${table.entityName}/page${table.entityName}',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="${table.entityName}FormDetail('+row.${table.pkHump}+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    <#list table.columns as po>
	    <#if (po.fieldDic?exists)>
	    {field:'${po.fieldName}',hidden:true},
	    {field:'${po.fieldName}Text',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center',sortable:true}<#if po_has_next >,</#if>
	    <#else>
	    {field:'${po.fieldName}',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center',sortable:true}<#if po_has_next >,</#if>
	    </#if>
	    </#list>
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			${table.entityName}FormDetail(row.${table.pkHump});
	    }
	});
    ${table.entityName}DataGrid.datagrid('doCellTip');
    var pager = ${table.entityName}DataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('${table.entityName}_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function ${table.entityName}FormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=${table.entityName}&isdetail=true&id="+id
	});
}
//重新加载表格
function reload${table.entityName}(){
	${table.entityName}DataGrid.datagrid('reload');
}
//查询表格
function search${table.entityName}(){
	${table.entityName}DataGrid.datagrid('load',{
		search:$("#search${table.entityName}").val(),
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		applyPerson: $("#applyPerson").textbox('getValue'),
		applyDept :$("#applyDept").combobox('getValue')
	});
}

//增加记录
function add${table.entityName}() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=${table.entityName}",
		submiturl:"/${table.entityName}/save${table.entityName}?formcode=${table.entityName}",
//		contenturl:"/view/${table.viewpath}/${table.entityName}",
//		submiturl:"/${table.entityName}/save${table.entityName}",
		callback:reload${table.entityName}
	});
	
}

//修改记录
function edit${table.entityName}() {
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
		var id = row.${table.pkHump};
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=${table.entityName}&id=" + id,
			submiturl:"/${table.entityName}/save${table.entityName}?formcode=${table.entityName}",
//			contenturl : "/view/${table.viewpath}/${table.entityName}",
//			submiturl : "/${table.entityName}/save${table.entityName}",
//			onload : "/${table.entityName}/find${table.entityName}?id=" + id,
			callback : reload${table.entityName}
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function del${table.entityName}() {
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
	var id =row.${table.pkHump};
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/${table.entityName}/del${table.entityName}",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							${table.entityName}DataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
