package ${table.bizpack}.entity;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.springframework.format.annotation.DateTimeFormat;
import com.alibaba.fastjson.annotation.JSONField;

/**   
 * @Title: Entity
 * @Description: ${table.description}
 * @author sys
 * @date ${table.date}
 * @version V1.0   
 *
 */
@Entity
@Table(name = "${table.tablename}")
@SuppressWarnings("serial")
public class ${table.entityName} implements java.io.Serializable {
	<#list table.columns as po>
	/** ${po.fieldName} ${po.filedComment!""} ${po.fieldTitle!}  ${po.fieldDic!} */
	<#if po.fieldType== 'Date'>
	@DateTimeFormat(pattern="yyyy-MM-dd")//前台数据注入到后台时设置转换格式
	@JSONField(format="yyyy-MM-dd")//从后台json化到前台时format成的字符串的格式
	private ${po.fieldType} ${po.fieldName};
	<#else>
	private ${po.fieldType} ${po.fieldName};
	</#if>
	</#list>
	
	<#list table.columns as po>
	/**
	 *方法: 取得 ${po.filedComment!""} ${po.fieldTitle!} ${po.fieldName} ${po.fieldType}
	 *@return: ${po.fieldType}  ${po.filedComment!""} 字典[${po.fieldDic!}]
	 */
	<#if po.fieldDbName == table.pk>
	
	@Id
	@GeneratedValue(strategy = GenerationType.TABLE,generator="${table.tablename}")
	@TableGenerator(name="${table.tablename}",allocationSize=20)
	</#if>
	<#if po.fieldType== 'Date'>
	@Temporal(TemporalType.TIMESTAMP)
	</#if>
	@Column(name ="${po.fieldDbName}",nullable=<#if po.nullable == 'Y'>true<#else>false</#if><#if po.precision != ''>,precision=${po.precision}</#if><#if po.scale != ''>,scale=${po.scale}</#if><#if po.dataLength != ''>,length=${po.dataLength}</#if>)
	public ${po.fieldType} get${po.fieldName?cap_first}(){
		return this.${po.fieldName};
	}

	/**
	 *方法: 设置 ${po.filedComment!""} ${po.fieldTitle!}  ${po.fieldName} ${po.fieldType} 字典[${po.fieldDic!}]
	 *@param: ${po.fieldType}  ${po.filedComment!""}
	 */
	public void set${po.fieldName?cap_first}(${po.fieldType} ${po.fieldName}){
		this.${po.fieldName} = ${po.fieldName};
	}
	</#list>
}
