getMyFlowDrafts
===
with form as
 (select b.form_code,
		 f.busi_table,
         ifnull(p2.design_name, p.design_name) design_name,
         ifnull(p2.flow_name, p.flow_name) flow_name,
         y.name,
         y.res_id,
         ifnull(p2.display_no,p.display_no)  display_no
    from bas_menu_button b
    left join bas_menu e
      on e.menu_id = b.menu_id
    left join gen_form f
      on f.form_code = b.form_code
     and f.is_use = 'Y'
    left join stf_business_process p
      on p.design_name = f.flow_code
    left join gen_form_flow o
      on o.form_id = f.id
     and o.apply_orgs =  #loginuser.orgid#
    left join stf_business_process p2
      on p2.design_name = o.flow_code
    left join STF_BUSINESS_TYPE y
      on f.flow_cat_id = y.res_id
   where (b.is_control = 'N' or
         b.button_id in
         (select m.button_id
             from bas_roles_menu m
            where m.role_id in (select b.role_Id
                                  from Bas_Roles_Account b
                                 where b.account_Id =  #loginuser.accountid#)
              and m.button_id is not null))
     and b.form_code is not null
     and (f.flow_code is not null or exists
          (select 1
             from gen_form_flow o
            where o.form_id = f.id
              and o.org_id = #loginuser.orgid#
              and o.is_use = 'Y'))
     and y.name is not null)
select @pageTag(){
	form.*, 
	DATE_FORMAT(i.createtime,'%Y-%m-%d %H:%i:%s') createtime,
	getaccountname(i.creator) creator,
	getBusiMainId(form.busi_table,i.processinstid) pk
	@}
  from form, wf_processinst i 
 where i.processinstname = form.design_name
   and i.currentstate in ('4', '10')
   and not exists
 (select 1 from bas_message s where s.processinstid = i.processinstid)
 and i.creator=#loginuser.accountid#
 @if(!isEmpty(createDate)){
 and DATE_FORMAT(i.createtime,'%Y-%m-%d')=#createDate#
@}
@if(!isEmpty(flowname)){
 and form.flow_Name like #flowname#
@}
 order by createtime desc

 
getHrStation
===
select station from hr_Emp h where h.emp_id = #empId#
 
getHrEmpName
===
select emp_name from hr_Emp h where h.emp_id = #empId#

getHrEmp
===
SELECT
	*, 
	DATE_FORMAT(H.BIRTHDAY,'%Y-%m-%d') BIRTHDAY_FMT,
	DATE_FORMAT(H.WORK_TIME,'%Y-%m-%d') WORK_TIME_FMT,
	DATE_FORMAT(H.JOIN_ORG_TIME,'%Y-%m-%d') JOIN_ORG_TIME_FMT,
	DATE_FORMAT(H.ENTRY_TIME,'%Y-%m-%d') ENTRY_TIME_FMT
FROM
	HR_EMP H
WHERE
	H.EMP_ID = #empId#