select
===
with tmp as
 (select g.GROUP_ID,
         group_concat(concat(g.user_type,':',g.user_id) ORDER BY g.user_id) user_id,
         group_concat((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.user_id) user_name
    from BAS_GROUP_ACCOUNT_RELATE g
   where g.is_use = 'Y'
   group by g.GROUP_ID)
select @pageTag(){
				t.GROUP_ID,
		t.GROUP_NAME,
		t.STATUS,
        GETDICNAME('GROUP_STATUS',t.STATUS) STATUS_TEXT,
		t.GROUP_ORG,
        GETORGNAME(t.GROUP_ORG) GROUP_ORG_TEXT,
		t.GROUP_OWNER,
        GETACCOUNTNAME(t.GROUP_OWNER) GROUP_OWNER_TEXT,
		t.GROUP_TYPE,
        GETDICNAME('GROUP_TYPE',t.GROUP_TYPE) GROUP_TYPE_TEXT,
		t.ORDER_BY,
		t.CREATE_ACCOUNT,
		getaccountname(t.CREATE_ACCOUNT)CREATE_ACCOUNT_name,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
        t.REMARK,
		p.user_id group_component,
		p.user_name group_component_TEXT
	 @}
from BAS_GROUP t
left join tmp p on t.GROUP_ID = p.GROUP_ID
where t.is_use = 'Y'
@if(!isEmpty(applyPerson)){
    and getaccountname(t.CREATE_ACCOUNT)  like #applyPerson# ESCAPE '/'  
@}
@if(!isEmpty(mgrFilter)){
    and (t.CREATE_ACCOUNT=#loginuser.accountid# or t.GROUP_TYPE='1')
@}
@if(!isEmpty(dept)){
    and t.APPLY_DEPT= #dept#
@}
@if(!isEmpty(startDate) && !isEmpty(endDate)){
and (t.CREATE_TIME
 between STR_TO_DATE(#startDate#,'%Y-%m-%d') and STR_TO_DATE(#endDate#,'%Y-%m-%d'))
@}
@if(!isEmpty(search)){
and(
 upper(t.GROUP_NAME) like #search#  ESCAPE '/'  or 
 upper(t.STATUS) like #search#  ESCAPE '/'  or 
 upper(t.GROUP_ORG) like #search#  ESCAPE '/'  or 
 upper(t.GROUP_OWNER) like #search#  ESCAPE '/'  or 
 upper(t.GROUP_TYPE) like #search#  ESCAPE '/'  or 
 upper(t.ORDER_BY) like #search#  ESCAPE '/'  or 
 upper(t.CREATE_ACCOUNT) like #search#  ESCAPE '/'  or 
 upper(t.CREATE_TIME) like #search#  ESCAPE '/'  or 
 upper(t.MODIFY_ACCOUNT) like #search#  ESCAPE '/'  or 
 upper(t.MODIFY_TIME) like #search#  ESCAPE '/'  or 
 upper(t.IS_USE) like #search#  ESCAPE '/' 
)@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.GROUP_ID desc
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}

findByAccountIdAndRoleId
===
select t.*
from BAS_ROLES_ACCOUNT t
where 1=1
@if(!isEmpty(accountId)){
and t.ACCOUNT_ID=#accountId#
@}
@if(!isEmpty(roleId)){
and t.ROLE_ID=#roleId#
@}

getComponentsByGroupId
===
with tmp as
 (select g.GROUP_ID,
         group_concat(concat(g.user_type,':',g.user_id) ORDER BY g.user_id) user_id,
         group_concat((case
                   when g.user_type = 'dept' then
                    getdeptname(g.user_id)
                   when g.user_type = 'org' then
                    getbaseabbr(g.user_id)
                   when g.user_type = 'user' then
                    getaccountname(g.user_id)
                 end) ORDER BY g.user_id) user_name
    from BAS_GROUP_ACCOUNT_RELATE g
   where g.is_use = 'Y'
	and  g.GROUP_ID=#groupId#
   group by g.GROUP_ID)
select 
p.user_id,
p.user_name
from BAS_GROUP t 
left join tmp p on t.GROUP_ID = p.GROUP_ID
where t.is_use = 'Y'
@if(!isEmpty(groupId)){
	and t.GROUP_ID=#groupId#
@}