PageAll
===
select @pageTag(){
				t.BUSINESS_ID,
		t.BUSINESS_PID,
		t.BUSINESS_CODE,
		t.BUSINESS_NAME,
		t.BUSINESS_TYPE,
		t.AUTH_INFO,
		GETDICNAME('BAS_BUSINESS',t.BUSINESS_TYPE) as BUSINESS_TYPE_TEXT,
		GETDICNAME('AUTH_INFO',t.AUTH_INFO) as AUTH_INFO_TEXT,
		t.MENU_ID,
		b.MENU_NAME,
		t.PAGE_ADDRESS,
		t.COMPUTE_COUNT,
		t.FILE_ID,
		t.IMAGE_URL,
		t.MEMO,
		t.IS_USE,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME
	 @}
from BAS_BUSINESS_PROCESS t LEFT JOIN BAS_MENU b on t.MENU_ID=b.MENU_ID
where t.is_use = 'Y' 
@if(!isEmpty(businessId)){
 and T.BUSINESS_TYPE='4' 
@}
@if(!isEmpty(search)){
and(
 upper(t.BUSINESS_ID) like #search#  or 
 upper(t.BUSINESS_PID) like #search#  or 
 upper(t.BUSINESS_CODE) like #search#  or 
 upper(t.BUSINESS_NAME) like #search#  or 
 upper(t.BUSINESS_TYPE) like #search#  or 
 upper(t.AUTH_INFO) like #search#  or 
 upper(t.MENU_ID) like #search#  or 
 upper(t.PAGE_ADDRESS) like #search#  or 
 upper(t.COMPUTE_COUNT) like #search#  or 
 upper(t.FILE_ID) like #search#  or 
 upper(t.IMAGE_URL) like #search#  or 
 upper(t.MEMO) like #search#  or 
 upper(t.IS_USE) like #search#  or 
 upper(t.CREATE_ACCOUNT) like #search#  or 
 upper(t.CREATE_TIME) like #search#  or 
 upper(t.MODIFY_ACCOUNT) like #search#  or 
 upper(t.MODIFY_TIME) like #search# 
)@}
@if(!isEmpty(businessId)){
 START WITH T.BUSINESS_PID = #businessId# CONNECT BY PRIOR T.BUSINESS_ID = T.BUSINESS_PID
@}
@pageIgnoreTag(){
 order by t.BUSINESS_ID desc
@}


select
===
with recursive temp as(
                       select b.* from BAS_BUSINESS_PROCESS b where b.IS_USE = 'Y' and b.BUSINESS_PID =#pid# 
                       union all 
                       select b.* from BAS_BUSINESS_PROCESS b,temp t where t.BUSINESS_ID=b.BUSINESS_PID
                       )
                       SELECT t.BUSINESS_ID ID, T.BUSINESS_PID PID, t.BUSINESS_NAME TEXT FROM temp t ;

delBasBusinessProcessAndChild
===
UPDATE 	BAS_BUSINESS_PROCESS T 
SET		T.IS_USE='N'
WHERE 	T.BUSINESS_ID in ( 
	SELECT 	A.BUSINESS_ID
	FROM 	BAS_BUSINESS_PROCESS A 
	WHERE 	A.IS_USE = 'Y'
	start with A.BUSINESS_ID = #id#
	connect by prior A.BUSINESS_ID = A.BUSINESS_PID )

selectDetail
===
SELECT 	t.* 
 FROM 	BAS_BUSINESS_PROCESS T 
 WHERE 	t.IS_USE = 'Y'
 START WITH T.BUSINESS_PID = (select BUSINESS_ID FROM BAS_BUSINESS_PROCESS where BUSINESS_CODE=#businessCode#)
 CONNECT BY PRIOR T.BUSINESS_ID = T.BUSINESS_PID
 
selectBusinessList
===
 SELECT t.BUSINESS_ID,
		t.BUSINESS_PID,
		t.BUSINESS_CODE,
		t.BUSINESS_NAME,
		t.BUSINESS_TYPE,
		t.AUTH_INFO,
		t.MENU_ID,
		t.PAGE_ADDRESS,
		t.COMPUTE_COUNT,
		t.FILE_ID,
		t.IMAGE_URL,
		t.MEMO,
		t.IS_USE,
		DECODE((SELECT a.BUSINESS_TYPE FROM BAS_BUSINESS_PROCESS a WHERE a.BUSINESS_ID = t.BUSINESS_PID),'3',
			(SELECT a.BUSINESS_NAME FROM BAS_BUSINESS_PROCESS a WHERE a.BUSINESS_ID =t.BUSINESS_PID),'') AS PID_NAME,
		(SELECT a.BUSINESS_CODE FROM BAS_BUSINESS_PROCESS a WHERE a.BUSINESS_ID = t.BUSINESS_PID) as PID_CODE
FROM
	BAS_BUSINESS_PROCESS T 
WHERE
	t.IS_USE = 'Y' and t.PRE_BUSINESS_ID is null
	AND t.BUSINESS_TYPE = '4' START WITH T.BUSINESS_PID =#businessId# CONNECT BY PRIOR T.BUSINESS_ID = T.BUSINESS_PID
	
selectBusinessFlow
===
 SELECT t.BUSINESS_ID,
		t.BUSINESS_PID,
		t.BUSINESS_CODE,
		t.BUSINESS_NAME,
		t.BUSINESS_TYPE,
		t.AUTH_INFO,
		t.MENU_ID,
		t.PAGE_ADDRESS,
		t.COMPUTE_COUNT,
		t.FILE_ID,
		t.IMAGE_URL,
		t.MEMO,
		t.IS_USE
FROM
	BAS_BUSINESS_PROCESS T 
WHERE
	t.IS_USE = 'Y' START WITH T.BUSINESS_ID=#businessId# CONNECT BY PRIOR T.BUSINESS_ID in (select regexp_substr(','||t.PRE_BUSINESS_ID||',','[^,]+',1,rownum) from dual connect by rownum<=LENGTH (','||t.PRE_BUSINESS_ID||',') - LENGTH (regexp_replace(','||t.PRE_BUSINESS_ID||',', ',', ''))+1)
	
selectDetailByCode
===
SELECT 	t.BUSINESS_ID,
		t.BUSINESS_PID,
		t.BUSINESS_CODE,
		t.BUSINESS_NAME,
		t.BUSINESS_TYPE,
		t.AUTH_INFO,
		t.MENU_ID,
		t.PAGE_ADDRESS,
		t.COMPUTE_COUNT,
		t.FILE_ID,
		t.IMAGE_URL,
		t.MEMO,
		t.IS_USE
 FROM 	BAS_BUSINESS_PROCESS T 
 WHERE 	t.IS_USE = 'Y'
 and T.BUSINESS_PID = (select BUSINESS_ID FROM BAS_BUSINESS_PROCESS where BUSINESS_CODE=#businessCode#) ORDER BY BUSINESS_ID