<%@ page language="java" pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<!doctype html>
<html>
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="renderer" content="webkit">
	<!--国产浏览器webkit模式-->
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<LINK href="${pageContext.request.contextPath}/loginImg/favicon/favicon.ico?v=<%=System.currentTimeMillis()%>" type="image/x-icon" rel="shortcut icon">
	<link rel="apple-touch-icon-precomposed" href="${pageContext.request.contextPath}/loginImg/favicon/favicon.ico?v=<%=System.currentTimeMillis()%>">
	<script src="${pageContext.request.contextPath}/static/plugins/vue/vue.min.js"></script>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/static/plugins/element-ui-mini/index.css">
	<script src="${pageContext.request.contextPath}/static/plugins/element-ui-mini/index.js"></script>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/static/style/loginConfig/css/login.css" type="text/css">

	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/jquery/jquery-1.11.0.min.js"></script>
	<script src="${pageContext.request.contextPath}/static/staticCore/js/polygonizr.min.js" type="text/javascript"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/layer/layer.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/jquery/jquery.cookie.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/qrcode/jqeury-qrcode.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/qrcode/jqeury-qrcode.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/crypto-js-4.0.0/crypto-js.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/static/plugins/crypto-js-4.0.0/aes.js"></script>
	<script type="text/javascript" src="${pageContext.request.contextPath}/js/index.js"></script>

	<title>${loginConfig.title}</title>
	<!--[if lt IE 9]>
	<script src="${pageContext.request.contextPath}/static/style/login/compatible/html5shiv.min.js"></script>
	<script src="${pageContext.request.contextPath}/static/style/login/compatible/respond.min.js"></script>
	<![endif]-->

	<script>
		var token = '${param.token}';
		var timeOut;
		var skin = 1;
		$(document).ready(function(e) {

			$(".co_checkbox").click(function() {
				if ($(this).hasClass("now")) {
					$(this).removeClass("now");
					$(this).children("input:checkbox[type='checkbox']").attr("checked", false);
				} else {
					$(this).addClass("now");
					$(this).children("input:checkbox[type='checkbox']").attr("checked", "checked");
				}
			});

			//select
			$(".co_select .select").click(function() {
				var ishasClass = $(this).hasClass("active");
				if (ishasClass) {
					$(".co_select .list").hide();
					$(".co_select .select.active").removeClass("active");
				} else {
					$(this).addClass("active").next(".list").show();
				}
			});
			$(".co_select").mouseleave(function() {
				timeOut = setTimeout(function() {
					$(".co_select .list").hide();
					$(".co_select .select.active").removeClass("active");
				}, 600);
				$(".co_select").mouseover(function() {
					clearTimeout(timeOut);
				});

			})
			$(".co_select li").click(function() {
				$(".co_select li.now").removeClass("now");
				$(".co_select .select.active").removeClass("active");
				$(this).addClass("now");
				var text = $(this).text();
				if (text.length > 14) text = text.substring(0, 13) + "...";
				$(".co_corpInput").val(text);
				$(".co_select .list").hide();
			});

			//error check
			$("input").on("input propertychange", function() {
				if ($(this).hasClass("error")) {
					$(this).removeClass("error");
				}
			});

			$("input").focus(function() {
				$(this).parent().children("label.h4").addClass("gray");
			}).blur(function() {
				if (!$(this).val()) $(this).parent().children("label.h4").removeClass("gray");
			});


			$(".co_signType").click(function() {
				var isPc = $(this).hasClass("pc");
				if (isPc) {
					$(this).removeClass("pc").addClass("phone");
					$(".co_formHead>h2").text("登录");
					$(".co_pcForm").show(200);
					$(".co_phoneForm").hide(200);
				} else {
					$(this).removeClass("phone").addClass("pc");
					$(".co_formHead>h2").text("扫码登录");
					$(".co_pcForm").hide(200);
					$(".co_phoneForm").show(200);
				}
			});
			$(".co_signTab>a").click(function() {
				var isPc = $(this).hasClass("pc");
				if (isPc) {
					$(".co_formHead>h1").text("登 录");
					$(".co_signTab>a").removeClass("active");
					$(this).addClass("active");
					$(".co_pcForm").show();
					$(".co_phoneForm").hide();
				} else {
					$(".co_formHead>h1").text("扫码登录");
					$(".co_signTab>a").removeClass("active");
					$(this).addClass("active");
					$(".co_pcForm").hide();
					$(".co_phoneForm").show();
				}
			});

		});

		var sessionSalt = ['<%=request.getSession().getAttribute("sessionSalt")%>'];
		function encrypt(word){
			//按照自己页面模板取出session中的加密因子
			var key = CryptoJS.enc.Utf8.parse(sessionSalt);
			var srcs = CryptoJS.enc.Utf8.parse(word);
			var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
			return encrypted.toString();
		}
		//解密
		function decrypt(encrypted,salt){
			var key = CryptoJS.enc.Utf8.parse(salt);
			var decrypted = CryptoJS.AES.decrypt(encrypted, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
			return decrypted.toString(CryptoJS.enc.Utf8);
		}

	</script>

	</head>
	<body>
		<div class="co_login rightFull2" id="app">
			<div class="co_loginHead">
				<div class="co_container" style="background:url(${logoImgUrl}) left center no-repeat"></div>
			</div>
			<div class="co_bg">
				<el-carousel indicator-position="outside" :height="bannerHeight + 'px'" interval="${loginConfig.picSwitchSpeed}">
					<el-carousel-item v-for="item in img_list" :key="item">
						<img :src="item" alt />
					</el-carousel-item>
				</el-carousel>
			</div>
			<div class="co_loginBody co_container">
				<div class="logo"></div>
				<div class="co_loginBanner"></div>
				<div class="co_loginArea">
					<div class="co_loginBox mini" style="background: ${loginConfig.loginFormBg == null ? '#FFFFFF' : loginConfig.loginFormBg}">
						<a class="co_signType phone" href="javascript:void(0)"></a>
						<div class="co_signTab h1">
							<a href="#" class="pc active">登 录</a>
							<span class="space"></span>
							<a href="#" class="phone">下载App</a>
						</div>

						<div class="co_formContainer">
							<form action="#" id="user">

								<div class="co_pcForm clearfix">
									<div class="co_formHead">
										<h1>登 录</h1>
									</div>
									<h4>请输入账号密码进行登录</h4>
									<div class="co_corp">
										<label class="h4 gray">所属企业</label>
										<el-select v-model="value" placeholder="集团公司" class="co_corpInput">
											<el-option v-for="item in options" :key="item.value" :label="item.label"
												:value="item.value">
											</el-option>
										</el-select>
									</div>
									<div class="co_user">
										<label class="h4">用户名</label>
										<el-input placeholder="请输入用户名或手机号码" class="co_userInput" v-model="input" id="userName">
										</el-input>
										<label class="errorLabel h5">没有找到此用户，这可怎么办！</label>
									</div>
									<div class="co_pass">
										<label class="h4">密码</label>
										<el-input placeholder="请输入密码" class="co_passInput"  v-model="input2"
												  type="password" id="passWord" name="passWord"   onkeypress="clickEnter()"></el-input>
										<label class="errorLabel h5">我想，应该是密码记错了！</label>
									</div>
									<div class="co_remember">
										<a href="javascript:void(0);" class="co_checkbox">
											<input type="checkbox" id="checkbox" hidden="hidden"
												style="display: none">
											<span class="co_check"></span>
											<span class="co_text h5">记住密码</span>
											<div class="clearfix"></div>
										</a>
										<a href="javascript:void(0)" class="co_help">
											<div class="co-tip up h6" style="width: 180px;  ">cookie失效，登录状态即失效</div>
										</a>
									</div>
									<button tabindex="3" class="co-btn h3" id="submitBtn" onClick="login()"
										type="button">登录</button>
								</div>
								<div class="co_phoneForm">
									<div class="co_formHead">
										<h1>扫码登录</h1>
									</div>
									<h4 style="color: white">请使用手机应用扫码登录</h4>
									<div id="qrcode" style="width:150px;height:150px;margin: auto;border:8px solid #fff;"></div>
								</div>
							</form>

						</div>
					</div>
				</div>
			</div>

			<div class="co_loginFoot">
				<div class="co_container">
					<span class="co_copyright h6">版权所有 © 2019 HEFEI BINGHU NEW DISTRICT CONSTRUCTION INVESTMENT CO.,LTD.
						ALL RIGHTS
						RESERVED. 保留所有权利。</span>
				</div>
			</div>
			<div class="mb layui-anim co-anim-hide"></div>
		</div>

	</body>
<script>
	new Vue({
		el: '#app',
		data: function () {
			return {
				// 图片父容器高度
				bannerHeight: 1000,
				img_list: JSON.parse('${loginBgImgs}'),
				input: '',
				input2: '',
				options: [{
					value: '选项1',
					label: '集团公司'
				}, {
					value: '选项2',
					label: '科大国创软件股份有限公司'
				}, {
					value: '选项3',
					label: '科大云网科技有限公司'
				}, {
					value: '选项4',
					label: '科大国创软件股份有限公司'
				}, {
					value: '选项5',
					label: '科大云网科技有限公司'
				}],
				value: ''
			}
		},
		methods: {
			setSize: function () {
				// 通过浏览器宽度(图片宽度)计算高度

				this.bannerHeight = window.innerHeight;
			}
		},
		mounted() {
			// 首次加载时,需要调用一次
			this.bannerHeight = window.innerHeight;
			// 窗口大小发生改变时,调用一次
			window.onresize = () => {
				this.bannerHeight = window.innerHeight;
			};
		}
	})

	var ctx='${pageContext.request.contextPath}';
	//获取维一标识token生成二维码
	$.post(ctx+'/login/generationQRCode', function (data) {
		$("#qrcode").qrcode({text:data.o,background : "#ffffff", //二维码的后景色
			foreground : "#000000", width : 150,height : 150,src:'${pageContext.request.contextPath}/static/style/images/logo.png'});
		$('#qrcode').attr('token',data.o);
	},'JSON');
	var time = window.setInterval(function () {
		if($(".co_signType ").hasClass("pc")){
			$.post(ctx+'/login/scanLogin',{'token':$('#qrcode').attr('token')},function (data) {
				if(data.success){
					clearInterval(time);
					top.location.reload()
				}
			},'JSON')
		}
	},1000);
</script>
<style scoped>
	.el-carousel__item img {
		/*设置图片宽度和浏览器宽度一致*/
		width: 100%;
		height: inherit;
	}
</style>
</html>
