var BasInterfaceLogDataGrid=$('#BasInterfaceLog_datagrid');
$(function(){
	initBasInterfaceLogGrid();
});

function initBasInterfaceLogGrid(){
	BasInterfaceLogDataGrid.datagrid({
		height:$("body").height()-200,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#BasInterfaceLog_datagrid_tb",
	    url:ctx+'/BasInterfaceLog/pageBasInterfaceLog',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasInterfaceLogFormDetail('+row.logId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'logId',title:'',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceName',title:'接口名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateTime',title:'执行时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateAccount',title:'执行人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateIp',title:'调用ip',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateMethod',title:'方法',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateResult',hidden:true},
	    {field:'operateResultText',title:'成功失败',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateDetail',title:'详细信息',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceArgs',title:'参数',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceCode',title:'接口编码',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasInterfaceLogFormDetail(row.logId);
	    }
	});
    BasInterfaceLogDataGrid.datagrid('doCellTip');
    var pager = BasInterfaceLogDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasInterfaceLog_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasInterfaceLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasInterfaceLog&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasInterfaceLog(){
	BasInterfaceLogDataGrid.datagrid('reload');
}
//查询表格
function searchBasInterfaceLog(){
	BasInterfaceLogDataGrid.datagrid('load',{
		search:$("#searchBasInterfaceLog").val(),
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		applyPerson: $("#applyPerson").textbox('getValue'),
		applyDept :$("#applyDept").combobox('getValue')
	});
}

//增加记录
function addBasInterfaceLog() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasInterfaceLog",
		submiturl:"/BasInterfaceLog/saveBasInterfaceLog?formcode=BasInterfaceLog",
//		contenturl:"/view/base/BasInterfaceLog",
//		submiturl:"/BasInterfaceLog/saveBasInterfaceLog",
		callback:reloadBasInterfaceLog
	});
	
}

//修改记录
function editBasInterfaceLog() {
	var row = BasInterfaceLogDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.logId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasInterfaceLog&id=" + id,
			submiturl:"/BasInterfaceLog/saveBasInterfaceLog?formcode=BasInterfaceLog",
//			contenturl : "/view/base/BasInterfaceLog",
//			submiturl : "/BasInterfaceLog/saveBasInterfaceLog",
//			onload : "/BasInterfaceLog/findBasInterfaceLog?id=" + id,
			callback : reloadBasInterfaceLog
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasInterfaceLog() {
	var row = BasInterfaceLogDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.logId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasInterfaceLog/delBasInterfaceLog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasInterfaceLogDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
