/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.workflow.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.gexin.fastjson.JSON;
import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasRolesAccountDao;
import com.ustc.base.entity.BasDept;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.BasMenu;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.entity.BasOrg;
import com.ustc.base.entity.BasRolesAccount;
import com.ustc.base.entity.BasSignaturePersonal;
import com.ustc.base.service.BasDeptService;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasMenuService;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.BasOrgService;
import com.ustc.base.service.BasRolesAccountService;
import com.ustc.base.service.BasSignaturePersonalService;
import com.ustc.base.service.CommonService;
import com.ustc.doc.entity.DocFileVersion;
import com.ustc.doc.entity.DocFormFile;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFileVersionService;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.entity.GenFormFlow;
import com.ustc.gen.service.GenFormFlowService;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.util.FreeMarkerUtil;
import com.ustc.workflow.entity.StfBusinessProcess;
import com.ustc.workflow.entity.WfActivityParams;
import com.ustc.workflow.entity.WfProcessinstRoll;
import com.ustc.workflow.entity.WfWorkitemAdd;
import com.ustc.workflow.service.IWfActivityParamsService;
import com.ustc.workflow.service.StfBusinessProcessService;
import com.ustc.workflow.service.WfProcessinstRollService;
import com.ustc.workflow.service.WfWorkitemAddService;
import com.ustcsoft.usiflow.core.util.PrimaryKeyUtil;
import com.ustcsoft.usiflow.engine.ProcessEngine;
import com.ustcsoft.usiflow.engine.ProcessEngineBuilder;
import com.ustcsoft.usiflow.engine.core.RelaDataManagerBuilder;
import com.ustcsoft.usiflow.engine.core.data.RelaDataManager;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.Participant;
import com.ustcsoft.usiflow.engine.model.ProcessDefine;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.model.elements.ActivityElement;
import com.ustcsoft.usiflow.engine.model.elements.ProcessElement;
import com.ustcsoft.usiflow.engine.model.elements.TransitionElement;
import com.ustcsoft.usiflow.engine.repository.IProcessDefineRepository;
import com.ustcsoft.usiflow.engine.repository.IProcessInstanceRepository;
import com.ustcsoft.usiflow.engine.repository.IRelevantDataRepository;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import com.ustcsoft.usiflow.engine.service.IProcessInstanceService;
import com.ustcsoft.usiflow.engine.service.IWorkItemService;
import com.ustcsoft.usiflow.engine.xml.Dom4jProcDefParser;
import com.ustcsoft.usiflow.engine.xml.ProcessDefineParser;
import com.ustcsoft.usiflow.service.filter.DataSourceRelaDataFilter;
import com.ustcsoft.usiflow.service.filter.LoggerProcessFilter;
import com.ustcsoft.usiflow.service.filter.ProcessFilter;
import com.ustcsoft.usiflow.service.filter.TransCtrlFilter;
import com.ustcsoft.usiflow.service.spi.IParticipantService;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.ModelAndView;

@Component
@Transactional
@DependsOn(value={"SpringContextHolder"})
public class FlowUtilService {
    Logger logger = Logger.getLogger(FlowUtilService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper beetls;
    private ProcessEngine processEngine;
    private IProcessInstanceService procInstService;
    private IWorkItemService workItemService;
    private IProcessDefineService proservice;
    private IProcessInstanceRepository procInstRep;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private BasMenuService menuservice;
    @Autowired
    private GenFormService genFormService;
    @Autowired
    private GenFormFlowService genformflowService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasRolesAccountDao basrolesaccountDao;
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private BasRolesAccountService basrolesaccountService;
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private BasSignaturePersonalService bassignaturepersonalService;
    @Autowired
    private WfProcessinstRollService wfprocessinstrollService;
    private static final String splitstr = "@#@";
    @Autowired
    private BasRolesAccountService basRolesAccountService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFileVersionService docFileVersionService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private WfWorkitemAddService wfWorkitemAddService;
    @Value(value="${flow.revokeFlowType:create}")
    private String revokeFlowType;

    @PostConstruct
    public void init() {
        this.logger.info((Object)"\u521d\u59cb\u5316\u6d41\u7a0b\u5f15\u64ce...");
        this.processEngine = new ProcessEngineBuilder(SpringContextHolder.getApplicationContext()).buildProcessEngine();
        this.processEngine.addFilter((ProcessFilter)new LoggerProcessFilter());
        this.processEngine.addFilter((ProcessFilter)new TransCtrlFilter());
        this.processEngine.addFilter((ProcessFilter)new DataSourceRelaDataFilter());
        this.procInstService = this.processEngine.getProcessInstanceService();
        this.workItemService = this.processEngine.getWorkItemService();
        this.proservice = this.processEngine.getProcessDefineService();
        this.procInstRep = (IProcessInstanceRepository)SpringContextHolder.getApplicationContext().getBean(IProcessInstanceRepository.class);
        this.logger.info((Object)"\u521d\u59cb\u5316\u6d41\u7a0b\u5f15\u64ce...\u5b8c\u6210!");
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId) throws GEPSBisException {
        return this.createAndStartProcess(userId, formCode, businessMainId, "", new HashMap<String, Object>(), null);
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId, String title, String app) throws GEPSBisException {
        return this.createAndStartProcess(userId, formCode, businessMainId, title, new HashMap<String, Object>(), app);
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId, String title) throws GEPSBisException {
        return this.createAndStartProcess(userId, formCode, businessMainId, SysUtils.getLoginUser().getOrgid(), title, new HashMap<String, Object>(), null);
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId, String title, Map<String, Object> condtion, String app) throws GEPSBisException {
        return this.createAndStartProcess(userId, formCode, businessMainId, SysUtils.getLoginUser().getOrgid(), title, condtion, app);
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId, Long orgId, String title, Map<String, Object> condtion, String app) throws GEPSBisException {
        GenForm form = this.genFormService.findGenFormByCode(formCode);
        if (form == null) {
            this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u8868\u5355\uff01");
            throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u5bf9\u5e94\u8868\u5355\uff01");
        }
        if (orgId == null) {
            orgId = this.basEmpAccountService.findByAccountId(userId).getOrgId();
        }
        GenFormFlow genFormFlow = this.genformflowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
        String flowCode = form.getFlowCode();
        if (genFormFlow != null) {
            flowCode = genFormFlow.getFlowCode();
        } else {
            boolean flag = false;
            if (StringUtils.isNotEmpty((String)flowCode)) {
                String shareType;
                List<StfBusinessProcess> list = this.sbpservice.findByDesignName(flowCode);
                StfBusinessProcess stfBusinessProcess = list.get(0);
                if (stfBusinessProcess != null && ("1".equals(shareType = stfBusinessProcess.getShareType()) || StringUtils.isNotEmpty((String)stfBusinessProcess.getApplyOrgs()) && stfBusinessProcess.getApplyOrgs().concat(",").contains(orgId.toString().concat(",")))) {
                    flag = true;
                }
                if (!flag) {
                    this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u5f53\u524d\u5355\u4f4d\u6682\u672a\u914d\u7f6e\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
                    throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u5f53\u524d\u5355\u4f4d\u6682\u672a\u914d\u7f6e\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
                }
            } else {
                this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
                throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
            }
        }
        if (!StringUtils.isEmpty((String)flowCode)) {
            ProcessInstance processinst = this.procInstService.createAndStartProcess(flowCode, userId.toString());
            this.saveProcInstIdInBusiness(form.getBusiTable(), businessMainId, processinst.getProcessInstId());
            if ("1".equals(app)) {
                try {
                    this.excuteFlowDefault(processinst.getProcessInstId(), formCode, businessMainId, title, condtion);
                }
                catch (DocumentException e) {
                    this.logger.error((Object)"\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01");
                    throw new GEPSBisException("\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01");
                }
            }
            return processinst.getProcessInstId();
        }
        this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
        throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
    }

    public Long createAndStartProcess(Long userId, String flowCode, String tableName, Long businessMainId) throws GEPSBisException {
        if (StringUtils.isNotBlank((String)flowCode)) {
            ProcessInstance processinst = this.procInstService.createAndStartProcess(flowCode, userId.toString());
            this.saveProcInstIdInBusiness(tableName, businessMainId, processinst.getProcessInstId());
            return processinst.getProcessInstId();
        }
        this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
        throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
    }

    public Long createAndStartProcess(Long userId, String formCode, Long businessMainId, Map<String, Object> conditions) throws GEPSBisException {
        GenForm from = this.genFormService.findGenFormByCode(formCode);
        if (from != null && !StringUtils.isEmpty((String)from.getFlowCode())) {
            RelaDataManager relaDataManager = RelaDataManagerBuilder.buildRelaDataManager();
            ProcessInstance processinst = this.procInstService.createProcess(from.getFlowCode(), userId.toString());
            Long processInstId = processinst.getProcessInstId();
            relaDataManager.setExpressConditions(processInstId.longValue(), null, conditions);
            this.procInstService.startProcess(processInstId.longValue());
            this.saveProcInstIdInBusiness(from.getBusiTable(), businessMainId, processInstId);
            return processInstId;
        }
        this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
        throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
    }

    public Long startAndReportProcess(Long userId, String formCode, Long businessMainId, Long orgId, String title, Map<String, Object> condtion, String app, String parts) throws GEPSBisException {
        GenForm form = this.genFormService.findGenFormByCode(formCode);
        if (orgId == null) {
            orgId = this.basEmpAccountService.findById(userId).getOrgId();
        }
        GenFormFlow genFormFlow = this.genformflowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
        String flowCode = form.getFlowCode();
        if (genFormFlow != null) {
            flowCode = genFormFlow.getFlowCode();
        }
        if (form != null && !StringUtils.isEmpty((String)flowCode)) {
            ProcessInstance processinst = this.procInstService.createProcess(flowCode, userId.toString());
            this.genNextActParticipants(processinst.getProcessInstId(), userId, this.getFirstAct(processinst.getProcessInstId()), formCode, "");
            this.procInstService.startProcess(processinst.getProcessInstId());
            if ("1".equals(app)) {
                try {
                    this.excuteFlowDefault(userId, processinst.getProcessInstId(), formCode, businessMainId, title, condtion, "", parts);
                }
                catch (DocumentException e) {
                    this.logger.error((Object)"\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01");
                    throw new GEPSBisException("\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01");
                }
            }
            return processinst.getProcessInstId();
        }
        this.logger.error((Object)"\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
        throw new GEPSBisException("\u521b\u5efa\u6d41\u7a0b\u5931\u8d25,\u672a\u627e\u5230\u8868\u5355\u5bf9\u5e94\u6d41\u7a0b\uff01");
    }

    public void excuteFlow(Long processInstId, Long userId, Long orgId, String formCode, String businessMainId, String conditions, String toActIds, String TH, String advice, String title, Long msglevel, String listUrl, String nextPersons, String backActId, Long workItemId, String signpic, String copyPersons, String backoptions, String follows) throws GEPSBisException, DocumentException {
        this.excuteFlow(processInstId, userId, orgId, formCode, businessMainId, conditions, toActIds, TH, advice, title, msglevel, listUrl, nextPersons, backActId, workItemId, signpic, copyPersons, backoptions, follows, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void excuteFlow(Long processInstId, Long userId, Long orgId, String formCode, String businessMainId, String conditions, String toActIds, String TH, String advice, String title, Long msglevel, String listUrl, String nextPersons, String backActId, Long workItemId, String signpic, String copyPersons, String backoptions, String follows, String fileIds, String actAttitude, String attitudeOptions) throws GEPSBisException, DocumentException {
        void var32_42;
        List<WfWorkitemAdd> adds;
        Long maxworkitemid = this.queryCurrentWorkItem(processInstId);
        if (StringUtils.isBlank((String)toActIds) && StringUtils.isNotBlank((String)backActId)) {
            toActIds = backActId;
        }
        IWorkItemService worktoItemService = this.processEngine.getWorkItemService();
        workItemId = this.getWorkItemIdNoAgent(processInstId, workItemId);
        Long agentId = null;
        if (workItemId == null) {
            Map m = this.getWorkItemIdAgent(processInstId, workItemId);
            agentId = userId;
            userId = Long.valueOf(m.get("AGENT_TO_ACCOUNT").toString());
            workItemId = Long.valueOf(m.get("WORKITEMID").toString());
        }
        List<DocFormFile> orifiles = this.docFormFileService.listFormFileByPK("workitem", "888888", workItemId.toString());
        orifiles.forEach(file -> {
            file.setIsUse("N");
            this.docFormFileService.saveDocFormFile((DocFormFile)file);
        });
        if (StringUtils.isNotBlank((String)fileIds)) {
            FormFileBean formfile = new FormFileBean();
            formfile.setPrimaryKey(workItemId);
            ArrayList<DocFormFile> panelfilelist = new ArrayList<DocFormFile>(fileIds.split(",").length + 1);
            for (String string : fileIds.split(",")) {
                DocFormFile file2 = new DocFormFile();
                file2.setFileTypeId("888888");
                file2.setFileVersionId(Long.parseLong(string));
                file2.setPrimaryKey(Objects.toString(workItemId));
                file2.setIsUse("Y");
                file2.setFormId("workitem");
                panelfilelist.add(file2);
                DocFileVersion version = this.docFileVersionService.findDocFileVersion(file2.getFileVersionId());
                if (version == null) continue;
                file2.setFileName(version.getOriginalName());
                file2.setOriginalName(version.getOriginalName());
            }
            formfile.setPanelfilelist(panelfilelist);
            this.docFormFileService.SaveFormFileBean(formfile);
        }
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        WorkItem workItem = workItemRep.findWorkItem(workItemId.longValue());
        if (StringUtils.isBlank((String)backActId) && "1".equals(workItem.getBackoptions()) && workItem.getSourceworkItemId() != 0L) {
            WorkItem sourceworkItem = workItemRep.findWorkItem(workItem.getSourceworkItemId());
            backActId = sourceworkItem.getActivityDefId();
            Participant p = new Participant();
            p.setParticipant(sourceworkItem.getParticipant());
            p.setParticType("person");
            nextPersons = JSON.toJSONString(Arrays.asList(p));
        }
        if (StringUtils.isNotBlank((String)backActId)) {
            TH = "TH";
        }
        HashMap<String, Object> conditionAll = new HashMap<String, Object>();
        RelaDataManager relaDataManager = RelaDataManagerBuilder.buildRelaDataManager();
        IRelevantDataRepository relDataRes = (IRelevantDataRepository)SpringContextHolder.getApplicationContext().getBean(IRelevantDataRepository.class);
        relDataRes.deleteRelevantData(processInstId.longValue());
        if (StringUtils.isNotBlank((String)conditions)) {
            for (String con : conditions.split(splitstr)) {
                conditionAll.putAll(this.buildCondition(con));
            }
        }
        String string = StrKit.notNull(conditionAll.get("status")) ? conditionAll.get("status").toString() : "2";
        relDataRes.deleteRelevantData(processInstId.longValue(), workItem.getActivityDefId(), "nextFreeActs");
        if (StringUtils.isNotBlank((String)toActIds)) {
            relaDataManager.setNextFreeActs(processInstId.longValue(), workItem.getActivityDefId(), Arrays.asList(toActIds.split(splitstr)));
        }
        if ("TH".equals(TH)) {
            this.endWorkItemWhenTh(userId, processInstId, workItemId);
        }
        boolean isAllWorkDoned = this.isAllWorkItemIsDoneWhenPass(processInstId, workItemId);
        boolean isStart = this.isStartActivity(processInstId, workItemId, toActIds);
        if (isStart || StringUtils.isNotBlank((String)nextPersons)) {
            this.genNextActParticipants(processInstId, userId, toActIds, formCode, nextPersons);
        }
        if (!(adds = this.wfWorkitemAddService.findByWorkitemid("1", workItemId)).isEmpty()) {
            for (WfWorkitemAdd add : adds) {
                if (!"TH".equals(TH)) {
                    this.addSign(add.getMsgId(), add.getAddPersons());
                }
                add.setIsUse("N");
                this.wfWorkitemAddService.saveWfWorkitemAdd(add);
            }
        }
        worktoItemService.finishWorkItem(workItemId.longValue(), userId.toString(), advice, TH, backoptions);
        if (agentId != null) {
            String agentUpdateSql = " update wf_workitem w set w.AGENT_PARTICIPANT=" + agentId + " where w.workitemid=" + workItemId;
            this.sqlHelper.exeNativeSQL(agentUpdateSql);
        }
        this.setWorkmemoryPic(workItemId, signpic, follows, actAttitude, attitudeOptions);
        if (StringUtils.isNotBlank((String)toActIds) && toActIds.replaceAll(splitstr, "").equals("act_finish")) {
            String string2 = "3";
        }
        if ("TH".equals(TH) && this.getFirstAct(processInstId).equals(backActId)) {
            String string3 = "21";
        }
        if (isStart || "TH".equals(TH)) {
            this.updateBusinessStatus(formCode, businessMainId, processInstId, (String)var32_42);
        }
        this.logger.info((Object)("\u6267\u884c\u6d41\u7a0b\u751f\u6210\u6d88\u606f\u7684\u76f8\u5173\u4fe1\u606f:{isAllWorkDoned:" + isAllWorkDoned + ",status:" + (String)var32_42 + ",workitemid:" + workItemId + ",formCode:" + formCode + ",businessMainId:" + businessMainId + ",processInstId:" + processInstId + ",toActIds:'" + toActIds + "',conditions:'" + conditions + "',nextPersons:'" + nextPersons + "',backActId:'" + backActId + "',title:'" + title + "'}"));
        this.sysMsgdeal(maxworkitemid, workItemId, formCode, businessMainId, processInstId, TH, title, isAllWorkDoned, msglevel, listUrl, userId, follows);
        this.sendCopyMsg(workItemId, processInstId, formCode, businessMainId, copyPersons, title, workItem.getActivityDefId(), msglevel);
    }

    public void rollbackFlow(Long msgId, String workmemory, String roleType) throws DocumentException, GEPSBisException {
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        BasMessage msg = this.basmessageService.findBasMessage(msgId);
        if (msg == null) {
            throw new GEPSBisException("\u6ca1\u6709\u627e\u5230\u8be5\u4e8b\u9879");
        }
        if (!"N".equals(msg.getIsUse())) {
            throw new GEPSBisException("\u8be5\u4e8b\u9879\u8fd8\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de");
        }
        HashMap<String, Object> paras = new HashMap<String, Object>(4);
        paras.put("processinstid", msg.getProcessinstid());
        paras.put("msgId", msgId);
        paras.put("accountId", SysUtils.getLoginAccountId());
        paras.put("isDeal", "Y");
        if (this.beetls.getIntValue("workflow.flow.checkMsgPerm", paras) == 0) {
            throw new GEPSBisException("\u4e0d\u662f\u60a8\u5904\u7406\u7684\u5f85\u529e\uff0c\u65e0\u6cd5\u64a4\u56de");
        }
        WorkItem work = workItemRep.findWorkItem(msg.getWorkitemid().longValue());
        IProcessDefineRepository pdr = (IProcessDefineRepository)SpringContextHolder.getApplicationContext().getBean(IProcessDefineRepository.class);
        ProcessInstance process = this.procInstService.findProcessById(msg.getProcessinstid().longValue());
        ProcessDefine pd = pdr.findPublishProcessDefine(process.getProcessInstName());
        ActivityElement activityXml = (ActivityElement)pd.getProcessElement().getActivitys().get(work.getActivityDefId());
        ArrayList<Long> workItemIds = new ArrayList<Long>();
        if ("multi".equalsIgnoreCase(activityXml.getWiMode()) && "all".equalsIgnoreCase(activityXml.getFinishRule())) {
            List workItems = workItemRep.findActivityWorkItems(work.getActivityInstId());
            for (WorkItem workitem : workItems) {
                workItemIds.add(workitem.getWorkItemId());
            }
        } else {
            workItemIds.add(work.getWorkItemId());
        }
        paras.put("workItemIds", workItemIds);
        if (this.beetls.getIntValue("workflow.flow.checkFllowWorkItemDone", paras) > 0) {
            throw new GEPSBisException("\u8be5\u4e8b\u9879\u540e\u7eed\u8282\u70b9\u6709\u4eba\u63d0\u4ea4\uff0c\u4e0d\u80fd\u64a4\u56de");
        }
        List<Long> receiveIds = this.beetls.getList("workflow.flow.getUndoAcount", paras, Long.class);
        this.rollbackFlow(workItemIds, msgId, msg.getBusiMainId(), msg.getProcessinstid(), msg.getFormCode(), work.getActivityDefId(), receiveIds, workmemory, "2", roleType);
    }

    public void rollbackFlow(String busiMainId, Long processinstid, String formCode, String workmemory, String roleType) throws DocumentException, GEPSBisException {
        ProcessInstance process = this.procInstService.findProcessById(processinstid.longValue());
        if (process.getCurrentState() == 12) {
            throw new GEPSBisException("\u6d41\u7a0b\u5df2\u7ed3\u675f\u65e0\u6cd5\u64a4\u9500");
        }
        if (!SysUtils.getLoginAccountId().toString().equals(process.getCreator())) {
            throw new GEPSBisException("\u60a8\u6682\u65f6\u6ca1\u6709\u6743\u9650\u64a4\u9500");
        }
        HashMap<String, Object> paras = new HashMap<String, Object>(4);
        paras.put("processinstid", processinstid);
        paras.put("accountId", SysUtils.getLoginAccountId());
        List<Long> receiveIds = this.beetls.getList("workflow.flow.getAllAcount", paras, Long.class);
        this.rollbackFlow(null, null, busiMainId, processinstid, formCode, this.getFirstAct(process.getProcessInstName()), receiveIds, workmemory, "1", roleType);
    }

    public void rollbackFlow(List<Long> workItemIds, Long msgId, String busiMainId, Long processinstid, String formCode, String actId, List<Long> receiveIds, String workmemory, String flowStatus, String roleType) throws DocumentException, GEPSBisException {
        LoginUser user = SysUtils.getLoginUser();
        List workList = this.workItemService.findUnFinishedWorkItemByProcessInstId(processinstid.longValue());
        if (workList.isEmpty()) {
            throw new GEPSBisException("\u6d41\u7a0b\u5df2\u7ed3\u675f\u65e0\u6cd5" + roleType);
        }
        if (StringUtils.isEmpty((String)roleType)) {
            roleType = msgId == null ? "\u64a4\u56de" : "\u64a4\u9500";
        }
        IProcessDefineRepository pdr = (IProcessDefineRepository)SpringContextHolder.getApplicationContext().getBean(IProcessDefineRepository.class);
        ProcessInstance process = this.procInstService.findProcessById(processinstid.longValue());
        ProcessDefine pd = pdr.findPublishProcessDefine(process.getProcessInstName());
        if (msgId != null) {
            BasMessage msg = this.basmessageService.findBasMessage(msgId);
            HashMap<String, Object> paras = new HashMap<String, Object>(10);
            paras.put("workItemIds", workItemIds);
            paras.put("processinstid", msg.getProcessinstid());
            String sql = "update wf_activityinst t set t.currentstate=7,t.processinstid=-t.processinstid where  t.processinstid=#processinstid# and t.activityinstid in ( select w.activityinstid from WF_WORKITEM w where  w.sourceworkitemid in(#join(workItemIds)#)) ";
            String trslsql = "update wf_transctrl t set t.processinstid=-t.processinstid where exists ( select 1 from WF_WORKITEM w where t.transtime=w.endtime and w.workitemid in(#join(workItemIds)#)) and t.processinstid=#processinstid#";
            String msgsql = "update bas_message t set t.is_use='D' where exists ( select 1 from WF_WORKITEM w where t.workitemid=w.workitemid and w.sourceworkitemid in(#join(workItemIds)#)) and t.processinstid=#processinstid#";
            String worksql = "update WF_WORKITEM w set w.currentstate=7,w.BizState='roll',w.workmemory='" + workmemory + "',w.processinstid=-w.processinstid where w.sourceworkitemid in(#join(workItemIds)#) and w.processinstid=#processinstid#";
            this.beetls.updateBysql(sql, paras);
            this.beetls.updateBysql(trslsql, paras);
            this.beetls.updateBysql(msgsql, paras);
            this.beetls.updateBysql(worksql, paras);
            paras.put("workItemId", msg.getWorkitemid());
            paras.put("msgId", msgId);
            String sql2 = "update wf_activityinst t set t.currentstate=10   where exists ( select 1 from WF_WORKITEM w where t.activityinstid=w.activityinstid and w.workitemid=#workItemId#) and t.processinstid=#processinstid#";
            String worksql2 = "update WF_WORKITEM t set t.currentstate=10,t.endtime=null,t.workmemory=null where t.workitemid=#workItemId# and t.processinstid=#processinstid#";
            String msgsql2 = "update BAS_MESSAGE_RECEIVE t set t.is_deal='N',T.DEAL_TIME=NULL where t.msg_id=#msgId#";
            String msgsql3 = "update BAS_MESSAGE t set t.is_use='Y' where t.msg_id=#msgId#";
            this.beetls.updateBysql(sql2, paras);
            this.beetls.updateBysql(worksql2, paras);
            this.beetls.updateBysql(msgsql2, paras);
            this.beetls.updateBysql(msgsql3, paras);
            this.updateBusinessStatus(formCode, busiMainId, processinstid, flowStatus);
        } else if (processinstid != null) {
            GenForm from = this.genFormService.findGenFormByCode(formCode);
            ArrayList<Long> unworkItemIds = new ArrayList<Long>(workList.size());
            for (WorkItem workItem : workList) {
                unworkItemIds.add(workItem.getWorkItemId());
            }
            HashMap<String, Object> paras = new HashMap<String, Object>(8);
            paras.put("unworkItemIds", unworkItemIds);
            paras.put("processinstid", processinstid);
            String msgsql = "update bas_message t set t.is_use='D' where exists ( select 1 from WF_WORKITEM w where t.workitemid=w.workitemid and w.workitemid in(#join(unworkItemIds)#)) and t.processinstid=#processinstid#";
            this.beetls.updateBysql(msgsql, paras);
            if ("create".equals(this.revokeFlowType)) {
                Long processinstidnew = this.procInstService.createAndStartProcess(pd.getProcessDefName(), user.getAccountid().toString()).getProcessInstId();
                paras.put("processinstidnew", processinstidnew);
                String updateSql = "update " + from.getBusiTable() + " t set t." + "processinstid" + "=#processinstidnew#,t.workflow_status=" + flowStatus + ",t.MODIFY_TIME=now() where t." + "processinstid" + "=#processinstid#";
                this.beetls.updateBysql(updateSql, paras);
                this.procInstService.terminateProcess(processinstid.longValue());
            } else {
                String updateSql = "update " + from.getBusiTable() + " t set t.workflow_status=" + flowStatus + ",t.MODIFY_TIME=now() where t." + "processinstid" + "=#processinstid#";
                this.beetls.updateBysql(updateSql, paras);
                String sql = "update WF_WORKITEM w set w.BizState='roll',w.workmemory='\u53d1\u8d77\u4eba\u64a4\u56de,\u64a4\u56de\u539f\u56e0:" + workmemory + "' where w.CURRENTSTATE in(10,4) and w.processinstid=" + processinstid;
                this.sqlHelper.exeNativeSQL(sql);
                this.procInstService.terminateProcess(processinstid.longValue());
                sql = "update wf_processinst w set w.CURRENTSTATE='2' where w.processinstid=" + processinstid;
                this.sqlHelper.exeNativeSQL(sql);
                this.procInstService.startProcess(processinstid.longValue());
            }
        }
        WfProcessinstRoll entity = new WfProcessinstRoll();
        entity.setBusiMainId(busiMainId);
        entity.setProcessinstid(processinstid);
        entity.setMsgId(msgId);
        entity.setFormCode(formCode);
        this.wfprocessinstrollService.saveWfProcessinstRoll(entity);
        if (!receiveIds.isEmpty()) {
            String title = this.genFormService.getFlowTitle(formCode, busiMainId);
            this.msgService.saveMessage(processinstid, null, "\u3010\u6d41\u7a0b" + roleType + "-" + user.getAccountName() + "\u3011" + pd.getProcessCHName() + Objects.toString(title, "") + ",\u64a4\u56de\u539f\u56e0:" + workmemory, "{formCode:'" + formCode + "',id:" + busiMainId + "}", user.getAccountid(), receiveIds, "/GenForm/form?newpage=true&formcode=" + formCode + "&isdetail=true&id=" + busiMainId, "3", formCode, busiMainId, null, null, true);
        }
    }

    public void addSign(Long msgId, String accoundIds, String type) throws GEPSBisException {
        if (msgId == null || StringUtils.isBlank((String)accoundIds)) {
            throw new GEPSBisException("\u8bf7\u9009\u62e9\u52a0\u7b7e\u7684\u4eba\u5458");
        }
        BasMessage msg = this.basmessageService.findBasMessage(msgId);
        if (msg == null) {
            throw new GEPSBisException("\u6ca1\u6709\u627e\u5230\u8be5\u5f85\u529e\u4e8b\u9879");
        }
        if (!"Y".equals(msg.getIsUse())) {
            throw new GEPSBisException("\u8be5\u4e8b\u9879\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u52a0\u7b7e");
        }
        JsonMsg jsonmsg = this.wfWorkitemAddService.checkSign(msgId, accoundIds);
        if (!jsonmsg.isSuccess()) {
            throw new GEPSBisException(jsonmsg.getMsg().toString());
        }
        WfWorkitemAdd add = new WfWorkitemAdd();
        add.setAddPersons(accoundIds);
        add.setAddType(type);
        add.setIsUse("Y");
        add.setWorkitemid(msg.getWorkitemid());
        add.setProcessinstid(msg.getProcessinstid());
        add.setMsgId(msgId);
        this.wfWorkitemAddService.saveWfWorkitemAdd(add);
        if ("1".equals(type)) {
            return;
        }
        this.addSign(msgId, accoundIds);
    }

    public void addSign(Long msgId, String accoundIds) throws GEPSBisException {
        if (msgId == null || StringUtils.isBlank((String)accoundIds)) {
            throw new GEPSBisException("\u8bf7\u9009\u62e9\u52a0\u7b7e\u7684\u4eba\u5458");
        }
        BasMessage msg = this.basmessageService.findBasMessage(msgId);
        if (msg == null) {
            throw new GEPSBisException("\u6ca1\u6709\u627e\u5230\u8be5\u5f85\u529e\u4e8b\u9879");
        }
        Long maxworkitemid = this.queryCurrentWorkItem(msg.getProcessinstid());
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        WorkItem work = workItemRep.findWorkItem(msg.getWorkitemid().longValue());
        this.genAddSignWorkItem(work, accoundIds);
        this.sysMsgdeal(maxworkitemid, null, msg.getFormCode(), msg.getBusiMainId(), msg.getProcessinstid(), "add", null, true, null, null, null, null);
    }

    public void genAddSignWorkItem(WorkItem work, String accoundIds) {
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        String[] ids = accoundIds.split(",");
        System.out.println("sssssss");
        for (String id : ids) {
            WorkItem workItem = new WorkItem();
            workItem.setWorkItemName(work.getWorkItemName());
            workItem.setActivityInstId(work.getActivityInstId());
            workItem.setActivityDefId(work.getActivityDefId());
            workItem.setWorkItemType("man");
            workItem.setProcessInstId(work.getProcessInstId());
            workItem.setCurrentState(10);
            workItem.setProcessDefName(work.getProcessDefName());
            workItem.setLimitTime(work.getLimitTime());
            workItem.setStartTime(new Date());
            workItem.setParticipant(id);
            workItem.setIsAdd("Y");
            long workItemId = PrimaryKeyUtil.getPrimaryKey((String)"workItemId");
            workItem.setWorkItemId(workItemId);
            Participant p = new Participant();
            p.setParticId(PrimaryKeyUtil.getPrimaryKey((String)"participantId").longValue());
            p.setWorkItemId(workItemId);
            p.setParticipant(id);
            p.setParticType("person");
            BasEmpAccount account = this.basEmpAccountService.findById(Long.parseLong(id));
            if (account != null) {
                p.setParticipant2(account.getAccountName());
            }
            workItemRep.insertWorkItem(workItem);
            workItemRep.insertPaericipant(p);
        }
    }

    private void setWorkmemoryPic(Long workItemId, String signpic, String follows, String actAttitude, String attitudeOptions) {
        String updateSql = "update wf_workitem w  set w.WORKMEMORY_PIC=?1,w.FOLLOW_TYPE='" + (follows == null ? "" : follows) + "',w.ATTITUDE='" + (actAttitude == null ? "" : actAttitude) + "',w.ATTITUDE_OPTIONS='" + (attitudeOptions == null ? "" : attitudeOptions) + "' where w.WORKITEMID=?2";
        this.sqlHelper.exeNativeSQL(updateSql, new Object[]{signpic, workItemId});
    }

    public void stopFlow(Long processInstId, String businessMainId, Long workItemId, String signpic, String follows, String actAttitude, String attitudeOptions) {
        String updateSql = "update wf_workitem w  set w.WORKMEMORY_PIC=?1,w.FOLLOW_TYPE='" + (follows == null ? "" : follows) + "',w.ATTITUDE='" + (actAttitude == null ? "" : actAttitude) + "',w.ATTITUDE_OPTIONS='" + (attitudeOptions == null ? "" : attitudeOptions) + "',w.ENDTIME=now(),w.CURRENTSTATE=12 where w.WORKITEMID=?2";
        this.sqlHelper.exeNativeSQL(updateSql, new Object[]{signpic, workItemId});
        this.msgService.delMydealByWorkitemid(workItemId, SysUtils.getLoginAccountId(), null);
        this.msgService.delMydealByProcessinstid(processInstId, businessMainId);
        this.procInstService.terminateProcess(processInstId.longValue());
    }

    private void genNextActParticipants(Long processInstId, Long userId, String toActIds, String formCode, String nextPersons) {
        int i;
        ProcessInstance processInstance = this.procInstService.findProcessById(processInstId.longValue());
        Document processDefContentDOC = ProcessDefineParser.createDocument((String)this.sbpservice.queryFlowContent(null, processInstId));
        ProcessElement processXml = ProcessDefineParser.createProcessXml((String)processDefContentDOC.asXML());
        int length = toActIds.split(splitstr).length;
        for (i = 0; i < length; ++i) {
            if (!"toolApp".equals(((ActivityElement)processXml.getActivitys().get(toActIds.split(splitstr)[i])).getType())) continue;
            List list = ((ActivityElement)processXml.getActivitys().get(toActIds.split(splitstr)[i])).getAfterTrans();
            for (TransitionElement tran : list) {
                toActIds = toActIds + splitstr + tran.getTo();
                nextPersons = nextPersons + splitstr;
            }
        }
        for (i = 0; i < toActIds.split(splitstr).length; ++i) {
            if ("toolApp".equals(((ActivityElement)processXml.getActivitys().get(toActIds.split(splitstr)[i])).getType())) continue;
            HashMap userids = new HashMap();
            Element Participants = (Element)processDefContentDOC.selectSingleNode("/ProcessDefine/Activitys/Activity[@id='" + toActIds.split(splitstr)[i] + "']/Participants");
            Element participantType = (Element)processDefContentDOC.selectSingleNode("/ProcessDefine/Activitys/Activity[@id='" + toActIds.split(splitstr)[i] + "']/participantType");
            List participantEleList = processDefContentDOC.selectNodes("/ProcessDefine/Activitys/Activity[@id='" + toActIds.split(splitstr)[i] + "']/Participants/participant");
            if (StringUtils.isNotBlank((String)nextPersons) && StringUtils.isNotBlank((String)nextPersons.replaceAll(splitstr, "")) && StringUtils.isNotBlank((String)nextPersons.split(splitstr)[i])) {
                participantType.setText("org-role");
                List participantList = JSONArray.parseArray((String)nextPersons.split(splitstr)[i], Participant.class);
                if (participantList.size() <= 0) continue;
                for (Element element : participantEleList) {
                    Participants.remove(element);
                }
                for (Participant participant : participantList) {
                    if (userids.containsKey(participant.getParticipant())) continue;
                    userids.put(participant.getParticipant(), null);
                    Element tmpparticipant = Participants.addElement("participant");
                    tmpparticipant.addAttribute("id", participant.getParticipant());
                    tmpparticipant.addAttribute("name", participant.getParticipant2());
                    tmpparticipant.addAttribute("type", participant.getParticType());
                }
                continue;
            }
            String split = ">";
            BasEmpAccount creater = this.basEmpAccountService.findById(Long.parseLong(processInstance.getCreator()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map creatermap = BeanUtil.beanToMap((Object)creater);
            BasOrg org = this.basOrgService.findByOrgId(creater.getOrgId());
            if (org.getBelongDept() != null) {
                creatermap.put("businessUnitId", org.getBelongDept());
                BasDept belongedept = this.basDeptService.findByDeptId(org.getBelongDept());
                if (belongedept != null) {
                    creatermap.put("businessUnitOrgId", belongedept.getOrgId());
                }
            } else {
                creatermap.put("businessUnitId", creater.getDeptId());
                creatermap.put("businessUnitOrgId", creater.getOrgId());
            }
            map.put("creater", creatermap);
            map.put("loginuser", SysUtils.getLoginUser());
            try {
                map.putAll(this.getFormParams(processInstId, formCode));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Element element : participantEleList) {
                if ("organization".equals(element.attributeValue("type"))) {
                    List<BasEmpAccount> accounts = element.attributeValue("id").contains(">") ? this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(element.attributeValue("id"), map).split(">")[1])) : this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(element.attributeValue("id"), map)));
                    Participants.remove(element);
                    for (BasEmpAccount account : accounts) {
                        if (userids.containsKey(account.getAccountId().toString())) continue;
                        userids.put(account.getAccountId().toString(), null);
                        Element tmpparticipant = Participants.addElement("participant");
                        tmpparticipant.addAttribute("id", account.getAccountId().toString());
                        tmpparticipant.addAttribute("name", account.getAccountName());
                        tmpparticipant.addAttribute("type", "person");
                    }
                    continue;
                }
                if (!element.attributeValue("id").contains(">")) continue;
                Participants.remove(element);
                List<String> ids = Arrays.asList(FreeMarkerUtil.instance().genString(element.attributeValue("id"), map).split(">"));
                List accounts = null;
                if (ids.size() == 2) {
                    accounts = this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), null, Long.parseLong(ids.get(1)));
                } else if (ids.size() == 3) {
                    accounts = this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), Long.parseLong(ids.get(1)), Long.parseLong(ids.get(2)));
                }
                for (Object o : accounts) {
                    Map m = (Map)o;
                    if (userids.containsKey(Objects.toString(m.get("ACCOUNT_ID"), ""))) continue;
                    userids.put(Objects.toString(m.get("ACCOUNT_ID"), ""), null);
                    Element tmpparticipant = Participants.addElement("participant");
                    tmpparticipant.addAttribute("id", Objects.toString(m.get("ACCOUNT_ID"), ""));
                    tmpparticipant.addAttribute("name", Objects.toString(m.get("ACCOUNT_NAME"), ""));
                    tmpparticipant.addAttribute("type", "person");
                }
            }
        }
        this.procInstRep.updateProcessDefineProcessInst(processDefContentDOC.asXML(), userId.toString(), processInstance.getProcessDefId(), processInstId.longValue());
    }

    public void excuteFlowDefault(Long processInstId, String formCode, Long businessMainId, String title) throws GEPSBisException, DocumentException {
        this.excuteFlowDefault(processInstId, formCode, businessMainId, title, new HashMap<String, Object>());
    }

    public WfActivityParams excuteFlowDefaultV(Long processInstId, String formCode, Long businessMainId, String title) throws GEPSBisException, DocumentException {
        return this.excuteFlowDefaultV(processInstId, formCode, businessMainId, title, new HashMap<String, Object>());
    }

    public void excuteFlowDefault(Long processInstId, String formCode, Long businessMainId, String title, Map<String, Object> condtion) throws GEPSBisException, DocumentException {
        LoginUser user = SysUtils.getLoginUser();
        if (condtion == null) {
            condtion = new HashMap<String, Object>();
        }
        condtion.put("businessMainId", businessMainId);
        condtion.put("formCode", formCode);
        condtion.put("msgtitle", title);
        WfActivityParams params = this.getLineCondition(processInstId, user.getAccountid(), condtion, formCode);
        if (!params.getLines().isEmpty()) {
            String cond1 = params.getLines().get(0)[1].toString();
            this.excuteFlow(processInstId, user.getAccountid(), user.getOrgid(), formCode, businessMainId.toString(), cond1, params.getLines().get(0)[2].toString(), "TG", "\u4e0a\u62a5", title, 1L, "", "", null, null, null, null, null, null);
        }
    }

    public void excuteFlowDefault(Long userId, Long processInstId, String formCode, Long businessMainId, String title, Map<String, Object> condtion, String advice, String parts) throws GEPSBisException, DocumentException {
        if (condtion == null) {
            condtion = new HashMap<String, Object>();
        }
        condtion.put("businessMainId", businessMainId);
        condtion.put("formCode", formCode);
        condtion.put("msgtitle", title);
        WfActivityParams params = this.getLineCondition(processInstId, userId, condtion, formCode);
        if (!params.getLines().isEmpty()) {
            String cond1 = params.getLines().get(0)[1].toString();
            this.excuteFlow(processInstId, userId, this.basEmpAccountService.findById(userId).getOrgId(), formCode, businessMainId.toString(), cond1, params.getLines().get(0)[2].toString(), "TG", "\u4e0a\u62a5", title, 1L, "", parts, null, null, null, null, null, null);
        }
    }

    public Map<String, Object> getFormParams(Long processInstId, String formCode) throws Exception {
        ProcessInstance instance;
        BasEmpAccount account;
        if (StringUtils.isBlank((String)formCode)) {
            return new HashMap<String, Object>();
        }
        GenForm form = this.genFormService.findGenFormByCode(formCode);
        String sql = "call getbusimainid('" + form.getBusiTable() + "'," + processInstId + ") ";
        Object ob = this.sqlHelper.getSingal(sql);
        this.logger.info((Object)("\u8bf7\u6c42\u4e1a\u52a1\u53c2\u6570\uff1aformCode:" + formCode + ",\u4e1a\u52a1\u8868\uff1a" + form.getBusiTable() + "\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + processInstId + ",\u4e3b\u952e:" + Objects.toString(ob, "") + ",\u8bf7\u6c42\u5730\u5740\uff1a" + (form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&id=" + ob : form.getLoaddataUrl() + "?id=" + Objects.toString(ob, ""))));
        if (ob == null) {
            return new HashMap<String, Object>();
        }
        String loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&id=" + ob : form.getLoaddataUrl() + "?id=" + ob;
        JSONObject objectdata = (JSONObject)SysUtils.sendHttp(loadurl);
        if (processInstId != null && (account = this.basEmpAccountService.findById(Long.parseLong((instance = this.procInstService.findProcessById(processInstId.longValue())).getCreator()))) != null) {
            objectdata.put("isCreatorGroup", (Object)(account.getOrgId().intValue() == 10000000 ? "Y" : "N"));
            objectdata.put("creatorOrgId", (Object)account.getOrgId());
            objectdata.put("creatorDeptId", (Object)account.getDeptId());
            objectdata.put("creatorJobLevel", (Object)this.beetls.getStringValue("business.hr.HrEmp.getMaxJobLevel", MapUtil.of((Object)"accountId", (Object)account.getAccountId())));
        }
        Map map = (Map)JSONObject.parseObject((String)objectdata.toJSONString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if ("EdocApply".equals(formCode) && map.get("param") != null) {
            map.putAll((Map)map.get("param"));
        }
        return map;
    }

    public WfActivityParams getLineCondition(Long processInstId, Long userId, Map<String, Object> condtion, String formCode) {
        WfActivityParams params = this.getWfActivityParams(processInstId, userId, condtion);
        if (params.getWorkItem() == null) {
            return params;
        }
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        String processDefContent = this.sbpservice.queryFlowContent(null, processInstId);
        ProcessElement processXml = ProcessDefineParser.createProcessXml((String)processDefContent);
        List list = Dom4jProcDefParser.parserTransitionInfo((String)processDefContent, (String)params.getWorkItem().getActivityDefId());
        ArrayList<Object[]> obl = new ArrayList<Object[]>(list.size());
        boolean allWorkDone = this.isAllWorkItemIsDoneWhenPass(processInstId, params.getWorkItem().getWorkItemId());
        params.setAllWorkDone(allWorkDone);
        this.addCondition(condtion, processInstId, formCode);
        condtion.get("estimatedExpenditure");
        if ("1".equals(params.getWorkItem().getBackoptions()) && params.getWorkItem().getSourceworkItemId() != 0L) {
            WorkItem sourceworkItem = workItemRep.findWorkItem(params.getWorkItem().getSourceworkItemId());
            Object[] ob = new Object[13];
            ob[0] = "\u91cd\u65b0\u63d0\u4ea4";
            ob[1] = "";
            ob[2] = sourceworkItem.getActivityDefId();
            ob[3] = "TG";
            ob[4] = params.getWorkItem().getActivityDefId();
            ActivityElement actEle = (ActivityElement)processXml.getActivitys().get(ob[2]);
            ob[5] = false;
            ob[6] = actEle.getName();
            ob[7] = actEle.getWiMode();
            ob[8] = "person";
            BasEmpAccount account = this.basEmpAccountService.findById(Long.parseLong(sourceworkItem.getParticipant()));
            if (account != null) {
                ob[9] = account.getAccountName();
            }
            ob[10] = "";
            ob[11] = "";
            ob[12] = "";
            obl.add(ob);
        } else {
            List<Element> els = new ArrayList();
            HashMap<String, String> preActs = new HashMap<String, String>();
            HashMap<String, String> conds = new HashMap<String, String>();
            HashMap acts = new HashMap();
            if (this.isAllWorkItemIsDoneWhenPass(processInstId, params.getWorkItem().getWorkItemId())) {
                Element el;
                Iterator iterator1 = list.iterator();
                while (iterator1.hasNext()) {
                    el = (Element)iterator1.next();
                    Iterator iterator = el.elementIterator("complexExpressionValue");
                    while (iterator.hasNext()) {
                        Element childel = (Element)iterator.next();
                        String exp = this.isConform(childel.getData().toString(), condtion, processInstId, formCode);
                        if (exp == null) {
                            iterator1.remove();
                            continue;
                        }
                        conds.put(el.attributeValue("to"), exp);
                    }
                }
                while (!list.isEmpty()) {
                    List<Object> nextpersons;
                    el = (Element)list.get(0);
                    try {
                        nextpersons = this.getNextWFParticipantIds(processInstId, el.attributeValue("to"), "N", formCode, condtion);
                    }
                    catch (Exception e) {
                        nextpersons = new ArrayList();
                    }
                    catch (Throwable t) {
                        nextpersons = new ArrayList();
                    }
                    ActivityElement nextact = (ActivityElement)processXml.getActivitys().get(el.attributeValue("to"));
                    if (nextact != null && "Y".equals(nextact.getAutoFinish()) && nextpersons.size() == 1 && ((Long)nextpersons.get(0)).equals(SysUtils.getLoginAccountId())) {
                        List nextlist = Dom4jProcDefParser.parserTransitionInfo((String)processDefContent, (String)el.attributeValue("to"));
                        block6: for (Element ne : nextlist) {
                            String preact = "";
                            if (preActs.get(el.attributeValue("to")) != null) {
                                preact = (String)preActs.get(el.attributeValue("to"));
                            }
                            if (StringUtils.isNotBlank((String)preact)) {
                                preact = preact + ",";
                            }
                            preActs.put(ne.attributeValue("to"), preact + el.attributeValue("to"));
                            Iterator iterator = ne.elementIterator("complexExpressionValue");
                            while (iterator.hasNext()) {
                                Element childel = (Element)iterator.next();
                                String exp = this.isConform(childel.getData().toString(), condtion, processInstId, formCode);
                                if (exp == null) continue block6;
                                String prcond = "";
                                if (conds.get(el.attributeValue("to")) != null) {
                                    prcond = (String)conds.get(el.attributeValue("to"));
                                }
                                if (StringUtils.isNotBlank((String)prcond)) {
                                    prcond = prcond + ",";
                                }
                                conds.put(ne.attributeValue("to"), prcond + exp);
                            }
                            list.add(ne);
                        }
                    } else {
                        els.add(el);
                    }
                    list.remove(0);
                }
            } else {
                els = list;
            }
            block8: for (Element el : els) {
                Element childel;
                if (acts.containsKey(el.attributeValue("to"))) continue;
                Object[] ob = new Object[13];
                Iterator iterator = el.elementIterator("complexExpressionValue");
                while (iterator.hasNext()) {
                    childel = (Element)iterator.next();
                    String exp = this.isConform(childel.getData().toString(), condtion, processInstId, formCode);
                    if (exp == null) continue block8;
                    acts.put(el.attributeValue("to"), null);
                    ob[1] = exp;
                }
                ob[0] = el.attributeValue("name");
                if (ob[0] == null || StringUtils.isEmpty((String)ob[0].toString())) {
                    ob[0] = "\u53d1\u9001";
                }
                ob[2] = el.attributeValue("to");
                iterator = el.elementIterator("description");
                while (iterator.hasNext()) {
                    childel = (Element)iterator.next();
                    ob[3] = childel.getData().toString();
                }
                ob[4] = params.getWorkItem().getActivityDefId();
                ActivityElement actEle = (ActivityElement)processXml.getActivitys().get(ob[2]);
                List<Long> nextpersons = this.getNextWFParticipantIds(processInstId, el.attributeValue("to"), "N", formCode, condtion);
                ob[5] = "act_finish".equals(el.attributeValue("to")) ? Boolean.valueOf(false) : ((nextpersons == null || nextpersons.isEmpty()) && !"toolApp".equals(((ActivityElement)processXml.getActivitys().get(el.attributeValue("to"))).getType()) ? Boolean.valueOf(this.isStartActivity(processInstId, params.getWorkItem().getWorkItemId(), Objects.toString(ob[2], ""))) : Boolean.valueOf(actEle.getIsAllowAppointParticipants() != null && actEle.getIsAllowAppointParticipants() != false && this.isStartActivity(processInstId, params.getWorkItem().getWorkItemId(), Objects.toString(ob[2], ""))));
                ob[6] = actEle.getName();
                ob[7] = actEle.getWiMode();
                ob[8] = "role";
                ob[9] = "";
                ob[10] = preActs.get(el.attributeValue("to")) == null ? "" : preActs.get(el.attributeValue("to"));
                ob[11] = conds.get(el.attributeValue("to")) == null ? "" : conds.get(el.attributeValue("to"));
                Iterator iterator2 = el.elementIterator("advice");
                while (iterator2.hasNext()) {
                    Element childel2 = (Element)iterator2.next();
                    ob[12] = childel2.getData().toString();
                }
                if (ob[12] == null || "".equals(ob[12])) {
                    ob[12] = ob[0];
                }
                if ((nextpersons == null || nextpersons.isEmpty()) && Objects.toString(ob[5]) == "true") {
                    ob[8] = "org";
                } else if (actEle.getParticipants() != null) {
                    for (Participant p : actEle.getParticipants()) {
                        if (!"organization".equals(p.getParticType()) || p.getParticipant().contains(">")) continue;
                        ob[8] = "org";
                    }
                }
                obl.add(ob);
            }
        }
        params.setLines(obl);
        return params;
    }

    public WfActivityParams excuteFlowDefaultV(Long processInstId, String formCode, Long businessMainId, String title, Map<String, Object> condtion) throws GEPSBisException, DocumentException {
        LoginUser user = SysUtils.getLoginUser();
        condtion.put("businessMainId", businessMainId);
        condtion.put("formCode", formCode);
        condtion.put("msgtitle", title);
        WfActivityParams params = this.getLineCondition(processInstId, user.getAccountid(), condtion, formCode);
        if (params.getLines() != null && !params.getLines().isEmpty()) {
            String cond1 = params.getLines().get(0)[1].toString();
            this.excuteFlow(processInstId, user.getAccountid(), user.getOrgid(), formCode, businessMainId.toString(), cond1, params.getLines().get(0)[2].toString(), "TG", "\u4e0a\u62a5", title, 1L, "", "", null, null, null, null, null, null);
        }
        return params;
    }

    public WfActivityParams getWfActivityParams(Long processInstId, Long userId, Map<String, Object> condtion) {
        WfActivityParams params = new WfActivityParams();
        Long workitemid = this.getWorkItemId(processInstId);
        if (workitemid != null) {
            HashMap<String, Object> sqlparams = new HashMap<String, Object>();
            sqlparams.put("workitemid", workitemid);
            sqlparams.put("processinstId", processInstId);
            String undoAccount = this.beetls.getStringValue("workflow.flow.checkAddWorkitem", sqlparams);
            if (StringUtils.isNotBlank((String)undoAccount)) {
                params.setValidate(false);
                params.setUnvalidateMsg("\u52a0\u7b7e\u4eba\u5458[" + undoAccount + "]\u6682\u672a\u53cd\u9988\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5");
                return params;
            }
            IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
            WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
            params.setWorkItem(workItem);
            params.setBusinessMainId(Long.parseLong(condtion.get("businessMainId").toString()));
            params.setProcessInstId(processInstId);
            params.setFormCode(condtion.get("formCode").toString());
            if (condtion.get("msgtitle") != null) {
                params.setTitle(String.valueOf(condtion.get("msgtitle")));
            }
            params.setParams(condtion);
            params.setActId(workItem.getActivityDefId());
            String processDefContent = this.sbpservice.queryFlowContent(null, processInstId);
            ActivityElement actEle = (ActivityElement)ProcessDefineParser.createProcessXml((String)processDefContent).getActivitys().get(workItem.getActivityDefId());
            if (actEle != null) {
                Map<String, Object> edocAct;
                boolean isStart = this.isStartActivity(processInstId, workitemid, "");
                params.setCanCopy(isStart && StringUtils.isNotBlank((String)actEle.getCopyparticipantType()));
                params.setChooseCopy(isStart && actEle.getIsAllowAppointcopyParticipants() != false);
                params.setSplitMode(actEle.getSplitMode());
                params.setIsFreeActivity(actEle.getIsFreeActivity());
                params.setAllowFile(actEle.getIsAllowFile());
                Element actClass = (Element)ProcessDefineParser.createDocument((String)processDefContent).selectSingleNode("/ProcessDefine/Activitys/Activity[@id='" + actEle.getId() + "']/actClass");
                if (actClass != null) {
                    params.setActClass(actClass.getStringValue());
                }
                ProcessInstance instance = this.procInstService.findProcessById(processInstId.longValue());
                params.setFreeacts(this.processEngine.getFreeFlowService().queryCustomPossibleNextActsOfFreeActivity(processInstId.longValue(), instance.getProcessDefId(), actEle.getId()));
                if (StringUtils.isNotBlank((String)actEle.getActPerm()) && (edocAct = this.bSqlHelper.getMap("workflow.flow.getEdocAct", MapUtil.of((Object)"id", (Object)Long.parseLong(actEle.getActPerm())))) != null) {
                    params.setActAttitude(Objects.toString(edocAct.get("actAttitude"), ""));
                    params.setDisagreeChoose(Objects.toString(edocAct.get("disagreeChoose"), ""));
                    params.setChooseOptions(Objects.toString(edocAct.get("chooseOptions"), ""));
                }
                Map properties = actEle.getProperties();
                Set set = properties.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String obj = (String)iterator.next();
                    if (!StringUtils.isBlank((String)obj)) continue;
                    iterator.remove();
                }
                params.getParams().putAll(properties);
                if (properties.get("paramsClass") != null) {
                    String className = ((String)properties.get("paramsClass")).toString();
                    IWfActivityParamsService paramsClass = (IWfActivityParamsService)this.processEngine.getApplicationContext().getBean(className);
                    params = paramsClass.genActivityParams(params);
                }
            }
        }
        return params;
    }

    public JsonMsg excuteFlowWithMsgIds(Long[] msgIds, String flowline, String advice, Long accountId) {
        JsonMsg msg = new JsonMsg();
        StringBuffer sb = new StringBuffer();
        for (Long msgId : msgIds) {
            BasMessage basMessage = this.msgService.findBasMessage(msgId);
            try {
                Object[] chooseline;
                block7: {
                    WfActivityParams params;
                    block8: {
                        if (basMessage == null) continue;
                        HashMap<String, Object> cond = new HashMap<String, Object>();
                        cond.put("businessMainId", basMessage.getBusiMainId());
                        cond.put("formCode", basMessage.getFormCode());
                        cond.put("msgtitle", basMessage.getMsgTitle());
                        params = this.getLineCondition(basMessage.getProcessinstid(), accountId, cond, basMessage.getFormCode());
                        if (params.getLines() == null) {
                            this.logger.error((Object)("\u6d41\u7a0b:" + basMessage.getProcessinstid() + "\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u7684\u9009\u9879"));
                            sb.append("\u5f85\u529e:" + this.splitMsgTitle(basMessage.getMsgTitle()) + "-\u6ca1\u6709\u5bf9\u5e94\u7684\u5de5\u4f5c\u9879,\u8bf7\u6838\u5b9e<br>");
                            continue;
                        }
                        chooseline = null;
                        if (params.getChooseCopy().booleanValue() || params.isNeedConfirm() || !params.isValidate()) break block7;
                        if (params.getLines().size() != 1) break block8;
                        if ("true".equals(params.getLines().get(0)[5].toString())) break block7;
                        chooseline = params.getLines().get(0);
                        break block7;
                    }
                    for (Object[] line : params.getLines()) {
                        if (!flowline.equals(line[3].toString()) || "true".equals(line[5].toString())) continue;
                        chooseline = line;
                        break;
                    }
                }
                if (chooseline == null) {
                    this.logger.error((Object)("\u6d41\u7a0b:" + basMessage.getProcessinstid() + "\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8fde\u7ebf"));
                    sb.append("\u5f85\u529e:" + this.splitMsgTitle(basMessage.getMsgTitle()) + "-\u4e0d\u7b26\u5408\u6279\u91cf\u6267\u884c\u6761\u4ef6,\u8bf7\u5355\u72ec\u5ba1\u6279<br>");
                    continue;
                }
                BasEmpAccount account = this.basEmpAccountService.findById(accountId);
                String condition = chooseline[1].toString();
                this.excuteFlow(basMessage.getProcessinstid(), accountId, account.getOrgId(), basMessage.getFormCode(), basMessage.getBusiMainId(), condition, chooseline[2].toString(), flowline, advice, basMessage.getMsgParams(), SysContent.MSG_LEVEL_0, "", null, null, null, null, null, null, null);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u6d41\u7a0b:" + basMessage.getProcessinstid() + "\u6267\u884c\u51fa\u9519!"), (Throwable)e);
                sb.append("\u5f85\u529e:" + this.splitMsgTitle(basMessage.getMsgTitle()) + "\u4e0d\u7b26\u5408\u6279\u91cf\u6267\u884c\u6761\u4ef6,\u8bf7\u5355\u72ec\u5ba1\u6279\n");
            }
        }
        if (StrKit.notBlank(sb.toString())) {
            sb.insert(0, "\u9664\u4ee5\u4e0b\u5f85\u529e\u5b58\u5728\u95ee\u9898,\u5176\u4ed6\u5f85\u529e\u5747\u5904\u7406\u5b8c\u6210<br>");
            msg.setSuccess(false);
        }
        msg.setMsg(sb.toString());
        return msg;
    }

    private Map<String, Object> buildCondition(String condition) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StrKit.notBlank(condition)) {
            String[] acons;
            Pattern pattern = Pattern.compile("&&|\\|\\|");
            Pattern pattern2 = Pattern.compile("==|>=|<=|>|<|!=");
            for (String acon : acons = pattern.split(condition.replaceAll("\\(|\\)", ""))) {
                try {
                    String[] con = pattern2.split(acon);
                    con[0] = con[0].replaceAll("#", "");
                    String value = con[1].trim();
                    if ("status".equals(con[0])) {
                        // empty if block
                    }
                    if (value.contains("'")) {
                        value = value.replaceAll("'", "");
                        conditions.put(con[0].trim(), value);
                        continue;
                    }
                    try {
                        if (value.indexOf(".") != -1) {
                            conditions.put(con[0].trim(), Double.parseDouble(value));
                            continue;
                        }
                        conditions.put(con[0].trim(), Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        conditions.put(con[0].trim(), value);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38" + acon));
                }
            }
        }
        return conditions;
    }

    private String isConform(String expression, Map<String, Object> condition, Long processInstId, String formCode) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("SpringExpression");
        Bindings variables = engine.createBindings();
        String expBak = expression = expression.replaceAll("\\s*|\t|\r|\n", "");
        variables.putAll((Map<? extends String, ? extends Object>)condition);
        expBak = expBak.replaceAll("&&", "and");
        expBak = expBak.replaceAll("\\|\\|", "or");
        try {
            if ("".equals(expBak.trim()) || ((Boolean)engine.eval(expBak, variables)).booleanValue()) {
                return expression;
            }
            return null;
        }
        catch (ScriptException e) {
            this.logger.error((Object)("\u89e3\u6790\u8868\u8fbe\u5f0f\u5931\u8d25\uff1a" + expBak));
            return null;
        }
    }

    public Map<String, Object> addCondition(Map<String, Object> condition) {
        if (condition == null) {
            condition = new HashMap<String, Object>();
        }
        LoginUser user = new LoginUser();
        LoginUser loginuser = SysUtils.getLoginUser();
        BeanUtil.copyProperties((Object)loginuser, (Object)user, (String[])new String[0]);
        user.setScriptSession(null);
        user.setAccountList(null);
        condition.putAll(BeanUtil.beanToMap((Object)user));
        condition.put("isGroup", user.getOrgid().intValue() == 10000000 ? "Y" : "N");
        condition.put("isBiz", user.getOrgid().equals(user.getBusinessUnitOrgId()) ? "N" : "Y");
        return condition;
    }

    public Map<String, Object> addCondition(Map<String, Object> condition, Long processInstId, String formCode) {
        if (condition == null) {
            condition = new HashMap<String, Object>();
        }
        this.addCondition(condition);
        try {
            condition.putAll(this.getFormParams(processInstId, formCode));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u6dfb\u52a0\u8868\u5355\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return condition;
    }

    private void sendCopyMsg(Long workitemid, Long processInstId, String formCode, String businessMainId, String copyPersons, String title, String actId, Long msglevel) throws GEPSBisException {
        String flowName;
        if (StringUtils.isBlank((String)copyPersons)) {
            return;
        }
        ProcessInstance instance = this.procInstService.findProcessById(processInstId.longValue());
        ActivityElement actEle = (ActivityElement)ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processInstId)).getActivitys().get(actId);
        Map properties = actEle.getProperties();
        String menuId = (String)properties.get("menuId");
        String msgUrl = (String)properties.get("url");
        if (menuId != null) {
            BasMenu basmenu = this.menuservice.findBasMenu(Long.parseLong(menuId));
            if (basmenu != null) {
                String menuurl = basmenu.getMenuAddr();
                msgUrl = menuurl.indexOf("?") > 0 ? menuurl + "&menuId=" + menuId : menuurl + "?menuId=" + menuId;
            } else {
                throw new GEPSBisException("menuid\u4e3a" + menuId + "\u7684\u83dc\u5355\u672a\u627e\u5230!");
            }
        }
        if ("EdocApply".equals(formCode) && StringUtils.isBlank((String)msgUrl)) {
            msgUrl = "/EdocApply/edocForm?edocId=" + businessMainId;
        }
        String msgtitle = flowName = this.getFlowNameByProcessInstId(processInstId);
        if (StringUtils.isBlank((String)title) || "undefined".equals(title)) {
            title = this.genFormService.getFlowTitle(formCode, businessMainId);
        }
        if (StringUtils.isNotBlank((String)title)) {
            msgtitle = msgtitle + "-" + title;
        }
        ArrayList<Long> receiveIds = new ArrayList<Long>();
        List participantList = JSONArray.parseArray((String)copyPersons, Participant.class);
        for (Participant part : participantList) {
            receiveIds.add(Long.parseLong(part.getParticipant()));
        }
        GenForm form = this.genFormService.findGenFormByCode(formCode);
        this.msgService.saveMessage(processInstId, workitemid, msgtitle, title, SysUtils.getLoginAccountId(), receiveIds, msgUrl, SysContent.MSG_COPY.toString(), formCode, businessMainId, msglevel, "", StrKit.toBoolean(form.getIsApp()));
    }

    private void sysMsgdeal(Long maxworkitemid, Long workitemid, String formCode, String businessMainId, Long processInstId, String TH, String title, boolean isAllWorkDoned, Long msglevel, String listUrl, Long userId, String follows) throws GEPSBisException {
        if (userId == null) {
            userId = SysUtils.getLoginAccountId();
        }
        Long orgId = SysUtils.getLoginUser().getOrgid();
        if (workitemid != null) {
            this.msgService.delMydealByWorkitemid(workitemid, userId, follows);
        }
        if ("TH".equals(TH) || "ROLL".equals(TH)) {
            this.msgService.delMydealByProcessinstid(processInstId, businessMainId);
        }
        ProcessInstance instance = this.procInstService.findProcessById(processInstId.longValue());
        List workList = this.workItemService.findUnFinishedWorkItemByProcessInstId(processInstId.longValue());
        String bizTile = this.genFormService.getFlowTitle(formCode, businessMainId);
        List<BasMessage> msgs = this.msgService.findByProcessinstid(processInstId);
        HashMap works = new HashMap();
        msgs.forEach(msg -> works.put(msg.getWorkitemid(), null));
        for (WorkItem work : workList) {
            ActivityElement actEle;
            if (maxworkitemid.compareTo(work.getWorkItemId()) >= 0 || works.containsKey(work.getWorkItemId()) || (actEle = (ActivityElement)ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processInstId)).getActivitys().get(work.getActivityDefId())) == null || "act_finish".equals(work.getActivityDefId())) continue;
            Map properties = actEle.getProperties();
            try {
                String flowName;
                String menuId = (String)properties.get("menuId");
                String msgUrl = (String)properties.get("url");
                if (menuId != null) {
                    BasMenu basmenu = this.menuservice.findBasMenu(Long.parseLong(menuId));
                    if (basmenu != null) {
                        String menuurl = basmenu.getMenuAddr();
                        msgUrl = menuurl.indexOf("?") > 0 ? menuurl + "&menuId=" + menuId : menuurl + "?menuId=" + menuId;
                    } else {
                        throw new GEPSBisException("menuid\u4e3a" + menuId + "\u7684\u83dc\u5355\u672a\u627e\u5230!");
                    }
                }
                if ("EdocApply".equals(formCode) && StringUtils.isBlank((String)msgUrl)) {
                    msgUrl = "/EdocApply/edocForm?edocId=" + businessMainId;
                }
                String msgtitle = flowName = this.getFlowNameByProcessInstId(processInstId);
                if (StringUtils.isBlank((String)title) || "undefined".equals(title)) {
                    title = bizTile;
                }
                if (StringUtils.isNotBlank((String)title)) {
                    msgtitle = msgtitle + "-" + title;
                }
                GenForm form = this.genFormService.findGenFormByCode(formCode);
                List<Long> receiveIds = this.getNextPersion(work, orgId);
                this.msgService.saveMessage(processInstId, work.getWorkItemId(), msgtitle, title, userId, receiveIds, msgUrl, SysContent.MSG_BASE.toString(), formCode, businessMainId, msglevel, listUrl, StrKit.toBoolean(form.getIsApp()));
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790\u63a5\u6536\u4eba\u5931\u8d25\uff01", (Throwable)e);
                throw new GEPSBisException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u63a5\u6536\u4eba\u5931\u8d25!");
            }
        }
        if ("12".equals(String.valueOf(instance.getCurrentState()))) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(Long.parseLong(instance.getCreator()));
            try {
                String flowName = this.getFlowNameByProcessInstId(processInstId) + "-" + bizTile;
                if (!userId.equals(Long.parseLong(instance.getCreator()))) {
                    this.msgService.saveMessage(processInstId, null, "\u60a8\u53d1\u8d77\u7684" + flowName + "\u5df2\u7ed3\u675f\uff0c\u8bf7\u77e5\u6089\uff01", null, userId, list, "", "3", formCode, businessMainId, SysContent.MSG_LEVEL_0, "", false);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"\u6d41\u7a0b\u7ed3\u675f\u901a\u77e5\u53d1\u8d77\u4eba\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public List<Long> getNextPersion(WorkItem work, Long orgId) throws GEPSBisException {
        ArrayList<Long> receiveIds = new ArrayList<Long>();
        StringBuilder role = new StringBuilder();
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        List partlist = workItemRep.findWorkItemParticipants(work.getWorkItemId());
        for (Participant p : partlist) {
            if ("person".equals(p.getParticType())) {
                Long uId = Long.valueOf(p.getParticipant());
                receiveIds.add(uId);
                continue;
            }
            if (!"role".equals(p.getParticType())) continue;
            role.append("'" + p.getParticipant() + "',");
        }
        if (role.length() > 0) {
            role.deleteCharAt(role.length() - 1);
            List<Long> ids = this.getNextStepPerson(orgId, role.toString());
            receiveIds.addAll(ids);
        }
        return receiveIds.stream().distinct().collect(Collectors.toList());
    }

    private void saveProcInstIdInBusiness(String tableName, Long businessMainId, Long processinstId) {
        String businessMainIdCode = this.commonService.getPK(tableName);
        String updateSql = "update " + tableName + " t set t." + "processinstid" + "=" + processinstId + ",t.workflow_status=" + SysContent.DEFAULT_STATUS + " where t." + businessMainIdCode + "=" + businessMainId;
        this.sqlHelper.exeNativeSQL(updateSql);
    }

    private void updateBusinessStatus(String formCode, String businessMainId, Long processInstId, String status) {
        GenForm from = this.genFormService.findGenFormByCode(formCode);
        String tableName = from.getBusiTable();
        if (StringUtils.isBlank((String)status)) {
            status = "'21'";
        }
        String updateSql = "update " + tableName + " t set t." + "WORKFLOW_STATUS" + "=" + status + ",t.MODIFY_TIME=now() where t." + "processinstid" + "=" + processInstId;
        this.sqlHelper.exeNativeSQL(updateSql);
    }

    public List<Participant> getLastDealPerson(Long processinstId, String toActId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processinstId", processinstId);
        map.put("toActId", toActId);
        return this.beetls.getList("workflow.flow.getActLastedDealPerson", map, Participant.class);
    }

    public List<Map<String, Object>> getLastDealPersonMap(Long processinstId, String toActId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processinstId", processinstId);
        map.put("toActId", toActId);
        String sql = "SELECT\n\ta.ACCOUNT_ID ,\n\ta.ACCOUNT_NAME ,\n\ta.ACCOUNT_NAME EMP_NAME,\n\tgetdeptname(a.dept_id) dept_name\nFROM\n\twf_workitem w,\n\t( SELECT max( a.ACTIVITYINSTID ) ACTIVITYINSTID FROM wf_activityinst a WHERE a.PROCESSINSTID =:processinstId AND a.ACTIVITYDEFID =:toActId and a.CURRENTSTATE=12 ) t,\n\tbas_emp_account a\nWHERE\n\tw.ACTIVITYINSTID = t.ACTIVITYINSTID\n\tand a.ACCOUNT_ID = w.PARTICIPANT";
        return this.sqlHelper.queryByNativeSQL(sql, map, new int[0]);
    }

    public String getLastItemPerson(Long processInstId, String toActId) {
        String sql = "select z.participant from (SELECT t.participant\n          FROM wf_workitem t\n         WHERE t.processinstid = " + processInstId + "\n           AND t.activitydefid = '" + toActId + "'\n         ORDER BY t.workitemid DESC) z where rownum = 1";
        Object ob = this.sqlHelper.getSingal(sql);
        String participant = "";
        if (ob != null) {
            participant = ob.toString();
        }
        return participant;
    }

    public String getLastDealWorkitem(Long processInstId, Long userId) {
        String sql = "select z.workitemid from (SELECT t.workitemid\n          FROM wf_workitem t\n         WHERE t.processinstid = " + processInstId + "\n           AND t.participant = '" + userId + "'\n         ORDER BY t.workitemid DESC) z where rownum = 1";
        Object ob = this.sqlHelper.getSingal(sql);
        String workitemid = "";
        if (ob != null) {
            workitemid = ob.toString();
        }
        return workitemid;
    }

    private List<Long> getNextStepPerson(Long orgId, String roles) throws GEPSBisException {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String sql = "SELECT distinct c.account_id\n       FROM bas_emp_account c,\n            bas_roles_account    er,\n            bas_org r\n      WHERE c.account_id = er.account_id\n        and er.role_id in (" + roles + ")\n        AND c.is_use = 'Y'\n        and r.org_id='" + orgId + "' ";
        try {
            List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
            if (!list.isEmpty()) {
                for (Object o : list) {
                    Map m = (Map)o;
                    userIds.add(Long.parseLong(m.get("ACCOUNT_ID").toString()));
                }
            }
        }
        catch (Exception e) {
            throw new GEPSBisException("\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5458\u672a\u627e\u5230", e);
        }
        return userIds;
    }

    public Long getWorkItemId(Long processInstId) {
        return this.getWorkItemId(processInstId, null);
    }

    public Long getWorkItemIdNoAgent(Long processInstId, Long workItemId) {
        Object ob;
        Long userId = SysUtils.getLoginAccountId();
        String roleSql = "SELECT er.role_id\n  FROM bas_emp_account  c,\n       bas_roles_account er,\n       bas_roles    r\n WHERE c.account_id = er.account_id\n and er.role_id=r.role_id\n and c.account_id=" + userId + "\n and c.is_use='Y'\n AND r.is_use='Y'";
        String sql = "SELECT b.WORKITEMID FROM wf_participant a, wf_workitem b WHERE ((a.PARTICTYPE = 'person' AND a.Participant = '" + userId + "') OR (a.PARTICTYPE = 'role' AND a.PARTICIPANT in (" + roleSql + ")) OR (a.PARTICTYPE = 'organization' AND a.PARTICIPANT = '" + userId + "')) AND b.CURRENTSTATE IN(4,10) AND a.WORKITEMID = b.WORKITEMID AND b.PROCESSINSTID = '" + processInstId + "'";
        if (workItemId != null) {
            sql = sql + " and b.WORKITEMID =" + workItemId;
        }
        workItemId = (ob = this.sqlHelper.getSingal(sql)) != null ? Long.valueOf(this.sqlHelper.getSingal(sql).toString()) : null;
        return workItemId;
    }

    public Map getWorkItemIdAgent(Long processInstId, Long workItemId) {
        Object ob;
        Long userId = SysUtils.getLoginAccountId();
        String sql = "select s.workitemid,a.agent_to_account\n  from WF_AGENT a, gen_form f, bas_message s, bas_message_receive e\n where s.form_code = f.form_code\n   and s.msg_id = e.msg_id\n   and e.account_id = a.agent_to_account\n   and s.processinstid = " + processInstId + "\n   and(( concat('%,', a.agent_content ,',%') like concat('%,', f.flow_cat_id ,',%')\n   and a.agent_account = " + userId + "\n   and a.end_date > now()\n   and (a.cancel_date is null or a.cancel_date > now()))or a.agent_type='2')";
        if (workItemId != null) {
            sql = sql + " and w.WORKITEMID =" + workItemId;
        }
        if ((ob = this.sqlHelper.getSingalMap(sql, new Object[0])) != null) {
            return (Map)ob;
        }
        return null;
    }

    public Long getWorkItemId(Long processInstId, Long workItemId) {
        Map m;
        if ((workItemId = this.getWorkItemIdNoAgent(processInstId, workItemId)) == null && (m = this.getWorkItemIdAgent(processInstId, workItemId)) != null) {
            workItemId = Long.valueOf(m.get("WORKITEMID").toString());
        }
        return workItemId;
    }

    public String getActivitydefid(Long processInstId, String userId) {
        String roleSql = "SELECT er.role_id\n  FROM bas_emp_account  c,\n       bas_roles_account er,\n       bas_roles    r\n WHERE c.account_id = er.account_id\n and er.role_id=r.role_id\n and c.account_id=" + userId + "\n and c.is_use='Y'\n AND r.is_use='Y'";
        String sql = "SELECT  b.activitydefid FROM wf_participant a, wf_workitem b WHERE ((a.PARTICTYPE = 'person' AND a.Participant = '" + userId + "') OR (a.PARTICTYPE = 'role' AND a.PARTICIPANT in (" + roleSql + ")) OR (a.PARTICTYPE = 'organization' AND a.PARTICIPANT = '" + userId + "')) AND b.CURRENTSTATE IN(4,10) AND a.WORKITEMID = b.WORKITEMID AND b.PROCESSINSTID = '" + processInstId + "'";
        String workitemid = null;
        Object ob = this.sqlHelper.getSingal(sql);
        if (ob != null) {
            workitemid = this.sqlHelper.getSingal(sql).toString();
        } else {
            sql = "select w.activitydefid\n  from WF_AGENT a, gen_form f, bas_message s, bas_message_receive e,wf_workitem w\n where s.form_code = f.form_code\n   and s.msg_id = e.msg_id\n   and e.account_id = a.agent_to_account\n   and s.workitemid = w.workitemid\n   and s.processinstid = " + processInstId + "\n   and (('%,' || a.agent_content || ',%' like '%,' || f.flow_cat_id || ',%'\n   and a.agent_account = " + userId + "\n   and a.end_date > sysdate()\n   and (a.cancel_date is null or a.cancel_date > sysdate()))or a.agent_type='2')";
            ob = this.sqlHelper.getSingal(sql);
            if (ob != null) {
                workitemid = this.sqlHelper.getSingal(sql).toString();
            }
        }
        return workitemid;
    }

    public String haseRole(String participant, Long workitemid) {
        String sql = "select t.particid from WF_PARTICIPANT t where t.participant='" + participant + "' and t.workitemid=" + workitemid;
        String particid = null;
        try {
            particid = this.sqlHelper.getSingal(sql).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return particid;
    }

    public List<?> queryActivityinst(Long processinstid) {
        String sql = "select b.processinstid,\n       b.processdefid,\n       b.processinstname,\n       a.activityinstid,\n       a.activityinstname,\n       a.activitytype,\n       a.currentstate,\n       a.starttime,\n       a.endtime,a.activitydefid\n  from wf_activityinst a, wf_processinst b\n where a.processinstid = '" + processinstid + "'\n   and a.activityinstid = b.activityinstid(+)\n order by a.activityinstid";
        List list = null;
        try {
            list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public List<?> queryWorkItem(Long activityinstid) {
        String sql = "select workitemid,\n       workitemname,\n       currentstate,\n       (select e.account_name from bas_emp_account e where e.account_id = t.participant) participant,\n       starttime,\n       endtime,\n       workmemory,\n       activityinstid\n  from WF_WORKITEM t\n where t.activityinstid = " + activityinstid;
        List list = null;
        try {
            list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public Long queryCurrentWorkItem(Long processinstid) {
        String sql = "select max(a.workitemid)\n                         from wf_workitem a\n                        where a.processinstid =" + processinstid;
        Object ob = this.sqlHelper.getSingal(sql);
        if (ob != null) {
            return Long.parseLong(ob.toString());
        }
        return null;
    }

    public Object querySubProcInstId(Long processinstid, String activitydefid) {
        String queryString = "select b.processinstid, b.processdefid\n  from wf_activityinst a, wf_processinst b\n where a.processinstid = '" + processinstid + "'\n   and a.activityinstid = b.activityinstid\n   and a.activitydefid = '" + activitydefid + "'\n order by a.activityinstid";
        try {
            return this.sqlHelper.getSingal(queryString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object queryParentProcInstId(Long processinstid) {
        String queryString = "select p.processinstid, p.processdefid from WF_PROCESSINST p where p.processinstid =(select t.parentprocinstid from WF_PROCESSINST t where t.processinstid=" + processinstid + " and t.processinstid != t.parentprocinstid)";
        try {
            return this.sqlHelper.getSingal(queryString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String queryActivitydefid(Long processinstid) {
        String queryString = "select act.activitydefid from WF_PROCESSINST inst,wf_activityinst act where inst.activityinstid=act.activityinstid and inst.processinstid=" + processinstid;
        String result = "";
        try {
            result = this.sqlHelper.getSingal(queryString).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<?> queryWorkItemByDefid(Long processinstid, String activitydefid) {
        if (processinstid == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("processinstid", processinstid);
        if (activitydefid != null) {
            params.put("activitydefid", Arrays.asList(activitydefid.split(",")));
        }
        String queryString = "select t.* from (select t.workitemid,\n       t.workitemname,\n       t.currentstate,\n       t.participant account_Id,\n       (select e.account_name from bas_emp_account e where e.account_id = t.participant) participant,\n      DATE_FORMAT(t.starttime,'%Y-%m-%d %H:%i') starttime,\n       DATE_FORMAT(t.endtime,'%Y-%m-%d %H:%i')  endtime,\n       t.endtime endtimeori,\n       t.workmemory,\n       t.limittime,\n\t\tt.WORKMEMORY_PIC,\t\trank() over(partition by t.activitydefid,t.participant order by t.endtime desc) rn  from WF_WORKITEM t\n where t.processinstid =:processinstid\n";
        if (activitydefid != null) {
            queryString = queryString + "and t.activitydefid in (:activitydefid)\n";
        }
        queryString = queryString + ") t where t.rn =1 order by t.workitemid";
        List list = this.sqlHelper.queryByNativeSQL(queryString, params, new int[0]);
        if (CommonService.showSign) {
            for (Object o : list) {
                BasSignaturePersonal b;
                Map m = (Map)o;
                if (m.get("ACCOUNT_ID") != null && (b = this.bassignaturepersonalService.findByAccountIdAndDate(Long.parseLong(m.get("ACCOUNT_ID").toString()), (Date)m.get("ENDTIMEORI"))) != null) {
                    m.put("sign", b.getSign());
                }
                List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "txt", "jpg", "set", "gif", "doc", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
                List<DocFormFile> files = this.docFormFileService.listFormFileByPK("workitem", "888888", m.get("WORKITEMID").toString());
                files.forEach(file -> file.setFileType(types.indexOf(FilenameUtils.getExtension((String)file.getOriginalName())) != -1 ? FilenameUtils.getExtension((String)file.getOriginalName()) : "file"));
                m.put("files", files);
            }
        }
        return list;
    }

    public List<?> queryFinishWorkItemByDefid(Long processinstid, String activitydefid) throws NumberFormatException, ParseException {
        if (processinstid == null || StringUtils.isBlank((String)activitydefid)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("processinstid", processinstid);
        params.put("activitydefid", Arrays.asList(activitydefid.split(",")));
        String queryString = "select t.* from (select t.workitemid,\n       t.workitemname,\n       t.currentstate,\n       t.participant account_Id,\n       (select e.account_name from bas_emp_account e where e.account_id = t.participant) participant,\n       DATE_FORMAT(t.starttime,'%Y-%m-%d %H:%i') starttime,\n       DATE_FORMAT(t.endtime,'%Y-%m-%d %H:%i') endtime,\n       t.workmemory,\n       t.limittime,\n\t\tt.WORKMEMORY_PIC,\t\trank() over(partition by t.activitydefid,t.participant order by t.endtime desc) rn  from WF_WORKITEM t\n where t.activitydefid in (:activitydefid)\n   and t.processinstid =:processinstid and t.currentstate='12'\n ) t where t.rn =1 order by t.workitemid";
        List list = this.sqlHelper.queryByNativeSQL(queryString, params, new int[0]);
        if (CommonService.showSign) {
            for (int i = 0; i < list.size(); ++i) {
                Map m = (Map)list.get(i);
                BasSignaturePersonal b = this.bassignaturepersonalService.findByAccountIdAndDate(Long.parseLong(m.get("ACCOUNT_ID").toString()), DateUtils.strToDate(m.get("ENDTIME").toString()));
                if (b != null) {
                    m.put("sign", b.getSign());
                }
                List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "txt", "jpg", "set", "gif", "doc", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
                List<DocFormFile> files = this.docFormFileService.listFormFileByPK("workitem", "888888", m.get("WORKITEMID").toString());
                files.forEach(file -> file.setFileType(types.indexOf(FilenameUtils.getExtension((String)file.getOriginalName())) != -1 ? FilenameUtils.getExtension((String)file.getOriginalName()) : "file"));
                m.put("files", files);
            }
        }
        return list;
    }

    public String queryCanDealProcess(long accountId) {
        String sqlString = "select t.processinstid\n  from wf_workitem t\n  left join  WF_PARTICIPANT  m\n    on t.workitemid = m.workitemid\n   and t.currentstate in (4, 10)\n   and m.partictype = 'role'\n   left join bas_emp_role n on m.participant=n.role_id\n   where n.login_account_id=%s";
        return String.format(sqlString, accountId);
    }

    public String queryDealedProcess(Long ... done) {
        boolean judge;
        long accountId = SysUtils.getLoginAccountId();
        if (done != null && done.length > 0 && done[0] == 2L && (judge = this.basRolesAccountService.isHasAdminRoles(accountId))) {
            return "select processinstid from WF_PROCESSINST";
        }
        String sql = "select processinstid\n  from (select distinct a.processinstid, a.currentstate\n          from wf_workitem a\n          left join wf_participant b\n            on a.workitemid = b.workitemid\n          left join bas_roles_account c\n            on b.participant = concat ( c.role_id,'' )         where c.account_id = %s\n           and b.partictype = 'role'\n        union\n        select distinct a.processinstid, a.currentstate\n          from wf_workitem a\n          left join wf_participant b\n            on a.workitemid = b.workitemid\n         where b.partictype = 'person'\n           and b.participant = %s) w";
        if (done != null && done.length > 0) {
            if (done[0] == 0L) {
                sql = sql + "   where currentstate in (4, 10) \n";
            } else if (done[0] == 1L) {
                sql = sql + "   where currentstate =12 \n";
            } else if (done[0] == 2L) {
                sql = sql + "   where currentstate in (4,10,12) \n";
            }
            return String.format(sql, "'" + accountId + "'", "'" + accountId + "'");
        }
        return String.format(sql, "'" + accountId + "'", "'" + accountId + "'");
    }

    public String queryDealedProcess(String formCode, Long ... done) {
        boolean judge;
        long accountId = SysUtils.getLoginAccountId();
        long deptId = SysUtils.getLoginUser().getDeptid();
        long orgId = SysUtils.getLoginUser().getOrgid();
        if (done != null && done.length > 0 && done[0] == 2L && (judge = this.basRolesAccountService.isHasAdminRoles(accountId))) {
            return "select processinstid from WF_PROCESSINST";
        }
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isPermitted("allData" + formCode)) {
            return "select processinstid from WF_PROCESSINST";
        }
        boolean isDeptDate = false;
        if (currentUser.isPermitted("deptData" + formCode)) {
            isDeptDate = true;
        }
        boolean isLeaderData = false;
        if (currentUser.isPermitted("leaderData" + formCode)) {
            isLeaderData = true;
        }
        boolean isOrgData = false;
        if (currentUser.isPermitted("orgData" + formCode)) {
            isOrgData = true;
        }
        String sql = "select processinstid\n  from (select distinct a.processinstid, a.currentstate\n          from wf_workitem a\n          left join wf_participant b\n            on a.workitemid = b.workitemid\n          left join bas_roles_account c\n            on b.participant = concat ( c.role_id,'' )\n         where c.account_id = %s\n           and b.partictype = 'role'\n        union\n        select distinct a.processinstid, a.currentstate\n          from wf_workitem a\n          left join wf_participant b\n            on a.workitemid = b.workitemid\n         where b.partictype = 'person'\n           and b.participant = %s) w";
        if (done != null && done.length > 0) {
            if (done[0] == 0L) {
                sql = sql + "   where currentstate in (4, 10) \n";
            } else if (done[0] == 1L) {
                sql = sql + "   where currentstate =12 \n";
            } else if (done[0] == 2L) {
                sql = sql + "   where currentstate in (4,10,12) \n";
            }
        }
        if (done[0] == 2L) {
            if (isDeptDate) {
                sql = sql + " union\n select processinstid\n  from WF_PROCESSINST t\n  left join bas_emp_account a\n    on t.CREATOR = a.ACCOUNT_ID\n   and a.IS_USE = 'Y'\n where a.dept_id = '" + deptId + "'";
            }
            if (isLeaderData) {
                sql = sql + " union\nselect distinct processinstid\n  from WF_PROCESSINST t\n  left join bas_emp_account e\n    on t.CREATOR = e.ACCOUNT_ID\n   and e.IS_USE = 'Y'\n  left join bas_roles_account a\n    on e.DEPT_ID = a.DEPT_ID\n  left join bas_roles r\n    on a.ROLE_ID = r.ROLE_ID\n   and r.IS_USE = 'Y'\n where r.ROLE_CODE = 'DEPT_LEADER'\n   and a.ACCOUNT_ID = '" + accountId + "'";
            }
            if (isOrgData) {
                sql = sql + " union\n select processinstid\n  from WF_PROCESSINST t\n  left join bas_emp_account a\n    on t.CREATOR = a.ACCOUNT_ID\n   and a.IS_USE = 'Y'\n where a.ORG_ID = '" + orgId + "'";
            }
        }
        return String.format(sql, "'" + accountId + "'", "'" + accountId + "'");
    }

    public Object queryFlowStatusByInstid(Long processinstid) {
        String sql = "select t.currentstate from WF_PROCESSINST t where t.processinstid=" + processinstid;
        try {
            return this.sqlHelper.getSingal(sql);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public IProcessInstanceService getProcInstService() {
        return this.procInstService;
    }

    public IWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public IProcessDefineService getProservice() {
        return this.proservice;
    }

    public void setProservice(IProcessDefineService proservice) {
        this.proservice = proservice;
    }

    public Long createAndStartProcessliuChengId(String liuchengId, Long userId) {
        ProcessInstance processinst = this.procInstService.createAndStartProcess(liuchengId, userId.toString());
        return processinst.getParentProcInstId();
    }

    public List<Map> getFlowApproList(Long processinstid) throws ParseException {
        String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
        ProcessElement pe = ProcessDefineParser.createProcessXml((String)processDefContent);
        ArrayList<String> actIds = new ArrayList<String>(pe.getActivitys().size());
        for (String key : pe.getActivitys().keySet()) {
            Element actClass = (Element)ProcessDefineParser.createDocument((String)processDefContent).selectSingleNode("/ProcessDefine/Activitys/Activity[@id='" + key + "']/actClass");
            if (actClass == null || !"2".equals(actClass.getStringValue())) continue;
            actIds.add(key);
        }
        String sql = "select * from(\nSELECT w.WORKITEMID,\nw.WORKITEMNAME,w.PARTICIPANT ACCOUNT_ID,\n\tGETACCOUNTNAME ( w.PARTICIPANT ) account_name,\n\tDATE_FORMAT( w.STARTTIME, '%Y-%m-%d %H:%i:%s' ) AS STARTTIME,\n\tDATE_FORMAT( w.ENDTIME, '%Y-%m-%d %H:%i:%s' ) AS ENDTIME,\n\tw.ENDTIME ENDTIMEORI,\n\tw.workmemory,\n\tw.workmemory_pic,\n\trow_number() over (partition by w.ACTIVITYDEFID,w.PARTICIPANT order by w.WORKITEMID desc) rn\nFROM\n\twf_workitem w \nWHERE\n\tw.PROCESSINSTID = ?1 \n and w.ACTIVITYDEFID in ?2 and w.currentstate='12'\n order by w.WORKITEMID\n)t where t.rn = 1";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{processinstid, actIds}, new int[0]);
        for (Object o : list) {
            BasSignaturePersonal b;
            Map m = (Map)o;
            if (m.get("ACCOUNT_ID") == null || (b = this.bassignaturepersonalService.findByAccountIdAndDate(Long.parseLong(m.get("ACCOUNT_ID").toString()), (Date)m.get("ENDTIMEORI"))) == null) continue;
            m.put("sign", b.getSign());
        }
        return list;
    }

    public List<Map> getAppList(Long processinstid) throws ParseException {
        String sql = "select       t.processinstid,\n       w.workitemid,\n       t.activitydefid,\n       t.activityinstname,\n       w.PARTICIPANT,\n      DATE_FORMAT(T.STARTTIME,'%Y-%m-%d %H:%i:%s')  as STARTTIME,\n      DATE_FORMAT(w.ENDTIME,'%Y-%m-%d %H:%i:%s')   as ENDTIME,\n      concat( w.account_name,nvl2(w.AGENT_PARTICIPANT, concat('<span style=\"color:red\">[', w.AGENT_account_name,'(\u4ee3)]</span>'),'') )account_name,\n       w.workmemory,\n       w.workmemory_pic,\n       w.participant2,\n       w.currentstate,\n       r.destactdefname,\n       DATE_FORMAT(ifnull(s.read_time, s.deal_time), '%Y-%m-%d %H:%i:%s') read_time\n  from wf_activityinst t\n  left join (select w.processinstid,\n                    w.activityinstid,\n                    w.currentstate,\n                    w.workitemid,\n                    w.starttime,\n                    w.endtime,\n                    a.account_name,\n                    b.account_name AGENT_account_name,\n                    w.AGENT_PARTICIPANT,\n                    w.workmemory,\n                    w.workmemory_pic,\n                    (select group_concat(p.participant2 order by p.particid) from wf_participant p\n                 where w.workitemid = p.workitemid) participant2,\n                    w.participant\n               from wf_workitem w\n               left join bas_emp_account a\n                 on a.account_id = w.participant\n               left join bas_emp_account b\n                 on b.account_id = w.AGENT_PARTICIPANT\n              where w.processinstid = ?1 and w.bizstate != 'NTH') w\n    on t.processinstid = w.processinstid\n   and t.activityinstid = w.activityinstid\n  left join WF_TRANSCTRL r\n    on r.srcactdefid = t.activitydefid\n   and r.transtime = t.endtime\n   and r.processinstid = t.processinstid\n  left join (select c.*, s.workitemid\n               from BAS_MESSAGE_RECEIVE c, BAS_MESSAGE s\n              where c.msg_id = s.msg_id) s\n    on s.account_id = w.participant\n   and s.workitemid = w.workitemid\n where t.processinstid = ?1\n order by t.createtime, t.activityinstid";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{processinstid}, new int[0]);
        for (Map map : list) {
            if (map.get("ENDTIME") == null || map.get("STARTTIME") == null || "act_start".equals(map.get("ACTIVITYDEFID").toString()) || "act_finish".equals(map.get("ACTIVITYDEFID").toString())) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date endtime = sdf.parse(map.get("ENDTIME").toString());
            Date starttime = sdf.parse(map.get("STARTTIME").toString());
            map.put("USETIME", DateUtils.getDatePoor(endtime, starttime));
            List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "txt", "jpg", "set", "gif", "doc", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
            List<DocFormFile> files = this.docFormFileService.listFormFileByPK("workitem", "888888", map.get("WORKITEMID").toString());
            files.forEach(file -> file.setFileType(types.indexOf(FilenameUtils.getExtension((String)file.getOriginalName())) != -1 ? FilenameUtils.getExtension((String)file.getOriginalName()) : "file"));
            map.put("files", files);
            List<Participant> lastlist = this.getLastDealPerson(processinstid, map.get("ACTIVITYDEFID").toString());
            if (lastlist.size() != 1) continue;
            map.put("backPersons", lastlist);
        }
        return list;
    }

    public List<Map> getAppListNew(Long processinstid) throws ParseException {
        String sql = "select       t.processinstid,\n       w.workitemid,\n       t.activitydefid,\n       t.activityinstname,\n\t\tw.bizstate,\n       w.isadd,\n\t\tGETDICNAME('ATTITUDE',w.ATTITUDE) ATTITUDE,\n\t\tGETDICNAME('CHOOSE_OPTIONS',w.ATTITUDE_OPTIONS) ATTITUDE_OPTIONS,\n\t(select getaccountname(i.participant)  from wf_workitem i where i.workitemid=w.sourceworkitemid) pre_Account,\n (select group_concat(getaccountname(r.account_id)) from BAS_MESSAGE s, bas_message_receive r where r.msg_id = s.msg_id    and s.workitemid = w.workitemid and s.msg_type=5) copyPersons,       DATE_FORMAT(T.STARTTIME,'%Y-%m-%d %H:%i:%s') as STARTTIME,\n       DATE_FORMAT(w.ENDTIME,'%Y-%m-%d %H:%i:%s') as ENDTIME,\n       concat(nvl(concat(w.account_name,nvl2(w.AGENT_PARTICIPANT,concat('<span style=\"color:red\">[', w.AGENT_account_name,'(\u4ee3)]</span>'),'')),c.account_name),case when w.bizstate='roll' then'' else '' end,case when w.isadd='Y' then '\u3010\u52a0\u7b7e\u3011' else '' end) account_name,\n       w.workmemory,\n       w.workmemory_pic,\n       w.workitemname,\n       w.participant2,\n       w.currentstate,\n(select GROUP_CONCAT(x.dest) \n    FROM (SELECT\n        CONCAT(t.WORKITEMNAME ,'(', GROUP_CONCAT(\n        nvl2(\n        t.PARTICIPANT,\n        GETACCOUNTNAME(t.PARTICIPANT), (SELECT\n            GROUP_CONCAT(\n            GETACCOUNTNAME(r.ACCOUNT_ID))\n          FROM bas_message m,\n               bas_message_receive r\n          WHERE m.MSG_ID = r.MSG_ID\n          AND m.MSG_TYPE = '1'\n          AND m.WORKITEMID = t.WORKITEMID))), ')') dest\n      FROM wf_workitem t\n      WHERE t.SOURCEWORKITEMID =w.workitemid  AND t.PROCESSINSTID = w.processinstid and ifnull(t.bizstate,'TG')<>'roll' GROUP BY t.WORKITEMNAME) x )destactdefname,       DATE_FORMAT(nvl(s.read_time, s.deal_time),'%Y-%m-%d %H:%i:%s') read_time\n  from wf_activityinst t\n   join (select w.processinstid,\n                    w.activityinstid,\n                    w.currentstate,\n                    w.bizstate,\n                    w.workitemid,\n                    w.starttime,\n                    w.endtime,\n                    w.ATTITUDE,\n                    w.ATTITUDE_OPTIONS,\n                    w.isadd,\n                    w.workitemname,\n                    w.sourceworkitemid,\n                    a.account_name,\n                    b.account_name AGENT_account_name,\n                    w.AGENT_PARTICIPANT,\n                    w.workmemory,\n                    w.workmemory_pic,\n                    (select group_concat(p.participant2 order by p.particid) from wf_participant p\n                 where w.workitemid = p.workitemid) participant2,\n                    w.participant\n               from wf_workitem w\n               left join bas_emp_account a\n                 on a.account_id = w.participant\n               left join bas_emp_account b\n                 on b.account_id = w.AGENT_PARTICIPANT\n              where w.processinstid = ?1 ) w\n    on t.processinstid = w.processinstid\n   and t.activityinstid = w.activityinstid\n  left join (select c.*, s.workitemid\n               from BAS_MESSAGE_RECEIVE c, BAS_MESSAGE s\n              where c.msg_id = s.msg_id and s.msg_type<>'5') s\n   on s.workitemid = w.workitemid\n   and ( s.account_id = w.participant or w.currentstate<>'12')\n          left join bas_emp_account c\n                 on c.account_id = s.account_id\n where t.processinstid = ?1\n and t.activityinstname<>'\u5f00\u59cb'\n order by t.createtime, t.activityinstid";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{processinstid}, new int[0]);
        String addlist = "SELECT\n\tconcat(getaccountname ( t.ADD_PERSONS ),'\u3010\u52a0\u7b7e(\u5f85\u751f\u6548)\u3011') account_name,\n\ti.WORKITEMNAME activityinstname,\n\t'Y' isadd \nFROM\n\twf_workitem_add t\n\tLEFT JOIN wf_workitem i ON i.workitemid = t.workitemid \nWHERE\n\tt.PROCESSINSTID = ?1 \n\tAND t.IS_USE = 'Y' \n\tAND t.ADD_TYPE = '1'";
        List list2 = this.sqlHelper.queryByNativeSQL(addlist, new Object[]{processinstid}, new int[0]);
        list.addAll(list2);
        List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "txt", "jpg", "set", "gif", "doc", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
        for (Map map : list) {
            if (map.get("ENDTIME") == null || map.get("STARTTIME") == null || "act_start".equals(map.get("ACTIVITYDEFID").toString()) || "act_finish".equals(map.get("ACTIVITYDEFID").toString())) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date endtime = sdf.parse(map.get("ENDTIME").toString());
            Date starttime = sdf.parse(map.get("STARTTIME").toString());
            map.put("USETIME", DateUtils.getDatePoor(endtime, starttime));
            List<DocFormFile> files = this.docFormFileService.listFormFileByPK("workitem", "888888", map.get("WORKITEMID").toString());
            files.forEach(file -> file.setFileType(types.indexOf(FilenameUtils.getExtension((String)file.getOriginalName())) != -1 ? FilenameUtils.getExtension((String)file.getOriginalName()) : "file"));
            map.put("files", files);
        }
        return list;
    }

    public Long getAccountId(Long processinstid) throws ParseException {
        String sql = "select t.creator from wf_processinst t where t.processinstid= ?1 \n";
        Object ob = this.sqlHelper.getSingal(sql, new Object[]{processinstid});
        return Long.parseLong(ob.toString());
    }

    public String getProcessdefidByProcessinstid(Long processinstid) {
        String sql = "SELECT S.PROCESSDEFID FROM WF_PROCESSINST S WHERE S.PROCESSINSTID=?1";
        Object processdefidObj = this.sqlHelper.getSingal(sql, new Object[]{processinstid});
        return processdefidObj == null ? "" : processdefidObj.toString();
    }

    public boolean isAllWorkItemIsDoneWhenPass(Long processinstid, Long workItemId) {
        String sql = "select count(*) from wf_workitem t\n WHERE t.processinstid = ?1\n   AND t.workitemid <> ?2\n   AND t.currentstate IN (4, 10)\n\tand exists  (select 1 from wf_workitem a where a.processinstid= ?1 and a.workitemid = ?2 and a.activitydefid=t.activitydefid)";
        Object ob = this.sqlHelper.getSingal(sql, new Object[]{processinstid, workItemId});
        if (ob != null) {
            return ob.toString().equals("0");
        }
        return true;
    }

    public String getFlowNameByProcessInstId(Long processInstId) {
        String sql = "SELECT t.flow_name\n  FROM stf_business_process t,\n       wf_processinst       p,\n       wf_processdefine     d\n WHERE p.processinstid =?1\n   AND d.processdefid = p.processdefid\n   AND d.processdefname = t.design_name";
        Object ob = this.sqlHelper.getSingal(sql, new Object[]{processInstId});
        if (ob != null) {
            return ob.toString();
        }
        return null;
    }

    public String getDesignNameByProcessInstId(Long processInstId) {
        String sql = "SELECT t.design_name\n  FROM stf_business_process t,\n       wf_processinst       p,\n       wf_processdefine     d\n WHERE p.processinstid =?1\n   AND d.processdefid = p.processdefid\n   AND d.processdefname = t.design_name";
        Object ob = this.sqlHelper.getSingal(sql, new Object[]{processInstId});
        if (ob != null) {
            return ob.toString();
        }
        return null;
    }

    private void cleanRelvant_data(Long processinstId, String activitydefId) {
        String delsql = "delete from wf_relevant_data where PROCESSINSTID = ?1 and ACTIVITYDEFID = ?2 and NAME = ?3";
        this.sqlHelper.exeNativeSQL(delsql, new Object[]{processinstId, activitydefId, "transitionExpressCondition"});
    }

    public List<Map<String, Object>> queryFlowAdvice(Long processInstId, String actID) {
        StringBuilder sql = new StringBuilder("select a.activityinstid,\n       a.activitydefid,\n       a.activitytype,\n       a.activityinstname,\n       a.currentstate,\n       a.currentstate acurrentstate,\n       b.workitemid,\n       DATE_FORMAT(b.endtime,'%Y-%m-%d %H:%i:%s') endtime,\n       (case\n         when b.currentstate = '12' then\n          (select group_concat(a.account_name) from bas_emp_account a where a.account_id = b.participant)\n         else\n\t\t(select group_concat(d.participant2)             from wf_participant d\n            where d.workitemid = b.workitemid)\n       end) participant,\n       b.workmemory,\n       b.currentstate bcurrentstate\n  from (select rank() over(partition by a.processinstid, a.activitydefid order by a.activityinstid desc) ver,\t\t\t  a.* from wf_activityinst a) a,wf_workitem b\n where a.ver=1 and a.activityinstid = b.activityinstid\n   and a.processinstid = b.processinstid\n");
        if (processInstId != null) {
            sql.append("   and a.processinstid = " + processInstId + "\n");
        }
        if (actID != null && !actID.equals("")) {
            sql.append("   and a.activitydefid = '" + actID + "'\n");
        }
        sql.append("   order by a.activityinstid desc");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
    }

    private void endWorkItemWhenTh(Long userId, Long processinstid, Long workItemId) {
        String workitemsql = "update wf_workitem t\nset t.currentstate=7,t.participant=?1\n WHERE t.processinstid = ?2\n   AND t.workitemid <> ?3\n   AND t.currentstate IN (4, 10)";
        this.sqlHelper.exeNativeSQL(workitemsql, new Object[]{userId, processinstid, workItemId});
        String activitysql = "update WF_ACTIVITYINST t\nset t.currentstate='7',t.endtime=now()\n where t.processinstid=?1\n and t.activityinstid <>       (select t.activityinstid\n          from wf_workitem t\n         WHERE t.processinstid = ?1\n           AND t.workitemid = ?2) and  t.currentstate IN (4, 10)";
        this.sqlHelper.exeNativeSQL(activitysql, new Object[]{processinstid, workItemId});
        String transctrlsql = "update WF_TRANSCTRL t\nset t.isuse='Y'\n where t.processinstid = ?1\n           AND t.isstartdestact = 'Y'";
        this.sqlHelper.exeNativeSQL(transctrlsql, new Object[]{processinstid});
    }

    private String splitMsgTitle(String fullMsgTitle) {
        String msgtitle = "";
        int start = fullMsgTitle.indexOf("-");
        int end = fullMsgTitle.lastIndexOf(",");
        msgtitle = start > 0 && end > 0 ? fullMsgTitle.substring(start, end) : fullMsgTitle;
        return msgtitle;
    }

    public void updateWfProcessinst(Long processInstId, Long userId) {
        String updateSql = "update wf_processinst t\n   set t.creator = " + userId + ", t.createtime = SYSDATE\n where t.processinstid = " + processInstId;
        this.sqlHelper.exeNativeSQL(updateSql);
    }

    public Map<String, Object> getFlowInfo(Long processinstid) {
        HashMap<String, Object> flowInfo = new HashMap<String, Object>();
        if (processinstid == null) {
            return flowInfo;
        }
        flowInfo.put("processinstid", processinstid);
        String activitydefid = "";
        try {
            ProcessInstance processInstance = this.procInstService.findProcessById(processinstid.longValue());
            if (processInstance.getCurrentState() != 12) {
                Map actproperties = new HashMap();
                if (processinstid != null && StringUtils.isNotEmpty((String)(activitydefid = this.getActivitydefid(processinstid, SysUtils.getLoginAccountId().toString())))) {
                    ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processinstid));
                    actproperties = ((ActivityElement)pe.getActivitys().get(activitydefid)).getProperties();
                    flowInfo.put("actDesc", ((ActivityElement)pe.getActivitys().get(activitydefid)).getDescription());
                    flowInfo.put("allowFile", ((ActivityElement)pe.getActivitys().get(activitydefid)).getIsAllowFile());
                }
                flowInfo.put("actId", activitydefid);
                flowInfo.put("actproperties", actproperties);
                flowInfo.put("properties", this.proservice.getProcessProperties(Long.valueOf(processInstance.getProcessDefId())));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("accountId", SysUtils.getLoginAccountId());
            params.put("processinstid", processinstid);
            flowInfo.put("dealActIds", this.beetls.getList("workflow.flow.getApproActs", params, String.class));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u4fe1\u606f\u5931\u8d25", e.getCause());
        }
        return flowInfo;
    }

    public List<Map<String, Object>> getFlowActList(String flowName) {
        String sql = "SELECT x.* FROM (\nWITH flow_act AS (\n\tSELECT\n\t\tExtractValue ( t.PROCESSDEFCONTENT, '/ProcessDefine/Activitys/Activity/@id' ) acts_id,\n\t\tREGEXP_REPLACE(ExtractValue ( t.PROCESSDEFCONTENT, '/ProcessDefine/Activitys/Activity/@name' ),'\\\\s+',' ') NAMES   \n\tFROM\n\t\twf_processdefine t \n\tWHERE\n\t\tt.PROCESSDEFNAME =?1\n\t\tand t.currentstate = '3'\n\t) SELECT\n\tSUBSTRING_INDEX( SUBSTRING_INDEX( a.acts_id, ' ', b.ID + 1 ), ' ',- 1 ) AS activitydefid,\n\tSUBSTRING_INDEX( SUBSTRING_INDEX( a.NAMES, ' ', b.ID + 1 ), ' ',- 1 ) AS actname \nFROM\n\tflow_act A\n\tJOIN sys_ROW b ON b.ID < ( length( a.acts_id ) - length( REPLACE ( a.acts_id, ' ', '' ) ) + 1 )\n) X where  x.activitydefid <>'act_start' and x.activitydefid <>'act_finish' \norder by cast(substr(x.activitydefid,5)  as   SIGNED   INTEGER)";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{flowName}, new int[0]);
    }

    public List<Long> getParticipantsBypartfield(String partfield, ProcessInstance processInstance) {
        String[] peopleIds;
        ArrayList<Long> perponsList = new ArrayList<Long>();
        if (processInstance == null) {
            return perponsList;
        }
        String flowCode = this.proservice.findProcessDefine(processInstance.getProcessDefId()).getProcessDefName();
        GenFormFlow formflow = this.genformflowService.findByFormIdAndApplyOrgs(null, flowCode, this.basEmpAccountService.findById(Long.parseLong(processInstance.getCreator())).getOrgId().toString());
        GenForm form = formflow != null ? this.genFormService.findGenForm(formflow.getFormId()) : this.genFormService.findByFlowCode(flowCode);
        String sql = "select " + partfield + " from " + form.getBusiTable() + " where PROCESSINSTID=:processinstid and is_use=:isUse";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isUse", "Y");
        params.put("processinstid", processInstance.getMainProcInstId());
        Object peopleId = this.sqlHelper.getSingal(sql, params);
        if (peopleId == null) {
            return perponsList;
        }
        for (String id : peopleIds = peopleId.toString().split(",")) {
            perponsList.add(Long.parseLong(id));
        }
        return perponsList;
    }

    public List<Map<String, String>> getNextWFParticipant(Long processinstid, String toActId, String isCopy, String formCode) {
        List partlist;
        String participantType;
        ProcessInstance processInstance = this.procInstService.findProcessById(processinstid.longValue());
        String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
        ProcessElement process = ProcessDefineParser.createProcessXml((String)processDefContent);
        ActivityElement actEle = (ActivityElement)process.getActivitys().get(toActId);
        if (!"Y".equals(isCopy)) {
            while ("toolApp".equals(actEle.getType())) {
                toActId = this.getNextActId(processinstid, toActId);
                actEle = (ActivityElement)process.getActivitys().get(toActId);
            }
        }
        String string = participantType = "Y".equals(isCopy) ? actEle.getCopyparticipantType() : actEle.getParticipantType();
        if ("process-starter".equals(participantType)) {
            Participant participant = new Participant();
            participant.setParticType("person");
            participant.setParticipant(processInstance.getCreator());
            partlist = new ArrayList();
            partlist.add(participant);
        } else if ("act-logic".equals(participantType)) {
            String beanName = "Y".equals(isCopy) ? actEle.getCopyparticiLogic() : actEle.getParticiLogic();
            IParticipantService action = (IParticipantService)this.processEngine.getApplicationContext().getBean(beanName, IParticipantService.class);
            IProcessInstanceService procInstService = this.processEngine.getProcessInstanceService();
            partlist = action.createWorkItemParticipants(procInstService.findProcessById(processinstid.longValue()), toActId);
        } else {
            partlist = "act-executer".equals(participantType) ? this.workItemService.queryActivityExecutors(processinstid.longValue(), actEle.getCopyparticiSpecActID()) : ("Y".equals(isCopy) ? actEle.getCopyparticipants() : actEle.getParticipants());
        }
        List<BasDept> depts = this.basDeptService.getDept();
        HashMap<Long, String> deptMaps = new HashMap<Long, String>(depts.size() * 3 / 4 + 1);
        HashMap<Long, String> bizdeptMaps = new HashMap<Long, String>(depts.size() * 3 / 4 + 1);
        HashMap<Long, String> orgMaps = new HashMap<Long, String>(depts.size() * 3 / 4 + 1);
        for (BasDept dept : depts) {
            BasOrg org = this.basOrgService.findByOrgId(dept.getOrgId());
            orgMaps.put(org.getOrgId(), org.getAbbr());
            if (org.getBelongDept() != null) {
                bizdeptMaps.put(dept.getDeptId(), this.basDeptService.findByDeptId(org.getBelongDept()).getDeptName());
            } else {
                bizdeptMaps.put(dept.getDeptId(), dept.getDeptName());
            }
            deptMaps.put(dept.getDeptId(), dept.getDeptName());
        }
        String split = ">";
        BasEmpAccount creater = this.basEmpAccountService.findById(Long.parseLong(processInstance.getCreator()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map creatermap = BeanUtil.beanToMap((Object)creater);
        BasOrg org = this.basOrgService.findByOrgId(creater.getOrgId());
        if (org.getBelongDept() != null) {
            creatermap.put("businessUnitId", org.getBelongDept());
            BasDept belongedept = this.basDeptService.findByDeptId(org.getBelongDept());
            if (belongedept != null) {
                creatermap.put("businessUnitOrgId", belongedept.getOrgId());
            }
        } else {
            creatermap.put("businessUnitId", creater.getDeptId());
            creatermap.put("businessUnitOrgId", creater.getOrgId());
        }
        map.put("creater", creatermap);
        map.put("loginuser", SysUtils.getLoginUser());
        try {
            map.putAll(this.getFormParams(processinstid, formCode));
        }
        catch (Exception belongedept) {
            // empty catch block
        }
        ArrayList<Map<String, String>> nextParticipants = new ArrayList<Map<String, String>>();
        HashMap<Long, String> userids = new HashMap<Long, String>();
        if (partlist != null && !partlist.isEmpty()) {
            for (Participant participant : partlist) {
                BasEmpAccount account;
                HashMap<String, String> nextParticipant;
                List<BasEmpAccount> accounts;
                if ("role".equals(participant.getParticType())) {
                    if (participant.getParticipant().contains(">")) {
                        List<String> ids = Arrays.asList(FreeMarkerUtil.instance().genString(participant.getParticipant(), map).split(">"));
                        Object accounts2 = null;
                        if (ids.size() == 2) {
                            accounts2 = this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), null, Long.parseLong(ids.get(1)));
                        } else if (ids.size() == 3) {
                            accounts2 = this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), Long.parseLong(ids.get(1)), Long.parseLong(ids.get(2)));
                        }
                        Iterator iterator = accounts2.iterator();
                        while (iterator.hasNext()) {
                            Object o = iterator.next();
                            Map m = (Map)o;
                            HashMap<String, String> nextParticipant2 = new HashMap<String, String>();
                            if (userids.containsKey(Long.parseLong(Objects.toString(m.get("ACCOUNT_ID"), "")))) continue;
                            userids.put(Long.parseLong(Objects.toString(m.get("ACCOUNT_ID"), "")), Objects.toString(m.get("ACCOUNT_NAME"), ""));
                            nextParticipant2.put("participant2", Objects.toString(m.get("ACCOUNT_NAME"), ""));
                            nextParticipant2.put("particType", "person");
                            nextParticipant2.put("participant", Objects.toString(m.get("ACCOUNT_ID"), ""));
                            nextParticipant2.put("deptname", Objects.toString(m.get("DEPT_NAME"), ""));
                            nextParticipant2.put("orideptname", (String)deptMaps.get(Long.parseLong(Objects.toString(m.get("DEPT_ID"), "0"))));
                            nextParticipant2.put("orgName", (String)orgMaps.get(Long.parseLong(Objects.toString(m.get("ORG_ID"), ""))));
                            nextParticipant2.put("isdefault", participant.getIsdefault());
                            nextParticipants.add(nextParticipant2);
                        }
                        continue;
                    }
                    accounts = this.basEmpAccountService.getBasAccountByRoleId(Long.parseLong(participant.getParticipant()));
                    for (BasEmpAccount account2 : accounts) {
                        nextParticipant = new HashMap<String, String>();
                        if (userids.containsKey(account2.getAccountId())) continue;
                        userids.put(account2.getAccountId(), account2.getAccountName());
                        nextParticipant.put("participant2", account2.getAccountName());
                        nextParticipant.put("particType", "person");
                        nextParticipant.put("participant", account2.getAccountId().toString());
                        nextParticipant.put("deptname", (String)deptMaps.get(account2.getDeptId()));
                        nextParticipant.put("orideptname", (String)deptMaps.get(account2.getDeptId()));
                        nextParticipant.put("orgName", (String)orgMaps.get(account2.getOrgId()));
                        nextParticipant.put("isdefault", participant.getIsdefault());
                        nextParticipants.add(nextParticipant);
                    }
                    continue;
                }
                if ("organization".equals(participant.getParticType())) {
                    accounts = participant.getParticipant().contains(">") ? this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(participant.getParticipant(), map).split(">")[1])) : this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(participant.getParticipant(), map)));
                    for (BasEmpAccount account2 : accounts) {
                        if (userids.containsKey(account2.getAccountId())) continue;
                        userids.put(account2.getAccountId(), account2.getAccountName());
                        nextParticipant = new HashMap();
                        nextParticipant.put("participant2", account2.getAccountName());
                        nextParticipant.put("particType", "person");
                        nextParticipant.put("participant", account2.getAccountId().toString());
                        nextParticipant.put("deptname", (String)bizdeptMaps.get(account2.getDeptId()));
                        nextParticipant.put("orideptname", (String)deptMaps.get(account2.getDeptId()));
                        nextParticipant.put("orgName", (String)orgMaps.get(account2.getOrgId()));
                        nextParticipant.put("isdefault", participant.getIsdefault());
                        nextParticipants.add(nextParticipant);
                    }
                    continue;
                }
                HashMap<String, String> nextParticipant3 = new HashMap<String, String>();
                if (userids.containsKey(Long.parseLong(participant.getParticipant())) || (account = this.basEmpAccountService.findById(Long.parseLong(participant.getParticipant()))) == null) continue;
                userids.put(account.getAccountId(), account.getAccountName());
                nextParticipant3.put("participant2", account.getAccountName());
                nextParticipant3.put("particType", "person");
                nextParticipant3.put("participant", participant.getParticipant());
                nextParticipant3.put("deptname", (String)deptMaps.get(account.getDeptId()));
                nextParticipant3.put("orideptname", (String)deptMaps.get(account.getDeptId()));
                nextParticipant3.put("orgName", (String)orgMaps.get(account.getOrgId()));
                nextParticipant3.put("isdefault", participant.getIsdefault());
                nextParticipants.add(nextParticipant3);
            }
        }
        return nextParticipants;
    }

    public List<Long> getNextWFParticipantIds(Long processinstid, String toActId, String isCopy, String formCode, Map<String, Object> params) {
        String participantType;
        ProcessInstance processInstance = this.procInstService.findProcessById(processinstid.longValue());
        String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
        ProcessElement process = ProcessDefineParser.createProcessXml((String)processDefContent);
        ActivityElement actEle = (ActivityElement)process.getActivitys().get(toActId);
        if (!"Y".equals(isCopy)) {
            while ("toolApp".equals(actEle.getType()) && !StringUtils.isEmpty((String)(toActId = this.getNextActId(processinstid, toActId)))) {
                actEle = (ActivityElement)process.getActivitys().get(toActId);
            }
        }
        List partlist = null;
        ArrayList<Long> accountlist = new ArrayList<Long>();
        String string = participantType = "Y".equals(isCopy) ? actEle.getCopyparticipantType() : actEle.getParticipantType();
        if ("process-starter".equals(participantType)) {
            accountlist.add(Long.parseLong(processInstance.getCreator()));
        } else if ("act-logic".equals(participantType)) {
            String beanName = "Y".equals(isCopy) ? actEle.getCopyparticiLogic() : actEle.getParticiLogic();
            IParticipantService action = (IParticipantService)this.processEngine.getApplicationContext().getBean(beanName, IParticipantService.class);
            IProcessInstanceService procInstService = this.processEngine.getProcessInstanceService();
            List parts = action.createWorkItemParticipants(procInstService.findProcessById(processinstid.longValue()), toActId);
            for (Participant part : parts) {
                accountlist.add(Long.parseLong(part.getParticipant()));
            }
        } else {
            partlist = "Y".equals(isCopy) ? actEle.getCopyparticipants() : actEle.getParticipants();
        }
        String split = ">";
        BasEmpAccount creater = this.basEmpAccountService.findById(Long.parseLong(processInstance.getCreator()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map creatermap = BeanUtil.beanToMap((Object)creater);
        BasOrg org = this.basOrgService.findByOrgId(creater.getOrgId());
        if (org.getBelongDept() != null) {
            creatermap.put("businessUnitId", org.getBelongDept());
            BasDept belongedept = this.basDeptService.findByDeptId(org.getBelongDept());
            if (belongedept != null) {
                creatermap.put("businessUnitOrgId", belongedept.getOrgId());
            }
        } else {
            creatermap.put("businessUnitId", creater.getDeptId());
            creatermap.put("businessUnitOrgId", creater.getOrgId());
        }
        map.put("creater", creatermap);
        map.put("loginuser", SysUtils.getLoginUser());
        map.putAll(params);
        if (partlist != null && !partlist.isEmpty()) {
            for (Participant participant : partlist) {
                if ("role".equals(participant.getParticType())) {
                    if (participant.getParticipant().contains(">")) {
                        List<String> ids = Arrays.asList(FreeMarkerUtil.instance().genString(participant.getParticipant(), map).split(">"));
                        List accounts = null;
                        if (ids.size() == 2) {
                            accounts = StringUtils.isNotBlank((String)ids.get(0)) && StringUtils.isNotBlank((String)ids.get(1)) ? this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), null, Long.parseLong(ids.get(1))) : new ArrayList();
                        } else if (ids.size() == 3) {
                            accounts = StringUtils.isNotBlank((String)ids.get(0)) && StringUtils.isNotBlank((String)ids.get(1)) && StringUtils.isNotBlank((String)ids.get(2)) ? this.basrolesaccountService.getRoleSelectAcount(Long.parseLong(ids.get(0)), Long.parseLong(ids.get(1)), Long.parseLong(ids.get(2))) : new ArrayList();
                        }
                        for (Object o : accounts) {
                            Map m = (Map)o;
                            if (m.get("ACCOUNT_ID") == null) continue;
                            accountlist.add(Long.parseLong(Objects.toString(m.get("ACCOUNT_ID"), "-999999")));
                        }
                        continue;
                    }
                    List<BasRolesAccount> roleaccounts = this.basrolesaccountDao.findByRoleId(Long.parseLong(participant.getParticipant()));
                    for (BasRolesAccount roleaccount : roleaccounts) {
                        accountlist.add(roleaccount.getAccountId());
                    }
                    continue;
                }
                if ("organization".equals(participant.getParticType())) {
                    List<BasEmpAccount> accounts = participant.getParticipant().contains(">") ? this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(participant.getParticipant(), map).split(">")[1])) : this.basEmpAccountService.findByOrgOrBizId(Long.parseLong(FreeMarkerUtil.instance().genString(participant.getParticipant(), map)));
                    for (BasEmpAccount account : accounts) {
                        accountlist.add(account.getAccountId());
                    }
                    continue;
                }
                accountlist.add(Long.parseLong(participant.getParticipant()));
            }
        }
        return accountlist;
    }

    public String getNextActId(Long processinstid, String actId) {
        try {
            String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
            List list = Dom4jProcDefParser.parserTransitionInfo((String)processDefContent, (String)actId);
            String currentActid = this.getCurrentActId(processinstid);
            for (Element lineEl : list) {
                if (currentActid.equals(lineEl.attribute("to").getValue())) continue;
                return lineEl.attribute("to").getValue();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u89e3\u6790xml\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return "";
    }

    public String getCurrentActId(Long processinstid) {
        try {
            String sql = "select group_concat(distinct t.activitydefid) actIds from WF_workitem t\nwhere processinstid = ?1 and t.currentstate in('4','10')";
            Object ob = this.sqlHelper.getSingal(sql, new Object[]{processinstid});
            return ob.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getFlowActsByEdcoAct(Long edocAct, Long processinstid) {
        if (edocAct == null || processinstid == null) {
            return null;
        }
        ArrayList<String> flowacts = new ArrayList<String>();
        ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processinstid));
        for (ActivityElement ae : pe.getActivitys().values()) {
            if (!edocAct.toString().equals(ae.getActPerm())) continue;
            flowacts.add(ae.getId());
        }
        return StringUtils.join((Object[])flowacts.toArray(), (String)",");
    }

    public void stopFlow(Long processinstid) {
        this.procInstService.terminateProcess(processinstid.longValue());
        this.basmessageService.delMydealByProcessinstid(processinstid);
    }

    public List<Map<String, Object>> getProcessApp(Long processInstId) {
        String sql = "select (select count(1)\n          from WF_WORKITEM t\n          left join bas_message m\n            on m.workitemid = t.workitemid\n          left join bas_message_receive r\n            on r.msg_id = m.msg_id\n         where t.processinstid = p.processinstid\n           and t.currentstate in ('4', '10') and ifnull(t.bizstate,'TG')<>'roll') todo,\n       (select count(1)\n          from WF_WORKITEM t\n         where t.processinstid = p.processinstid\n           and t.currentstate in ('7', '12')  and ifnull(t.bizstate,'TG')<>'roll') done,\n       (select count(1)\n          from WF_WORKITEM t\n          left join bas_message m\n            on m.workitemid = t.workitemid\n          left join bas_message_receive r\n            on r.msg_id = m.msg_id\n         where t.processinstid = p.processinstid\n           and t.currentstate in ('4', '10')\n           and r.is_read = 'N'  and ifnull(t.bizstate,'TG')<>'roll') toview\n  from wf_processinst p\n where p.processinstid = #processinstid# ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", processInstId);
        return this.beetls.serachBySql(sql, params);
    }

    public Map<String, Map<String, Object>> queryWorkMemory(String formCode, Long processinstid) {
        List<Map<String, Object>> items;
        String sql;
        GenForm form = this.genFormService.findGenFormByCode(formCode);
        GenFormFlow flow = this.genformflowService.findByFormIdAndApplyOrgs(form.getId(), null, SysUtils.getLoginUser().getOrgid().toString());
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (flow == null) {
            sql = "select T.EDITABLE_ACT, t.item_htmlname, t.item_label\n  from GEN_PANEL_ITEM t,  gen_form_panel p\n where t.panel_id = p.panel_id\n   and p.form_id = #formId#\n   and t.is_use = 'Y'\n   and t.item_type = 0 order by t.display_no\n";
            params.put("formId", form.getId());
            items = this.beetls.serachBySql(sql, params);
        } else {
            sql = "select group_concat(i.act_id) EDITABLE_ACT,\n       t.item_htmlname,\n       i.item_label\n  from (select i.*,\n               (select m.display_no\n                   from gen_act_item m\n                  where m.setting_id = i.setting_id\n                    and m.act_id = '" + this.getFirstAct(processinstid) + "'\n                    and m.item_id = i.item_id) ds\n          from gen_act_item i\n         where i.is_show = 'Y'\n           AND i.is_use = 'Y'\n           and i.setting_id = #id#)i,\n       GEN_PANEL_ITEM t\n where i.item_id = t.item_id\n   and i.is_editable = 'Y'\n   AND t.is_use = 'Y'\n   AND t.item_type = 0\n group by t.item_htmlname, i.item_label, ifnull(i.ds, t.display_no)\n order by ifnull(i.ds, t.display_no)";
            params.put("id", flow.getId());
            items = this.beetls.serachBySql(sql, params);
        }
        if (items == null || items.isEmpty()) {
            return map;
        }
        String workitemsql = "select getaccountname(t.participant) account_name,\n t.participant,\n t.workitemname,\n t.workmemory,\n t.endtime endtimeori,\n DATE_FORMAT(t.endtime,'%Y-%m-%d %H:%i:%S') endtime\n from WF_WORKITEM t\n where  FIND_IN_SET(t.activitydefid,#actids#)>0\n and processinstid = #processinstid#\n and ifnull(t.bizstate,'TG')<>'TH' and t.currentstate='12' order by t.endtime";
        params.put("processinstid", processinstid);
        for (Map<String, Object> item : items) {
            params.put("actids", Objects.toString(item.get("editableAct"), ""));
            params.put("processinstid", processinstid);
            List<Map<String, Object>> works = this.beetls.serachBySql(workitemsql, params);
            Map<Object, Object> work = new HashMap<String, String>();
            if (works.isEmpty()) {
                work.put("accountName", "");
                work.put("participant", "");
                work.put("workmemory", "");
                work.put("endtimeori", "");
                work.put("endtime", "");
                work.put("endtimeymd", "");
                works.add(work);
            } else {
                for (Map<String, Object> w : works) {
                    BasSignaturePersonal b;
                    if (!CommonService.showSign || w.get("participant") == null || (b = this.bassignaturepersonalService.findByAccountIdAndDate(Long.parseLong(w.get("participant").toString()), (Date)w.get("endtimeori"))) == null) continue;
                    w.put("sign", b.getSign());
                }
                work = works.get(0);
            }
            item.put("works", works);
            work.putAll(item);
            map.put(Objects.toString(item.get("itemHtmlname"), ""), work);
        }
        return map;
    }

    public Map<String, Object> queryWorkMemory(String formCode, Long processinstid, String itemHtmlname) {
        return this.queryWorkMemory(formCode, processinstid).get(itemHtmlname);
    }

    public Long getEdocActByFlowCode(String string) {
        IProcessDefineRepository pdr = (IProcessDefineRepository)SpringContextHolder.getApplicationContext().getBean(IProcessDefineRepository.class);
        ProcessDefine pd = pdr.findPublishProcessDefine(string);
        List afterTrans = ((ActivityElement)pd.getProcessElement().getActivitys().get("act_start")).getAfterTrans();
        return Long.parseLong(((ActivityElement)pd.getProcessElement().getActivitys().get(((TransitionElement)afterTrans.get(0)).getTo())).getActPerm());
    }

    public String getFirstAct(String flowCode) {
        IProcessDefineRepository pdr = (IProcessDefineRepository)SpringContextHolder.getApplicationContext().getBean(IProcessDefineRepository.class);
        ProcessDefine pd = pdr.findPublishProcessDefine(flowCode);
        List afterTrans = ((ActivityElement)pd.getProcessElement().getActivitys().get("act_start")).getAfterTrans();
        return ((TransitionElement)afterTrans.get(0)).getTo();
    }

    public String getFirstAct(Long processinstid) {
        return this.getFirstAct(this.procInstService.findProcessById(processinstid.longValue()).getProcessInstName());
    }

    public void updateFlows(Long processDefId) {
        String sql = "update wf_processdefine_processinst t\n   set t.processdefcontent =\n       (select t.processdefcontent\n          from WF_PROCESSDEFINE t\n         where t.processdefid = '" + processDefId + "'),\n t.oriprocessdefcontent =\n       (select t.processdefcontent\n          from WF_PROCESSDEFINE t\n         where t.processdefid = '" + processDefId + "')\n where t.processdefid = '" + processDefId + "'\n and exists (select 1 from WF_PROCESSINST p where p.currentstate in(4,10) and t.processinstid=p.processinstid)";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processDefId", processDefId);
        this.sqlHelper.exeNativeSQL(sql);
    }

    public void getRollableAct(ModelAndView view, Long msgId, String busiMainId, Long processinstid, String formCode) {
        if (msgId != null) {
            BasMessage msg = this.basmessageService.findBasMessage(msgId);
            if (msg == null || "Y".equals(msg.getIsUse())) {
                return;
            }
            HashMap<String, Object> paras = new HashMap<String, Object>(4);
            paras.put("processinstid", msg.getProcessinstid());
            paras.put("msgId", msgId);
            paras.put("accountId", SysUtils.getLoginAccountId());
            paras.put("isDeal", "Y");
            if (this.beetls.getIntValue("workflow.flow.checkMsgPerm", paras) == 0) {
                return;
            }
            IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
            WorkItem work = workItemRep.findWorkItem(msg.getWorkitemid().longValue());
            if (work == null) {
                return;
            }
            String processDefContent = this.sbpservice.queryFlowContent(null, msg.getProcessinstid());
            ProcessElement processElement = ProcessDefineParser.createProcessXml((String)processDefContent);
            ActivityElement activityXml = (ActivityElement)processElement.getActivitys().get(work.getActivityDefId());
            if (activityXml == null) {
                return;
            }
            ArrayList<Long> workItemIds = new ArrayList<Long>();
            if ("multi".equalsIgnoreCase(activityXml.getWiMode()) && "all".equalsIgnoreCase(activityXml.getFinishRule())) {
                List workItems = workItemRep.findActivityWorkItems(work.getActivityInstId());
                for (WorkItem workitem : workItems) {
                    workItemIds.add(workitem.getWorkItemId());
                }
            } else {
                workItemIds.add(work.getWorkItemId());
            }
            paras.put("workItemIds", workItemIds);
            if (this.beetls.getIntValue("workflow.flow.checkFllowWorkItemDone", paras) > 0) {
                return;
            }
            List workList = this.workItemService.findUnFinishedWorkItemByProcessInstId(msg.getProcessinstid().longValue());
            ArrayList<String> curActs = new ArrayList<String>(workList.size());
            if (workList.isEmpty()) {
                return;
            }
            for (WorkItem workItem : workList) {
                if (curActs.contains(workItem.getWorkItemName())) continue;
                curActs.add(workItem.getWorkItemName());
            }
            view.addObject("curActs", (Object)CollUtil.join(curActs, (CharSequence)","));
            view.addObject("rollAct", (Object)activityXml.getName());
            view.addObject("rollType", (Object)"\u64a4\u56de");
        } else if (processinstid != null) {
            ProcessInstance process = this.procInstService.findProcessById(processinstid.longValue());
            if (process.getCurrentState() == 12 || process.getCurrentState() == 7) {
                return;
            }
            if (process.getCreator().equals(SysUtils.getLoginAccountId().toString())) {
                String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
                ProcessElement processElement = ProcessDefineParser.createProcessXml((String)processDefContent);
                List workList = this.workItemService.findUnFinishedWorkItemByProcessInstId(processinstid.longValue());
                ArrayList<String> curActs = new ArrayList<String>(workList.size());
                String actId = this.getFirstAct(process.getProcessInstName());
                for (WorkItem workItem : workList) {
                    if (curActs.contains(workItem.getWorkItemName())) continue;
                    curActs.add(workItem.getWorkItemName());
                }
                view.addObject("curActs", (Object)CollUtil.join(curActs, (CharSequence)","));
                view.addObject("rollAct", (Object)((ActivityElement)processElement.getActivitys().get(actId)).getName());
                view.addObject("rollType", (Object)"\u64a4\u9500");
            }
        }
    }

    public boolean isStartActivity(Long processinstid, Long workItemId, String toActId) {
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        WorkItem workItem = workItemRep.findWorkItem(workItemId.longValue());
        String processDefContent = this.sbpservice.queryFlowContent(null, processinstid);
        ProcessElement processElement = ProcessDefineParser.createProcessXml((String)processDefContent);
        ActivityElement activityXml = (ActivityElement)processElement.getActivitys().get(workItem.getActivityDefId());
        String rule = activityXml.getFinishRule();
        long activityInstId = workItem.getActivityInstId();
        boolean isComplete = false;
        if ("single".equalsIgnoreCase(activityXml.getWiMode())) {
            isComplete = true;
        } else if ("all".equalsIgnoreCase(rule)) {
            int unfinishCount = workItemRep.getUnFinishedWorkItemCount(activityInstId);
            if (unfinishCount == 1) {
                isComplete = true;
            }
        } else if ("specifyNum".equalsIgnoreCase(rule)) {
            int finishCount;
            int ruleCount = activityXml.getFinishRquiredNum();
            if (ruleCount <= (finishCount = workItemRep.getFinishedWorkItemCount(activityInstId) + 1)) {
                isComplete = true;
            }
        } else if ("specifyPercent".equalsIgnoreCase(rule)) {
            double mustPercent;
            int total = workItemRep.getWorkItemCount(activityInstId);
            DecimalFormat df1 = new DecimalFormat("##.0000");
            int finishCount = workItemRep.getFinishedWorkItemCount(activityInstId) + 1;
            double c = Double.parseDouble(String.valueOf(finishCount)) / (double)total;
            String d = df1.format(c);
            double finishPercent = Double.parseDouble(d) * 100.0;
            if (finishPercent >= (mustPercent = activityXml.getFinishRequiredPercent())) {
                isComplete = true;
            }
        }
        if (StringUtils.isNotBlank((String)toActId) && processElement.getActivitys().get(toActId) != null && !"XOR".equalsIgnoreCase(((ActivityElement)processElement.getActivitys().get(toActId)).getJoinMode())) {
            isComplete = isComplete && this.checkPreActityAllDone(processinstid, processElement, workItem, toActId);
        }
        return isComplete;
    }

    private boolean checkPreActityAllDone(Long processinstid, ProcessElement processElement, WorkItem workItem, String toActId) {
        HashMap lines = new HashMap();
        ArrayList<String> preActs = new ArrayList<String>();
        LinkedList<String> queue = new LinkedList<String>();
        for (TransitionElement line : processElement.getTransitions()) {
            if ("act_start".equals(line.getFrom()) || "act_finish".equals(line.getTo())) continue;
            if (!lines.containsKey(line.getTo())) {
                lines.put(line.getTo(), new ArrayList());
            }
            ((List)lines.get(line.getTo())).add(line.getFrom());
        }
        queue.add(workItem.getActivityDefId());
        while (!queue.isEmpty()) {
            String headact = (String)queue.poll();
            if (lines.get(headact) == null) continue;
            for (String actId : (List)lines.get(headact)) {
                if (preActs.contains(actId)) continue;
                preActs.add(actId);
                queue.add(actId);
            }
        }
        List activitys = this.processEngine.getActivityInstService().findWaitingAndTerminateAndRunningActivityInst(processinstid.longValue());
        for (ActivityInst activity : activitys) {
            if (activity.getActivityInstId() == workItem.getActivityInstId() || "7".equals(activity.getCurrentState()) || !preActs.contains(activity.getActivityDefId())) continue;
            return false;
        }
        return true;
    }

    public Long getEdocActByFlow(Long processinstid, String ... flowCode) {
        if (processinstid != null) {
            ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processinstid));
            String curAct = this.getActivitydefid(processinstid, SysUtils.getLoginAccountId().toString());
            if (StringUtils.isBlank((String)curAct)) {
                return null;
            }
            ActivityElement ae = (ActivityElement)pe.getActivitys().get(this.getActivitydefid(processinstid, SysUtils.getLoginAccountId().toString()));
            return StringUtils.isBlank((String)ae.getActPerm()) ? -99999L : Long.parseLong(ae.getActPerm());
        }
        if (flowCode.length == 0) {
            return null;
        }
        IProcessDefineRepository pdr = (IProcessDefineRepository)SpringContextHolder.getApplicationContext().getBean(IProcessDefineRepository.class);
        ProcessDefine pd = pdr.findPublishProcessDefine(flowCode[0]);
        List afterTrans = ((ActivityElement)pd.getProcessElement().getActivitys().get("act_start")).getAfterTrans();
        String perm = ((ActivityElement)pd.getProcessElement().getActivitys().get(((TransitionElement)afterTrans.get(0)).getTo())).getActPerm();
        if (StringUtils.isNotBlank((String)perm)) {
            return Long.parseLong(perm);
        }
        return null;
    }

    public Map<String, Object> getFlowAdviceByProcessinstid(Long processinstid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap advices = new HashMap();
        HashMap sender = new HashMap();
        HashMap adviceTime = new HashMap();
        List<Map<String, Object>> adviceList = this.beetls.getMapList("workflow.flow.getAllWorkItem", MapUtil.of((Object)"processinstid", (Object)processinstid));
        adviceList.stream().forEach(map -> {
            advices.put(Objects.toString(map.get("activitydefid")), Objects.toString(map.get("workmemory"), ""));
            sender.put(Objects.toString(map.get("activitydefid")), Objects.toString(map.get("accountName"), ""));
            adviceTime.put(Objects.toString(map.get("activitydefid")), Objects.toString(map.get("endtime"), ""));
        });
        result.put("advices", advices);
        result.put("sender", sender);
        result.put("adviceTime", adviceTime);
        return result;
    }

    public void restartProInstForFmBudget(Long processinstid, String thReason) {
        IWorkItemRepository workItemRep = (IWorkItemRepository)this.processEngine.getApplicationContext().getBean(IWorkItemRepository.class);
        Long loginAccountId = SysUtils.getLoginAccountId();
        String sql = "SELECT\n   t.workitemid, t.STARTTIME \nFROM\n   wf_workitem t \nWHERE\n   t.PROCESSINSTID = " + processinstid + " \nORDER BY\n   t.STARTTIME ASC";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        if (list != null && !list.isEmpty()) {
            Map map = (Map)list.get(0);
            WorkItem fristItem = workItemRep.findWorkItem(Long.valueOf(map.get("WORKITEMID").toString()).longValue());
            List participantList = workItemRep.findWorkItemParticipants(fristItem.getWorkItemId());
            WorkItem thItem = new WorkItem();
            BeanUtils.copyProperties((Object)fristItem, (Object)thItem);
            long workItemId = PrimaryKeyUtil.getPrimaryKey((String)"workItemId");
            thItem.setWorkItemId(workItemId);
            thItem.setWorkItemName("\u7f16\u5236\u6c47\u603b\u9000\u56de");
            thItem.setBizState("TH");
            thItem.setCurrentState(12);
            thItem.setStartTime(new Date());
            thItem.setEndTime(new Date());
            thItem.setFinalTime(new Date());
            thItem.setWorkMemory(thReason);
            thItem.setParticipant(loginAccountId.toString());
            String insertSql = "INSERT INTO WF_WORKITEM\n  (workItemId,\n   workItemName,\n   workItemType,\n   currentState,\n   participant,\n   limitTime,\n   activityDefId,\n   activityInstId,\n   processInstId,\n   startTime,\n   processDefName,\n   bizState,\n   isAdd,\n   sourceworkItemId,\n   backoptions,\n   endtime,\n   finaltime,\n   workmemory)\nVALUES\n  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.sqlHelper.exeNativeSQL(insertSql, new Object[]{thItem.getWorkItemId(), thItem.getWorkItemName(), thItem.getWorkItemType(), thItem.getCurrentState(), thItem.getParticipant(), thItem.getLimitTime(), thItem.getActivityDefId(), thItem.getActivityInstId(), thItem.getProcessInstId(), thItem.getStartTime(), thItem.getProcessDefName(), thItem.getBizState(), thItem.getIsAdd(), thItem.getSourceworkItemId(), thItem.getBackoptions(), thItem.getEndTime(), thItem.getFinalTime(), thItem.getWorkMemory()});
            WorkItem copyFristItem = new WorkItem();
            BeanUtils.copyProperties((Object)fristItem, (Object)copyFristItem);
            long fristWorkItemId = PrimaryKeyUtil.getPrimaryKey((String)"workItemId");
            copyFristItem.setWorkItemId(fristWorkItemId);
            copyFristItem.setStartTime(new Date());
            copyFristItem.setEndTime(null);
            copyFristItem.setFinalTime(null);
            copyFristItem.setBizState("NTH");
            copyFristItem.setCurrentState(10);
            copyFristItem.setParticipant(null);
            copyFristItem.setWorkMemory(null);
            workItemRep.insertWorkItem(copyFristItem);
            for (Participant person : participantList) {
                Participant copyPerson = new Participant();
                BeanUtils.copyProperties((Object)person, (Object)copyPerson);
                long participantid = PrimaryKeyUtil.getPrimaryKey((String)"participantId");
                copyPerson.setParticId(participantid);
                copyPerson.setWorkItemId(fristWorkItemId);
                workItemRep.insertPaericipant(copyPerson);
            }
            String updateSQL = "update wf_activityinst t set t.CURRENTSTATE = 10, t.ENDTIME = null , t.FINALTIME = null where t.ACTIVITYINSTID = " + copyFristItem.getActivityInstId();
            this.sqlHelper.exeNativeSQL(updateSQL);
        }
    }

    public String findWfProcessdefineProcessinst(Long processinstid) {
        try {
            String sql = "select t.CREATOR from wf_processdefine_processinst t \nwhere processinstid = ?1 ";
            Object singal = this.sqlHelper.getSingal(sql, new Object[]{processinstid});
            if (singal != null) {
                return singal.toString();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public Boolean findIsJudge(String paramStr, String paramVal, Long accountid, Long processinstid) {
        Boolean judge = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", processinstid);
        params.put("accountid", accountid);
        String acts = this.bSqlHelper.getStringValue("workflow.flow.findActByProcessinstidAndAccountid", params);
        if (!StringUtils.isEmpty((String)acts)) {
            String[] actList;
            for (String act : actList = acts.split(",")) {
                if (StringUtils.isEmpty((String)act)) continue;
                Map actproperties = new HashMap();
                ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, processinstid));
                actproperties = ((ActivityElement)pe.getActivitys().get(act)).getProperties();
                if (!paramVal.equals(actproperties.get(paramStr))) continue;
                judge = true;
                break;
            }
        }
        return judge;
    }
}

