/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.workflow.controller;

import com.alibaba.fastjson.JSON;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasMessageService;
import com.ustc.sys.util.ListUtils;
import com.ustc.workflow.service.FlowUtilService;
import com.ustc.workflow.service.StfBusinessProcessService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.Participant;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.model.elements.FreeActElement;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.xml.ProcessDefineParser;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/viewwf"})
public class ViewFlowController
extends BaseController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    private static final String PROCESSINSTIDS = "processinstid";
    private static final String ACTID = "actid";
    private static final String VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    @RequestMapping(value={"/queryTransctrls"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryTransctrls(HttpServletRequest requestServlet, Long id) throws IOException {
        if (id != null) {
            IActivityInstService activityInstService = this.flowUtilservice.getProcessEngine().getActivityInstService();
            StringBuilder sb = new StringBuilder();
            List transCtrls = activityInstService.findTransCtrls(id.longValue());
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
            for (TransCtrl tc : transCtrls) {
                sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
            }
            sb.append("</transctrls>\n<noFinishActs>\n");
            List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
            for (ActivityInst activityInst : activityInsts) {
                sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
            }
            sb.append("</noFinishActs></activities>");
            return sb.toString();
        }
        return "";
    }

    @RequestMapping(value={"/queryFlowContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processInstId, HttpServletResponse reponse) throws IOException, SQLException {
        return this.sbpservice.queryFlowContent(id, processInstId);
    }

    @RequestMapping(value={"/queryActivityinsts"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryActivityinsts(HttpServletRequest requestServlet) throws IOException {
        Long processinstid = null;
        if (requestServlet.getParameter(PROCESSINSTIDS) != null) {
            processinstid = Long.valueOf(requestServlet.getParameter(PROCESSINSTIDS));
        }
        List<?> list = this.flowUtilservice.queryActivityinst(processinstid);
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            Object[] obj = new Object[]{map.get("PROCESSINSTID") == null ? "" : map.get("PROCESSINSTID").toString(), map.get("PROCESSDEFID") == null ? "" : map.get("PROCESSDEFID").toString(), map.get("PROCESSINSTNAME") == null ? "" : map.get("PROCESSINSTNAME").toString(), map.get("ACTIVITYINSTID") == null ? "" : map.get("ACTIVITYINSTID").toString(), map.get("ACTIVITYINSTNAME") == null ? "" : map.get("ACTIVITYINSTNAME").toString(), map.get("ACTIVITYTYPE") == null ? "" : map.get("ACTIVITYTYPE").toString(), map.get("CURRENTSTATE") == null ? "" : map.get("CURRENTSTATE").toString(), map.get("STARTTIME") == null ? "" : map.get("STARTTIME").toString(), map.get("ENDTIME") == null ? "" : map.get("ENDTIME").toString(), map.get("ACTIVITYDEFID") == null ? "" : map.get("ACTIVITYDEFID").toString()};
            sb.append("<node processinstid=\"" + obj[0].toString() + "\" processdefid=\"" + obj[1].toString() + "\" activitydefid=\"" + obj[9].toString() + "\" activityinstid=\"" + obj[3].toString() + "\" activityinstname=\"" + obj[4].toString() + "\" activitytype=\"" + obj[5].toString() + "\" currentstate=\"" + obj[6].toString() + "\" starttime=\"" + obj[7].toString() + "\" endtime=\"" + obj[8].toString() + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryWorkItemW"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryWorkItemW(HttpServletRequest requestServlet) throws IOException {
        Long activityinstid = null;
        if (requestServlet.getParameter("activityinstid") != null && !"".equals(requestServlet.getParameter("activityinstid"))) {
            activityinstid = Long.valueOf(requestServlet.getParameter("activityinstid"));
        }
        List<?> list = this.flowUtilservice.queryWorkItem(activityinstid);
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            Object[] obj = new Object[]{m.get("WORKITEMID") == null ? "" : m.get("WORKITEMID"), m.get("WORKITEMNAME") == null ? "" : m.get("WORKITEMNAME"), m.get("CURRENTSTATE") == null ? "" : m.get("CURRENTSTATE"), m.get("PARTICIPANT") == null ? "" : m.get("PARTICIPANT"), m.get("STARTTIME") == null ? "" : m.get("STARTTIME"), m.get("ENDTIME") == null ? "" : m.get("ENDTIME"), m.get("WORKMEMORY") == null ? "" : m.get("WORKMEMORY")};
            sb.append("<node workitemid=\"" + obj[0] + "\" workitemname=\"" + obj[1] + "\" currentstate=\"" + obj[2] + "\" participant=\"" + obj[3] + "\" starttime=\"" + obj[4] + "\" endtime=\"" + obj[5] + "\" workmemory=\"" + obj[6] + "\" istimeout=\"0\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryWorkItemByDefid"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryWorkItemByDefid(HttpServletRequest requestServlet) throws IOException {
        Long processinstid = null;
        if (requestServlet.getParameter(PROCESSINSTIDS) != null) {
            processinstid = Long.valueOf(requestServlet.getParameter(PROCESSINSTIDS));
        }
        String activitydefid = null;
        if (requestServlet.getParameter("activitydefid") != null) {
            activitydefid = String.valueOf(requestServlet.getParameter("activitydefid"));
        }
        List<?> list = this.flowUtilservice.queryWorkItemByDefid(processinstid, activitydefid);
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            Object[] obj = new Object[]{m.get("WORKITEMID") == null ? "" : m.get("WORKITEMID"), m.get("WORKITEMNAME") == null ? "" : m.get("WORKITEMNAME"), m.get("CURRENTSTATE") == null ? "" : m.get("CURRENTSTATE"), m.get("PARTICIPANT") == null ? "" : m.get("PARTICIPANT"), m.get("STARTTIME") == null ? "" : m.get("STARTTIME"), m.get("ENDTIME") == null ? "" : m.get("ENDTIME"), m.get("WORKMEMORY") == null ? "" : m.get("WORKMEMORY"), m.get("LIMITTIME") == null ? "" : m.get("LIMITTIME")};
            sb.append("<node workitemid=\"" + obj[0] + "\" workitemname=\"" + obj[1] + "\" currentstate=\"" + obj[2] + "\" participant=\"" + obj[3] + "\" starttime=\"" + obj[4] + "\" endtime=\"" + obj[5] + "\" workmemory=\"" + obj[6] + "\" istimeout=\"" + obj[7] + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/querySubProcInstId"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySubProcInstId(HttpServletRequest requestServlet) throws IOException {
        Object tmp;
        Object[] obj;
        String activitydefid = "";
        Long processInstId = 0L;
        if (requestServlet.getParameter(ACTID) != null) {
            activitydefid = requestServlet.getParameter(ACTID);
        }
        if (requestServlet.getParameter("parentProcinstid") != null) {
            processInstId = Long.valueOf(requestServlet.getParameter("parentProcinstid"));
        }
        if ((obj = (Object[])(tmp = this.flowUtilservice.querySubProcInstId(processInstId, activitydefid))) == null) {
            obj = new Object[2];
        }
        if (obj[0] == null) {
            obj[0] = "";
        }
        if (obj[1] == null) {
            obj[1] = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        sb.append("<node processinstid=\"" + obj[0] + "\" processDefId=\"" + obj[1] + "\">\n");
        sb.append("</node>\n");
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryParentProcInstId"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryParentProcInstId(HttpServletRequest requestServlet) throws IOException {
        Object tmp;
        Object[] obj;
        Long processinstid = 0L;
        if (requestServlet.getParameter(PROCESSINSTIDS) != null) {
            processinstid = Long.valueOf(requestServlet.getParameter(PROCESSINSTIDS));
        }
        if ((obj = (Object[])(tmp = this.flowUtilservice.queryParentProcInstId(processinstid))) == null) {
            obj = new Object[2];
        }
        if (obj[0] == null) {
            obj[0] = "";
        }
        if (obj[1] == null) {
            obj[1] = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        sb.append("<node parentProcessinstid=\"" + obj[0] + "\" parentProcessDefId=\"" + obj[1] + "\">\n");
        sb.append("</node>\n");
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryActivitydefid"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryActivitydefid(HttpServletRequest requestServlet) throws IOException {
        Long processinstid = 0L;
        if (requestServlet.getParameter(PROCESSINSTIDS) != null) {
            processinstid = Long.valueOf(requestServlet.getParameter(PROCESSINSTIDS));
        }
        String str = this.flowUtilservice.queryActivitydefid(processinstid);
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>");
        sb.append("<node activitydefid=\"" + str + "\">\n");
        sb.append("</node>\n");
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/getAppList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAppList(HttpServletRequest requestServlet, Long processinstid, Integer start, Integer limit) throws IOException, ParseException {
        if (processinstid == null) {
            return new PageObject();
        }
        List<Map> list = this.flowUtilservice.getAppList(processinstid);
        if (start == null || limit == null) {
            return list;
        }
        int to = start + limit;
        if (to > list.size()) {
            to = list.size();
        }
        return new PageObject<Map>(list.subList(start, to), Long.valueOf(list.size()));
    }

    @RequestMapping(value={"/viewFlow"}, method={RequestMethod.GET})
    public Object viewFlow(HttpServletRequest requestServlet, Long processInstId) {
        if (processInstId != null) {
            requestServlet.setAttribute("processInstId", (Object)processInstId);
            requestServlet.setAttribute("processDefId", (Object)this.flowUtilservice.getProcessdefidByProcessinstid(processInstId));
            requestServlet.setAttribute("isCreator", (Object)this.flowUtilservice.getProcInstService().findProcessById(processInstId.longValue()).getCreator().equals(SysUtils.getLoginAccountId().toString()));
        }
        return "/workflow/jsflowview";
    }

    @RequestMapping(value={"/selecFlow"}, method={RequestMethod.GET})
    public Object selecFlow(HttpServletRequest requestServlet, Long processInstId, Long msgId) {
        String processDefId = this.flowUtilservice.getProcessdefidByProcessinstid(processInstId);
        requestServlet.setAttribute("processInstId", (Object)processInstId);
        List actlist = this.flowUtilservice.getProcessEngine().getFreeFlowService().queryCustomPossibleNextActsOfFreeActivity(processInstId.longValue(), Long.parseLong(processDefId), this.flowUtilservice.getActivitydefid(processInstId, SysUtils.getLoginAccountId().toString()));
        if (!actlist.isEmpty()) {
            IActivityInstService activityInstService = this.flowUtilservice.getProcessEngine().getActivityInstService();
            List transCtrls = activityInstService.findTransCtrls(processInstId.longValue());
            HashMap tsacts = new HashMap();
            HashMap<String, Object> deals = new HashMap<String, Object>();
            for (TransCtrl ts : transCtrls) {
                tsacts.put(ts.getSrcActDefId(), null);
            }
            ArrayList<String> freeacts = new ArrayList<String>(actlist.size());
            ArrayList<String> freeactnames = new ArrayList<String>(actlist.size());
            for (FreeActElement freeact : actlist) {
                if (!tsacts.containsKey(freeact.getId()) || "start".equals(freeact.getType()) || "finish".equals(freeact.getType())) continue;
                freeacts.add(freeact.getId());
                freeactnames.add(freeact.getName());
                List<Participant> participants = this.flowUtilservice.getLastDealPerson(processInstId, freeact.getId());
                if (participants.isEmpty()) continue;
                deals.put(freeact.getId(), participants.stream().map(Participant::getParticipant2).collect(Collectors.joining(",")));
                deals.put(freeact.getId() + "Persons", participants);
            }
            requestServlet.setAttribute("deals", (Object)JSON.toJSONString(deals));
            requestServlet.setAttribute("freeacts", (Object)ListUtils.listToString(freeacts, ','));
            requestServlet.setAttribute("freeactnames", (Object)ListUtils.listToString(freeactnames, ','));
            if (msgId != null) {
                BasMessage message = this.basmessageService.findBasMessageByAccountId(msgId, SysUtils.getLoginAccountId());
                IWorkItemRepository workitemrep = (IWorkItemRepository)SpringContextHolder.getApplicationContext().getBean(IWorkItemRepository.class);
                WorkItem workItem = workitemrep.findWorkItem(message.getWorkitemid().longValue());
                Document processDefContentDOC = ProcessDefineParser.createDocument((String)this.sbpservice.queryFlowContent(null, processInstId));
                Element backoptions = (Element)processDefContentDOC.selectSingleNode("/ProcessDefine/Activitys/Activity[@id='" + workItem.getActivityDefId() + "']/disablebackoptions");
                if (backoptions != null) {
                    requestServlet.setAttribute("disablebackoptions", (Object)backoptions.getText());
                }
            }
        }
        requestServlet.setAttribute("processDefId", (Object)processDefId);
        return "/workflow/jsflowselect";
    }

    @RequestMapping(value={"/queryFlowAdvice"})
    @ResponseBody
    public String queryFlowAdvice(HttpServletRequest requestServlet, Long processInstId, String actID) {
        List<Map<String, Object>> list = this.flowUtilservice.queryFlowAdvice(processInstId, actID);
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("<node>\n");
        String particiString = "";
        StringBuffer participantListString = new StringBuffer("");
        for (Map<String, Object> m : list) {
            if (m.get("PARTICIPANT") == null || "".equals(m.get("PARTICIPANT").toString())) continue;
            participantListString.append(m.get("PARTICIPANT") + ",");
        }
        if (!"".equals(participantListString.toString())) {
            particiString = participantListString.substring(0, participantListString.length() - 1);
        }
        for (Map<String, Object> m : list) {
            sb.append("<node actityID=\"" + actID + "\"   wiMode=\"multi\"   actityName=\"" + m.get("ACTIVITYINSTNAME") + "\"   acurrentstate=\"" + m.get("ACURRENTSTATE") + "\"   participantList=\"" + particiString + "\"  participant=\"" + m.get("PARTICIPANT") + "\"  endtime=\"" + (m.get("ENDTIME") == null ? "" : m.get("ENDTIME")) + "\"  workmemory=\"" + (m.get("WORKMEMORY") == null ? "" : m.get("WORKMEMORY")) + "\" currentstate=\"" + m.get("CURRENTSTATE") + "\"  />\n");
        }
        sb.append("</node>\n");
        return sb.toString();
    }

    @RequestMapping(value={"/viewProcessApp"})
    public Object viewProcessApp(Long processInstId, Model model) throws ParseException {
        Subject currentUser;
        if (processInstId != null) {
            List<Map<String, Object>> personscount = this.flowUtilservice.getProcessApp(processInstId);
            if (personscount.size() > 0) {
                model.addAttribute("personscount", personscount.get(0));
            }
            model.addAttribute("appList", this.flowUtilservice.getAppListNew(processInstId));
        }
        if ((currentUser = SecurityUtils.getSubject()).isPermitted("admin:manage")) {
            model.addAttribute("isAdmin", (Object)"Y");
        }
        return "/workflow/processApp";
    }
}

