/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.workflow.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.service.CommonService;
import com.ustc.gen.service.GenFormService;
import com.ustc.workflow.entity.StfBusinessProcess;
import com.ustc.workflow.entity.StfBusinessType;
import com.ustc.workflow.service.FlowUtilService;
import com.ustc.workflow.service.StfBusinessProcessService;
import com.ustc.workflow.service.StfBusinessTypeService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/StfBusinessProcess"})
public class StfBusinessProcessController
extends BaseController {
    @Autowired
    private StfBusinessProcessService StfBusinessProcessService;
    @Autowired
    private StfBusinessTypeService stfbusinesstypeService;
    @Autowired
    private GenFormService genformService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private CommonService comService;

    @RequestMapping(value={"/findStfBusinessProcess"})
    @ResponseBody
    public Object findStfBusinessProcess(Long id) {
        StfBusinessProcess sbp = this.StfBusinessProcessService.find(id);
        Long businessTypeId = sbp.getBusinessTypeId();
        StfBusinessType bt = this.stfbusinesstypeService.findById(businessTypeId);
        String name = bt.getName();
        String type = sbp.getType();
        sbp.setBusinessTypeName(name);
        if (type != null && !"".equals(type)) {
            switch (type) {
                case "flow": {
                    type = "4";
                    break;
                }
                case "subflow": {
                    type = "1";
                    break;
                }
                case "feiflow": {
                    type = "1";
                }
            }
            sbp.setType(type);
        }
        return sbp;
    }

    @RequestMapping(value={"/queryFlowContent"})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processinstid, String actid, HttpServletResponse reponse) throws IOException, SQLException {
        reponse.setContentType("text/xml;charset=UTF-8");
        return this.StfBusinessProcessService.queryFlowContent(id, processinstid);
    }

    @RequestMapping(value={"/saveStfBusinessProcess"})
    @ResponseBody
    public Object saveStfBusinessProcess(StfBusinessProcess entity, @RequestParam(value="businessTypeId", defaultValue="") Long businessTypeId, Long id) {
        JsonMsg msg = new JsonMsg();
        String type = entity.getType();
        if (null != type && !"".equals(type)) {
            switch (type) {
                case "4": {
                    type = "flow";
                    break;
                }
                case "1": {
                    type = "subflow";
                    break;
                }
                case "2": {
                    type = "feiflow";
                }
            }
            entity.setType(type);
        }
        if (StringUtils.isBlank((String)entity.getApplyOrgs()) && ("2".equals(entity.getShareType()) || "3".equals(entity.getShareType()))) {
            msg.setSuccess(false);
            msg.setMsg("\u9694\u79bb\u6d41\u7a0b\u8bf7\u9009\u62e9\u6388\u6743\u5355\u4f4d");
            return msg;
        }
        if (entity.getId() == null && id == null) {
            StfBusinessProcess newentity = new StfBusinessProcess();
            this.StfBusinessProcessService.save(entity);
            newentity = this.StfBusinessProcessService.find(entity.getId());
            newentity.setDesignName(newentity.getType() + "." + String.valueOf(newentity.getId()));
            this.StfBusinessProcessService.update(newentity);
        } else {
            entity.setId(id);
            this.StfBusinessProcessService.update(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delStfBusinessProcess"})
    @ResponseBody
    public Object delStfBusinessProcess(Long id) {
        this.StfBusinessProcessService.delStfBusinessProcess(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeStfBusinessTypeWithRoot"})
    @ResponseBody
    public Object treeStfBusinessTypeWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.StfBusinessProcessService.treeStfBusinessType(pid);
        return treelist;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageStfBusinessProcess(@RequestParam(value="businessTypeId", defaultValue="") String businessTypeId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.StfBusinessProcessService.PageAll(businessTypeId, search, type, page, rows);
    }

    @RequestMapping(value={"/getflowByFlowCatId"})
    @ResponseBody
    public Object getflowByFlowCatId(Long flowCatId, String orgId) {
        return this.StfBusinessProcessService.getflowByFlowCatId(flowCatId, orgId);
    }

    @RequestMapping(value={"/copyStfBusinessProcess"})
    @ResponseBody
    public Object copyStfBusinessProcess(Long id) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ParseException {
        StfBusinessProcess entity = this.StfBusinessProcessService.copyStfBusinessProcess(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/allBusiflow"})
    @ResponseBody
    public Object allBusiflow(String fuzzy, int page, int rows) {
        return this.StfBusinessProcessService.findAll(fuzzy, page, rows);
    }

    @RequestMapping(value={"/flowMonitor"})
    @ResponseBody
    public Object flowMonitor() {
        return this.StfBusinessProcessService.flowMonitor();
    }
}

