/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.util;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.JSONUtil;
import com.ustc.util.DateUtil;
import com.ustc.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    private static Logger logger = LoggerFactory.getLogger(ReflectUtil.class);

    public static <T> List<T> jsonStrToBeanList(String jsonStr, Class<T> cls) throws JSONException {
        List mapList = (List)JSONUtil.deserialize((String)jsonStr);
        return ReflectUtil.mapListToBeanList(mapList, cls);
    }

    public static <T> List<T> mapListToBeanList(List<Map<String, Object>> mapList, Class<T> cls) {
        ArrayList<T> dataList = new ArrayList<T>();
        if (mapList == null) {
            return dataList;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] propertyArr = beanInfo.getPropertyDescriptors();
            ArrayList<String> fieldNameArr = new ArrayList<String>();
            ArrayList<Method> methodArr = new ArrayList<Method>();
            ArrayList<String> typeArr = new ArrayList<String>();
            for (int i = 0; i < propertyArr.length; ++i) {
                PropertyDescriptor descriptor = propertyArr[i];
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method readMethod = descriptor.getWriteMethod();
                String type = readMethod.getParameterTypes()[0].toString();
                fieldNameArr.add(propertyName);
                methodArr.add(readMethod);
                typeArr.add(type);
            }
            for (Map<String, Object> map : mapList) {
                dataList.add(ReflectUtil.getObj(fieldNameArr, methodArr, typeArr, map, cls));
            }
        }
        catch (Exception e) {
            logger.error("map\u6570\u7ec4\u8f6c\u4e3a\u76f8\u5e94\u7684bean\u6570\u7ec4\u5931\u8d25", (Throwable)e);
        }
        return dataList;
    }

    public static <T> T mapToBean(Map map, Class<T> cls) {
        if (map == null) {
            return null;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] propertyArr = beanInfo.getPropertyDescriptors();
            ArrayList<String> fieldNameArr = new ArrayList<String>();
            ArrayList<Method> methodArr = new ArrayList<Method>();
            ArrayList<String> typeArr = new ArrayList<String>();
            for (int i = 0; i < propertyArr.length; ++i) {
                PropertyDescriptor descriptor = propertyArr[i];
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method readMethod = descriptor.getWriteMethod();
                String type = readMethod.getParameterTypes()[0].toString();
                fieldNameArr.add(propertyName);
                methodArr.add(readMethod);
                typeArr.add(type);
            }
            return ReflectUtil.getObj(fieldNameArr, methodArr, typeArr, map, cls);
        }
        catch (Exception e) {
            logger.error("\u5c06map\u8f6c\u4e3aBean\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static List<Map<Object, Object>> beanListToMapList(List beanList, Class cls) {
        ArrayList<Map<Object, Object>> mapList = new ArrayList<Map<Object, Object>>();
        if (beanList == null) {
            return mapList;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            ArrayList<String> propertyList = new ArrayList<String>();
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method method = descriptor.getReadMethod();
                propertyList.add(propertyName);
                methodList.add(method);
            }
            HashMap map = null;
            for (Object bean : beanList) {
                map = new HashMap();
                for (int i = 0; i < propertyList.size(); ++i) {
                    Object result = ((Method)methodList.get(i)).invoke(bean, new Object[0]);
                    map.put(propertyList.get(i), result == null ? "" : result);
                }
                mapList.add(map);
            }
        }
        catch (Exception e) {
            logger.error("\u5c06map\u6570\u7ec4\u8f6c\u4e3a\u76f8\u5e94\u7684bean\u6570\u7ec4\u5931\u8d25", (Throwable)e);
        }
        return mapList;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException e1) {
            logger.error("Introspection\u671f\u95f4\u53d1\u751f\u5f02\u5e38\u5f02\u5e38", (Throwable)e1);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        try {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                returnMap.put(propertyName, "");
            }
        }
        catch (Exception e) {
            logger.error("bean\u8f6c\u4e3amap\u5f02\u5e38", (Throwable)e);
        }
        return returnMap;
    }

    private static <T> T getObj(List<String> fieldNameArr, List<Method> methodArr, List<String> typeArr, Map map, Class<T> cls) {
        T model = null;
        try {
            model = cls.newInstance();
            String fieldName = "";
            String type = "";
            Method method = null;
            for (int i = 0; i < fieldNameArr.size(); ++i) {
                fieldName = fieldNameArr.get(i);
                type = typeArr.get(i);
                method = methodArr.get(i);
                if (type.startsWith("class")) {
                    if ("class java.lang.String".equals(type)) {
                        method.invoke(model, StringUtil.null2String(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.util.Date".equals(type)) {
                        if (map.get(fieldName) instanceof Date) {
                            method.invoke(model, map.get(fieldName));
                            continue;
                        }
                        method.invoke(model, DateUtil.parseDate(StringUtil.null2String(map.get(fieldName))));
                        continue;
                    }
                    if ("class java.lang.Long".equals(type)) {
                        method.invoke(model, StringUtil.strToLong(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Double".equals(type)) {
                        method.invoke(model, StringUtil.strToDouble(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Float".equals(type)) {
                        method.invoke(model, StringUtil.strToFloat(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Integer".equals(type)) {
                        method.invoke(model, StringUtil.strToInt(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Boolean".equals(type)) {
                        method.invoke(model, StringUtil.strToBoolean(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Character".equals(type)) {
                        method.invoke(model, StringUtil.strToChar(map.get(fieldName)));
                        continue;
                    }
                    if ("class java.lang.Byte".equals(type)) {
                        method.invoke(model, StringUtil.strToByte(map.get(fieldName)));
                        continue;
                    }
                    if (!"class java.lang.Short".equals(type)) continue;
                    method.invoke(model, StringUtil.strToShort(map.get(fieldName)));
                    continue;
                }
                if ("long".equals(type)) {
                    method.invoke(model, StringUtil.str2Long(map.get(fieldName)));
                    continue;
                }
                if ("double".equals(type)) {
                    method.invoke(model, StringUtil.str2Double(map.get(fieldName)));
                    continue;
                }
                if ("float".equals(type)) {
                    method.invoke(model, Float.valueOf(StringUtil.str2Float(map.get(fieldName))));
                    continue;
                }
                if ("int".equals(type)) {
                    method.invoke(model, StringUtil.str2Int(map.get(fieldName)));
                    continue;
                }
                if ("boolean".equals(type)) {
                    method.invoke(model, StringUtil.str2Boolean(map.get(fieldName)));
                    continue;
                }
                if ("char".equals(type)) {
                    method.invoke(model, Character.valueOf(StringUtil.str2Char(map.get(fieldName))));
                    continue;
                }
                if ("byte".equals(type)) {
                    method.invoke(model, StringUtil.str2Byte(map.get(fieldName)));
                    continue;
                }
                if (!"short".equals(type)) continue;
                method.invoke(model, StringUtil.str2Short(map.get(fieldName)));
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    public static List<Map<String, Object>> compareObject(Object oldObj, Object newObj) {
        Map<String, Object> oldMap = ReflectUtil.beanToMap(oldObj);
        Map<String, Object> newMap = ReflectUtil.beanToMap(newObj);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> tmpMap = null;
        for (String key : oldMap.keySet()) {
            if (oldMap.get(key).equals(newMap.get(key))) continue;
            tmpMap = new HashMap<String, Object>();
            tmpMap.put("changeCol", key);
            tmpMap.put("oldValue", oldMap.get(key));
            tmpMap.put("newValue", newMap.get(key));
            resultList.add(tmpMap);
        }
        return resultList;
    }

    public static <T> T add(Object bean, Object beanDst, Class<T> cls) {
        Map<String, Object> map = ReflectUtil.beanToMap(bean);
        Map<String, Object> mapDst = ReflectUtil.beanToMap(beanDst);
        Set<String> keys = mapDst.keySet();
        for (String key : keys) {
            if (!StringUtil.isEmpty(mapDst.get(key))) continue;
            mapDst.put(key, map.get(key));
        }
        return ReflectUtil.mapToBean(mapDst, cls);
    }
}

