/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.util;

import com.ustc.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil
extends SimpleDateFormat {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String[] parsePatterns = new String[]{"yyyy/MM/dd", "yyyy-MM-dd", "yyyy-M-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy\u5e74MM\u6708", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM"};

    public static String getDateStrCN(String dateStr) {
        Date date = DateUtil.parseDate(dateStr);
        if (date == null) {
            log.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u65e5\u671f\u683c\u5f0f {}", (Object)dateStr);
            return null;
        }
        return DateUtil.format(date, "yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static String getMonthDateStr(String dateStr) {
        Date date = DateUtil.parseDate(dateStr);
        if (date == null) {
            log.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u65e5\u671f\u683c\u5f0f {}", (Object)dateStr);
            return null;
        }
        return DateUtil.format(date, "yyyy\u5e74M\u6708");
    }

    public static String getCurDateTimeStr() {
        return DateUtil.formatDateTime(new Date());
    }

    public static String getTodayStr() {
        return DateUtil.formatDate(new Date());
    }

    public static Date getToday() {
        return new Date();
    }

    public static String formatDate(Object date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }

    public static String formatDateTime(Object date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDateMin(Object date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm");
    }

    public static String getCurDateMinStr() {
        return DateUtil.formatDateMin(new Date());
    }

    public static String formatMonth(Object date) {
        return DateUtil.format(date, "yyyy-MM");
    }

    public static String formatDay(Object date) {
        return DateUtil.format(date, "HH:mm");
    }

    public static Date getLastDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        return c.getTime();
    }

    public static Date getNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        return c.getTime();
    }

    public static Date getOldDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        return c.getTime();
    }

    public static String format(Object date, String pattern) {
        if (date == null || pattern == null) {
            log.error("\u4f20\u5165\u7684\u65e5\u671f\u5bf9\u8c61\u6216\u683c\u5f0f\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
            return null;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date parseDate(String dateStr) {
        if (StringUtil.isEmpty(dateStr)) {
            log.error("\u4f20\u5165\u7684\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
            return null;
        }
        try {
            return DateUtils.parseDate((String)dateStr, (String[])parsePatterns);
        }
        catch (ParseException e) {
            log.error("\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5931\u8d25" + dateStr, (Throwable)e);
            return null;
        }
    }

    public static String getYear() {
        return DateUtil.getTodayStr().substring(0, 4);
    }

    public static String getMonth() {
        return DateUtil.getTodayStr().substring(5, 7);
    }

    public static int getMonthWeek(Date curDate) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(curDate);
        return rightNow.get(4);
    }

    public static int getDayMonth(Date curDate) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(curDate);
        return rightNow.get(5);
    }

    public static int getYearWeek(Date curDate) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(curDate);
        return rightNow.get(3);
    }

    public static int getYearMonth(Date curDate) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(curDate);
        return rightNow.get(2);
    }

    public static String getPerAfterDay(String dateStr, int days) {
        Date date = DateUtil.parseDate(dateStr);
        return DateUtil.formatDate(DateUtil.getPerAfterDay(date, days));
    }

    public static Date getPerAfterDay(Date date, int days) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(6, days);
        return rightNow.getTime();
    }

    public static String getPerAfterMonth(String dateStr, int months) {
        Date date = DateUtil.parseDate(dateStr);
        return DateUtil.formatDate(DateUtil.getPerAfterMonth(date, months));
    }

    public static Date getPerAfterMonth(Date date, int months) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(2, months);
        return rightNow.getTime();
    }

    public static String getPerAfterYear(String dateStr, int years) {
        Date date = DateUtil.parseDate(dateStr);
        return DateUtil.formatDate(DateUtil.getPerAfterYear(date, years));
    }

    public static Date getPerAfterYear(Date date, int years) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(1, years);
        return rightNow.getTime();
    }

    public static String getPerAfterWeek(String dateStr, int weeks) {
        Date date = DateUtil.parseDate(dateStr);
        return DateUtil.formatDate(DateUtil.getPerAfterWeek(date, weeks));
    }

    public static Date getPerAfterWeek(Date date, int weeks) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(3, weeks);
        return rightNow.getTime();
    }

    public static int getWeekDay(Date date) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        return rightNow.get(7);
    }

    public static String getWeekCN(Date date) {
        int i = DateUtil.getWeekDay(date);
        String s = "";
        switch (i) {
            case 1: {
                s = "\u661f\u671f\u5929";
                break;
            }
            case 2: {
                s = "\u661f\u671f\u4e00";
                break;
            }
            case 3: {
                s = "\u661f\u671f\u4e8c";
                break;
            }
            case 4: {
                s = "\u661f\u671f\u4e09";
                break;
            }
            case 5: {
                s = "\u661f\u671f\u56db";
                break;
            }
            case 6: {
                s = "\u661f\u671f\u4e94";
                break;
            }
            case 7: {
                s = "\u661f\u671f\u516d";
            }
        }
        return s;
    }

    public static Date getMonthLastDay(Date date) {
        if (date == null) {
            log.error("\u4f20\u5165\u7684\u65e5\u671f\u4e3anull!");
            return null;
        }
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.set(5, 1);
        rightNow.roll(5, -1);
        return rightNow.getTime();
    }

    public static String getMonthLastDay(String dateStr) {
        Date date = DateUtil.parseDate(dateStr);
        return DateUtil.formatDate(DateUtil.getMonthLastDay(date));
    }

    public static int getDiffMonths(Date startDate, Date endDate) throws Exception {
        if (startDate == null || endDate == null) {
            log.error("\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002");
            throw new Exception("\u56e0\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u65e5\u671f\u95f4\u9694!");
        }
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int diff = (end.get(1) - start.get(1)) * 12 + end.get(2) - start.get(2);
        return diff;
    }

    public static int getDiffMonths(String startDateStr, String endDateStr) throws Exception {
        return DateUtil.getDiffMonths(DateUtil.parseDate(startDateStr), DateUtil.parseDate(endDateStr));
    }

    public static int getDiffDays(Date startDate, Date endDate) throws Exception {
        if (startDate == null || endDate == null) {
            throw new Exception("\u4f20\u5165\u7684\u65e5\u671f\u4e3a\u7a7a!");
        }
        Long str = (endDate.getTime() - startDate.getTime()) / 86400000L;
        return str.intValue();
    }

    public static int getDiffDays(String startDateStr, String endDateStr) throws Exception {
        if (StringUtil.isEmpty(startDateStr) || StringUtil.isEmpty(endDateStr)) {
            throw new Exception("\u4f20\u5165\u7684\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a!");
        }
        Date startDate = DateUtil.parseDate(startDateStr);
        Date endDate = DateUtil.parseDate(endDateStr);
        if (startDate == null || endDate == null) {
            throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u65e5\u671f\u683c\u5f0f\uff01!");
        }
        return DateUtil.getDiffDays(startDate, endDate);
    }

    public static boolean isLeapYear(String year) {
        boolean isLeapYear = false;
        int yearInt = Integer.parseInt(year);
        if (yearInt / 400 == 0 || yearInt % 4 == 0 && yearInt / 100 != 0) {
            isLeapYear = true;
        }
        return isLeapYear;
    }

    public static String toDateStr(String str) {
        String dateStr = null;
        if (str != null && str.length() == 10) {
            dateStr = str.substring(0, 4) + "-" + str.substring(5, 7) + "-" + str.substring(8, 10);
        }
        return dateStr;
    }

    public static Long getDiffMilliseconds(Date startDate, Date endDate) throws Exception {
        if (startDate == null || endDate == null) {
            throw new Exception("\u4f20\u5165\u7684\u65e5\u671f\u4e3a\u7a7a!");
        }
        Long diff = endDate.getTime() - startDate.getTime();
        return diff;
    }

    @Override
    public Date parse(String source) {
        return DateUtil.parseDate(source);
    }

    public static String getCurrentQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date startTime = null;
        if (currentMonth >= 1 && currentMonth <= 3) {
            c.set(2, 0);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            c.set(2, 3);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            c.set(2, 6);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            c.set(2, 9);
        }
        c.set(5, 1);
        startTime = c.getTime();
        return DateUtil.formatDate(startTime);
    }

    public static int compareTime(Date dateOne, Date dateTwo) {
        Date dt1 = dateOne;
        Date dt2 = dateTwo;
        if (dt1.getTime() > dt2.getTime()) {
            return 1;
        }
        return 0;
    }

    public static String checkIsHoliday(String data) {
        BufferedReader reader = null;
        String result = null;
        StringBuffer sbf = new StringBuffer();
        String httpUrl = "http://tool.bitefu.net/jiari/?d=" + data;
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            reader.close();
            result = sbf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

