/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.sys.dao.BasRegionDao;
import com.ustc.sys.entity.BasRegion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRegionService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRegionDao basregionDao;
    @Autowired
    private BeetlSQLHelper bSqlHelper;

    public BasRegion findBasRegion(Long id) {
        BasRegion entity = (BasRegion)this.basregionDao.findById(id).get();
        return entity;
    }

    public BasRegion findByRegionCode(String regionCode) {
        List<BasRegion> list = this.basregionDao.findByRegionCodeAndIsUse(regionCode, "Y");
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void saveBasRegion(BasRegion entity) {
        this.basregionDao.save(entity);
    }

    public void delBasRegion(Long id) {
        this.basregionDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", search);
        }
        return this.bSqlHelper.serachPage("sys.BasRegion.PageAll", params);
    }

    public void delBasRegionAndChild(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.bSqlHelper.updateOrDelete("sys.BasRegion.delBasRegionAndChild", params);
    }

    public List<ComBoxTreeNode> treeBasRegion(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("sys.BasRegion.select", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeBasRegionAndMaHouseBuilding(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("sys.BasRegion.selectBasRegionAndMaHouseBuilding", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String getRegionNameByIds(String regionIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("regionIds", regionIds);
        return this.bSqlHelper.getStringValue("sys.BasRegion.getRegionNameByIds", params);
    }
}

