/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.gen.dao.GenPanleItemTypeDao;
import com.ustc.gen.entity.GenPanleItemType;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenPanleItemTypeService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenPanleItemTypeDao genPanleItemTypeDao;

    public GenPanleItemType findGenPanleItemType(Long id) {
        GenPanleItemType entity = (GenPanleItemType)this.genPanleItemTypeDao.findById(id).get();
        return entity;
    }

    @CacheEvict(cacheNames={"ITEM_TYPE"}, allEntries=true)
    public void saveGenPanleItemType(GenPanleItemType entity) {
        this.genPanleItemTypeDao.save(entity);
    }

    @CacheEvict(cacheNames={"ITEM_TYPE"}, allEntries=true)
    public void delGenPanleItemType(Long id) {
        GenPanleItemType entity = (GenPanleItemType)this.genPanleItemTypeDao.findById(id).get();
        entity.setIsUse("N");
        this.genPanleItemTypeDao.save(entity);
    }

    @CacheEvict(cacheNames={"ITEM_TYPE"}, allEntries=true)
    public List<GenPanleItemType> findAll() {
        return this.genPanleItemTypeDao.findByIsUse("Y");
    }

    @CacheEvict(cacheNames={"ITEM_TYPE"}, allEntries=true)
    public Map<Long, GenPanleItemType> findMapAll() {
        List<GenPanleItemType> list = this.genPanleItemTypeDao.findByIsUse("Y");
        HashMap<Long, GenPanleItemType> map = new HashMap<Long, GenPanleItemType>(list.size() * 2);
        list.forEach(type -> map.put(type.getId(), (GenPanleItemType)type));
        return map;
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("gen.GenPanleItemType.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getItemTypeCombo(String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        return this.bSqlHelper.getMapList("gen.GenPanleItemType.getItemTypeCombo", params);
    }
}

