/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.gen.dao.GenPanelItemDao;
import com.ustc.gen.entity.DBColumn;
import com.ustc.gen.entity.DBTable;
import com.ustc.gen.entity.GenPanelItem;
import com.ustc.gen.service.GenFormPanelService;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.service.GeneratorService;
import com.ustc.gen.util.DBPropertyUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenPanelItemService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenPanelItemDao genpanelitemDao;
    @Autowired
    private GeneratorService generatorService;
    @Autowired
    private GenFormService genFormService;
    @Autowired
    private GenFormPanelService genFormPanelService;

    public GenPanelItem findGenPanelItem(String id) {
        GenPanelItem entity = (GenPanelItem)this.genpanelitemDao.findById(id).get();
        return entity;
    }

    public List<GenPanelItem> findByItemIdIn(List<String> itemIds) {
        return this.genpanelitemDao.findByItemIdInAndIsUse(itemIds, "Y");
    }

    public void changeTitle(String id) {
        GenPanelItem entity = (GenPanelItem)this.genpanelitemDao.findById(id).get();
        if ("Y".equals(entity.getIsTitle())) {
            entity.setIsTitle("N");
        } else {
            entity.setIsTitle("Y");
        }
        this.genpanelitemDao.save(entity);
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void saveGenPanelItem(GenPanelItem entity) {
        if (entity.getItemId() == null && StringUtils.isEmpty((String)entity.getItemHtmlid())) {
            entity.setItemHtmlid(entity.getItemHtmlname());
        }
        entity.setModifyTime(new Date());
        this.genpanelitemDao.save(entity);
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void saveGenPanelItem(List<GenPanelItem> entities) {
        this.genpanelitemDao.saveAll(entities);
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void copyGenPanelItem(String panelId, String copyFields) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (StringUtils.isNotBlank((String)copyFields)) {
            for (String id : copyFields.split(",")) {
                GenPanelItem item = this.findGenPanelItem(id);
                GenPanelItem newitem = (GenPanelItem)BeanUtils.cloneBean((Object)item);
                newitem.setPanelId(panelId);
                newitem.setItemId(null);
                this.genpanelitemDao.save(newitem);
            }
        }
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void delGenPanelItem(String id) {
        this.genpanelitemDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from GEN_PANEL_ITEM t  order by t.ITEM_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from GEN_PANEL_ITEM t where   upper(t.DISPLAY_NO) like ?1  or upper(t.ITEM_ID) like ?1  or upper(t.PANEL_ID) like ?1  or upper(t.ITEM_HTMLID) like ?1  or upper(t.ITEM_LABEL) like ?1  or upper(t.ITEM_TYPE) like ?1  or upper(t.SINGLEROW) like ?1  or upper(t.HIDDEN) like ?1  or upper(t.ITEM_UNIT) like ?1  or upper(t.ITEM_LENGTH) like ?1  or upper(t.ITEM_DECIMAL) like ?1  or upper(t.DATAOPTIONS) like ?1  or upper(t.HTML_ATTR) like ?1  or upper(t.NULLABLE) like ?1  or upper(t.EDITABLE) like ?1  or upper(t.ENABLE) like ?1  or upper(t.IS_USE) like ?1  order by t.ITEM_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("ITEM_TYPE", "ITEM_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject pageGenPanelItemWithFormCode(String search, int page, int rows, String sort, String order, String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)formCode)) {
            params.put("formCode", formCode);
        }
        return this.bSqlHelper.serachPage("gen.GenPanelItem.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List PageAllByPanelID(String panelid, String groupId) {
        Object[] params = null;
        String sql = "select t.*,y.item_Name  ITEM_TYPE_TEXT_ from GEN_PANEL_ITEM t left join gen_panle_item_type y on y.id=t.ITEM_TYPE where t.PANEL_ID=?1 and t.is_use='Y'";
        if (StringUtils.isNotBlank((String)groupId)) {
            sql = sql + " and t.group_id=?2 \n";
            params = new Object[]{panelid, groupId};
        } else {
            params = new Object[]{panelid};
        }
        sql = sql + " order by t.DISPLAY_NO,ITEM_ID";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        HashMap dicmapper = new HashMap();
        return list;
    }

    public void genbyTable(String tablename, String panelid) {
        DBTable table = this.generatorService.buildTable(tablename);
        this.genPanelItemByTable(table, panelid);
    }

    public void genPanelItemByTable(DBTable table, String panelid) {
        List<GenPanelItem> items = this.genpanelitemDao.findByPanelIdAndIsUseOrderByDisplayNo(panelid, "Y");
        for (GenPanelItem item : items) {
            item.setIsUse("N");
        }
        this.genpanelitemDao.saveAll(items);
        Long i = 1L;
        List<String> noList = Arrays.asList("isUse", "modifyAccount");
        List<String> hiddenList = Arrays.asList("workflowStatus", "modifyTime", "processinstid", "id", "createAccount", "createTime", table.getPkHump());
        for (DBColumn column : table.getColumns()) {
            if (noList.contains(column.getFieldName())) continue;
            GenPanelItem entity = new GenPanelItem();
            entity.setPanelId(panelid);
            entity.setItemHtmlid(column.getFieldName());
            entity.setItemHtmlname(column.getFieldName());
            entity.setItemLength(Long.parseLong(column.getDataLength()));
            entity.setItemLabel(column.getFieldTitle());
            entity.setIsUse("Y");
            entity.setHidden(0L);
            entity.setSinglerow(0L);
            entity.setRequired(0L);
            entity.setEditable(1L);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            entity.setDisplayNo(l);
            entity.setModifyTime(new Date());
            entity.setEditableAct("Act_1");
            if (!StringUtils.isEmpty((String)column.getFieldDic())) {
                entity.setItemType("6");
                entity.setDicCode(column.getFieldDic());
                entity.setEditable(0L);
            } else if (hiddenList.contains(column.getFieldName())) {
                entity.setHidden(1L);
                entity.setItemType("1");
            } else if ("Date".equals(column.getFieldType())) {
                entity.setEditable(0L);
                entity.setItemType("4");
            } else if ("Long".equals(column.getFieldType())) {
                entity.setItemType("3");
            } else if ("String".equals(column.getFieldType())) {
                if (Long.parseLong(column.getDataLength()) > 200L) {
                    entity.setSinglerow(1L);
                    entity.setItemType("9");
                } else {
                    entity.setItemType("1");
                }
            } else if ("Double".equals(column.getFieldType())) {
                entity.setItemType("3");
                entity.setItemDecimal(Long.parseLong(column.getScale()));
            } else if ("Integer".equals(column.getFieldType())) {
                entity.setItemType("3");
                entity.setItemDecimal(Long.parseLong(column.getScale()));
            } else if ("BigDecimal".equals(column.getFieldType())) {
                entity.setItemType("3");
                entity.setItemDecimal(Long.parseLong(column.getScale()));
            }
            this.saveGenPanelItem(entity);
        }
    }

    public List<GenPanelItem> findByPanelId(String panelid, String settingId, String actId, String isPishiForm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("panelid", panelid);
        params.put("settingId", settingId);
        params.put("actId", actId);
        StringBuffer sql = new StringBuffer();
        sql.append("select t.* \n  from GEN_PANEL_ITEM t \n  LEFT JOIN GEN_ACT_ITEM A \n    ON A.ACT_ID =:actId \n   and a.setting_id =:settingId \n   and t.item_id = a.item_id \tand a.is_use = 'Y' \n");
        if ("Y".equals(isPishiForm)) {
            sql.append(" and a.PANEL_TYPE='10' \n");
        } else {
            sql.append(" and (a.PANEL_TYPE='0' or a.PANEL_TYPE is null) \n");
        }
        sql.append(" where t.panel_id =:panelid \n   and t.is_use = 'Y' \n order by ifnull(a.display_no, t.display_no)");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), params, GenPanelItem.class, new int[0]);
    }
}

