/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LayuiPageObject;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.BasDeptService;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasSysCodeService;
import com.ustc.base.service.CommonService;
import com.ustc.doc.dao.DocFileTypeDao;
import com.ustc.doc.entity.DocFileType;
import com.ustc.doc.entity.DocFileVersion;
import com.ustc.doc.entity.DocFormFile;
import com.ustc.doc.service.DocFileTypeService;
import com.ustc.doc.service.DocFileVersionService;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.common.BuildFile;
import com.ustc.gen.common.BuildForm;
import com.ustc.gen.common.BuildGroup;
import com.ustc.gen.common.BuildItem;
import com.ustc.gen.common.BuildPanel;
import com.ustc.gen.common.BuildType;
import com.ustc.gen.dao.GenFormDao;
import com.ustc.gen.dao.GenPanelFileDao;
import com.ustc.gen.dao.GenPanelItemDao;
import com.ustc.gen.entity.DBTable;
import com.ustc.gen.entity.GenAppFile;
import com.ustc.gen.entity.GenAppForm;
import com.ustc.gen.entity.GenAppItem;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.entity.GenFormFlow;
import com.ustc.gen.entity.GenFormPanel;
import com.ustc.gen.entity.GenPanelFile;
import com.ustc.gen.entity.GenPanelGroup;
import com.ustc.gen.entity.GenPanelItem;
import com.ustc.gen.entity.GenPanleItemType;
import com.ustc.gen.service.GenFormFlowService;
import com.ustc.gen.service.GenFormPanelService;
import com.ustc.gen.service.GenPanelGroupService;
import com.ustc.gen.service.GenPanelItemService;
import com.ustc.gen.service.GenPanleItemTypeService;
import com.ustc.gen.util.FreeMarkerUtil;
import com.ustc.pub.service.PubContactOrgService;
import com.ustc.sys.util.BeanCompareUtils;
import com.ustc.sys.util.ListUtils;
import com.ustc.workflow.service.FlowUtilService;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Transactional
public class GenFormService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenFormPanelService formPanelService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFileVersionService docFileVersionService;
    @Autowired
    private GenPanelItemDao panelItemDao;
    @Autowired
    private GenFormDao genformDao;
    @Autowired
    private GenFormService genFormService;
    @Autowired
    private GenPanelItemService genpanelitemService;
    @Autowired
    private GenPanleItemTypeService genpanleitemTypeService;
    @Autowired
    private GenPanelItemDao genpanelitemDao;
    @Autowired
    private BasSysCodeService basSysCodeService;
    @Autowired
    private DocFileTypeDao docfiletypeDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private PubContactOrgService pubContactOrgService;
    @Autowired
    private GenPanelFileDao genpanelfileDao;
    @Autowired
    private DocFileTypeService docfiletypeService;
    @Autowired
    private GenFormFlowService genFormFlowService;
    @Autowired
    private GenPanelGroupService genpanelgroupService;
    @Value(value="${formBorder:yes}")
    private String formBorder;

    public GenForm findGenFormByCode(String formcode) {
        List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(formcode, "Y");
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public StringBuilder findGenFormByCodes(String formcodes) {
        StringBuilder formName = new StringBuilder();
        String[] formcode = formcodes.split(",");
        for (int i = 0; i < formcode.length; ++i) {
            List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(formcode[i], "Y");
            if (list == null || list.size() <= 0) continue;
            if (formName.length() > 0) {
                formName.append(",");
            }
            formName.append(list.get(0).getFormName());
        }
        return formName;
    }

    public GenForm findByFlowCode(String flowCode) {
        List<GenForm> list = this.genformDao.findByFlowCodeAndIsUse(flowCode, "Y");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public GenForm findGenForm(String id) {
        GenForm entity = (GenForm)this.genformDao.findById(id).get();
        return entity;
    }

    public void saveGenForm(GenForm entity) {
        this.genformDao.save(entity);
    }

    public void delGenForm(String id) {
        this.genformDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.*,\n       a.catalog_name,\n         case when b.design_name   is null then null else CONCAT( b.design_name , '(' , b.flow_name , ')') end flow_name\n  from GEN_FORM t\n  left join doc_catalog a\n    on t.catalog_id = a.catalog_id\n  left join stf_business_process b\n    on t.flow_code = b.design_name\n");
        sql.append(" WHERE T.IS_USE = 'Y' ");
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and (upper(t.ID) like :search  or upper(t.FORM_CODE) like :search  or upper(t.FORM_NAME) like :search  or upper(t.FLOW_CODE) like :search  or upper(t.FORM_URL) like :search  or upper(t.LOADDATA_URL) like :search  or upper(t.BUSI_TABLE) like :search or upper(t.MEMO) like :search ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append("  order by t.id");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("FORM_TYPE", "FORM_TYPE");
        dicmapper.put("FORM_STYLE", "FORM_STYLE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllFlow(String search, int page, int rows, String orgId) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.design_name, concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')text,GETORGNAME(t.APPLY_ORGS) org_name,concat( t.design_name,'(',t.flow_name,')')flow_name  from STF_BUSINESS_PROCESS t,Stf_Business_Type y where y.res_id=t.business_type_id ");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            sql.append("and ( t.APPLY_ORGS is null or concat(',',t.APPLY_ORGS,',') like concat('%,',:orgId,',%'))");
            params.put("orgId", orgId);
        }
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and (upper(t.design_name) like :search  or upper(concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')) like :search  or upper(GETORGNAME(t.APPLY_ORGS) like :search )) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.design_name");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public List allFlow(String type, String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "select t.design_name, concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')text,GETORGNAME(t.APPLY_ORGS) org_name,concat( t.design_name,'(',t.flow_name,')')flow_name  from STF_BUSINESS_PROCESS t,Stf_Business_Type y where y.res_id=t.business_type_id ";
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            sql = sql + "and ( t.APPLY_ORGS is null or concat(',',t.APPLY_ORGS,',') like concat('%,',:orgId,',%'))";
            params.put("orgId", orgId);
        }
        sql = sql + " order by t.design_name";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return list;
    }

    public JsonMsg checkRepeat(GenForm entity) {
        JsonMsg msg = new JsonMsg();
        List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(entity.getFormCode(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getId().equals(entity.getId())) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public GenAppForm buildAppForm(String formcode, String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GenAppForm appform = new GenAppForm();
        GenForm form = this.findGenFormByCode(formcode);
        if (form != null) {
            LoginUser user = (LoginUser)request.getSession().getAttribute("LOGIN_USER");
            HashMap<String, LoginUser> freemarkmap = new HashMap<String, LoginUser>();
            freemarkmap.put("loginuser", user);
            appform.setAppDetailUrl(form.getAppDetailUrl());
            appform.setCatalogid(form.getCatalogId());
            appform.setFormId(form.getId());
            appform.setFormName(form.getFormName());
            List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
            appform.setActionUrl(form.getSubmitUrl());
            for (GenFormPanel panel : panellist) {
                if (panel.getPanelType().equals(BuildType.PANEL_FORM) || panel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                    JSONObject data;
                    List<GenPanelGroup> grouplist = this.genpanelgroupService.findByPanelId(panel.getPanelId());
                    ArrayList<BuildGroup> glist = new ArrayList<BuildGroup>();
                    if (grouplist.isEmpty()) {
                        BuildGroup g = new BuildGroup();
                        g.setGroupId("panel" + panel.getPanelId());
                        g.setGroupTitle(panel.getPanelTitle());
                        glist.add(g);
                    } else {
                        for (GenPanelGroup group : grouplist) {
                            BuildGroup g = new BuildGroup();
                            g.setGroupId(group.getGroupId());
                            g.setGroupTitle(group.getGroupTitle());
                            glist.add(g);
                        }
                    }
                    appform.setGroups(glist);
                    String loadurl = "";
                    if (!StrKit.notBlank(form.getLoaddataUrl())) continue;
                    String paras = "formcode=" + formcode + "&id=" + id;
                    Map<String, Object> flowInfo = new HashMap<String, Object>();
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&" + paras : form.getLoaddataUrl() + "?" + paras;
                        Object objectdata = SysUtils.sendHttp(request, response, loadurl);
                        data = (JSONObject)objectdata;
                    } else {
                        data = new JSONObject();
                    }
                    Long orgId = SysUtils.getLoginUser().getOrgid();
                    if (StringUtils.isNotBlank((CharSequence)id) && data.getLong("processinstid") != null) {
                        ProcessInstance process = this.flowUtilService.getProcInstService().findProcessById(data.getLong("processinstid").longValue());
                        orgId = this.basEmpAccountService.findById(Long.parseLong(process.getCreator())).getOrgId();
                    }
                    GenFormFlow gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
                    String flowCode = form.getFlowCode();
                    if (gflow != null) {
                        flowCode = gflow.getFlowCode();
                    }
                    if (StringUtils.isNotBlank((CharSequence)id) && data.getLong("processinstid") != null) {
                        flowInfo = this.flowUtilService.getFlowInfo(data.getLong("processinstid"));
                    } else if (StringUtils.isNotBlank((CharSequence)flowCode)) {
                        flowInfo.put("actId", this.flowUtilService.getFirstAct(flowCode));
                    } else {
                        flowInfo.put("actId", "Act_1");
                    }
                    appform.setFlowInfo(flowInfo);
                    List<GenPanelItem> itemlist = this.genpanelitemDao.findByPanelIdAndIsUseAndAppShowOrderByDisplayNo(panel.getPanelId(), "Y", 1L);
                    for (GenPanelItem panelitem : itemlist) {
                        GenAppItem item = new GenAppItem();
                        item.setType(panelitem.getItemType());
                        item.setLabel(panelitem.getItemLabel());
                        if (StringUtils.isNotBlank((CharSequence)panelitem.getItemUnit())) {
                            item.setLabel(panelitem.getItemLabel() + "(" + panelitem.getItemUnit() + ")");
                        }
                        item.setHidden(1L == panelitem.getHidden());
                        item.setUnit(panelitem.getItemUnit());
                        item.setGroupId(StringUtils.isBlank((CharSequence)panelitem.getGroupId()) ? "panel" + panel.getPanelId() : panelitem.getGroupId());
                        item.setName(panelitem.getItemHtmlname());
                        item.setLength(panelitem.getItemLength());
                        item.setDecimal(panelitem.getItemDecimal());
                        item.setAppOptions(panelitem.getAppoptions());
                        if (BuildType.ITEM_DICBOX.equals(panelitem.getItemType())) {
                            item.setUrl("/dic/dic?typeCode=" + panelitem.getDicCode());
                        } else {
                            item.setUrl(panelitem.getComboUrl());
                        }
                        if (BuildType.ITEM_OTHERRADIOBOX.equals(panelitem.getItemType())) {
                            item.setType(BuildType.ITEM_DICRADIOBOX);
                        }
                        if (BuildType.ITEM_OTHERCHECKBOX.equals(panelitem.getItemType())) {
                            item.setType(BuildType.ITEM_DICCHECKBOX);
                        }
                        if (StringUtils.isBlank((CharSequence)id)) {
                            item.setValue(FreeMarkerUtil.instance().genString(panelitem.getDefaultValue(), freemarkmap));
                            if (StringUtils.isNotBlank((CharSequence)item.getValue())) {
                                data.put(panelitem.getItemHtmlname(), (Object)item.getValue());
                            }
                        }
                        if (data != null && data.containsKey((Object)panelitem.getItemHtmlname())) {
                            DocFileVersion version;
                            String detailId;
                            JSONArray array;
                            Object combodata;
                            String combourl;
                            item.setHiddenValue(data.getString(panelitem.getItemHtmlname()));
                            if (BuildType.ITEM_MONEYBOX.equals(panelitem.getItemType())) {
                                item.setValue(data.getString(panelitem.getItemHtmlname()));
                            } else {
                                item.setValue(data.getString(panelitem.getItemHtmlname()));
                            }
                            if (panelitem.getItemType().equals("6") || StringUtils.isNotBlank((CharSequence)panelitem.getDicCode()) && (BuildType.ITEM_DICRADIOBOX.equals(panelitem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(panelitem.getItemType())) || BuildType.ITEM_OTHERRADIOBOX.equals(panelitem.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(panelitem.getItemType())) {
                                item.setType("6");
                                String value = this.commonService.getDicText(panelitem.getDicCode(), item.getValue());
                                item.setValue(value);
                            } else if (panelitem.getItemType().equals("2") || BuildType.ITEM_DICRADIOBOX.equals(panelitem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(panelitem.getItemType())) {
                                item.setType("2");
                                combourl = panelitem.getComboUrl().indexOf("?") > 0 ? panelitem.getComboUrl() + "&" + paras + "&detailId=" + item.getValue() : panelitem.getComboUrl() + "?" + paras + "&detailId=" + (item.getValue() == null ? "" : item.getValue());
                                combodata = SysUtils.sendHttp(request, response, combourl);
                                array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                                String combtext = "";
                                for (int i = 0; i < array.size(); ++i) {
                                    JSONObject jsonObject = array.getJSONObject(i);
                                    if (!("," + item.getHiddenValue() + ",").contains("," + jsonObject.getString("value") + ",")) continue;
                                    combtext = combtext + (StringUtils.isBlank((CharSequence)combtext) ? "" : ",") + jsonObject.getString("text");
                                }
                                if (StringUtils.isNotBlank((CharSequence)combtext)) {
                                    item.setValue(combtext);
                                }
                            } else if (BuildType.ITEM_COMBOTREE.equals(panelitem.getItemType())) {
                                combourl = panelitem.getComboUrl().indexOf("?") > 0 ? panelitem.getComboUrl() + "&" + paras : panelitem.getComboUrl() + "?" + paras;
                                combodata = SysUtils.sendHttp(request, response, combourl = combourl + "&detailId=" + item.getHiddenValue());
                                if (combodata != null && (array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata))).size() > 0) {
                                    item.setValue(array.getJSONObject(0).getString("text"));
                                }
                            } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(panelitem.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(panelitem.getItemType()) || BuildType.ITEM_HREMPCHOOSEBOX.equals(panelitem.getItemType()) || BuildType.ITEM_DEPTCHOOSEBOX.equals(panelitem.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(panelitem.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(panelitem.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(panelitem.getItemType())) {
                                if (StringUtils.isNotBlank((CharSequence)item.getValue())) {
                                    String contactOrgName;
                                    if (BuildType.ITEM_DEPTCHOOSEBOX.equals(panelitem.getItemType())) {
                                        item.setValue(this.basDeptService.findByDeptId(Long.parseLong(item.getValue())).getDeptName());
                                    } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(panelitem.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(panelitem.getItemType())) {
                                        String accountName = this.basEmpAccountService.queryEmpAccountByIds(item.getValue());
                                        item.setValue(accountName);
                                    } else if (!BuildType.ITEM_PROCHOOSEBOX.equals(panelitem.getItemType()) && (BuildType.ITEM_CONORGCHOOSEBOX.equals(panelitem.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(panelitem.getItemType())) && (contactOrgName = this.pubContactOrgService.queryContactOrgNameByIds(item.getValue())) != null) {
                                        item.setValue(contactOrgName);
                                    }
                                }
                            } else if (BuildType.ITEM_CHOOSEBOX.equals(panelitem.getItemType()) && StringUtils.isNotBlank((CharSequence)Objects.toString(data.get((Object)panelitem.getItemHtmlname()), null))) {
                                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{panelitem.getFormCode(), panelitem.getDisplayField()})) {
                                    String dataurl;
                                    Object itemdata;
                                    GenForm itemform = this.findGenFormByCode(panelitem.getFormCode());
                                    String detailId2 = item.getHiddenValue();
                                    if (detailId2 != null && (itemdata = SysUtils.sendHttp(request, response, dataurl = itemform.getLoaddataUrl() + "?id=" + detailId2)) != null) {
                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                        map.put("item", itemdata);
                                        item.setValue(FreeMarkerUtil.instance().genString(panelitem.getDisplayField(), map));
                                    }
                                } else if (data.containsKey((Object)(panelitem.getItemHtmlname() + "_TEXT_"))) {
                                    item.setValue(data.getString(panelitem.getItemHtmlname() + "_TEXT_"));
                                }
                            } else if (BuildType.ITEM_CHOOSEFILEBOX.equals(panelitem.getItemType()) && StringUtils.isNotBlank((CharSequence)(detailId = item.getHiddenValue())) && (version = this.docFileVersionService.findBaseVersionByVersionid(Long.parseLong(detailId))) != null) {
                                item.setValue(version.getOriginalName());
                            }
                        } else {
                            if ("\u521b\u5efa\u4eba".equals(panelitem.getItemLabel()) || "createBy".equals(panelitem.getItemHtmlname())) {
                                item.setValue(user.getAccountName());
                                item.setHiddenValue(user.getAccountid().toString());
                            }
                            if ("\u521b\u5efa\u65f6\u95f4".equals(panelitem.getItemLabel()) || "createTime".equals(panelitem.getItemHtmlname())) {
                                item.setValue(DateUtils.getDate());
                                item.setHiddenValue(DateUtils.getDate());
                            }
                        }
                        List<String> uneditableTypes = Arrays.asList(BuildType.ITEM_GRADEBOX, BuildType.ITEM_SELECTCHOOSEBOX, BuildType.ITEM_COMBOTREE);
                        List<String> noeditableTypes = Arrays.asList(BuildType.ITEM_EMPORGCHOOSEBOX, BuildType.ITEM_CHOOSEBOX, BuildType.ITEM_COMBOBOX, BuildType.ITEM_DICBOX, BuildType.ITEM_DATETIMEBOX, BuildType.ITEM_DATEBOX, BuildType.ITEM_YEARBOX, BuildType.ITEM_MONTHBOX, BuildType.ITEM_EMPCHOOSEBOX, BuildType.ITEM_HREMPCHOOSEBOX, BuildType.ITEM_DEPTCHOOSEBOX, BuildType.ITEM_PROCHOOSEBOX, BuildType.ITEM_DICCHECKBOX);
                        if (StringUtils.isBlank((CharSequence)form.getFlowCode()) || (noeditableTypes.contains(panelitem.getItemType()) || panelitem.getEditable() == 1L) && StringUtils.isNotBlank((CharSequence)panelitem.getEditableAct()) && (StringUtils.isBlank((CharSequence)id) || !"Act_1".equals(panelitem.getEditableAct())) && !uneditableTypes.contains(panelitem.getItemType())) {
                            String[] acts = panelitem.getEditableAct().split(",");
                            List<String> actlist = Arrays.asList(acts);
                            if (StringUtils.isBlank((CharSequence)id) || actlist.contains(flowInfo.get("actId")) && !Objects.toString(data.get((Object)"workflowStatus"), "").contains("1")) {
                                if (panelitem.getDisable().intValue() == 1) {
                                    item.setEditable(false);
                                } else {
                                    item.setEditable(true);
                                }
                                item.setRequired(panelitem.getRequired().intValue() == 1);
                                if (BuildType.ITEM_DICBOX.equals(panelitem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(panelitem.getItemType()) || BuildType.ITEM_DICRADIOBOX.equals(panelitem.getItemType())) {
                                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{panelitem.getDicCode()})) {
                                        item.setUrl("/dic/dic?typeCode=" + panelitem.getDicCode());
                                    } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{panelitem.getComboUrl()})) {
                                        item.setUrl(panelitem.getComboUrl());
                                    }
                                } else {
                                    item.setUrl(panelitem.getComboUrl());
                                }
                                if (BuildType.ITEM_EMPCHOOSEBOX.equals(panelitem.getItemType()) && panelitem.getItemLength().intValue() >= 100) {
                                    item.setType(BuildType.ITEM_EMPCHOOSEBOX + ".1");
                                }
                            }
                        }
                        appform.AddItem(item);
                    }
                    List<GenPanelItem> hideItems = this.genpanelitemDao.findByPanelIdAndIsUseAndAppShowOrderByDisplayNo(panel.getPanelId(), "Y", 0L);
                    for (GenPanelItem panelitem : hideItems) {
                        GenAppItem item = new GenAppItem();
                        item.setType(panelitem.getItemType());
                        item.setLabel(panelitem.getItemLabel());
                        item.setName(panelitem.getItemHtmlname());
                        item.setHidden(true);
                        if (StringUtils.isBlank((CharSequence)id)) {
                            item.setValue(FreeMarkerUtil.instance().genString(panelitem.getDefaultValue(), freemarkmap));
                            if ("\u521b\u5efa\u4eba".equals(panelitem.getItemLabel()) || "createBy".equals(panelitem.getItemHtmlname())) {
                                item.setValue(user.getAccountid().toString());
                            }
                            if ("\u521b\u5efa\u65f6\u95f4".equals(panelitem.getItemLabel()) || "createTime".equals(panelitem.getItemHtmlname())) {
                                item.setValue(DateUtils.getDate());
                            }
                        } else {
                            item.setValue(data.getString(panelitem.getItemHtmlname()));
                        }
                        item.setHiddenValue(item.getValue());
                        appform.AddItem(item);
                    }
                    continue;
                }
                if (panel.getPanelType().equals(BuildType.PANEL_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_BILL)) {
                    List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                    if (!filelist.isEmpty()) {
                        appform.setFileTypeId(filelist.get(0).getFileTypeId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    for (GenPanelFile typefile : filelist) {
                        List<DocFormFile> files = this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), typefile.getFileTypeId(), id);
                        for (DocFormFile file : files) {
                            GenAppFile buildfile = new GenAppFile();
                            buildfile.setFileVersionId(file.getFileVersionId());
                            buildfile.setFileName(this.docFileVersionService.findBaseVersionByVersionid(file.getFileVersionId()).getOriginalName());
                            buildfile.setMemo(file.getMemo());
                            appform.AddFiles(buildfile);
                        }
                    }
                    continue;
                }
                appform.AddPanels(panel);
            }
        }
        return appform;
    }

    public BuildForm buildForm(GenForm form, String pkid, HttpServletRequest request, HttpServletResponse response, Object formdata, boolean editFile, String pageType, String isPishiForm) throws Exception {
        HttpSession session = request.getSession(false);
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        HashMap<String, LoginUser> freemarkmap = new HashMap<String, LoginUser>();
        freemarkmap.put("loginuser", user);
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setIsdetail(form.getIsdetail());
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setThemeId(form.getThemeId());
        buildform.setQueryString(form.getQueryString());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        buildform.setExtraJsUrl(form.getExtraJsUrl());
        Map<Long, GenPanleItemType> itemTypes = this.genpanleitemTypeService.findMapAll();
        if (form.getShowLogo() != null) {
            buildform.setShowLogo(form.getShowLogo() == 1L);
            buildform.setShowTitle(form.getShowTitle() == 1L);
            buildform.setShowCode(form.getShowCode() == 1L);
        } else {
            buildform.setShowLogo(false);
            buildform.setShowTitle(false);
            buildform.setShowCode(false);
        }
        buildform.setBizCode(form.getBizCode());
        if (StrKit.notBlank(buildform.getQueryString()) && buildform.getThemeId() != null) {
            buildform.setQueryString(buildform.getQueryString() + "&themeId=" + buildform.getThemeId());
        }
        buildform.setLoadformid(form.getLoadformid());
        buildform.setSubmiturl(form.getSubmitUrl());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        Map<Object, Object> flowInfo = new HashMap<String, String>();
        JSONObject json = (JSONObject)formdata;
        if (StrKit.notNull(buildform.getBizCode())) {
            buildform.setBizCodeText(json.getString(buildform.getBizCode()));
        }
        Long orgId = SysUtils.getLoginUser().getOrgid();
        if (pkid != null && json.getLong("processinstid") != null) {
            ProcessInstance process = this.flowUtilService.getProcInstService().findProcessById(json.getLong("processinstid").longValue());
            orgId = this.basEmpAccountService.findById(Long.parseLong(process.getCreator())).getOrgId();
        }
        GenFormFlow gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
        String flowCode = form.getFlowCode();
        if (gflow != null) {
            flowCode = gflow.getFlowCode();
        }
        if (pkid != null && json.getLong("processinstid") != null) {
            flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
        } else if (StringUtils.isNotBlank((CharSequence)flowCode)) {
            flowInfo.put("actId", this.flowUtilService.getFirstAct(flowCode));
        } else {
            flowInfo.put("actId", "Act_1");
        }
        HashMap<String, Map> actItemMap = new HashMap<String, Map>();
        if (flowInfo.get("actId") != null || StringUtils.isNotBlank((CharSequence)flowCode)) {
            List<Map<String, Object>> actItems = this.genFormFlowService.getFormItem(form.getId(), orgId, null, Objects.toString(flowInfo.get("actId"), StringUtils.isNotBlank((CharSequence)flowCode) ? this.flowUtilService.getFirstAct(flowCode) : ""), isPishiForm);
            for (Map map : actItems) {
                actItemMap.put(map.get("itemId").toString(), map);
            }
        }
        HashMap<String, BuildItem> itemReferPanel = new HashMap<String, BuildItem>();
        for (GenFormPanel genFormPanel : panellist) {
            DocFileType filetype;
            List<GenPanelFile> filelist;
            if (StrKit.notBlank(buildform.getExcludepanels()) && StrKit.notBlank(genFormPanel.getPanelHtmlid()) && ListUtils.stringToList(buildform.getExcludepanels()).contains(genFormPanel.getPanelHtmlid())) continue;
            if (Arrays.asList(BuildType.PANEL_TAB_FILE, BuildType.PANEL_TAB_FORM, BuildType.PANEL_TAB_CUSTOM, BuildType.PANEL_TAB_BILL, BuildType.PANEL_TAB_STAGE_FILE).contains(genFormPanel.getPanelType()) && !buildform.getGroupIds().containsKey(genFormPanel.getPanelGorupid())) {
                buildform.getGroupIds().put(genFormPanel.getPanelGorupid(), genFormPanel.getPanelGoruptitle());
            }
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setIsdetail(form.getIsdetail());
            buildpanel.setHideWhenEdit(genFormPanel.getHideWhenEdit() == null ? false : genFormPanel.getHideWhenEdit() == 1L);
            buildpanel.setPenelId(genFormPanel.getPanelId());
            buildpanel.setPaneltitle(genFormPanel.getPanelTitle());
            buildpanel.setPanelhtmlid(genFormPanel.getPanelHtmlid());
            buildpanel.setPanelgorupid(genFormPanel.getPanelGorupid());
            buildpanel.setPaneltype(genFormPanel.getPanelType());
            buildpanel.setColsize(genFormPanel.getFormColnum());
            buildpanel.setOrgItem(genFormPanel.getOrgItem());
            buildpanel.setLabelAlign(genFormPanel.getLabelAlign());
            if (StrKit.notBlank(genFormPanel.getPanelUrl())) {
                String panelurl = genFormPanel.getPanelUrl().indexOf("?") > 0 ? genFormPanel.getPanelUrl() + "&" + buildform.getQueryString() : genFormPanel.getPanelUrl() + "?" + buildform.getQueryString();
                buildpanel.setPanelurl(panelurl);
            }
            if (genFormPanel.getPanelType().equals(BuildType.PANEL_FORM) || genFormPanel.getPanelType().equals(BuildType.PANEL_FORM_PS) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                List<GenPanelGroup> grouplist = this.genpanelgroupService.findByPanelId(genFormPanel.getPanelId());
                ArrayList<BuildGroup> glist = new ArrayList<BuildGroup>();
                if (grouplist.isEmpty()) {
                    BuildGroup g = new BuildGroup();
                    g.setGroupId("panel" + genFormPanel.getPanelId());
                    g.setGroupTitle(genFormPanel.getPanelTitle());
                    glist.add(g);
                } else {
                    for (GenPanelGroup genPanelGroup : grouplist) {
                        BuildGroup g = new BuildGroup();
                        g.setGroupId(genPanelGroup.getGroupId());
                        g.setGroupTitle(genPanelGroup.getGroupTitle());
                        glist.add(g);
                    }
                }
                List<GenPanelItem> itemlist = this.genpanelitemService.findByPanelId(genFormPanel.getPanelId(), gflow != null ? gflow.getId() : "-9900999", Objects.toString(flowInfo.get("actId"), ""), isPishiForm);
                if ("track".equals(pageType)) {
                    itemlist = this.genpanelitemDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y");
                }
                for (GenPanelItem item : itemlist) {
                    String[] data;
                    String combourl;
                    Object detailId;
                    List<ComboxNode> list;
                    Object map;
                    if (StrKit.notBlank(buildform.getExcludeitems()) && StrKit.notBlank(item.getItemHtmlid()) && ListUtils.stringToList(buildform.getExcludeitems()).contains(item.getItemHtmlid())) continue;
                    GenPanleItemType type = itemTypes.get(Long.parseLong(item.getItemType()));
                    BuildItem builditem = new BuildItem();
                    builditem.setFtlname(type.getFtlName());
                    builditem.setButtonClickFun(type.getButtonClickFun());
                    builditem.setIsdetail(form.getIsdetail());
                    builditem.setId(item.getItemHtmlid());
                    builditem.setName(item.getItemHtmlname());
                    builditem.setLabel(item.getItemLabel());
                    builditem.setItemtype(item.getItemType());
                    builditem.setLength(item.getItemLength());
                    builditem.setDecimal(item.getItemDecimal());
                    builditem.setDicCode(item.getDicCode());
                    builditem.setComboUrl(FreeMarkerUtil.instance().genString(item.getComboUrl(), (Map)json));
                    builditem.setHidden(item.getHidden() == 1L);
                    builditem.setSinglerow(item.getSinglerow() == 1L);
                    builditem.setRequired(item.getRequired() == 1L);
                    builditem.setEditable(item.getEditable() == 1L);
                    builditem.setDisable(1L == item.getDisable());
                    builditem.setUnit(item.getItemUnit());
                    builditem.setDataoptions(item.getDataoptions());
                    builditem.setHtmlattr(item.getHtmlAttr());
                    builditem.setPrompt(item.getPrompt());
                    builditem.setDetailAsHref(1L == item.getDetailAsHref());
                    builditem.setClickFunc(item.getClickFunc());
                    builditem.setItemcol(item.getItemCol());
                    if (form.getIsdetail() && !form.getIsappro()) {
                        builditem.setIsdetail(true);
                        if (gflow != null) {
                            map = (Map)actItemMap.get(item.getItemId());
                            if (map != null) {
                                if (map.get("itemLabel") != null) {
                                    builditem.setLabel(map.get("itemLabel").toString());
                                }
                                builditem.setHidden("N".equals(map.get("isShow") + ""));
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode()) && !ListUtils.stringToList(item.getEditableAct()).contains(flowInfo.get("actId")) && ListUtils.stringToList(item.getHiddenAct()).contains(flowInfo.get("actId"))) {
                            builditem.setHidden(true);
                        }
                    } else if (gflow != null) {
                        map = (Map)actItemMap.get(item.getItemId());
                        if (map != null) {
                            if (map.get("itemLabel") != null) {
                                builditem.setLabel(map.get("itemLabel").toString());
                            }
                            builditem.setHidden("N".equals(map.get("isShow") + ""));
                            builditem.setEditable("Y".equals(map.get("isEditable") + ""));
                            builditem.setIsdetail(!"Y".equals(map.get("editableAct") + ""));
                            if (map.get("disable") != null && !"".equals(map.get("disable").toString())) {
                                builditem.setDisable("1".equals(map.get("disable").toString()));
                            }
                            if (map.get("singlerow") != null && !"".equals(map.get("singlerow").toString())) {
                                builditem.setSinglerow("1".equals(map.get("singlerow").toString()));
                            }
                            builditem.setRequired("Y".equals(map.get("isRequired") + ""));
                        } else {
                            builditem.setIsdetail(true);
                            builditem.setEditable(false);
                            builditem.setRequired(false);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode())) {
                        if (ListUtils.stringToList(item.getEditableAct()).contains(flowInfo.get("actId"))) {
                            builditem.setIsdetail(false);
                        } else {
                            if (ListUtils.stringToList(item.getHiddenAct()).contains(flowInfo.get("actId"))) {
                                builditem.setHidden(true);
                            }
                            builditem.setIsdetail(true);
                        }
                    }
                    builditem.setGroupId(item.getGroupId());
                    builditem.setGroupName("\u5206\u7ec4\u6807\u9898");
                    if (StringUtils.isEmpty((CharSequence)builditem.getGroupId())) {
                        builditem.setGroupId("panel" + genFormPanel.getPanelId());
                    }
                    for (BuildGroup g : glist) {
                        if (!g.getGroupId().equals(builditem.getGroupId())) continue;
                        g.addItem(builditem);
                    }
                    if (item.getReferPanel() != null && StringUtils.isNotBlank((CharSequence)item.getReferPanel())) {
                        itemReferPanel.put(item.getReferPanel(), builditem);
                        buildpanel.addItem(builditem);
                        continue;
                    }
                    if (StrKit.notNull(item.getDefaultValue())) {
                        builditem.setDefaultvalue(FreeMarkerUtil.instance().genString(item.getDefaultValue(), freemarkmap));
                    }
                    if (builditem.isIsdetail()) {
                        if (item.getItemType().equals(BuildType.ITEM_DICBOX)) {
                            list = this.commonService.getDicCombo(item.getDicCode());
                            builditem.setItemdata(list);
                        } else if (item.getItemType().equals(BuildType.ITEM_COMBOBOX) || item.getItemType().equals(BuildType.ITEM_COMBOTREE) || item.getItemType().equals(BuildType.ITEM_CASCADECOMBOBOX)) {
                            detailId = json.getString(item.getItemHtmlname());
                            if (detailId == null) {
                                detailId = "";
                            }
                            combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + buildform.getQueryString() + "&detailId=" + (String)detailId : item.getComboUrl() + "?" + buildform.getQueryString() + "&detailId=" + (String)detailId;
                            data = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl, (Map)json));
                            builditem.setItemdata(data);
                            builditem.setValue((String)detailId);
                        }
                    }
                    if (item.getItemType().equals(BuildType.ITEM_DICRADIOBOX) || item.getItemType().equals(BuildType.ITEM_DICCHECKBOX) || BuildType.ITEM_OTHERRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(item.getItemType())) {
                        if (StringUtils.isNotBlank((CharSequence)item.getDicCode())) {
                            list = this.commonService.getDicComboWithDefault(item.getDicCode());
                            builditem.setItemdata(list);
                        } else if (StringUtils.isNotBlank((CharSequence)item.getComboUrl())) {
                            detailId = json.getString(item.getItemHtmlname());
                            if (detailId == null) {
                                detailId = "";
                            }
                            combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + buildform.getQueryString() + "&detailId=" + (String)detailId : item.getComboUrl() + "?" + buildform.getQueryString() + "&detailId=" + (String)detailId;
                            data = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl, (Map)json));
                            builditem.setItemdata(data);
                        }
                    } else if (item.getItemType().equals(BuildType.ITEM_CHOOSEFILEBOX) && (detailId = json.getLong(item.getItemHtmlname())) != null) {
                        DocFileVersion version = this.docFileVersionService.findDocFileVersion((Long)detailId);
                        json.put(builditem.getName() + "fileName", (Object)version.getOriginalName());
                    }
                    if ((pkid == null || pkid != null && form.getLoadformid() != null) && StringUtils.isNotBlank((CharSequence)item.getGencode()) && item.getItemType().equals(BuildType.ITEM_TEXTBOX)) {
                        String gencode = this.basSysCodeService.genCode(item.getGencode(), form.getQueryString());
                        builditem.setDefaultvalue(gencode);
                    }
                    if ("empchoosebox".equals(type.getItemCode()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_HREMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType()) || BuildType.ITEM_DEPT_TEXTBOX.equals(item.getItemType())) {
                        if ("\u521b\u5efa\u4eba".equals(item.getItemLabel()) || "createBy".equals(item.getItemHtmlname())) {
                            builditem.setDataoptions("buttonText:''");
                        }
                        if (pkid != null || StringUtils.isNotBlank((CharSequence)builditem.getDefaultvalue())) {
                            String id = json.getString(item.getItemHtmlname());
                            if (pkid == null) {
                                id = builditem.getDefaultvalue();
                            }
                            if (StringUtils.isNotBlank((CharSequence)id)) {
                                if (BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType())) {
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)this.basDeptService.findByDeptId(Long.parseLong(id)).getDeptName());
                                } else if ("empchoosebox".equals(type.getItemCode()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType())) {
                                    String accountName = this.basEmpAccountService.queryEmpAccountByIds(id);
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)accountName);
                                } else if (BuildType.ITEM_HREMPCHOOSEBOX.equals(item.getItemType())) {
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)this.bSqlHelper.getStringValue("business.workflow.common.getHrStation", MapUtil.of((Object)"empId", (Object)Long.parseLong(id))));
                                } else if (!BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType())) {
                                    if (BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType())) {
                                        String contactOrgName = this.pubContactOrgService.queryContactOrgNameByIds(id);
                                        json.put(item.getItemHtmlname() + "_TEXT_", (Object)contactOrgName);
                                        if (StringUtils.isBlank((CharSequence)item.getClickFunc())) {
                                            for (String i : id.split(",")) {
                                                builditem.setClickFunc("formDetail(\"PubContactOrg_dw\"," + Long.valueOf(i) + ",\"\u3010" + this.pubContactOrgService.queryContactOrgNameByIds(i) + "\u3011\u8be6\u7ec6\u4fe1\u606f\")");
                                                builditem.setDetailAsHref(true);
                                            }
                                        }
                                    } else if (BuildType.ITEM_DEPT_TEXTBOX.equals(item.getItemType())) {
                                        String deptText = this.basDeptService.findDeptTextById(id);
                                        json.put(item.getItemHtmlname() + "_TEXT_", (Object)deptText);
                                    }
                                }
                            }
                        } else if ("\u521b\u5efa\u4eba".equals(item.getItemLabel()) || "createBy".equals(item.getItemHtmlname())) {
                            json.put(item.getItemHtmlname() + "_TEXT_", (Object)user.getAccountName());
                            json.put(item.getItemHtmlname(), (Object)user.getAccountid());
                        }
                    } else if (BuildType.ITEM_FLOWOPINIONBOX.equals(item.getItemType())) {
                        if (pkid != null) {
                            String editableacts = item.getEditableAct();
                            String actIds = "";
                            if (StringUtils.isNotBlank((CharSequence)editableacts)) {
                                for (String actId : editableacts.split(",")) {
                                    if (!StringUtils.isNotBlank((CharSequence)actId)) continue;
                                    List<Map<String, Object>> editactitems = this.genFormFlowService.getFormItem(form.getId(), orgId, item.getItemId(), actId, isPishiForm);
                                    if (!editactitems.isEmpty()) {
                                        if ("N".equals(String.valueOf(editactitems.get(0).get("isEditable"))) || "N".equals(String.valueOf(editactitems.get(0).get("isShow")))) continue;
                                        actIds = actIds + actId + ",";
                                        continue;
                                    }
                                    actIds = actIds + actId + ",";
                                }
                            }
                            if (actIds.length() > 0) {
                                actIds.substring(0, actIds.length() - 1);
                            }
                            if (gflow != null) {
                                String otheract;
                                String sql = "select group_concat(a.act_id)\n  from  gen_panel_item i,  gen_act_item a\n where a.item_id = i.item_id\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = '" + gflow.getId() + "'\n   and i.item_id = '" + item.getItemId() + "'\n   and (a.panel_type = '0' or a.panel_type is null) ";
                                if ("Y".equals(isPishiForm)) {
                                    sql = "select group_concat(a.act_id)\n  from  gen_panel_item i,  gen_act_item a\n where a.item_id = i.item_id\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = '" + gflow.getId() + "'\n   and i.item_id = '" + item.getItemId() + "'\n   and a.panel_type = '10' ";
                                }
                                if ((otheract = Objects.toString(this.sqlHelper.getSingal(sql), "")).length() > 0) {
                                    actIds = actIds + actIds + "," + otheract;
                                }
                            }
                            builditem.setAllowFile(Boolean.parseBoolean(Objects.toString(flowInfo.get("allowFile"), "false")));
                            builditem.setActDesc(Objects.toString(flowInfo.get("actDesc"), ""));
                            builditem.setOpinions(this.flowUtilService.queryFinishWorkItemByDefid(json.getLong("processinstid"), actIds));
                        }
                    } else if (BuildType.ITEM_CHOOSEBOX.equals(item.getItemType()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getFormCode(), item.getDisplayField()})) {
                        String dataurl;
                        Object data2;
                        GenForm itemform = this.findGenFormByCode(item.getFormCode());
                        String detailId2 = json.getString(item.getItemHtmlname());
                        if (pkid == null) {
                            detailId2 = builditem.getDefaultvalue();
                        }
                        if (StringUtils.isNotBlank((CharSequence)detailId2) && (data2 = SysUtils.sendHttp(request, response, dataurl = itemform.getLoaddataUrl() + "?id=" + detailId2)) != null) {
                            HashMap<String, Object> map2 = new HashMap<String, Object>();
                            map2.put("item", data2);
                            json.put(item.getItemHtmlname() + "_TEXT_", (Object)FreeMarkerUtil.instance().genString(item.getDisplayField(), map2));
                            builditem.setClickFunc("formDetail(\"" + item.getFormCode() + "\"," + detailId2 + ",\"\u3010" + json.getString(item.getItemHtmlname() + "_TEXT_") + "\u3011\u8be6\u7ec6\u4fe1\u606f\")");
                        }
                    }
                    if (pkid == null && ("\u521b\u5efa\u65f6\u95f4".equals(item.getItemLabel()) || "createTime".equals(item.getItemHtmlname()))) {
                        json.put(item.getItemHtmlname(), (Object)DateUtils.getDate());
                    }
                    if (StringUtils.isNotBlank((CharSequence)buildpanel.getOrgItem()) && builditem.getId().equals(buildpanel.getOrgItem())) {
                        String combourl2 = genFormPanel.getOrgCombourl();
                        Object combodata = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl2, (Map)json));
                        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                        for (int i = 0; i < array.size(); ++i) {
                            JSONObject jsonObject = array.getJSONObject(i);
                            if (!jsonObject.getString("value").equals(builditem.getValue())) continue;
                            buildpanel.setOrgText(jsonObject.getString("text"));
                            break;
                        }
                    }
                    buildpanel.addItem(builditem);
                }
                buildpanel.setGroups(glist);
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_FILE) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) {
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    List dealActIds;
                    BuildFile buildFile = new BuildFile();
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    if (editFile) {
                        buildFile.setEditable(true);
                    } else if (flowInfo.get("actId") != null) {
                        if (gflow != null) {
                            Map<String, Object> map = this.genFormFlowService.getFormFile(form.getId(), orgId, file.getFileTypeId(), Objects.toString(flowInfo.get("actId"), ""));
                            if (map != null) {
                                if (map.get("isShow") == null || !"Y".equals(map.get("isShow").toString())) continue;
                                buildFile.setEditable("Y".equals(map.get("isEditable").toString() + ""));
                                buildFile.setRequired("Y".equals(map.get("isRequired").toString() + ""));
                                buildFile.setShowLocal("Y".equals(map.get("showLocal").toString() + ""));
                                buildFile.setShowVisual("Y".equals(map.get("showVisual").toString() + ""));
                                buildFile.setShowScan("Y".equals(map.get("showScan").toString() + ""));
                            } else {
                                buildFile.setEditable(false);
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode())) {
                            if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && ("," + file.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                            if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                                boolean hide = true;
                                dealActIds = (List)flowInfo.get("dealActIds");
                                for (String dealActId : dealActIds) {
                                    if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                                    hide = false;
                                    break;
                                }
                                if (hide) continue;
                            }
                            if (StringUtils.isNotBlank((CharSequence)file.getEditableAct())) {
                                String[] acts = file.getEditableAct().split(",");
                                List<String> actlist = Arrays.asList(acts);
                                if (actlist.contains(flowInfo.get("actId"))) {
                                    buildFile.setEditable(true);
                                } else {
                                    buildFile.setEditable(false);
                                }
                            } else {
                                buildFile.setEditable(false);
                            }
                            buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                            buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                            buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                            buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode()) && StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                        boolean hide = true;
                        dealActIds = (List)flowInfo.get("dealActIds");
                        for (String dealActId : dealActIds) {
                            if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                            hide = false;
                            break;
                        }
                        if (hide) continue;
                    }
                    buildFile.setFileNature(filetype.getFileNature());
                    buildFile.setFilterFunction(file.getFilterFunction());
                    buildFile.setFileTypeId(file.getFileTypeId());
                    buildFile.setFileTypeName(file.getFileTypeName());
                    buildFile.setCatalogid(file.getCatalogId());
                    if (pkid != null) {
                        buildFile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildFile);
                }
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_BILL) || genFormPanel.getPanelType().equals(BuildType.PANEL_BILL)) {
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    BuildFile buildFile = new BuildFile();
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildFile.setFileNature(filetype.getFileNature());
                    buildFile.setFilterFunction(file.getFilterFunction());
                    buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildFile.setFileTypeId(file.getFileTypeId());
                    buildFile.setFileTypeName(file.getFileTypeName());
                    buildFile.setCatalogid(file.getCatalogId());
                    if (pkid != null) {
                        buildFile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildFile);
                }
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_CUSTOM) || genFormPanel.getPanelType().equals(BuildType.PANEL_CUSTOM)) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                String content = SysUtils.GetHttpContent(request, FreeMarkerUtil.instance().genString(buildpanel.getPanelurl(), (Map)json));
                buildpanel.setContent(content);
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE)) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
            }
            if (itemReferPanel.containsKey(genFormPanel.getPanelId())) {
                ((BuildItem)itemReferPanel.get(genFormPanel.getPanelId())).setPanel(buildpanel);
                continue;
            }
            buildform.getPanels().add(buildpanel);
        }
        for (String string : itemReferPanel.keySet()) {
            if (((BuildItem)itemReferPanel.get(string)).getPanel() != null) continue;
            for (BuildPanel panel : buildform.getPanels()) {
                for (BuildGroup group : panel.getGroups()) {
                    if (!group.getShowitems().contains(itemReferPanel.get(string))) continue;
                    group.getShowitems().remove(itemReferPanel.get(string));
                }
                if (!panel.getShowitems().contains(itemReferPanel.get(string))) continue;
                panel.getShowitems().remove(itemReferPanel.get(string));
            }
        }
        buildform.getPanels().forEach(a -> a.getGroups().forEach(b -> System.out.println(b.getGroupTitle())));
        return buildform;
    }

    public BuildForm buildFilePanel(GenForm form, String panelHtmlID, String pkid, String filepkids, Object formdata, Boolean editFile) throws Exception {
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setQueryString(form.getQueryString());
        buildform.setLoadformid(form.getLoadformid());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        Map<String, Object> flowInfo = new HashMap<String, String>();
        JSONObject json = (JSONObject)formdata;
        if (pkid != null) {
            flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
        }
        if (flowInfo.isEmpty()) {
            flowInfo.put("actId", "Act_1");
        }
        for (GenFormPanel panel : panellist) {
            DocFileType filetype;
            BuildFile buildfile;
            List<GenPanelFile> filelist;
            if (!panel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE) && (!StrKit.notBlank(panel.getPanelHtmlid()) || !panel.getPanelHtmlid().equals(panelHtmlID))) continue;
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setPaneltitle(panel.getPanelTitle());
            buildpanel.setPenelId(panel.getPanelId());
            buildpanel.setPanelhtmlid(panel.getPanelHtmlid());
            buildpanel.setPanelgorupid(panel.getPanelGorupid());
            buildpanel.setPaneltype(panel.getPanelType());
            buildpanel.setPanelurl(panel.getPanelUrl());
            if (StrKit.notBlank(panel.getPanelUrl())) {
                String panelurl = panel.getPanelUrl().indexOf("?") > 0 ? panel.getPanelUrl() + "&" + buildform.getQueryString() : panel.getPanelUrl() + "?" + buildform.getQueryString();
                buildpanel.setPanelurl(panelurl);
            }
            buildpanel.setColsize(panel.getFormColnum());
            buildpanel.setOrgItem(panel.getOrgItem());
            buildpanel.setLabelAlign(panel.getLabelAlign());
            if (panel.getPanelType().equals(BuildType.PANEL_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) {
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    buildfile = new BuildFile();
                    buildfile.setFileTypeId(file.getFileTypeId());
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildfile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildfile.setFileNature(filetype.getFileNature());
                    buildfile.setFilterFunction(file.getFilterFunction());
                    buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildfile.setFileTypeName(file.getFileTypeName());
                    buildfile.setCatalogid(file.getCatalogId());
                    buildfile.setEditable(editFile);
                    if (StrKit.notBlank(filepkids)) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), ListUtils.stringToList(filepkids)));
                    } else if (pkid != null) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildfile);
                }
            }
            if (panel.getPanelType().equals(BuildType.PANEL_TAB_BILL)) {
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    buildfile = new BuildFile();
                    buildfile.setFileTypeId(file.getFileTypeId());
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildfile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildfile.setFileNature(filetype.getFileNature());
                    buildfile.setFilterFunction(file.getFilterFunction());
                    buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildfile.setFileTypeName(file.getFileTypeName());
                    buildfile.setCatalogid(file.getCatalogId());
                    if (StrKit.notBlank(filepkids)) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), ListUtils.stringToList(filepkids)));
                    } else if (pkid != null) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildfile);
                }
            } else if ((panel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE)) && (form.getIsappro() || editFile.booleanValue())) {
                buildpanel.setIsdetail(false);
            }
            buildform.getPanels().add(buildpanel);
            break;
        }
        buildform.getPanels().forEach(a -> a.getGroups().forEach(b -> System.out.println(b.getGroupTitle())));
        return buildform;
    }

    public BuildForm buildBizEditFilePanel(GenForm form, String pkid, Boolean isArchive) throws Exception {
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setQueryString(form.getQueryString());
        buildform.setLoadformid(form.getLoadformid());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        for (GenFormPanel panel : panellist) {
            if (!panel.getPanelType().equals(BuildType.PANEL_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) continue;
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setPaneltitle(panel.getPanelTitle());
            buildpanel.setPenelId(panel.getPanelId());
            buildpanel.setPanelhtmlid(panel.getPanelHtmlid());
            buildpanel.setPanelgorupid(panel.getPanelGorupid());
            buildpanel.setPaneltype(BuildType.PANEL_FILE);
            buildpanel.setPanelurl(panel.getPanelUrl());
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
            for (GenPanelFile file : filelist) {
                BuildFile buildfile = new BuildFile();
                DocFileType filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                buildfile.setFileNature(filetype.getFileNature());
                buildfile.setFilterFunction(file.getFilterFunction());
                buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                buildfile.setFileTypeId(file.getFileTypeId());
                buildfile.setFileTypeName(file.getFileTypeName());
                buildfile.setCatalogid(file.getCatalogId());
                if (pkid != null) {
                    buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), Arrays.asList(pkid), isArchive));
                }
                buildpanel.addFile(buildfile);
            }
            buildform.getPanels().add(buildpanel);
        }
        return buildform;
    }

    public boolean isFileChange(String aformcode, String apkid, String formcode, String pkid) {
        List<DocFormFile> afileList = this.docFormFileService.findByFormCodeAndPrimaryKey(aformcode, apkid);
        return this.isFileChange(afileList, formcode, pkid);
    }

    public boolean isFileChange(List<DocFormFile> afileList, String formcode, String pkid) {
        List<DocFormFile> fileList = this.docFormFileService.findByFormCodeAndPrimaryKey(formcode, pkid);
        if (afileList == null || afileList.isEmpty()) {
            return !fileList.isEmpty();
        }
        if (afileList.size() != fileList.size()) {
            return true;
        }
        String[] fileCompareField = new String[]{"fileNo", "fileName"};
        for (DocFormFile afile : afileList) {
            DocFormFile file = this.docFormFileService.findByFormIdAndPrimaryKeyAndFileVersionId(formcode, pkid, afile.getFileVersionId());
            if (file == null) {
                return true;
            }
            if (!BeanCompareUtils.isFieldChange(fileCompareField, (Object)afile, (Object)file)) continue;
            return true;
        }
        return false;
    }

    public List<ComboxNode> flowActComb(String panelId) {
        ArrayList<ComboxNode> comlist = new ArrayList<ComboxNode>();
        GenForm form = this.formPanelService.findGenFormByPanelId(panelId);
        if (form == null || form.getFlowCode() == null) {
            return comlist;
        }
        List<Map<String, Object>> list = this.flowUtilService.getFlowActList(form.getFlowCode());
        for (Map<String, Object> map : list) {
            ComboxNode node = new ComboxNode();
            node.setValue(Objects.toString(map.get("ACTIVITYDEFID"), ""));
            node.setText(Objects.toString(map.get("ACTNAME"), "") + "(" + Objects.toString(map.get("ACTIVITYDEFID"), "") + ")");
            comlist.add(node);
        }
        return comlist;
    }

    public List<ComboxNode> queryFlowActComb(String formId) {
        ArrayList<ComboxNode> comlist = new ArrayList<ComboxNode>();
        GenForm form = this.genFormService.findGenForm(formId);
        if (form == null || form.getFlowCode() == null) {
            return comlist;
        }
        List<Map<String, Object>> list = this.flowUtilService.getFlowActList(form.getFlowCode());
        for (Map<String, Object> map : list) {
            ComboxNode node = new ComboxNode();
            node.setValue(Objects.toString(map.get("ACTIVITYDEFID"), ""));
            node.setText(Objects.toString(map.get("ACTNAME"), "") + "(" + Objects.toString(map.get("ACTIVITYDEFID"), "") + ")");
            comlist.add(node);
        }
        return comlist;
    }

    public String getActOpinionTexts(String formCode, String actId) {
        String sql;
        GenForm form = this.findGenFormByCode(formCode);
        GenFormFlow gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, SysUtils.getLoginUser().getOrgid().toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (gflow != null) {
            sql = "select group_concat(i.ITEM_HTMLID)\n  from gen_form_panel p, gen_panel_item i, gen_form t, gen_act_item a\n where i.panel_id = p.panel_id\n   and a.item_id = i.item_id\n   and p.is_use = 'Y'\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.act_id = :actId\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = :id\n   and p.form_id = t.id\n   and t.form_code = :formCode";
            params.put("id", gflow.getId());
        } else {
            sql = " select group_concat(i.ITEM_HTMLID)\n          from gen_form_panel p, gen_panel_item i,gen_form t\n         where i.panel_id = p.panel_id\n           and p.is_use = 'Y'\n           AND i.is_use = 'Y'\n           and i.item_type = '0'\n           and instr(','||nvl(i.editable_act,'Act_1')||',',','||:actId||',')>0\n           and p.form_id = t.id\t\tand  t.form_code =:formCode\n";
        }
        params.put("formCode", formCode);
        params.put("actId", actId);
        Object object = this.sqlHelper.getSingal(sql, params);
        return Objects.toString(object, null);
    }

    public List<ComboxNode> getFormList(String query) {
        String sql = "select g.id ,g.form_Code value,g.form_Name text from gen_form g where g.is_use='Y' ";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(g.form_Name) like upper(#query#) or upper(g.form_code) like upper(#query#)) ";
            paras.put("query", "%" + query + "%");
        }
        sql = sql + " order by g.id";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public List<ComboxNode> getPanelItem(String formCode, String query) {
        String sql = "select t.item_id id ,concat('$','{item.',t.item_htmlname,'}') value,t.item_label text from GEN_PANEL_ITEM t where exists (select 1 from gen_form_panel p,gen_form f where f.form_code=#formCode# and p.form_id=f.id and f.is_use='Y' and p.panel_id=t.PANEL_ID )and t.hidden='0' and t.is_use='Y'";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(t.item_htmlname) like upper(#query#) or upper(t.item_label) like upper(#query#))";
            paras.put("query", "%" + query + "%");
        }
        paras.put("formCode", formCode);
        sql = sql + " order by t.DISPLAY_NO,ITEM_ID";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public LayuiPageObject<Map<String, Object>> queryMyFlowDrafts(int page, int limit, String createDate, String flowname) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)createDate)) {
            paras.put("createDate", createDate);
        }
        if (!StringUtils.isEmpty((CharSequence)flowname)) {
            paras.put("flowname", "%" + flowname.toUpperCase() + "%");
        }
        return this.bSqlHelper.serachLayuiPage("business.workflow.common.getMyFlowDrafts", paras, PageRequest.of((int)page, (int)limit));
    }

    public String getFlowTitle(String formCode, String mainId) {
        JSONObject objectdata;
        if (StringUtils.isBlank((CharSequence)formCode) || mainId == null) {
            return null;
        }
        String sql = "select i.*\n  from GEN_FORM f, GEN_FORM_PANEL P, GEN_PANEL_ITEM I\n where P.FORM_ID = F.ID\n   AND I.PANEL_ID = P.PANEL_ID\n   AND P.IS_USE = 'Y'\n   AND I.IS_USE = 'Y'\n   AND f.form_code = #formCode#\n   and f.is_use = 'Y'\n   AND I.IS_TITLE = 'Y'\n\torder by i.display_no \n";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("formCode", formCode);
        List<GenPanelItem> list = this.bSqlHelper.serachBySql(sql, paras, GenPanelItem.class);
        GenForm form = this.findGenFormByCode(formCode);
        if (list.isEmpty()) {
            return null;
        }
        String loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&id=" + mainId : form.getLoaddataUrl() + "?id=" + mainId;
        try {
            objectdata = (JSONObject)SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), loadurl);
        }
        catch (Exception e) {
            return null;
        }
        StringBuffer title = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            GenPanelItem item = list.get(i);
            String t = Objects.toString(objectdata.get((Object)item.getItemHtmlname()), null);
            if (BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType())) {
                t = this.basDeptService.findByDeptId(Long.parseLong(t)).getDeptName();
            } else if (BuildType.ITEM_MONEYBOX.equals(item.getItemType())) {
                if (t != null) {
                    BigDecimal money = new BigDecimal(t);
                    t = money.setScale(item.getItemDecimal().intValue(), RoundingMode.HALF_UP).toString();
                }
            } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(item.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType())) {
                t = this.basEmpAccountService.queryEmpAccountByIds(t);
            } else if (BuildType.ITEM_DICBOX.equals(item.getItemType()) || BuildType.ITEM_DICRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(item.getItemType())) {
                if (item.getDicCode() != null) {
                    t = this.commonService.getDicText(item.getDicCode(), t);
                }
            } else if (BuildType.ITEM_COMBOBOX.equals(item.getItemType())) {
                Object combodata;
                String cbpara = "formcode=" + formCode + "&id=" + mainId;
                String combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + cbpara : item.getComboUrl() + "?" + cbpara;
                try {
                    combodata = SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), combourl);
                }
                catch (Exception e) {
                    return null;
                }
                JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                for (int j = 0; j < array.size(); ++j) {
                    JSONObject jsonObject = array.getJSONObject(j);
                    if (!jsonObject.getString("value").equals(t)) continue;
                    t = jsonObject.getString("text");
                    break;
                }
            } else if ((BuildType.ITEM_CHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType())) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getFormCode(), item.getDisplayField()})) {
                JSONObject cbdata;
                GenForm filedform = this.findGenFormByCode(item.getFormCode());
                String filedloadurl = filedform.getLoaddataUrl().indexOf("?") > 0 ? filedform.getLoaddataUrl() + "&id=" + t : filedform.getLoaddataUrl() + "?id=" + t;
                try {
                    cbdata = (JSONObject)SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), filedloadurl);
                }
                catch (Exception e) {
                    return null;
                }
                t = Objects.toString(cbdata.get((Object)item.getDisplayField().replace("${item.", "").replace("}", "")), null);
            }
            if (i > 0) {
                title.append("-");
            }
            if (!StrKit.notNull(t)) continue;
            title.append(t);
        }
        return title.toString().replaceAll("\t|\r|\n", "");
    }

    public GenForm copyGenForm(String id) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        GenForm entity = (GenForm)this.genformDao.findById(id).get();
        GenForm clonebean = (GenForm)BeanUtils.cloneBean((Object)entity);
        clonebean.setId(null);
        clonebean.setFormCode(clonebean.getFormCode() + "_clone");
        this.saveGenForm(clonebean);
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(id);
        for (GenFormPanel panel : panellist) {
            GenFormPanel clonepanel = (GenFormPanel)BeanUtils.cloneBean((Object)panel);
            clonepanel.setPanelId(null);
            clonepanel.setFormId(clonebean.getId());
            this.formPanelService.saveGenFormPanel(clonepanel);
            if (panel.getPanelType().equals(BuildType.PANEL_FORM) || panel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                List<GenPanelItem> itemlist = this.panelItemDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                ArrayList<GenPanelItem> cloneitemlist = new ArrayList<GenPanelItem>(itemlist.size());
                for (GenPanelItem item : itemlist) {
                    GenPanelItem cloneitem = (GenPanelItem)BeanUtils.cloneBean((Object)item);
                    cloneitem.setItemId(null);
                    cloneitem.setPanelId(clonepanel.getPanelId());
                    cloneitemlist.add(cloneitem);
                }
                this.panelItemDao.saveAll(cloneitemlist);
                continue;
            }
            if (!panel.getPanelType().equals(BuildType.PANEL_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) continue;
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
            ArrayList<GenPanelFile> clonefilelist = new ArrayList<GenPanelFile>(filelist.size());
            for (GenPanelFile file : filelist) {
                GenPanelFile clonefile = (GenPanelFile)BeanUtils.cloneBean((Object)file);
                clonefile.setPanelFileId(null);
                clonefile.setPanelId(clonepanel.getPanelId());
                clonefilelist.add(clonefile);
            }
            this.genpanelfileDao.saveAll(clonefilelist);
        }
        return clonebean;
    }

    public String getFlowCodeByFormCode(String formCode) {
        GenForm form = this.findGenFormByCode(formCode);
        GenFormFlow flow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, SysUtils.getLoginUser().getOrgid().toString());
        String flowCode = form.getFlowCode();
        if (flow != null) {
            flowCode = flow.getFlowCode();
        }
        return flowCode;
    }

    public void genFormByTable(DBTable table, boolean proccess) {
        String formName = StringUtils.isNotBlank((CharSequence)table.getDescription()) ? table.getDescription() : table.getTablename();
        if (formName.length() > 25) {
            formName.substring(0, 24);
        }
        GenForm form = new GenForm();
        form.setFormCode(table.getEntityName());
        form.setFormName(formName);
        form.setBusiTable(table.getTablename());
        form.setFormType("1");
        form.setIsApp("N");
        form.setSubmitUrl("/" + table.getEntityName() + "/save" + table.getEntityName());
        form.setLoaddataUrl("/" + table.getEntityName() + "/find" + table.getEntityName());
        form.setExcludeitems("/js/" + table.getViewpath() + "/" + table.getEntityName() + "Extra.js");
        form.setIsUse("Y");
        this.saveGenForm(form);
        GenFormPanel panel = new GenFormPanel();
        panel.setPanelTitle("\u8868\u5355\u9762\u677f");
        panel.setFormColnum(2L);
        panel.setPanelType("0");
        panel.setIsUse("Y");
        panel.setDisplayNo(1L);
        panel.setFormId(form.getId());
        this.formPanelService.saveGenFormPanel(panel);
        this.genpanelitemService.genPanelItemByTable(table, panel.getPanelId());
    }

    public List<DocFormFile> findBillFileList(String formCode, String pkId, String fileNature) {
        return this.findBillFileList(formCode, pkId, fileNature, null);
    }

    public List<DocFormFile> findBillFileList(String formCode, String pkId, String fileNature, String panelFileIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            return null;
        }
        params.put("formCode", formCode);
        if (StringUtils.isEmpty((CharSequence)pkId)) {
            return null;
        }
        params.put("pkId", pkId);
        if (!StringUtils.isEmpty((CharSequence)fileNature) && !"null".equals(fileNature)) {
            params.put("fileNature", ListUtils.stringToListWithLong(fileNature));
        }
        if (!StringUtils.isEmpty((CharSequence)panelFileIds) && !"null".equals(panelFileIds)) {
            params.put("panelFileIds", ListUtils.stringToListWithLong(panelFileIds));
        }
        GenForm form = new GenForm();
        List<GenForm> forms = this.genformDao.findByFormCodeAndIsUse(formCode, "Y");
        if (form != null && forms.size() > 0) {
            form = forms.get(0);
        }
        List<GenPanelFile> GenPanelFiles = this.bSqlHelper.getList("gen.GenForm.findBillPanelByFormCode", params, GenPanelFile.class);
        ArrayList<DocFormFile> list = new ArrayList<DocFormFile>();
        for (GenPanelFile file : GenPanelFiles) {
            List<DocFormFile> listFormFileByPK = this.docFormFileService.listFormFileByPK(form.getId(), file.getFileTypeId(), pkId);
            if (listFormFileByPK == null || listFormFileByPK.size() <= 0) continue;
            list.addAll(listFormFileByPK);
        }
        return list;
    }

    public List<ComboxNode> getPanelItemCom(String formCode, String query) {
        String sql = "select t.item_id id ,t.item_id value,t.item_label text from GEN_PANEL_ITEM t where exists (select 1 from gen_form_panel p,gen_form f where f.form_code=#formCode# and p.form_id=f.id and f.is_use='Y' and p.panel_id=t.PANEL_ID ) and t.is_use='Y'";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(t.item_htmlname) like upper(#query#) or upper(t.item_label) like upper(#query#))";
            paras.put("query", "%" + query + "%");
        }
        paras.put("formCode", formCode);
        sql = sql + " order by t.DISPLAY_NO,ITEM_ID";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public String getFormBorder() {
        return this.formBorder;
    }

    public void setFormBorder(String formBorder) {
        this.formBorder = formBorder;
    }

    public Object getFields(String fromCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formCode", fromCode);
        return this.bSqlHelper.getMapList("business.fm.FmApplyForm.getFields1", params);
    }

    public String getTitle(String fromCode) {
        String sql = "select i.*\n  from GEN_FORM f, GEN_FORM_PANEL P, GEN_PANEL_ITEM I\n where P.FORM_ID = F.ID\n   AND I.PANEL_ID = P.PANEL_ID\n   AND P.IS_USE = 'Y'\n   AND I.IS_USE = 'Y'\n   AND f.form_code = #formCode#\n   and f.is_use = 'Y'\n   AND I.IS_TITLE = 'Y'\n";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("formCode", fromCode);
        List<GenPanelItem> list = this.bSqlHelper.serachBySql(sql, paras, GenPanelItem.class);
        if (list.isEmpty()) {
            return "";
        }
        return list.get(0).getItemHtmlname();
    }
}

