/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.gen.dao.GenFormFlowDao;
import com.ustc.gen.entity.GenFormFlow;
import com.ustc.gen.service.GenActItemService;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenFormFlowService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenFormFlowDao genformflowDao;
    @Autowired
    private GenActItemService genactitemService;
    @Value(value="${formFlow.mode:strict}")
    private String flowModel;

    public GenFormFlow findGenFormFlow(String id) {
        GenFormFlow entity = (GenFormFlow)this.genformflowDao.findById(id).get();
        return entity;
    }

    public boolean checkEntity(GenFormFlow entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formId", entity.getFormId());
        params.put("applyOrgs", entity.getApplyOrgs());
        params.put("id", entity.getId() == null ? "-1" : entity.getId());
        Long count = this.bSqlHelper.getLongValue("gen.GenFormFlow.checkEntity", params);
        return count <= 0L;
    }

    public GenFormFlow findByFormIdAndApplyOrgs(String formId, String flowCode, String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (formId != null) {
            params.put("formId", formId);
        }
        if (!StringUtils.isEmpty((String)flowCode)) {
            params.put("flowCode", flowCode);
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            params.put("orgId", orgId);
        }
        return this.bSqlHelper.getEntity("gen.GenFormFlow.findByFormIdAndApplyOrgs", params, GenFormFlow.class);
    }

    public void saveGenFormFlow(GenFormFlow entity) {
        this.genformflowDao.save(entity);
    }

    public void delGenFormFlow(String id) {
        GenFormFlow entity = (GenFormFlow)this.genformflowDao.findById(id).get();
        entity.setIsUse("N");
        this.genformflowDao.save(entity);
        this.genactitemService.delGenActItemBySetting(id);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (this.flowModel != null) {
            params.put("flowModel", this.flowModel);
        }
        return this.bSqlHelper.serachPage("gen.GenFormFlow.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getFormItem(String formId, Long orgId, String itemId, String actId, String isPishiForm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (formId != null) {
            params.put("formId", formId);
        }
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        if (itemId != null) {
            params.put("itemId", itemId);
        }
        if (!StringUtils.isEmpty((String)actId)) {
            params.put("actId", actId);
        }
        if ("Y".equals(isPishiForm)) {
            params.put("isPishiForm", isPishiForm);
        }
        return this.bSqlHelper.getMapList("gen.GenFormFlow.getFormItem", params);
    }

    public Map<String, Object> getFormFile(String formId, Long orgId, String fileTypeId, String actId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)actId)) {
            params.put("actId", actId);
        }
        if (formId != null) {
            params.put("formId", formId);
        }
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        if (fileTypeId != null) {
            params.put("fileTypeId", fileTypeId);
        }
        return this.bSqlHelper.getMap("gen.GenFormFlow.getFormFile", params);
    }
}

