/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.controller;

import com.alibaba.fastjson.JSONObject;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.common.BuildForm;
import com.ustc.gen.common.BuildPanel;
import com.ustc.gen.common.BuildType;
import com.ustc.gen.dao.GenFormPrintDao;
import com.ustc.gen.entity.GenAppForm;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.entity.GenFormFlow;
import com.ustc.gen.entity.GenFormPanel;
import com.ustc.gen.entity.GenFormPrint;
import com.ustc.gen.service.GenFormFlowService;
import com.ustc.gen.service.GenFormPanelService;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.service.GeneratorService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.workflow.service.FlowUtilService;
import com.ustc.workflow.service.StfBusinessProcessService;
import com.ustc.workflow.service.WfCommonphraseService;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/GenForm"})
public class GenFormController
extends BaseController {
    @Autowired
    private GenFormService genformService;
    @Autowired
    private GenFormFlowService genformflowService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private WfCommonphraseService wfcommonphraseService;
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private GeneratorService generatorService;
    @Autowired
    private GenFormPanelService formPanelService;
    @Autowired
    private GenFormPrintDao genFormPrintDao;

    @RequestMapping(value={"/pageGenForm"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGenForm(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.genformService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/pageGenFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGenFlow(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String orgId) {
        return this.genformService.PageAllFlow(search, page, rows, orgId);
    }

    @RequestMapping(value={"/findGenForm"})
    @ResponseBody
    public Object findGenForm(String id) {
        GenForm form = this.genformService.findGenForm(id);
        return form;
    }

    @RequestMapping(value={"/switchFormStyle"})
    @ResponseBody
    public Object switchFormStyle(String id, String style) {
        GenForm form = this.genformService.findGenForm(id);
        form.setFormStyle(style);
        this.genformService.saveGenForm(form);
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveGenForm"})
    @ResponseBody
    public Object saveGenForm(GenForm entity) {
        JsonMsg msg = this.genformService.checkRepeat(entity);
        if (msg.isSuccess()) {
            entity.setIsUse("Y");
            this.genformService.saveGenForm(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delGenForm"})
    @ResponseBody
    public Object delGenForm(String id) {
        GenForm entity = this.genformService.findGenForm(id);
        entity.setIsUse("N");
        this.genformService.saveGenForm(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/form"})
    public ModelAndView form(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="formcode", required=true) String formcode, String id, String loadformcode, String excludeitems, String excludepanels, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail, @RequestParam(value="isappro", defaultValue="false") boolean isappro, @RequestParam(value="newpage", defaultValue="false") boolean newpage, @RequestParam(value="editFile", defaultValue="false") boolean editFile, @RequestParam(value="checkMsg", defaultValue="false") boolean checkMsg, Long msgId) throws Exception {
        BasMessage msg;
        String pageType = request.getParameter("pageType");
        String isPishiForm = request.getParameter("isPishiForm");
        ModelAndView view = new ModelAndView();
        view.addObject("formBorder", (Object)this.genformService.getFormBorder());
        view.addObject("isLayer", (Object)(StrKit.isBlank(request.getParameter("isLayer")) ? "" : request.getParameter("isLayer")));
        if (StrKit.notBlank(request.getParameter("delFile"))) {
            view.addObject("delFile", (Object)Boolean.valueOf(request.getParameter("delFile")));
        }
        if (checkMsg && (msg = this.basmessageService.findByformCodeAndbusiMainIdAndAccountId(id, SysUtils.getLoginAccountId(), formcode)) != null && (StringUtils.isBlank((String)msg.getMsgUrl()) || msg.getMsgUrl().contains("GenForm/form"))) {
            view.setViewName("redirect:/BasMessage/todoDetail?msgid=" + msg.getMsgId() + "&signlePage=false");
            return view;
        }
        if (msgId != null) {
            msg = this.basmessageService.findBasMessage(msgId);
            view.addObject("msg", (Object)msg);
        }
        GenForm form = this.genformService.findGenFormByCode(formcode);
        view.addObject("formStyle", (Object)("Y".equals(isPishiForm) ? "2" : form.getFormStyle()));
        view.addObject("printAddr", (Object)form.getPrintAddr());
        view.addObject("flowCode", (Object)form.getFlowCode());
        view.addObject("id", (Object)id);
        view.addObject("add", (Object)(id == null ? 1 : 0));
        view.addObject("isHaveFlow", (Object)(StrKit.notBlank(form.getFlowCode()) ? "Y" : "N"));
        String queryString = request.getQueryString();
        if (StrKit.notBlank(loadformcode)) {
            GenForm loadform = this.genformService.findGenFormByCode(loadformcode);
            form.setLoadformid(loadform.getId());
        }
        if (form != null) {
            if (form.getFormType().equals(BuildType.FORM_CUSTOM)) {
                RedirectView redirectView = new RedirectView(form.getFormUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
            } else {
                view.addObject("newpage", (Object)newpage);
                form.setQueryString(queryString);
                form.setIsdetail("Y".equals(isPishiForm) ? true : isdetail);
                Object data = this.getFormData(request, response, form, id);
                view.addObject("data", data);
                if (newpage) {
                    JSONObject json;
                    view.addObject("form", (Object)form);
                    if (StrKit.notBlank(form.getExtraJsUrl())) {
                        view.addObject("urlList", (Object)form.getExtraJsUrl().split(";"));
                    }
                    if (id != null && data != null && (json = (JSONObject)data).containsKey((Object)"processinstid")) {
                        this.flowUtilService.getRollableAct(view, msgId, id.toString(), json.getLong("processinstid"), formcode);
                        Long processinstid = json.getLong("processinstid");
                        if (processinstid != null) {
                            view.addObject("workitems", this.flowUtilService.queryWorkItemByDefid(processinstid, null));
                            view.addObject("processinstid", (Object)processinstid);
                        }
                    }
                    List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
                    for (GenFormPanel p : panellist) {
                        if (!BuildType.PANEL_FORM_PS.equals(p.getPanelType())) continue;
                        view.addObject("isHavePishi", (Object)"Y");
                    }
                    view.setViewName("/common/openFormDetail");
                    Map map = request.getParameterMap();
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key;
                        view.addObject(key, (Object)(map.get(key = (String)iterator.next()) == null ? "" : StringUtils.join((Object[])((Object[])map.get(key)), (char)',')));
                    }
                    return view;
                }
                if ("Y".equals(isPishiForm)) {
                    view.addObject("pishi", (Object)"_pishi");
                    view.setViewName("/gen/FormPishi");
                } else {
                    view.addObject("pishi", (Object)"");
                    view.setViewName(BuildType.FORM_CUSTOM.equals(form.getFormStyle()) ? "/gen/Form_new" : "/gen/Form");
                }
                form.setIsappro(isappro);
                if (id != null) {
                    if (StrKit.notBlank(form.getItemHiddenUrl())) {
                        excludeitems = SysUtils.sendHttp(request, response, form.getItemHiddenUrl() + "?id=" + id + "&isdetail=" + isdetail).toString();
                    }
                    if (StrKit.notBlank(form.getPanelHiddenUrl())) {
                        excludepanels = SysUtils.sendHttp(request, response, form.getPanelHiddenUrl() + "?id=" + id + "&isdetail=" + isdetail).toString();
                    }
                }
                form.setExcludeitems(excludeitems);
                form.setExcludepanels(excludepanels);
                if (data != null) {
                    JSONObject json = (JSONObject)data;
                    if (StrKit.isBlank(loadformcode)) {
                        Map<String, Object> flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
                        flowInfo.remove("actDesc");
                        request.setAttribute("flowInfo", flowInfo);
                    } else {
                        json.put("processinstid", null);
                    }
                    BuildForm buildform = this.genformService.buildForm(form, id, request, response, data, editFile, pageType, isPishiForm);
                    view.addObject("data", data);
                    view.addObject("form", (Object)buildform);
                } else {
                    view.setViewName("/errorpage/404");
                }
            }
        } else {
            view.setViewName("/errorpage/404");
            return view;
        }
        view.addObject("usuallyLang", this.wfcommonphraseService.findByAccountOrCommon(this.getLoginUser(request).getAccountid()));
        return view;
    }

    @RequestMapping(value={"/appform"})
    @ResponseBody
    public Object appform(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="formcode", required=true) String formcode, String id) throws Exception {
        GenAppForm appfrom = this.genformService.buildAppForm(formcode, id, request, response);
        return appfrom;
    }

    @RequestMapping(value={"/reloadFileList"})
    public ModelAndView reloadFileList(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="formcode", required=true) String formcode, String loadformcode, String panelHtmlID, String id, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail, @RequestParam(value="editFile", defaultValue="false") boolean editFile) throws Exception {
        GenForm form = this.genformService.findGenFormByCode(formcode);
        String queryString = request.getQueryString();
        if (StrKit.notBlank(loadformcode)) {
            GenForm loadform = this.genformService.findGenFormByCode(loadformcode);
            form.setLoadformid(loadform.getId());
        }
        ModelAndView view = new ModelAndView();
        view.addObject("id", (Object)id);
        if (form != null) {
            if (form.getFormType().equals(BuildType.FORM_CUSTOM)) {
                RedirectView redirectView = new RedirectView(form.getFormUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
            } else {
                form.setQueryString(queryString);
                form.setIsdetail(isdetail);
                Object data = this.getFormData(request, response, form, id);
                if (data != null) {
                    JSONObject json = (JSONObject)data;
                    Map<String, Object> flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
                    flowInfo.remove("actDesc");
                    request.setAttribute("flowInfo", flowInfo);
                    BuildForm buildform = this.genformService.buildFilePanel(form, panelHtmlID, id, null, data, editFile);
                    buildform.setIsdetail(isdetail);
                    view.setViewName("/gen/FormItems/filelist");
                    view.addObject("form", (Object)buildform);
                    view.addObject("filelistindex", (Object)0);
                    view.addObject("panel", (Object)(buildform.getPanels().size() > 0 ? buildform.getPanels().get(0) : new BuildPanel()));
                } else {
                    view.setViewName("/errorpage/404");
                }
            }
        } else {
            view.setViewName("/errorpage/404");
            return view;
        }
        return view;
    }

    @RequestMapping(value={"/editBizFiles"})
    public ModelAndView bizAddFiles(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="formcode", required=true) String formcode, String id, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) throws Exception {
        GenForm form = this.genformService.findGenFormByCode(formcode);
        String queryString = request.getQueryString();
        ModelAndView view = new ModelAndView();
        if (form != null) {
            if (form.getFormType().equals(BuildType.FORM_CUSTOM)) {
                RedirectView redirectView = new RedirectView(form.getFormUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
            } else {
                form.setQueryString(queryString);
                form.setIsdetail(isdetail);
                BuildForm buildform = this.genformService.buildBizEditFilePanel(form, id, false);
                buildform.setIsdetail(isdetail);
                view.setViewName("/gen/editBizFiles");
                view.addObject("form", (Object)buildform);
                view.addObject("filelistindex", (Object)0);
            }
        } else {
            view.setViewName("/errorpage/404");
            return view;
        }
        return view;
    }

    @RequestMapping(value={"/buildSinglePanel"})
    public ModelAndView buildSinglePanel(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="formcode", required=true) String formcode, String loadformcode, @RequestParam(value="panelHtmlID", required=true) String panelHtmlID, String id, String filepkids, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail, @RequestParam(value="editFile", defaultValue="false") boolean editFile) throws Exception {
        GenForm form = this.genformService.findGenFormByCode(formcode);
        String queryString = request.getQueryString();
        if (StrKit.notBlank(loadformcode)) {
            GenForm loadform = this.genformService.findGenFormByCode(loadformcode);
            form.setLoadformid(loadform.getId());
        }
        ModelAndView view = new ModelAndView();
        if (form != null) {
            if (form.getFormType().equals(BuildType.FORM_CUSTOM)) {
                RedirectView redirectView = new RedirectView(form.getFormUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
            } else {
                form.setQueryString(queryString);
                form.setIsdetail(isdetail);
                Object data = this.getFormData(request, response, form, id);
                if (data != null) {
                    JSONObject json = (JSONObject)data;
                    Map<String, Object> flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
                    flowInfo.remove("actDesc");
                    request.setAttribute("flowInfo", flowInfo);
                    BuildForm buildform = this.genformService.buildFilePanel(form, panelHtmlID, id, null, data, editFile);
                    buildform.setIsdetail(isdetail);
                    view.setViewName("/gen/FormItems/singlepanel");
                    view.addObject("form", (Object)buildform);
                    view.addObject("filelistindex", (Object)0);
                    view.addObject("panel", (Object)(buildform.getPanels().size() > 0 ? buildform.getPanels().get(0) : new BuildPanel()));
                } else {
                    view.setViewName("/errorpage/404");
                }
            }
        } else {
            view.setViewName("/errorpage/404");
            return view;
        }
        return view;
    }

    public Object getFormData(HttpServletRequest request, HttpServletResponse response, GenForm form, String id) throws Exception {
        Object data = new JSONObject();
        if (id != null) {
            String loadurl = "";
            if (form.getLoadformid() != null) {
                GenForm loadform = this.genformService.findGenForm(form.getLoadformid());
                if (StrKit.notBlank(loadform.getLoaddataUrl())) {
                    loadurl = loadform.getLoaddataUrl().indexOf("?") > 0 ? loadform.getLoaddataUrl() + "&" + form.getQueryString() : loadform.getLoaddataUrl() + "?" + form.getQueryString();
                }
            } else if (StrKit.notBlank(form.getLoaddataUrl())) {
                String string = loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&" + form.getQueryString() : form.getLoaddataUrl() + "?" + form.getQueryString();
            }
            if (StrKit.notBlank(loadurl)) {
                data = SysUtils.sendHttp(request, response, loadurl);
            }
        }
        return data;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public Object save(HttpServletRequest request, FormFileBean formfile) {
        System.out.println(request);
        System.out.println(formfile);
        formfile.setPrimaryKey(1L);
        formfile.setProjectId(1L);
        formfile.setAccountid(SysUtils.getLoginAccountId());
        this.docFormFileService.SaveFormFileBean(formfile);
        return new JsonMsg();
    }

    @RequestMapping(value={"/testredirect"})
    @ResponseBody
    public Object testredirect(HttpServletRequest request) {
        System.out.println(request.getQueryString());
        return new JsonMsg();
    }

    @RequestMapping(value={"/allflow"})
    @ResponseBody
    public ModelAndView allFlow(String type, String orgId) {
        List list = this.genformService.allFlow(type, orgId);
        ModelAndView view = new ModelAndView();
        view.setViewName("/gen/allflow");
        view.addObject("tables", (Object)list);
        return view;
    }

    @RequestMapping(value={"/flowActComb"})
    @ResponseBody
    public Object flowActComb(String panelId) {
        return this.genformService.flowActComb(panelId);
    }

    @RequestMapping(value={"/queryFlowActComb"})
    @ResponseBody
    public Object queryFlowActComb(String formId) {
        if (formId == null) {
            return null;
        }
        return this.genformService.queryFlowActComb(formId);
    }

    @RequestMapping(value={"/getFormList"})
    @ResponseBody
    public List<ComboxNode> getFormList(String q) {
        return this.genformService.getFormList(q);
    }

    @RequestMapping(value={"/getPanelItem"})
    @ResponseBody
    public List<ComboxNode> getPanelItem(String formCode, String q) {
        return this.genformService.getPanelItem(formCode, q);
    }

    @RequestMapping(value={"/addFormFlow"})
    public Object addFormFlow(String formCode, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        GenForm form = (GenForm)BeanUtils.cloneBean((Object)this.genformService.findGenFormByCode(formCode));
        model.addAttribute("isLayer", (Object)request.getParameter("isLayer"));
        String pkCol = this.generatorService.getPK(form.getBusiTable());
        model.addAttribute("pkField", (Object)DBPropertyUtil.columnToProperty2(pkCol));
        model.addAttribute("form", (Object)form);
        model.addAttribute("advices", (Object)request.getParameter("advices"));
        model.addAttribute("submit", (Object)request.getParameter("submit"));
        model.addAttribute("id", (Object)request.getParameter("id"));
        String loadScript = request.getParameter("loadScript");
        if (StrKit.notNull(loadScript)) {
            form.setLoadScript(loadScript);
        }
        StringBuffer urlParams = new StringBuffer(request.getQueryString());
        if (StrKit.isBlank(request.getParameter("formcode"))) {
            urlParams.append("&formcode=" + formCode);
        }
        if (StrKit.isBlank(request.getParameter("isdetail"))) {
            urlParams.append("&isdetail=false");
        } else {
            form.setIsdetail(Boolean.parseBoolean(request.getParameter("isdetail")));
        }
        if (StrKit.notBlank(form.getExtraJsUrl())) {
            model.addAttribute("urlList", (Object)form.getExtraJsUrl().split(";"));
        }
        model.addAttribute("urlParams", (Object)urlParams.toString());
        if (StrKit.notNull(request.getParameter("id"))) {
            form.setQueryString(urlParams.toString());
            Object data = this.getFormData(request, response, form, String.valueOf(request.getParameter("id")));
            JSONObject json = (JSONObject)data;
            Long processinstid = json.getLong("processinstid");
            if (processinstid != null) {
                model.addAttribute("workitems", this.flowUtilService.queryWorkItemByDefid(processinstid, null));
                model.addAttribute("processinstid", (Object)processinstid);
                String flowCode = this.flowUtilService.getProcInstService().findProcessById(processinstid.longValue()).getProcessInstName();
                model.addAttribute("flow", (Object)this.sbpservice.queryWorkFlowPublicVersion(flowCode));
            }
        } else {
            GenFormFlow flow = this.genformflowService.findByFormIdAndApplyOrgs(form.getId(), null, this.getLoginUser(request).getOrgid().toString());
            String flowCode = form.getFlowCode();
            if (flow != null) {
                flowCode = flow.getFlowCode();
            }
            model.addAttribute("flow", (Object)this.sbpservice.queryWorkFlowPublicVersion(flowCode));
        }
        return "/common/addFormFlow";
    }

    @RequestMapping(value={"/checkFormFlow"})
    @ResponseBody
    public Object checkFormFlow(String formCode, HttpServletRequest request) {
        GenForm form = this.genformService.findGenFormByCode(formCode);
        GenFormFlow flow = this.genformflowService.findByFormIdAndApplyOrgs(form.getId(), null, this.getLoginUser(request).getOrgid().toString());
        String flowCode = form.getFlowCode();
        if (flow != null) {
            flowCode = flow.getFlowCode();
        }
        JsonMsg msg = new JsonMsg();
        msg.setSuccess(StringUtils.isNotBlank((String)flowCode));
        return msg;
    }

    @RequestMapping(value={"/queryMyFlowDrafts"})
    @ResponseBody
    public Object queryMyFlowDrafts(int page, int limit, String createDate, String flowname) {
        return this.genformService.queryMyFlowDrafts(page, limit, createDate, flowname);
    }

    @RequestMapping(value={"/printform"})
    public ModelAndView printform(Long id, String formCode, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        GenFormPrint genFormPrint = null;
        String printUrl = "";
        if (id == null || StringUtils.isBlank((String)formCode)) {
            view.setViewName("/errorpage/404");
            return view;
        }
        GenForm form = this.genformService.findGenFormByCode(formCode);
        if (form == null) {
            view.setViewName("/errorpage/404");
            return view;
        }
        List<GenFormPrint> genFormPrintList = this.genFormPrintDao.findByPrintFormCodeAndIsUse(formCode, "Y");
        if (genFormPrintList != null && genFormPrintList.size() > 0) {
            genFormPrint = genFormPrintList.get(0);
        }
        if (genFormPrint != null) {
            String printAddr = "/GenFormPrint/getPrintPage" + printUrl + (printUrl.indexOf("?") != -1 ? "&" : "?") + "id=" + id + "&formCode=" + formCode + "&formcode=" + formCode;
            view.setViewName("redirect:" + printAddr);
            return view;
        }
        printUrl = StringUtils.isBlank((String)form.getPrintAddr()) ? "/GenForm/form?hideCloseBtn=1&newpage=true" : form.getPrintAddr();
        String printAddr = printUrl + (printUrl.indexOf("?") != -1 ? "&" : "?") + "id=" + id + "&formCode=" + formCode + "&formcode=" + formCode;
        view.setViewName("redirect:" + printAddr);
        return view;
    }

    @RequestMapping(value={"/copyGenForm"})
    @ResponseBody
    public Object copyGenForm(String id) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        GenForm entity = this.genformService.copyGenForm(id);
        entity.setIsUse("N");
        return new JsonMsg();
    }

    @RequestMapping(value={"/getPanelItemCom"})
    @ResponseBody
    public List<ComboxNode> getPanelItemCom(String formCode, String q) {
        return this.genformService.getPanelItemCom(formCode, q);
    }

    @RequestMapping(value={"/loadForm"})
    public Object loadForm(String loadFormCode, String loadId) {
        return "redirect:/GenForm/form?formCode=" + loadFormCode + "&formcode=" + loadFormCode + "&id=" + loadId + "&isdetail=true";
    }

    @RequestMapping(value={"/selectDate2"})
    public Object selectDate2(String fromCode, Model model, String flowCode) {
        GenForm genfrom = this.genformService.findGenFormByCode(fromCode);
        String pkCol = this.generatorService.getPK(genfrom.getBusiTable());
        model.addAttribute("pkField", (Object)DBPropertyUtil.columnToProperty2(pkCol));
        model.addAttribute("formCode", (Object)fromCode);
        model.addAttribute("table", (Object)genfrom.getBusiTable());
        model.addAttribute("field", this.genformService.getFields(fromCode));
        model.addAttribute("flowCode", (Object)flowCode);
        String title = this.genformService.getTitle(fromCode);
        if (!StringUtils.isEmpty((String)title)) {
            model.addAttribute("title", (Object)title);
        }
        return "/common/selectData2";
    }
}

