/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.doc.entity.DocCatalog;
import com.ustc.doc.service.DocCatalogService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/DocCatalog"})
public class DocCatalogController
extends BaseController {
    @Autowired
    private DocCatalogService doccatalogService;

    @RequestMapping(value={"/pageDocCatalog"})
    @ResponseBody
    public Object pageDocCatalog(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.doccatalogService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findDocCatalog"})
    @ResponseBody
    public Object findDocCatalog(String id) {
        return this.doccatalogService.findDocCatalog(id);
    }

    @RequestMapping(value={"/saveDocCatalog"})
    @ResponseBody
    public Object saveDocCatalog(DocCatalog entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        this.doccatalogService.saveDocCatalog(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/saveStanderDocCatalog"})
    @ResponseBody
    public Object saveStanderDocCatalog(DocCatalog entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        entity.setCatalogType("1");
        this.doccatalogService.saveDocCatalog(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delDocCatalog"})
    @ResponseBody
    public Object delDocCatalog(String id) {
        DocCatalog entity = this.doccatalogService.findDocCatalog(id);
        entity.setIsUse("N");
        this.doccatalogService.saveDocCatalog(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeDocCatalogWithRoot"})
    @ResponseBody
    public Object treeDocCatalogWithRoot(@RequestParam(value="pid", defaultValue="0") String pid) {
        List<ComBoxTreeNode> treelist = this.doccatalogService.treeDocCatalog(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeStanderDocCatalogWithRoot"})
    @ResponseBody
    public Object treeStanderDocCatalogWithRoot(@RequestParam(value="pid", defaultValue="0") String pid, @RequestParam(value="sysType", defaultValue="") String sysType) {
        List<ComBoxTreeNode> treelist = this.doccatalogService.treeStanderDocCatalog(pid, sysType);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6807\u51c6\u76ee\u5f55");
        root.setChecked(true);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeStanderDocCatalog"})
    @ResponseBody
    public Object treeStanderDocCatalog(@RequestParam(value="pid", defaultValue="0") String pid, @RequestParam(value="sysType", defaultValue="") String sysType, String detailId) {
        if (StringUtils.isNotEmpty((String)detailId)) {
            DocCatalog d = this.doccatalogService.findDocCatalog(detailId);
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setId(d.getCatalogId().toString());
            node.setText(d.getCatalogName());
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(node);
            return list;
        }
        return this.doccatalogService.treeStanderDocCatalog(pid, sysType);
    }

    @RequestMapping(value={"/treeDocCatalog"})
    @ResponseBody
    public Object treeDocCatalog(@RequestParam(value="pid", defaultValue="0") String pid) {
        return this.doccatalogService.treeDocCatalog(pid);
    }

    @RequestMapping(value={"/delDocCatalogAndChild"})
    @ResponseBody
    public Object delDocCatalogAndChild(String id) {
        this.doccatalogService.delDocCatalogAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeProjectCatalogWithRoot"})
    @ResponseBody
    public Object treeProjectCatalogWithRoot(@RequestParam(value="pid", defaultValue="0") String pid) {
        List<ComBoxTreeNode> treelist = this.doccatalogService.treeProjectCatalogWithRoot(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6807\u51c6\u76ee\u5f55");
        root.setChecked(true);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }
}

