/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Repository;

@Repository
public class FileHelper {
    public boolean isOffice(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return "doc".equalsIgnoreCase(extension) || "docx".equalsIgnoreCase(extension) || "xls".equalsIgnoreCase(extension) || "xlsx".equalsIgnoreCase(extension) || "ppt".equalsIgnoreCase(extension) || "ppsx".equalsIgnoreCase(extension) || "pptx".equalsIgnoreCase(extension);
    }

    public boolean canPreview(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return "pdf".equalsIgnoreCase(extension) || "txt".equalsIgnoreCase(extension) || "sql".equalsIgnoreCase(extension) || "log".equalsIgnoreCase(extension) || "html".equalsIgnoreCase(extension) || "png".equalsIgnoreCase(extension) || "gif".equalsIgnoreCase(extension) || "jepg".equalsIgnoreCase(extension) || "jpg".equalsIgnoreCase(extension);
    }

    public String changeExtPdf(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if ("xls".equalsIgnoreCase(extension) || "xlsx".equalsIgnoreCase(extension)) {
            return FilenameUtils.getBaseName((String)filename) + ".html";
        }
        return FilenameUtils.getBaseName((String)filename) + ".pdf";
    }

    public String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f|\\s*|\t|\r|\n]");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public File generFile(String filePath) {
        File destfile = new File(filePath);
        if (destfile.exists()) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String basename = FilenameUtils.getBaseName((String)filePath);
            String fileExt = FilenameUtils.getExtension((String)filePath);
            String currentTime = dateformat.format(new Date());
            destfile = new File(FilenameUtils.getFullPath((String)filePath) + basename + "_" + currentTime + "." + fileExt);
        }
        return destfile;
    }

    public boolean hasPermissions() {
        return true;
    }
}

