/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.convert;

import com.google.common.xml.XmlEscapers;
import com.ustc.doc.common.convert.MyDateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MyCellValueHelper {
    private boolean is07;
    private int cssRandom;
    private Map<String, String> fontCache = new HashMap<String, String>();

    public MyCellValueHelper(Workbook wb, int cssRandom) {
        this.cssRandom = cssRandom;
        if (wb instanceof HSSFWorkbook) {
            this.is07 = false;
        } else if (wb instanceof XSSFWorkbook) {
            this.is07 = true;
            this.cacheFontInfo(wb);
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + wb.getClass().getSimpleName());
        }
    }

    private void cacheFontInfo(Workbook wb) {
        short le = wb.getNumberOfFonts();
        for (short i = 0; i < le; i = (short)(i + 1)) {
            Font font = wb.getFontAt(i);
            this.fontCache.put(font.getBold() + "_" + font.getItalic() + "_" + font.getFontName() + "_" + font.getFontHeightInPoints() + "_" + font.getColor(), font.getIndex() + "");
        }
    }

    public String getHtmlValue(Cell cell, Workbook wb) {
        if (CellType.BOOLEAN == cell.getCellType()) {
            cell.setCellType(CellType.STRING);
            return cell.getStringCellValue();
        }
        if (CellType.NUMERIC == cell.getCellType()) {
            if (MyDateUtil.isCellDateFormatted(cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(cell.getDateCellValue()).toString();
            }
            HSSFDataFormatter dataFormatter = new HSSFDataFormatter();
            return dataFormatter.formatCellValue(cell);
        }
        if (CellType.STRING == cell.getCellType()) {
            if (cell.getRichStringCellValue().numFormattingRuns() == 0) {
                return XmlEscapers.xmlContentEscaper().escape(cell.getStringCellValue());
            }
            if (this.is07) {
                return this.getXSSFRichString((XSSFRichTextString)cell.getRichStringCellValue());
            }
            return this.getHSSFRichString((HSSFRichTextString)cell.getRichStringCellValue());
        }
        if (CellType.FORMULA == cell.getCellType()) {
            try {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    return date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                }
                cell.setCellType(CellType.STRING);
                return String.valueOf(cell.getNumericCellValue());
            }
            catch (IllegalStateException e) {
                return String.valueOf(cell.getRichStringCellValue());
            }
        }
        return "";
    }

    private String getHSSFRichString(HSSFRichTextString rich) {
        int nums = rich.numFormattingRuns();
        StringBuilder sb = new StringBuilder();
        String text = rich.toString();
        int currentIndex = 0;
        sb.append(text.substring(0, rich.getIndexOfFormattingRun(0)));
        for (int i = 0; i < nums; ++i) {
            sb.append("<span ");
            sb.append("class='font_" + rich.getFontOfFormattingRun(i));
            sb.append("_");
            sb.append(this.cssRandom);
            sb.append("'>");
            currentIndex = rich.getIndexOfFormattingRun(i);
            if (i < nums - 1) {
                sb.append(XmlEscapers.xmlContentEscaper().escape(text.substring(currentIndex, rich.getIndexOfFormattingRun(i + 1))));
            } else {
                sb.append(XmlEscapers.xmlContentEscaper().escape(text.substring(currentIndex, text.length())));
            }
            sb.append("</span>");
        }
        return sb.toString();
    }

    private String getXSSFRichString(XSSFRichTextString rich) {
        int nums = rich.numFormattingRuns();
        StringBuilder sb = new StringBuilder();
        String text = rich.toString();
        int currentIndex = 0;
        int lastIndex = 0;
        for (int i = 1; i <= nums; ++i) {
            sb.append("<span ");
            try {
                sb.append("class='font_" + this.getFontIndex(rich.getFontOfFormattingRun(i - 1)));
                sb.append("_");
                sb.append(this.cssRandom);
                sb.append("'");
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(">");
            currentIndex = rich.getIndexOfFormattingRun(i) == -1 ? text.length() : rich.getIndexOfFormattingRun(i);
            sb.append(XmlEscapers.xmlContentEscaper().escape(text.substring(lastIndex, currentIndex)));
            sb.append("</span>");
            lastIndex = currentIndex;
        }
        return sb.toString();
    }

    private String getFontIndex(XSSFFont font) {
        return this.fontCache.get(font.getBold() + "_" + font.getItalic() + "_" + font.getFontName() + "_" + font.getFontHeightInPoints() + "_" + font.getColor());
    }
}

