/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.MemCache;
import com.ustc.base.common.util.ValueText;
import com.ustc.base.dao.BasDeptDao;
import com.ustc.base.dao.BasDicDao;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.dao.BasOrgDao;
import com.ustc.base.entity.BasDept;
import com.ustc.base.entity.BasDic;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.BasOrg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="MemCacheService")
public class MemCacheService {
    @Autowired
    private BasDicDao dicDao;
    @Autowired
    private BasOrgDao basOrgDao;
    @Autowired
    private BasDeptDao basDeptDao;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;

    public void setDicCache() {
        List<BasDic> list = this.dicDao.findAllByOrderByDicCodeAscDicValueAsc();
        HashMap<String, List<ValueText>> map = new HashMap<String, List<ValueText>>();
        String dicCode = "";
        for (BasDic basDic : list) {
            dicCode = basDic.getDicCode();
            ArrayList<ValueText> tmpList = (ArrayList<ValueText>)map.get(dicCode);
            if (tmpList == null) {
                tmpList = new ArrayList<ValueText>();
            }
            tmpList.add(new ValueText(basDic.getDicValue(), basDic.getDicText()));
            map.put(dicCode, tmpList);
        }
        MemCache.dicMap = map;
    }

    public void setOrgCache() {
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        List list = this.basOrgDao.findAll();
        for (BasOrg entity : list) {
            orgMap.put(entity.getOrgId(), entity.getOrgName());
        }
        MemCache.orgMap = orgMap;
    }

    public void setDeptCache() {
        HashMap<Long, String> deptMap = new HashMap<Long, String>();
        List list = this.basDeptDao.findAll();
        for (BasDept entity : list) {
            deptMap.put(entity.getOrgId(), entity.getDeptName());
        }
        MemCache.deptMap = deptMap;
    }

    public void setEmpAccountCache() {
        HashMap<Long, String> empAccountMap = new HashMap<Long, String>();
        List list = this.basEmpAccountDao.findAll();
        for (BasEmpAccount entity : list) {
            empAccountMap.put(entity.getAccountId(), entity.getAccountName());
        }
        MemCache.empAccountMap = empAccountMap;
    }
}

