/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import cn.hutool.core.map.MapUtil;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.GmSpaceComponentDefinitionDao;
import com.ustc.base.entity.GmSpaceComponentDefinition;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmSpaceComponentDefinitionService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmSpaceComponentDefinitionDao gmspacecomponentdefinitionDao;

    public GmSpaceComponentDefinition findGmSpaceComponentDefinition(Long id) {
        GmSpaceComponentDefinition entity = (GmSpaceComponentDefinition)this.gmspacecomponentdefinitionDao.findById(id).get();
        return entity;
    }

    public void saveGmSpaceComponentDefinition(GmSpaceComponentDefinition entity) {
        this.gmspacecomponentdefinitionDao.save(entity);
    }

    public JsonMsg delGmSpaceComponentDefinition(Long id) {
        JsonMsg msg = new JsonMsg();
        String useSapce = this.bSqlHelper.getStringValue("base.GmSpaceComponentDefinition.getUseSpace", MapUtil.of((Object)"id", (Object)id));
        if (StringUtils.isNotBlank((String)useSapce)) {
            msg.setSuccess(false);
            msg.setMsg("\u5f53\u524d\u7ec4\u4ef6\u5df2\u88ab\u7a7a\u95f4[" + useSapce + "]\u5f15\u7528,\u6682\u65f6\u65e0\u6cd5\u5220\u9664");
            return msg;
        }
        GmSpaceComponentDefinition entity = (GmSpaceComponentDefinition)this.gmspacecomponentdefinitionDao.findById(id).get();
        entity.setIsUse("N");
        this.gmspacecomponentdefinitionDao.save(entity);
        return msg;
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order, String componentName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)componentName)) {
            params.put("componentName", "%" + componentName.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceComponentDefinition.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<ComBoxTreeNode> spaceComponentTree() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceComponentDefinition.spaceComponentTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> spaceComponentTreeFilter(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("spaceId", spaceId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceComponentDefinition.spaceComponentTreeFilter", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<Map<String, Object>> getSpaceComponentByCategory(String category) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        return this.bSqlHelper.getMapList("base.GmSpaceComponentDefinition.getSpaceComponentByCategory", params);
    }
}

