/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import cn.hutool.core.map.MapUtil;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.dao.GmSpaceComponentAssociatedDao;
import com.ustc.base.dao.GmSpaceComponentDefinitionDao;
import com.ustc.base.entity.GmInfoType;
import com.ustc.base.entity.GmSpaceComponentAssociated;
import com.ustc.base.entity.GmSpaceComponentDefinition;
import com.ustc.base.service.GmInfoTypeService;
import com.ustc.base.service.GmSpaceDefineService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmSpaceComponentAssociatedService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmSpaceComponentAssociatedDao gmspacecomponentassociatedDao;
    @Autowired
    private GmInfoTypeService gminfotypeService;
    @Autowired
    private GmSpaceComponentDefinitionDao gmSpaceComponentDefinitionDao;
    @Autowired
    private GmSpaceDefineService gmSpaceDefineService;

    public GmSpaceComponentAssociated findGmSpaceComponentAssociated(Long id) {
        GmSpaceComponentAssociated entity = (GmSpaceComponentAssociated)this.gmspacecomponentassociatedDao.findById(id).get();
        String componentId = entity.getComponentId();
        String componentType = entity.getComponentType();
        String columnNames = "";
        if ("1".equals(componentType)) {
            if (componentId.indexOf(",") == -1) {
                GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                columnNames = columnNames + gmInfoType.getTypeName();
            } else {
                String[] ids;
                for (String cid : ids = componentId.split(",")) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(cid));
                    columnNames = columnNames + gmInfoType.getTypeName() + " ";
                }
            }
        } else if (componentId.indexOf(",") == -1) {
            GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
            columnNames = columnNames + gmSpaceComponentDefinition.getComponentName();
        } else {
            String[] ids;
            for (String cid : ids = componentId.split(",")) {
                GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(cid)).get();
                columnNames = columnNames + gmSpaceComponentDefinition.getComponentName() + " ";
            }
        }
        entity.setComponentName(columnNames);
        return entity;
    }

    public void saveGmSpaceComponentAssociated(GmSpaceComponentAssociated entity) {
        this.gmspacecomponentassociatedDao.save(entity);
    }

    public void delGmSpaceComponentAssociated(Long id) {
        GmSpaceComponentAssociated entity = (GmSpaceComponentAssociated)this.gmspacecomponentassociatedDao.findById(id).get();
        entity.setIsUse("N");
        this.gmspacecomponentassociatedDao.save(entity);
    }

    public List<Map<String, Object>> findBySpaceId(Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("spaceId", spaceId);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceComponentAssociated.findBySpaceId", params);
        for (Map<String, Object> map : list) {
            String[] ids;
            String componentId = (String)map.get("componentId");
            String columnNames = "";
            if ("1".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                    columnNames = columnNames + gmInfoType.getTypeName();
                } else {
                    for (String id : ids = componentId.split(",")) {
                        GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(id));
                        columnNames = columnNames + gmInfoType.getTypeName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if ("2".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
                    columnNames = columnNames + gmSpaceComponentDefinition.getComponentName();
                    map.put("linkAddress", gmSpaceComponentDefinition.getLinkAddress());
                } else {
                    for (String id : ids = componentId.split(",")) {
                        GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(id)).get();
                        columnNames = columnNames + gmSpaceComponentDefinition.getComponentName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if (!"3".equals(map.get("componentType").toString())) continue;
            map.put("componentName", this.bSqlHelper.getStringValue("report.reportBase.getReportNameById", MapUtil.of((Object)"componentId", (Object)componentId)));
        }
        return list;
    }

    public void deleteBySpaceId(Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("spaceId", spaceId);
        }
        this.bSqlHelper.updateOrDelete("base.GmSpaceComponentAssociated.deleteBySpaceId", params);
    }

    public Integer countInfoTypeIsOrNotUse(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int info = 0;
        List<GmSpaceComponentAssociated> list = this.bSqlHelper.getList("base.GmSpaceComponentAssociated.countInfoTypeIsOrNotUse", params, GmSpaceComponentAssociated.class);
        for (GmSpaceComponentAssociated associated : list) {
            String componentId = associated.getComponentId();
            if (componentId.indexOf(id + "") == -1) continue;
            info = 1;
            return info;
        }
        return info;
    }

    public Map<String, Object> findPublishScopeByTypeId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("typeId", "%" + id + "%");
        }
        String userId = "";
        String userName = "";
        List<Map<String, Object>> mapList = this.bSqlHelper.getMapList("base.GmSpaceComponentAssociated.findPublishScopeByTypeId", params);
        for (Map<String, Object> map : mapList) {
            userId = userId + map.get("userType").toString() + ":" + map.get("userId").toString() + ",";
            userName = userName + map.get("userName").toString() + ",";
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (!mapList.isEmpty() && StringUtils.isNotBlank((String)userId)) {
            userId = userId.substring(0, userId.length() - 1);
            userName = userName.substring(0, userName.length() - 1);
            info.put("userId", userId);
            info.put("userName", userName);
        }
        return info;
    }
}

