/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import cn.hutool.core.util.ObjectUtil;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.GmInfoContentDao;
import com.ustc.base.dao.GmInfoPublishScopeDao;
import com.ustc.base.entity.GmInfoContent;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.common.FileService;
import com.ustc.doc.dao.DocFormFileDao;
import com.ustc.doc.entity.DocFormFile;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.service.PubFlowRelateService;
import com.ustc.webservice.sms.ISmsManagerService;
import com.ustc.workflow.service.FlowUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmInfoContentService {
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private GmInfoContentDao gminfocontentDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFormFileDao docformfileDao;
    @Autowired
    private GmInfoPublishScopeDao gminfopublishscopeDao;
    @Autowired
    private FileService fileService;
    @Autowired
    private PubFlowRelateService pubFlowRelateService;
    @Autowired(required=false)
    private ISmsManagerService smsManagerService;

    public GmInfoContent findGmInfoContent(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", id);
        GmInfoContent entity = this.bSqlHelper.getEntity("base.GmInfoContent.getEntityById", params, GmInfoContent.class);
        entity.setWriterBy_TEXT_(entity.getWriterByText());
        ArrayList<String> pklist = new ArrayList<String>();
        pklist.add(String.valueOf(id));
        List<DocFormFile> fileList = this.docformfileDao.findByFormIdAndFileTypeIdAndPrimaryKeyInAndIsUseOrderByDisplayNo("0", "0", pklist, "Y");
        for (DocFormFile doc : fileList) {
            String fileName = doc.getFileName();
            int l = fileName.lastIndexOf(".");
            if (l == -1) continue;
            String fileType = fileName.substring(l + 1, fileName.length());
            if ("x".equals(fileType.substring(0, fileType.length() - 1))) {
                fileType = fileType.substring(0, fileType.length() - 1);
            }
            doc.setFileType(fileType);
        }
        entity.setPanelfilelist(fileList);
        return entity;
    }

    public GmInfoContent saveGmInfoContent(GmInfoContent entity) {
        this.gminfocontentDao.save(entity);
        this.gminfocontentDao.flush();
        return entity;
    }

    public GmInfoContent saveGmInfoContent(GmInfoContent entity, FormFileBean formfile, String formcode) {
        this.gminfocontentDao.save(entity);
        this.gminfocontentDao.flush();
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getInfoId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
        this.pubFlowRelateService.savePubFlowRelateList(entity.getPfrList(), entity.getInfoId(), formcode);
        return entity;
    }

    public void delGmInfoContent(Long id) {
        GmInfoContent entity = (GmInfoContent)this.gminfocontentDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.gminfocontentDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public void publishEvent(Long id) {
        GmInfoContent entity = (GmInfoContent)this.gminfocontentDao.findById(id).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        List<Long> reciveIds = this.bSqlHelper.getList("base.GmInfoContent.getScopeAccountId", params, Long.class);
        this.msgService.saveMessage(entity.getProcessinstid(), entity.getContentTitle(), "", reciveIds, "/GmInfoContent/previewGmInfoContent?id=" + id, "3", "GmInfoContent", id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, String query, int page, int rows, String sort, String order, Long accountId, Long infoTypeId, String contentTitle, String publishPerson, String publishStart, String publishEnd, String keyWord, Boolean myPublish) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)query)) {
            params.put("query", query);
        }
        if (!StringUtils.isEmpty((String)keyWord)) {
            params.put("keyWord", "%" + keyWord + "%");
        }
        if (flowDone != null) {
            params.put("flowsql", " and (t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") or t.processinstid is null) \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        params.put("accountId", accountId);
        if (infoTypeId != null) {
            params.put("infoTypeId", infoTypeId);
        }
        if (!StringUtils.isEmpty((String)contentTitle)) {
            params.put("contentTitle", "%" + contentTitle + "%");
        }
        if (!StringUtils.isEmpty((String)publishPerson)) {
            params.put("publishPerson", "%" + publishPerson + "%");
        }
        if (!StringUtils.isEmpty((String)publishStart)) {
            params.put("publishStart", publishStart);
        }
        if (!StringUtils.isEmpty((String)publishEnd)) {
            params.put("publishEnd", publishEnd);
        }
        if (myPublish != null && myPublish.booleanValue()) {
            params.put("myPublish", " and t.PUBLISH_ACCONT_ID =" + user.getAccountid() + "\n");
        }
        return this.bSqlHelper.serachPage("base.GmInfoContent.select", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject PageHistory(String search, String query, int page, int rows, String sort, String order, Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (infoId != null) {
            GmInfoContent infoContent = this.findGmInfoContent(infoId);
            if (infoContent != null && infoContent.getRootId() != null) {
                params.put("infoId", infoContent.getRootId());
            } else {
                params.put("infoId", infoId);
            }
        }
        return this.bSqlHelper.serachPage("base.GmInfoContent.selectHistory", params, PageRequest.of((int)page, (int)rows));
    }

    public Map<String, Object> findGmInfoContentInfo(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        params.put("accountId", user.getAccountid());
        params.put("id", id);
        return this.bSqlHelper.getMap("base.GmInfoContent.findGmInfoContentInfo", params);
    }

    public List<Map<String, Object>> findContentById(String typeId, Long accountid, Long org, Long dept, int page, int rows, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId.split(","));
        if (accountid != null) {
            params.put("accountid", accountid);
        }
        if (org != null) {
            params.put("org", org);
        }
        if (dept != null) {
            params.put("dept", dept);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        params.put("hidenContent", "Y");
        params.put("hideExtra", "Y");
        PageObject<Map<String, Object>> obj = this.bSqlHelper.serachPage("base.GmInfoContent.findContent", params, PageRequest.of((int)page, (int)rows));
        List<Map<String, Object>> list = obj.getRows();
        if (list.size() > 0) {
            list.get(0).put("total", obj.getTotal());
        }
        return list;
    }

    public List<Map<String, Object>> findTenContentById(String typeId, Long accountid, Long org, Long dept) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId.split(","));
        if (accountid != null) {
            params.put("accountid", accountid);
        }
        if (org != null) {
            params.put("org", org);
        } else {
            params.put("org", "0");
        }
        if (dept != null) {
            params.put("dept", dept);
        } else {
            params.put("dept", "0");
        }
        params.put("hidenContent", "Y");
        return this.bSqlHelper.serachPage("base.GmInfoContent.findContent", params, PageRequest.of((int)1, (int)11)).getRows();
    }

    public PageObject<Map<String, Object>> pageTenContentById(String typeId, Long accountid, Long org, Long dept, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ObjectUtil.isNotEmpty((Object)typeId)) {
            params.put("typeId", typeId.split(","));
        }
        if (accountid != null) {
            params.put("accountid", accountid);
        }
        if (org != null) {
            params.put("org", org);
        } else {
            params.put("org", "0");
        }
        if (dept != null) {
            params.put("dept", dept);
        } else {
            params.put("dept", "0");
        }
        params.put("hidenContent", "Y");
        return this.bSqlHelper.serachPage("base.GmInfoContent.findContent", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> findImgContent(String typeIds, int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)typeIds)) {
            params.put("typeId", typeIds.split(","));
        }
        LoginUser user = SysUtils.getLoginUser();
        params.put("accountid", user.getAccountid());
        params.put("org", user.getOrgid());
        params.put("dept", user.getDeptid());
        params.put("isPicNews", "Y");
        params.put("hidenContent", "Y");
        return this.bSqlHelper.serachPage("base.GmInfoContent.findContent", params, PageRequest.of((int)1, (int)limit)).getRows();
    }

    public PageObject<Map<String, Object>> findPicNewsContent(String typeIds, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        params.put("accountid", user.getAccountid());
        params.put("org", user.getOrgid());
        params.put("dept", user.getDeptid());
        params.put("hidenContent", "Y");
        if (StringUtils.isNotBlank((String)typeIds)) {
            params.put("typeId", typeIds.split(","));
        }
        return this.bSqlHelper.serachPage("base.GmInfoContent.findPicNews", params, PageRequest.of((int)page, (int)rows));
    }

    public GmInfoContent findGmInfoContentBussiness(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("bussinessId", id);
        }
        return this.bSqlHelper.getEntity("base.GmInfoContent.findContentBybussinessId", params, GmInfoContent.class);
    }

    public Integer findCreateByAccountId(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        List<GmInfoContent> list = this.bSqlHelper.getList("base.GmInfoContent.findCreateByAccountId", params, GmInfoContent.class);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Integer findCheckByAccountId(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        List<GmInfoContent> list = this.bSqlHelper.getList("base.GmInfoContent.findCheckByAccountId", params, GmInfoContent.class);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public GmInfoContent saveHistoryData(GmInfoContent entity) {
        GmInfoContent history = new GmInfoContent();
        GmInfoContent infoContent = this.findGmInfoContent(entity.getInfoId());
        Integer count = this.findDataCountByInfoId(entity.getInfoId());
        entity.setVersionNo(String.valueOf((double)count.intValue() + 1.0));
        if (count > 0) {
            BeanUtils.copyProperties((Object)infoContent, (Object)history, (String[])new String[]{"infoId"});
            history.setIsHistory("Y");
            history.setRootId(entity.getInfoId());
            this.saveGmInfoContent(history);
        }
        return entity;
    }

    public Integer findDataCountByInfoId(Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", infoId);
        Integer count = this.bSqlHelper.getIntValue("base.GmInfoContent.findDataCountByInfoId", params);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public List<ComBoxTreeNode> findGmInfoTypeData(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmInfoContent.findGmInfoTypeData", params);
        return CommTreeUtils.buildTreeNode(list);
    }
}

