/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.google.common.collect.Maps;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.CommonService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class FirstPageService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMessageService basMessageService;
    private Object loginUser;

    public List<Map<String, Object>> findAccountTodoList(Long accountid) {
        List<Map<String, Object>> msglist = this.basMessageService.findAccountToDoList(accountid);
        return msglist;
    }

    public Double keyitemLoanplanmoney(Long accountid) {
        String sql = "select round(sum(s.apply_mooney),2) as plan_money\n  from b_fm_loan_plan t, b_fm_loan_plan_prj s\n where t.loan_plan_id = s.loan_plan_id\n   and to_char( t.loan_month ,'yyyy-mm') = to_char(sysdate,'yyyy-mm') \n   and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and t.workflow_status = '3'\n   and t.is_use = 'Y'\n   and s.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemLoanreceivemoney1(Long accountid) {
        String sql = "select round(sum(t.receive_money)/10000,2) as receive_money\n  from b_fm_loan_receive t\n where to_char( t.loan_month ,'yyyy-mm') = to_char(sysdate,'yyyy-mm')\n   and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and t.loan_type = '1'\n   and t.workflow_status = '3'\n   and t.is_success = 'Y'\n   and t.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemLoanreceivemoney2(Long accountid) {
        String sql = "select round(sum(t.receive_money)/10000,2) as receive_money\n  from b_fm_loan_receive t\n where to_char( t.loan_month ,'yyyy-mm') = to_char(sysdate,'yyyy-mm')\n   and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and t.loan_type = '2'\n   and t.workflow_status = '3'\n   and t.is_success = 'Y'\n   and t.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Long keyitemRiskATotal(Long accountid) {
        String sql = "select count(l.risk_level) as total_a\n  from b_risk_patrol_problem t, b_risk_patrol_problem_list l\n where t.patrol_problem_id = l.patrol_problem_id\n   and substr(to_char(t.workflow_status), -1, 1) <> '1'\n   and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and t.is_use = 'Y'\n   and l.is_use = 'Y'\n   and l.risk_level = '1'\n   and l.risk_patrol_problem_list_id not in\n       (select s.risk_patrol_problem_list_id\n          from b_risk_reform_report_list s\n         where s.is_use = 'Y'\n           and s.is_reform_complete = 'Y')";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Long.parseLong(o.toString());
        }
        return 0L;
    }

    public Long keyitemRiskANew(Long accountid) {
        String sql = "select count(l.risk_level) as month_a_new\n  from b_risk_patrol_problem t, b_risk_patrol_problem_list l\n where t.patrol_problem_id = l.patrol_problem_id\n   and substr(to_char(t.workflow_status), -1, 1) <> '1'\n   and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and to_char(t.patrol_date, 'yyyy-mm') = to_char(sysdate,'yyyy-mm') \n   and t.is_use = 'Y'\n   and l.is_use = 'Y'\n   and l.risk_level = '1'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Long.parseLong(o.toString());
        }
        return 0L;
    }

    public Long keyitemRiskAReform(Long accountid) {
        String sql = "select count(l.reform_report_list_id) as month_a_reform\n  from b_risk_reform_report       t,\n       b_risk_reform_report_list  l,\n       b_risk_patrol_problem      r,\n       b_risk_patrol_problem_list p\n where t.reform_report_id = l.reform_report_id\n   and t.patrol_problem_id = r.patrol_problem_id\n   and l.risk_patrol_problem_list_id = p.risk_patrol_problem_list_id\n   and p.risk_level = '1'\n   and t.workflow_status = '3'\n   and r.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and to_char(l.reform_complete_date, 'yyyy-mm') = to_char(sysdate,'yyyy-mm') \n   and t.is_use = 'Y'\n   and l.is_use = 'Y'\n   and l.is_reform_complete = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Long.parseLong(o.toString());
        }
        return 0L;
    }

    public Double keyitemRiskAMoney(Long accountid) {
        String sql = "select round(sum(p.total_pmcon_money)/10000,2) total_pmcon_money\n  from b_risk_patrol_problem t,\n       v_pm_con_pay p,\n       (select t.patrol_problem_id, count(l.risk_level) as total_a\n          from b_risk_patrol_problem t, b_risk_patrol_problem_list l\n         where t.patrol_problem_id = l.patrol_problem_id\n           and substr(to_char(t.workflow_status), -1, 1) <> '1'\n           and t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n           and t.is_use = 'Y'\n           and l.is_use = 'Y'\n           and l.risk_level = '1'\n           and l.risk_patrol_problem_list_id not in\n               (select r.risk_patrol_problem_list_id\n                  from b_risk_reform_report_list r\n                 where r.is_use = 'Y'\n                   and r.is_reform_complete = 'Y')\n         group by t.patrol_problem_id) s\n where t.pmcon_id = p.pmcon_id\n   and t.patrol_problem_id = s.patrol_problem_id\n   and s.total_a > 0";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemFreezeShould() {
        String sql = " select round(sum(ifnull(t.freeze_money, 0) - ifnull(r.unfreeze_money, 0) -\n           ifnull(s.draw_money, 0))/10000,2) as should_freeze\n  from B_RISK_FREEZE t,\n       (select a1.freeze_id, sum(a1.unfreeze_money) as unfreeze_money\n          from B_RISK_UNFREEZE a1\n         where a1.is_use = 'Y'\n         group by a1.freeze_id) r,\n       (select a2.freeze_id, sum(a2.draw_money) as draw_money\n          from B_RISK_DRAWING a2\n         where a2.is_freeze = 1\n           and a2.is_use = 'Y'\n         group by a2.freeze_id) s\n where t.freeze_id = r.freeze_id(+)\n   and t.freeze_id = s.freeze_id(+)\n   and t.is_use = 'Y' and t.freeze_status <> '2' and ( ifnull(t.freeze_money, 0) - ifnull(r.unfreeze_money, 0) - ifnull(s.draw_money, 0))>0 ";
        Object o = this.sqlHelper.getSingal(sql);
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemFreezeMonth(Long accountid) {
        String sql = "select round(sum(t.freeze_money)/10000,2) as freeze_money\n  from b_risk_freeze t\n where t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1) \n   and to_char(t.freeze_start, 'yyyy-mm') <= to_char(sysdate,'yyyy-mm') \n   and to_char(t.freeze_end, 'yyyy-mm') >= to_char(sysdate,'yyyy-mm') \n   and t.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemFreezeMonthUn(Long accountid) {
        String sql = "select round(sum(t.unfreeze_money)/10000,2) as unfreeze_money\n  from b_risk_unfreeze t\n where t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and to_char(t.unfreeze_time, 'yyyy-mm') = to_char(sysdate,'yyyy-mm')\n   and t.workflow_status = '3'\n   and t.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public Double keyitemFreezeMonthDraw(Long accountid) {
        String sql = "select round(sum(t.draw_money)/10000,2) as draw_money\n  from b_risk_drawing t\n where t.org_id in (select distinct x.org_id from BAS_FINANCE_ORG_RIGHT x where x.account_id=?1)\n   and to_char(t.draw_date, 'yyyy-mm') = to_char(sysdate,'yyyy-mm')\n   and t.workflow_status = '3'\n   and t.is_use = 'Y'";
        Object o = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return 0.0;
    }

    public PageObject pageBRiska(Long accountid, String search, int page, int rows, String sort, String order, String riskType) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select  decode(t.patrol_type,'1','\u5de1\u67e5\u7ba1\u7406','2','\u8ddf\u8e2a\u5ba1\u8ba1','3','\u5176\u4ed6\u98ce\u9669') risk_source, t.patrol_no,p.project_name,c.pmcon_name,o.contact_org_name,c.pmcon_money,\n decode(l.patrol_type,'1', d.dic_text, d2.dic_text)  dic_text,\n l.exist_problem,DATE_FORMAT(t.PATROL_DATE,'%Y-%m-%d') PATROL_DATE,t.processinstid,t.pmcon_id,p.project_id,o.contact_org_id,t.patrol_problem_id,t.patrol_type\nfrom   B_RISK_PATROL_PROBLEM t\n");
        if (!"3".equals(riskType)) {
            sql.append("left join B_RISK_PATROL_PROBLEM_LIST l on l.patrol_problem_id = t.patrol_problem_id and l.is_use=:isUse\n");
        } else {
            sql.append("left join b_risk_reform_report r on r.patrol_problem_id = t.patrol_problem_id and r.is_use=:isUse\n\n");
            sql.append("left join b_risk_reform_report_list rl on r.reform_report_id = rl.reform_report_id and rl.is_use=:isUse\n\n");
            sql.append("left join B_RISK_PATROL_PROBLEM_LIST l on rl.risk_patrol_problem_list_id = l.risk_patrol_problem_list_id and l.is_use=:isUse\n");
        }
        sql.append("left join b_pm_project p on p.project_id=t.project_id and p.is_use=:isUse\nleft join b_pm_contract c on c.pmcon_id=t.pmcon_id and c.is_use=:isUse\nleft join BAS_CONTACT_ORG o on o.contact_org_id = c.party_B and o.is_use=:isUse\nleft join bas_dic d on d.dic_value=l.patrol_type and d.dic_code='PATROL_TYPE_IN'\nleft join bas_dic d2 on d2.dic_value=l.patrol_type and d2.dic_code='PATROL_TYPE_OUT'\nwhere l.risk_level=:riskLevel and t.is_use=:isUse    and substr(to_char(t.workflow_status), -1, 1) <> '1' \n");
        params.put("isUse", "Y");
        params.put("riskLevel", "1");
        if ("1".equals(riskType)) {
            sql.append("   and l.risk_patrol_problem_list_id not in\n       (select s.risk_patrol_problem_list_id\n          from b_risk_reform_report_list s\n         where s.is_use = 'Y'\n           and s.is_reform_complete = 'Y')");
        } else if ("2".equals(riskType)) {
            sql.append("   and to_char(t.patrol_date, 'yyyy-mm') = to_char(sysdate,'yyyy-mm') \n");
        } else {
            sql.append("   and r.workflow_status = '3'\n");
            sql.append("   and to_char(rl.reform_complete_date, 'yyyy-mm') = to_char(sysdate,'yyyy-mm') \n");
            sql.append("   and rl.is_reform_complete = 'Y' \n");
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.patrol_no) like :search ");
            sql.append(" or upper(p.project_name) like :search ");
            sql.append(" or upper(c.pmcon_name) like :search ");
            sql.append(" or upper(o.contact_org_name) like :search ");
            sql.append(" or upper(l.exist_problem) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.patrol_no");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject pageBRisk(String search, int page, int rows, String sort, String order, String riskType, String risklevel, String startDate, String endDate) throws ParseException {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select  decode(t.patrol_type,'1','\u5de1\u67e5\u7ba1\u7406','2','\u8ddf\u8e2a\u5ba1\u8ba1','3','\u5176\u4ed6\u98ce\u9669') risk_source, t.patrol_no,p.project_name,c.pmcon_name,\n t.remark,DATE_FORMAT(t.PATROL_DATE,'%Y-%m-%d') PATROL_DATE,t.patrol_type\nfrom   B_RISK_PATROL_PROBLEM t\n");
        sql.append("left join B_RISK_PATROL_PROBLEM_LIST l on l.patrol_problem_id = t.patrol_problem_id and l.is_use=:isUse\n");
        sql.append(" left join b_pm_project p on p.project_id=t.project_id and p.is_use=:isUse\n");
        sql.append(" left join b_pm_contract c on c.pmcon_id=t.pmcon_id and c.is_use=:isUse\n");
        sql.append(" where l.risk_level=:riskLevel and t.is_use=:isUse \n");
        sql.append(" and t.workflow_status=:workStatus \n");
        params.put("isUse", "Y");
        params.put("workStatus", SysContent.PASS_STATUS);
        params.put("riskLevel", risklevel);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" and t.PATROL_DATE between :startDate and :endDate ");
        params.put("startDate", sdf.parse(startDate));
        params.put("endDate", sdf.parse(endDate));
        if ("reform".equals(riskType)) {
            sql.append("   and l.risk_patrol_problem_list_id  in (select distinct r.risk_patrol_problem_list_id \n");
            sql.append("     from b_Risk_Reform_Report_List r \n");
            sql.append("    where r.is_use = 'Y' and r.is_reform_complete = 'Y') \n");
        }
        if ("rest".equals(riskType)) {
            sql.append("   and l.risk_patrol_problem_list_id not in (select distinct r.risk_patrol_problem_list_id \n");
            sql.append("     from b_Risk_Reform_Report_List r \n");
            sql.append("    where r.is_use = 'Y' and r.is_reform_complete = 'Y') \n");
        }
        if ("outTime".equals(riskType)) {
            sql.append("   and l.risk_patrol_problem_list_id not in (select distinct r.risk_patrol_problem_list_id \n");
            sql.append("     from b_Risk_Reform_Report_List r \n");
            sql.append("    where r.is_use = 'Y' and r.is_reform_complete = 'Y') \n");
            sql.append("   and t.patrol_date < sysdate \n");
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.patrol_no) like :search ");
            sql.append(" or upper(p.project_name) like :search ");
            sql.append(" or upper(c.pmcon_name) like :search ");
            sql.append(" or upper(l.exist_problem) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.patrol_no");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessage> getAccountMessageList(Long accountid) {
        return this.getAccountMessageList(accountid, SysContent.MSG_ALERT);
    }

    public List<BasMessage> getAccountMessageList(Long accountid, Long type) {
        List<BasMessage> msglist = this.basMessageService.getAccountMessageList(accountid, type);
        Collections.sort(msglist);
        return msglist;
    }

    public Map<String, Object> getProjectInfo() {
        String sql = "SELECT  COUNT( 1 ) AS PROJECT_NUM,  to_char(SUM( T.PROJECT_MONEY ),'FM999,999,999,999,999.0000') AS SUM_PROJECT_MONEY,  COUNT( CASE WHEN T.PROJECT_STATUS = '1' THEN 1 ELSE NULL END ) AS PREPARATION,  COUNT( CASE WHEN T.PROJECT_STATUS = '2' THEN 1 ELSE NULL END ) AS CONSTRUCTION,  COUNT( CASE WHEN T.PROJECT_STATUS = '3' THEN 1 ELSE NULL END ) AS AUDITING,  COUNT( CASE WHEN T.PROJECT_STATUS = '4' THEN 1 ELSE NULL END ) AS COMPLETED,  COUNT( CASE WHEN T.PROJECT_STATUS = '5' THEN 1 ELSE NULL END ) AS ARCHIVE  FROM  B_PM_PROJECT T  WHERE  T.IS_USE = 'Y' ";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        Map map = Maps.newHashMap();
        if (list != null && !list.isEmpty()) {
            map = (Map)list.get(0);
        }
        return map;
    }
}

