/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.dao.BasFundSourceDao;
import com.ustc.base.dao.BasSouceAllotDao;
import com.ustc.base.entity.BasFundSource;
import com.ustc.base.entity.BasSouceAllot;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSouceAllotService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasSouceAllotDao basSouceAllotDao;
    @Autowired
    private BasFundSourceDao basFundSourceDao;

    public BasSouceAllot findBasSouceAllot(Long id) {
        BasSouceAllot entity = (BasSouceAllot)this.basSouceAllotDao.findById(id).get();
        return entity;
    }

    public void saveBasSouceAllot(Long orgid, String fundSourceIds) {
        if (orgid == null) {
            return;
        }
        this.basSouceAllotDao.deleteByOrgId(orgid);
        String prefix = "";
        if (orgid.equals(SysContent.ORG_ID_TFJT)) {
            prefix = "1-";
        }
        ArrayList<BasSouceAllot> entities = new ArrayList<BasSouceAllot>();
        if (StrKit.notBlank(fundSourceIds)) {
            String[] ids;
            for (String fundSourceId : ids = fundSourceIds.split(",")) {
                BasFundSource entity = (BasFundSource)this.basFundSourceDao.findById(Long.parseLong(fundSourceId)).get();
                if (entity == null) continue;
                BasSouceAllot newentity = new BasSouceAllot();
                newentity.setIsUse("Y");
                newentity.setFundSourceId(entity.getFundSourceId());
                newentity.setOrgId(orgid);
                newentity.setAllotCode(prefix + entity.getFundSourceCode());
                entities.add(newentity);
            }
        }
        this.basSouceAllotDao.saveAll(entities);
    }

    public void delBasSouceAllot(Long id) {
        BasSouceAllot entity = (BasSouceAllot)this.basSouceAllotDao.findById(id).get();
        entity.setIsUse("N");
        this.basSouceAllotDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasSouceAllot.select", params, PageRequest.of((int)page, (int)rows));
    }
}

