/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasModelDao;
import com.ustc.base.dao.BasRolesModelDao;
import com.ustc.base.entity.BasModel;
import com.ustc.base.entity.BasRoles;
import com.ustc.base.entity.BasRolesModel;
import com.ustc.base.service.BasRolesService;
import com.ustc.base.service.CommonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesModelService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesModelDao basrolesmodelDao;
    @Autowired
    private BasModelDao basModelDao;
    @Autowired
    private BasRolesService basRolesService;

    public BasRolesModel findBasRolesModel(Long id) {
        BasRolesModel entity = (BasRolesModel)this.basrolesmodelDao.findById(id).get();
        return entity;
    }

    public List<BasModel> findAccountModel(Long accountid) {
        ArrayList<BasModel> list = new ArrayList<BasModel>();
        ArrayList<Long> modelidlist = new ArrayList<Long>();
        List<BasRolesModel> rolemodellist = this.basrolesmodelDao.findByAccoutId(accountid);
        rolemodellist = this.basrolesmodelDao.findByAccoutId(accountid);
        for (BasRolesModel basRolesModel : rolemodellist) {
            if (modelidlist.contains(basRolesModel.getModelId())) continue;
            BasModel model = (BasModel)this.basModelDao.findById(basRolesModel.getModelId()).get();
            list.add(model);
            modelidlist.add(basRolesModel.getModelId());
        }
        return list;
    }

    private List<BasRolesModel> getBasRolesModelsByProject(Long projectId, Long accountid) {
        String sql = "select t.* from Bas_Roles_Model t where  t.role_Id in ( select b.ROLE_NAME from PM_PLOT_PEOPLE a  LEFT JOIN PM_PERSON b ON A.JOBNAME=b.ID  where instr(a.name||',',?1||',')>0  and a.project_id=?2 and b.role_name is not null union select DECODE( (select COUNT(1) from  B_PM_PROJECT c where c.project_id=?2 and c.PROJECT_MGR=?1) , 1, 1000000)  as role_name  from dual)and  t.model_Id not in (select c.model_Id from Bas_Model c where c.model_Type = 3 and c.is_Use = 'Y') order by t.role_Id,t.display_No";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{accountid, projectId}, BasRolesModel.class, new int[0]);
    }

    public void saveBasRolesModel(BasRolesModel entity) {
        this.basrolesmodelDao.save(entity);
    }

    public void delBasRolesModel(Long id) {
        this.basrolesmodelDao.deleteById(id);
    }

    public PageObject PageAll(Long roleid, Long orgid, Long deptid, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.rolemodel_id,t.role_id,t.model_id,a.model_title,a.model_type,a.model_width from BAS_ROLES_MODEL t  \n");
        sql.append(" left join  BAS_MODEL a on t.model_id=a.model_id \n");
        sql.append(" where t.role_id=:roleid \n");
        if (roleid != 0L) {
            BasRoles role = this.basRolesService.findBasRoles(roleid);
            String roleType = role.getRoleType();
            if ("dept".equals(roleType) && deptid != null) {
                sql.append(" and t.dept_id = :deptid \n");
                params.put("deptid", deptid);
            } else if ("org".equals(roleType) && orgid != null) {
                sql.append(" and t.org_id = :orgid \n");
                params.put("orgid", orgid);
            }
        }
        params.put("roleid", roleid);
        sql.append(" order by t.DISPLAY_NO");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MODEL_TYPE", "MODEL_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject pageRolesNoModel(Long roleid, Long orgid, Long deptid, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        String sqltemp = "";
        if (roleid != 0L) {
            BasRoles role = this.basRolesService.findBasRoles(roleid);
            String roleType = role.getRoleType();
            if ("dept".equals(roleType) && deptid != null) {
                sqltemp = " and A.dept_id = " + deptid;
            } else if ("org".equals(roleType) && orgid != null) {
                sqltemp = " and A.org_id = " + orgid;
            }
        }
        sql.append("select * from BAS_MODEL t   ");
        sql.append(" where  t.is_use=:isUse and t.model_id not in (select a.model_id from BAS_ROLES_MODEL a where a.role_id=:roleid " + sqltemp + ") ");
        params.put("isUse", "Y");
        params.put("roleid", roleid);
        sql.append(" order by t.model_title");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MODEL_TYPE", "MODEL_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public void moveInBasRolesModel(Long roleid, Long orgid, Long deptid, String modelidstr) {
        String[] modelids;
        if (roleid == null) {
            return;
        }
        BasRoles role = this.basRolesService.findBasRoles(roleid);
        String roleType = role.getRoleType();
        for (String modelid : modelids = modelidstr.split(",")) {
            BasRolesModel entity = "dept".equals(roleType) && deptid != null ? this.basrolesmodelDao.findByRoleIdAndDeptIdAndModelId(roleid, deptid, Long.parseLong(modelid)) : ("org".equals(roleType) && orgid != null ? this.basrolesmodelDao.findByRoleIdAndOrgIdAndModelId(roleid, orgid, Long.parseLong(modelid)) : this.basrolesmodelDao.findByRoleIdAndModelId(roleid, Long.parseLong(modelid)));
            if (entity != null) continue;
            BasRolesModel newentity = new BasRolesModel();
            newentity.setRoleId(roleid);
            newentity.setOrgId(orgid);
            newentity.setDeptId(deptid);
            newentity.setModelId(Long.parseLong(modelid));
            newentity.setDisplayNo(100L);
            this.basrolesmodelDao.save(newentity);
        }
    }
}

