/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasMenuButtonDao;
import com.ustc.base.dao.BasMenuDao;
import com.ustc.base.dao.BasRolesMenuDao;
import com.ustc.base.entity.BasMenuButton;
import com.ustc.base.entity.BasRoles;
import com.ustc.base.entity.BasRolesMenu;
import com.ustc.base.service.BasRolesService;
import com.ustc.base.service.CommonService;
import com.ustc.sys.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesMenuService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesMenuDao basrolesmenuDao;
    @Autowired
    private BasMenuButtonDao basmenubuttonDao;
    @Autowired
    private BasMenuDao basmenuDao;
    @Autowired
    private BasRolesService basRolesService;

    public BasRolesMenu findBasRolesMenu(Long id) {
        BasRolesMenu entity = (BasRolesMenu)this.basrolesmenuDao.findById(id).get();
        return entity;
    }

    public void saveBasRolesMenu(Long roleid, Long orgid, Long deptid, String addmenuids, String addbuttonids, String delmenuids, String delbuttonids) {
        if (roleid == null) {
            return;
        }
        BasRoles role = this.basRolesService.findBasRoles(roleid);
        String roleType = role.getRoleType();
        List<Long> menuIds = ListUtils.stringToListWithLong(delmenuids);
        List<Long> buttonIds = ListUtils.stringToListWithLong(delbuttonids);
        if ("dept".equals(roleType) && deptid != null) {
            this.basrolesmenuDao.deleteByRoleIdAndDeptIdAndMenuIdIn(roleid, deptid, menuIds);
            this.basrolesmenuDao.deleteByRoleIdAndDeptIdAndButtonIdIn(roleid, deptid, buttonIds);
        } else if ("org".equals(roleType) && orgid != null) {
            this.basrolesmenuDao.deleteByRoleIdAndOrgIdAndMenuIdIn(roleid, orgid, menuIds);
            this.basrolesmenuDao.deleteByRoleIdAndOrgIdAndButtonIdIn(roleid, orgid, buttonIds);
        } else {
            this.basrolesmenuDao.deleteByRoleIdAndMenuIdIn(roleid, menuIds);
            this.basrolesmenuDao.deleteByRoleIdAndButtonIdIn(roleid, buttonIds);
        }
        ArrayList<BasRolesMenu> entities = new ArrayList<BasRolesMenu>();
        if (StrKit.notBlank(addmenuids)) {
            String[] menus;
            for (String menuid : menus = addmenuids.split(",")) {
                BasRolesMenu newentity = new BasRolesMenu();
                newentity.setMenuId(Long.parseLong(menuid));
                newentity.setRoleId(roleid);
                if ("dept".equals(roleType) && deptid != null) {
                    if (this.basrolesmenuDao.findByRoleIdAndMenuIdAndDeptId(roleid, Long.parseLong(menuid), orgid) != null) continue;
                    newentity.setOrgId(orgid);
                    newentity.setDeptId(deptid);
                } else if ("org".equals(roleType) && orgid != null) {
                    newentity.setOrgId(orgid);
                }
                entities.add(newentity);
            }
        }
        if (StrKit.notBlank(addbuttonids)) {
            String[] buttons;
            String[] stringArray = buttons = addbuttonids.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String multid;
                String buttonid = multid = stringArray[i];
                BasMenuButton btn = (BasMenuButton)this.basmenubuttonDao.findById(Long.parseLong(buttonid)).get();
                BasRolesMenu newentity = new BasRolesMenu();
                newentity.setMenuId(btn.getMenuId());
                newentity.setRoleId(roleid);
                if ("dept".equals(roleType) && deptid != null) {
                    newentity.setOrgId(orgid);
                    newentity.setDeptId(deptid);
                } else if ("org".equals(roleType) && orgid != null) {
                    newentity.setOrgId(orgid);
                }
                newentity.setButtonId(Long.parseLong(buttonid));
                entities.add(newentity);
            }
        }
        this.basrolesmenuDao.saveAll(entities);
        SysUtils.clearShiroCache();
    }

    public void delBasRolesMenu(Long id) {
        this.basrolesmenuDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from BAS_ROLES_MENU t  order by t.ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_ROLES_MENU t where   upper(t.ID) like ?1  or upper(t.ROLE_ID) like ?1  or upper(t.MENU_ID) like ?1  order by t.ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComBoxTreeNode> findRoleMenutree(Long roleid, Long orgid, Long deptid) {
        String sqltemp = "";
        if (roleid != 0L) {
            BasRoles role = this.basRolesService.findBasRoles(roleid);
            String roleType = role.getRoleType();
            if ("dept".equals(roleType) && deptid != null) {
                sqltemp = " and A.dept_id = " + deptid;
            } else if ("org".equals(roleType) && orgid != null) {
                sqltemp = " and A.org_id = " + orgid;
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t.id id,\n       T.pid,\n       t.text text,\n       t.keyid,\n       t.nodetype,\n       t.ico,\n       t.state,\n       case when t.nodetype=0 then \n              (SELECT case when count(A.ID)=0 then  0 else  1 end\n                 FROM BAS_ROLES_MENU A\n                WHERE  A.MENU_ID = T.keyid AND A.ROLE_ID = ?1 " + sqltemp + " \n                  ) when  1 then\n              (SELECT case when count(A.ID)=0 then  0 else  1 end\n                 FROM BAS_ROLES_MENU A\n                WHERE A.ROLE_ID = ?1 " + sqltemp + " \n                  AND A.button_id = T.keyid) end as checked\n  FROM (with recursive temp as(\nselect concat('m' ,a.menu_id) id,\n               concat('m', a.pmenu_id) pid,\n               a.menu_id as keyid,\n               a.menu_name as text,\n               0 as nodetype,\n               0 as groupno,\n               a.display_no,\n               'icon-folder' as ico,\n               null as state\n          from BAS_MENU a\n         WHERE a.IS_USE = 'Y'\n           and a.ENABLE = 'Y'\n        union\n        select concat('b' ,b.button_id),\n               concat('m',b.menu_id) pid,\n               b.button_id as keyid,\n               b.button_text as text,\n               1 as nodetype,\n               b.group_no as groupno,\n               b.display_no,\n               'icon-button' as ico,\n               null as state\n          from bas_menu_button b\n         where b.is_use = 'Y'\n           and b.is_control = 'Y'),\n  menu as(\n select * from temp where  temp.pid = 'm0'\n union all\n select temp.* from temp,menu where menu.id=temp.pid\n )\n select * from menu) T order by t.groupno,T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{roleid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> findRoleMenutreeByAccount(Long accountId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT t.id id,\n       T.pid,\n       t.text text,\n       t.keyid,\n       t.nodetype,\n       t.ico,\n       (SELECT decode(count(A.MENU_TOP_ID), 0, 0, 1)\n          FROM BAS_ROLES_MENU_TOP A\n         WHERE A.ACCOUNT_ID = :accountId\n           AND A.MENU_ID = T.keyid) as checked\n  FROM (select distinct 'm' || t.menu_id id,\n                        'm' || t.pmenu_id pid,\n                        t.menu_id as keyid,\n                        t.menu_name as text,\n                        0 as nodetype,\n                        0 as groupno,\n                        t.display_no,\n                        'icon-folder' as ico\n          from BAS_MENU t\n          left join BAS_ROLES_MENU r\n            on r.menu_id = t.menu_id\n          left join bas_roles_account a\n            on a.role_id = r.role_id\n         WHERE t.IS_USE = 'Y'\n           and a.account_id = :accountId) T\n START WITH T.pid = 'm0'\nCONNECT BY PRIOR T.id = T.pid\n ORDER BY t.groupno, T.DISPLAY_NO ");
        params.put("accountId", accountId);
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

