/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasPushSettingsDao;
import com.ustc.base.entity.BasPushSettings;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasPushSettingsService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasPushSettingsDao baspushsettingsDao;

    public BasPushSettings findBasPushSettings(Long id) {
        BasPushSettings entity = (BasPushSettings)this.baspushsettingsDao.getOne(id);
        return entity;
    }

    public void saveBasPushSettings(List<BasPushSettings> list, LoginUser loginUser) {
        for (BasPushSettings entity : list) {
            entity.setIsUse("Y");
            if (entity.getPushSettingsId() == null) {
                entity.setCreateAccount(loginUser.getAccountid());
                entity.setCreateTime(new Date());
                this.baspushsettingsDao.save(entity);
                continue;
            }
            entity.setModifyAccount(loginUser.getAccountid());
            entity.setModifyTime(new Date());
            this.baspushsettingsDao.save(entity);
        }
    }

    public void delBasPushSettings(Long id) {
        BasPushSettings entity = (BasPushSettings)this.baspushsettingsDao.getOne(id);
        entity.setIsUse("N");
        this.baspushsettingsDao.save(entity);
    }

    public PageObject PageAll(String search, String warningId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)warningId)) {
            params.put("warningId", warningId);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.searchPage("base.BasPushSettings.select", params, PageRequest.of((int)page, (int)rows));
    }
}

