/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasModelDao;
import com.ustc.base.entity.BasModel;
import com.ustc.base.service.CommonService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasModelService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasModelDao basmodelDao;

    public BasModel findBasModel(Long id) {
        BasModel entity = (BasModel)this.basmodelDao.findById(id).get();
        return entity;
    }

    public void saveBasModel(BasModel entity) {
        this.basmodelDao.save(entity);
    }

    public void delBasModel(Long id) {
        BasModel entity = (BasModel)this.basmodelDao.findById(id).get();
        entity.setIsUse("N");
        this.basmodelDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from BAS_MODEL t where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.MODEL_ID) like :search ");
            sql.append(" or upper(t.MODEL_TITLE) like :search ");
            sql.append(" or upper(t.MODEL_TYPE) like :search ");
            sql.append(" or upper(t.MODEL_URL) like :search ");
            sql.append(" or upper(t.MODEL_WIDTH) like :search ");
            sql.append(" or upper(t.MEMO) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.MODEL_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MODEL_TYPE", "MODEL_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<Map<String, Object>> findBasModelPageByAccountId(Long accountId) {
        String sql = null;
        sql = "select distinct a.model_id, a.model_title, a.model_url\n  from BAS_MODEL a, BAS_ROLES_MODEL b, bas_roles_account c\n where a.model_id = b.model_id\n   and b.role_id = c.role_id\n   and a.is_use = 'Y'\n   and a.model_type = 3\n   and c.account_id = ?1\n order by a.model_id";
        Object[] params = new Object[]{accountId};
        List resultList = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return resultList;
    }
}

