/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasMenuButtonDao;
import com.ustc.base.entity.BasMenuButton;
import com.ustc.base.service.CommonService;
import com.ustc.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMenuButtonService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMenuButtonDao basmenubuttonDao;

    public List<BasMenuButton> findByMenuId(Long id) {
        return this.basmenubuttonDao.findByMenuIdAndIsUseOrderByDisplayNo(id, "Y");
    }

    public List<BasMenuButton> findByMenuIdAndAccountid(Long menuid, Long accountid) {
        return this.basmenubuttonDao.findByMenuIdAndAccountId(menuid, accountid);
    }

    public List<BasMenuButton> findByAccountId(Long accountid) {
        return this.basmenubuttonDao.findByAccountId(accountid);
    }

    public BasMenuButton findBasMenuButton(Long id) {
        BasMenuButton entity = (BasMenuButton)this.basmenubuttonDao.findById(id).get();
        return entity;
    }

    public void saveBasMenuButton(BasMenuButton entity) {
        this.basmenubuttonDao.save(entity);
    }

    public void delBasMenuButton(Long id) {
        BasMenuButton entity = (BasMenuButton)this.basmenubuttonDao.findById(id).get();
        entity.setIsUse("N");
        this.basmenubuttonDao.save(entity);
    }

    public PageObject PageAll(Long menuid, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from BAS_MENU_BUTTON t where t.is_use=:isUse and t.menu_id=:menuid and ifnull(t.type,'custom')!='public'");
        params.put("isUse", "Y");
        params.put("menuid", menuid);
        sql.append(" order by t.GROUP_NO,t.DISPLAY_NO");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("BUTTON_TYPE", "BUTTON_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public Object findByMenuIdAndAccountid2(Long menuId, Long accountid, Long projectId) {
        String sql = "select * from BAS_MENU_BUTTON t where t.IS_USE='Y'  AND T.MENU_ID=?1  and ( t.IS_CONTROL='N' OR T.BUTTON_ID IN (SELECT DISTINCT A.BUTTON_ID FROM BAS_ROLES_MENU A WHERE A.MENU_ID=?1 AND A.ROLE_ID IN ( select e.role_name from ( select b.ROLE_NAME from PM_PLOT_PEOPLE a  LEFT JOIN PM_PERSON b ON A.JOBNAME=b.ID  where instr(a.name||',',?2||',')>0  and a.project_id=?3 and b.role_name is not null\r\n UNION\r\n select DECODE( (select COUNT(1) from  B_PM_PROJECT c where c.project_id=?3 and c.PROJECT_MGR=?2) , 1, 1000000)  as role_name  from dual) e where e.role_name is not null)) OR T.BUTTON_ID in(select b.BUTTON_ID from BAS_MENU_BUTTON b ,bas_menu m where m.MENU_ID=?1 and m.PERMISSION_CONTROL='N' and b.MENU_ID=?1) )    ORDER BY  t.DISPLAY_NO  ,t.group_No";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{menuId, accountid, projectId}, BasMenuButton.class, new int[0]);
        return list;
    }

    public Object saveBasMenuButtonByType(BasMenuButton entity, String ischeck) {
        String sql = "select BUTTON_ID from bas_menu_button where BUTTON_HTMLID=:BUTTON_HTMLID and MENU_ID=:MENU_ID and is_use='Y'";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BUTTON_HTMLID", entity.getButtonHtmlid());
        params.put("MENU_ID", entity.getMenuId());
        Object object = this.sqlHelper.getSingal(sql, params);
        if (StringUtil.isEmpty(object)) {
            if ("Y".equals(ischeck)) {
                entity.setIsUse("Y");
                this.saveBasMenuButton(entity);
            }
        } else if ("N".equals(ischeck)) {
            this.delBasMenuButton(Long.parseLong(object.toString()));
        }
        return new JsonMsg();
    }

    public String findFormCodeById(long menuId) {
        String sql = "select FORM_CODE from bas_menu where MENU_ID=:menuId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("menuId", menuId);
        String formCode = "";
        try {
            formCode = this.sqlHelper.getSingal(sql, params).toString();
        }
        catch (Exception e) {
            formCode = "";
        }
        return formCode;
    }
}

