/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasGroupDao;
import com.ustc.base.entity.BasGroup;
import com.ustc.base.entity.BasGroupAccountRelate;
import com.ustc.base.service.BasGroupAccountRelateService;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasGroupService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasGroupDao basgroupDao;
    @Autowired
    private BasGroupAccountRelateService basGroupAccountRelateService;

    public BasGroup findBasGroup(Long id) {
        BasGroup entity = (BasGroup)this.basgroupDao.findById(id).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("groupId", id);
        }
        Map<String, Object> mapUseUser = this.bSqlHelper.getMap("base.BasGroup.getComponentsByGroupId", params);
        entity.setGroupComponent((String)mapUseUser.get("userId"));
        entity.setGroupComponent_TEXT_((String)mapUseUser.get("userName"));
        return entity;
    }

    public void saveBasGroup(BasGroup entity) {
        this.basgroupDao.save(entity);
        this.basGroupAccountRelateService.deleteByGroupId(entity.getGroupId());
        String groupComponent = entity.getGroupComponent();
        if (StringUtils.isNotBlank((String)groupComponent)) {
            String[] ids;
            for (String id : ids = groupComponent.split(",")) {
                BasGroupAccountRelate b = new BasGroupAccountRelate();
                String[] split = id.split(":");
                b.setGroupId(entity.getGroupId());
                b.setUserType(split[0]);
                b.setUserId(Long.parseLong(split[1]));
                b.setModifyAccount(SysUtils.getLoginUser().getAccountid());
                b.setModifyTime(new Date());
                b.setIsUse("Y");
                b.setCreateAccount(SysUtils.getLoginUser().getAccountid());
                b.setCreateTime(new Date());
                this.basGroupAccountRelateService.saveBasGroupAccountRelate(b);
            }
        }
    }

    public void delBasGroup(Long id) {
        BasGroup entity = (BasGroup)this.basgroupDao.findById(id).get();
        entity.setIsUse("N");
        this.basgroupDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order, String mgrFilter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)mgrFilter)) {
            params.put("mgrFilter", mgrFilter);
            params.put("accountId", SysUtils.getLoginUser().getAccountid());
        }
        return this.bSqlHelper.serachPage("base.BasGroup.select", params, PageRequest.of((int)page, (int)rows));
    }
}

