/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.dao.BasFundSourceDao;
import com.ustc.base.entity.BasDept;
import com.ustc.base.entity.BasFundSource;
import com.ustc.base.service.BasDeptService;
import com.ustc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasFundSourceService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasFundSourceDao basfundsourceDao;
    @Autowired
    private BasDeptService basdeptService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public BasFundSource findBasFundSource(Long id) {
        BasDept basd;
        BasFundSource entity = (BasFundSource)this.basfundsourceDao.findById(id).get();
        if (entity.getUnderDept() != null && (basd = this.basdeptService.findByDeptId(entity.getUnderDept())) != null) {
            entity.setUnderDept_TEXT_(basd.getDeptName());
        }
        return entity;
    }

    public void saveBasFundSource(BasFundSource entity) {
        this.basfundsourceDao.save(entity);
    }

    public void delBasFundSource(Long id) {
        this.basfundsourceDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select t.*, \n (SELECT a.ACCOUNT_NAME \n          FROM BAS_EMP_ACCOUNT a \n         WHERE a.account_id = t.modify_account) AS MODIFY_ACCOUNT_NAME \n from BAS_FUND_SOURCE t WHERE t.is_use = 'Y' order by t.DISPLAY_NO,t.FUND_SOURCE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select t.*, \n\t(SELECT a.ACCOUNT_NAME \n\t\tFROM BAS_EMP_ACCOUNT a \n\t\tWHERE a.account_id = t.modify_account) AS MODIFY_ACCOUNT_NAME\n from BAS_FUND_SOURCE t where  t.is_use = 'Y'  and (upper(t.FUND_SOURCE_ID) like ?1  or upper(t.FUND_SOURCE_CODE) like ?1  or upper(t.FUND_SOURCE) like ?1  or upper(t.FUND_SOURCE_PID) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.MODIFY_ACCOUNT) like ?1  or upper(t.MODIFY_TIME) like ?1  or upper(t.IS_USE) like ?1)  order by DISPLAY_NO,t.FUND_SOURCE_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    public void delBasFundSourceAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tDELETE FROM \tBAS_FUND_SOURCE T \n\tWHERE \tT.FUND_SOURCE_ID in ( \n\twith recursive temp as \n\t(select m.* from BAS_FUND_SOURCE m \n\twhere   m.FUND_SOURCE_ID = ?1  and m.is_use='Y' \n\tunion all\t\n\tselect m.* from BAS_FUND_SOURCE m,temp\t\n\twhere  m.FUND_SOURCE_PID=temp.FUND_SOURCE_ID and m.is_use='Y')\t\n\tselect t.FUND_SOURCE_ID from temp t\t\n\twhere t.is_use='Y'\t\n\torder by t.FUND_SOURCE_ID )\t\n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public List<ComBoxTreeNode> treeBasFundSource(Long pid, String isRepay, String pids, String systemType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        if (StrKit.notBlank(pids)) {
            String[] pidsArr = pids.split(",");
            params.put("pids", Arrays.asList(pidsArr));
        }
        if (!StringUtil.isEmpty(systemType)) {
            params.put("systemType", systemType);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasFundSource.treeSelect", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeBasFundSourceAllot(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasFundSource.treeBasFundSourceAllot", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComboxNode> getBasFundSourceComb(String isRepay, String fundSourceType, String isdetail) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT \tt.FUND_SOURCE_ID value, \n");
        sql.append("     \tt.FUND_SOURCE text \n");
        sql.append(" FROM \tBAS_FUND_SOURCE T WHERE t.is_use =:isUse \n");
        params.put("isUse", "Y");
        if (!"true".equals(isdetail)) {
            if (StringUtils.isNotBlank((String)isRepay) && !"null".equals(isRepay)) {
                sql.append(" and t.is_Repay=:isRepay\n");
                params.put("isRepay", isRepay);
            }
            sql.append(" and t.fund_source_pid<>0");
        }
        if (StringUtils.isNotBlank((String)fundSourceType) && !"null".equals(fundSourceType)) {
            sql.append(" and t.fund_Source_Type in(:fundSourceType)\n");
            params.put("fundSourceType", Arrays.asList(fundSourceType.split(",")));
        }
        sql.append(" order by t.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> treeBasFundSourcePart(String pids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pids", pids);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasFundSource.treeSelectPart", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public PageObject queryFundSourceMonth(Long orgId, String month, String search, int page, int rows) {
        PageObject<Map<String, Object>> p = new PageObject<Map<String, Object>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrKit.notNull(orgId, month)) {
            params.put("startMonth", month.substring(0, 4) + "-01");
            params.put("endMonth", month);
            params.put("orgId", orgId);
            List<Map<String, Object>> queryList = this.bSqlHelper.getMapList("base.BasFundSource.queryFundSourceYear", params);
            ArrayList list = new ArrayList();
            for (Map<String, Object> map : queryList) {
                if ("0".equals(Objects.toString(map.get("pid"), ""))) {
                    map.put("pid", null);
                }
                map.put("_parentId", map.get("pid"));
            }
            p.setRows(queryList);
        }
        return p;
    }

    public BasFundSource findOneDataById(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id == null) {
            return new BasFundSource();
        }
        params.put("id", id);
        return this.bSqlHelper.getEntity("base.BasFundSource.findOneDataById", params, BasFundSource.class);
    }

    public PageObject countFundSourceMonth(Long orgId, String month, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrKit.notNull(orgId, month)) {
            params.put("startMonth", month.substring(0, 4) + "-01");
            params.put("endMonth", month);
            params.put("orgId", orgId);
            return this.bSqlHelper.serachPage("base.BasFundSource.countFundSourceMonth", params, PageRequest.of((int)page, (int)rows));
        }
        return null;
    }
}

