/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasDicDao;
import com.ustc.base.entity.BasDic;
import com.ustc.base.service.MemCacheService;
import com.ustc.sys.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasDicService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDicDao dicDao;
    @Autowired
    private MemCacheService memCacheService;

    public JsonMsg checkRepeat(BasDic dictype) {
        JsonMsg msg = new JsonMsg();
        List<BasDic> list = this.dicDao.findByDicCodeAndDicTextAndDicValue(dictype.getDicCode(), dictype.getDicText(), dictype.getDicValue());
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getDicId().equals(dictype.getDicId())) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public BasDic findDic(Long dicId) {
        return (BasDic)this.dicDao.findById(dicId).get();
    }

    public List<BasDic> findByDicCodeAndValue(String dicCode, String dicValue) {
        List<BasDic> list = this.dicDao.findByDicCodeAndDicValueAndIsEnableOrderByDisplayNoAsc(dicCode, dicValue, "1");
        return list;
    }

    public Object findDicDB(Long dicId) {
        String sql = "select * from bas_dic t  where t.dic_id=?1";
        return this.sqlHelper.getSingal(sql, new Object[]{dicId});
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void saveDic(BasDic dictype) {
        this.dicDao.save(dictype);
        this.memCacheService.setDicCache();
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void delDic(Long dictypeid) {
        this.dicDao.deleteById(dictypeid);
    }

    public void delDic(String dicids) {
        for (String id : dicids.split(",")) {
            this.delDic(Long.parseLong(id));
        }
    }

    public PageObject PageAll(Long typeId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId);
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search + "%");
        }
        PageObject<Map<String, Object>> obj = this.bSqlHelper.serachPage("base.dic.select", params, PageRequest.of((int)page, (int)rows));
        obj.getRows().forEach(map -> {
            if ("0".equals(map.get("pdicId"))) {
                map.put("_parentId", null);
            } else {
                map.put("_parentId", map.get("pdicId"));
            }
        });
        return obj;
    }

    public String findDicText(String type) {
        if (StringUtils.isNotEmpty((String)type)) {
            String sql = "select t.dic_text from BAS_DIC t where t.dic_code='SYSTYPE' and t.dic_value=" + type;
            String type_text = (String)this.sqlHelper.getSingal(sql);
            return type_text;
        }
        return null;
    }

    public void updateData(Long id, String dicCode, String dicName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", id);
        List<BasDic> list = this.bSqlHelper.getList("base.dic.findByTypeId", params, BasDic.class);
        for (BasDic d : list) {
            d.setDicCode(dicCode);
            d.setDicName(dicName);
            this.dicDao.save(d);
        }
    }

    public List<ComboxNode> getWbsType(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.dic.getWbsType", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public PageObject PageDicByDicCode(Long menuid, int page, int rows, String dicCode) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select b.DIC_TEXT BUTTON_TEXT,b.DIC_VALUE BUTTON_HTMLID,b.MEMO from bas_dic b where b.DIC_CODE=:dicCode  ");
        params.put("dicCode", dicCode);
        sql.append(" order by b.DISPLAY_NO");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        String sqlMenue = "select MENU_TYPE from bas_menu  where MENU_ID=:menuid";
        HashMap<String, Object> paramsNew = new HashMap<String, Object>();
        paramsNew.put("menuid", menuid);
        PageObject pageObjectNew = this.sqlHelper.pagerNativeSQL(sqlMenue, paramsNew, (Integer)page, (Integer)rows);
        if (pageObjectNew.getRows().size() == 0) {
            return new PageObject();
        }
        Map mapMenu = (Map)pageObjectNew.getRows().get(0);
        String menuType = mapMenu.get("MENU_TYPE").toString();
        if (!"2".equals(menuType)) {
            return new PageObject();
        }
        List listOld = pageobject.getRows();
        if (listOld.size() == 0) {
            return pageobject;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        for (int i = 0; i < listOld.size(); ++i) {
            Map map = (Map)listOld.get(i);
            String code = (String)map.get("BUTTON_HTMLID");
            char flag = this.checkCode(code, menuid);
            String memo = this.getMeMo(code, menuid);
            map.put("IS_CHECK", Character.valueOf(flag));
            map.put("MENU_ID", menuid);
            map.put("MEMO", memo);
            list.add(map);
        }
        pageobject.setRows(list);
        return pageobject;
    }

    public char checkCode(String code, long menuid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        String newCode = code + "%";
        sql.append("select count(0) from bas_menu_button b where b.BUTTON_HTMLID like :newCode and b.MENU_ID=:menuid and is_use='Y'");
        params.put("menuid", menuid);
        params.put("newCode", newCode);
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)1, (Integer)30);
        Map map = (Map)pageobject.getRows().get(0);
        int count = Integer.parseInt(map.get("COUNT(0)").toString());
        if (count == 0) {
            return 'N';
        }
        return 'Y';
    }

    public String getMeMo(String code, long menuid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String newCode = code + "%";
        params.put("menuid", menuid);
        params.put("newCode", newCode);
        String sql = "select MEMO from bas_menu_button b where b.BUTTON_HTMLID=:newCode and b.MENU_ID=:menuid and is_use='Y'";
        String memo = "";
        try {
            memo = this.sqlHelper.getSingal(sql, params).toString();
        }
        catch (Exception e) {
            memo = "";
        }
        return memo;
    }

    public List<BasDic> findByDicCode(String dicCode) {
        return this.dicDao.findByDicCodeAndIsEnable(dicCode, "1");
    }

    public BasDic findByDicCodeAndDicText(String dicCode, String dicText) {
        return this.dicDao.findByDicCodeAndDicText(dicCode, dicText);
    }

    public List<ComboxNode> getComboByDicValues(String ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ids != null) {
            if (",".equals(Character.valueOf(ids.charAt(0)))) {
                ids = ids.substring(1);
            }
            params.put("ids", ListUtils.stringToListWithLong(ids));
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.dic.getComboByDicValues", params);
        return ComboxUtils.buildComboxNodes(list);
    }
}

