/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasContactOrgAccountDao;
import com.ustc.base.entity.BasContactOrgAccount;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasContactOrgAccountService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasContactOrgAccountDao bascontactorgaccountDao;

    public BasContactOrgAccount findBasContactOrgAccount(Long id) {
        BasContactOrgAccount entity = (BasContactOrgAccount)this.bascontactorgaccountDao.findById(id).get();
        return entity;
    }

    public List<BasContactOrgAccount> findByContactOrgId(Long contactOrgId) {
        return this.bascontactorgaccountDao.findByContactOrgId(contactOrgId);
    }

    public void saveBasContactOrgAccount(BasContactOrgAccount entity) {
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.bascontactorgaccountDao.save(entity);
    }

    public void delBasContactOrgAccount(Long id) {
        this.bascontactorgaccountDao.deleteById(id);
    }

    public void delBasContactOrgAccount(List<BasContactOrgAccount> entities, Long userId) {
        for (BasContactOrgAccount entity : entities) {
            entity.setIsUse("N");
            entity.setModifyAccount(userId);
            entity.setModifyTime(new Date());
        }
        this.bascontactorgaccountDao.saveAll(entities);
    }

    public void delContactOrgAccount(List<BasContactOrgAccount> entities) {
        this.bascontactorgaccountDao.deleteAll(entities);
    }

    public PageObject PageAll(String contactOrgId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select t.*,\n\t(SELECT a.ACCOUNT_NAME \n\t\tFROM BAS_EMP_ACCOUNT a \n\t\tWHERE a.account_id = t.modify_account) AS ACCOUNT_NAME, \n\tDATE_FORMAT(t.modify_time,'%Y-%m-%d %H:%i:%s') MODIFY_TIME_F \n from BAS_CONTACT_ORG_ACCOUNT t WHERE t.contact_org_id = ?1 AND t.is_use = 'Y' order by t.ORG_ACCOUNT_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select t.*, \n\t(SELECT a.ACCOUNT_NAME \n\t\tFROM BAS_EMP_ACCOUNT a \n\t\tWHERE a.account_id = t.modify_account) AS MODIFY_ACCOUNT_NAME\n from BAS_CONTACT_ORG_ACCOUNT t where \tt.contact_org_id = ?1 AND t.is_use = 'Y' AND ( upper(t.ORG_ACCOUNT_ID) like ?2  or upper(t.CONTACT_ORG_ID) like ?2  or upper(t.ORG_USERNAME) like ?2  or upper(t.ORG_BANK_ACCOUNT) like ?2  or upper(t.ORG_OPEN_BANK) like ?2  or upper(t.ORG_UNIONPAY_NO) like ?2  or upper(t.STATUS) like ?2  or upper(t.MEMO) like ?2  or upper(t.MODIFY_ACCOUNT) like ?2  or upper(t.MODIFY_TIME) like ?2  or upper(t.IS_USE) like ?2 ) order by t.ORG_ACCOUNT_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{contactOrgId, "%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{contactOrgId}, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("STATUS", "DATA_STATUS");
        dicmapper.put("IS_USE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject pageContactOrgAccountSelect(String contactOrgTypeId, String contactOrgId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "select t.*,\n       a.org_username,\n       a.org_bank_account,\n       a.org_open_bank,\n       a.org_unionpay_no\n  from BAS_CONTACT_ORG_ACCOUNT a, BAS_CONTACT_ORG t\n WHERE t.contact_org_id = a.contact_org_id\n";
        if (StringUtils.isNotEmpty((String)contactOrgTypeId)) {
            sql = sql + "   AND (t.contact_org_type_id = :contactOrgTypeId or\n       t.contact_org_type_id in\n       (SELECT ot.CONTACT_ORG_TYPE_ID\n           FROM BAS_CONTACT_ORG_TYPE ot\n          START WITH ot.contact_org_type_pid = :contactOrgTypeId\n         connect by prior ot.CONTACT_ORG_TYPE_ID = ot.CONTACT_ORG_TYPE_PID))\n";
            params.put("contactOrgTypeId", contactOrgTypeId);
        }
        if (StringUtils.isNotEmpty((String)contactOrgId)) {
            sql = sql + "  and t.contact_org_id=:contactOrgId\n";
            params.put("contactOrgId", contactOrgId);
        }
        sql = sql + "   AND t.is_use = :isUse\n   AND a.status = '1'\n   AND a.is_use = :isUse\n order by t.contact_org_id, a.org_account_id";
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql = sql + "and  ( or upper(t.CONTACT_ORG_NAME) like :search  or upper(t.CONTACT_ORG_CODE) like :search  or upper(o.ORG_USERNAME) like :search  or upper(o.ORG_BANK_ACCOUNT) like :search  or upper(o.ORG_OPEN_BANK) like :search  or upper(o.ORG_UNIONPAY_NO) like :search )";
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        pageobject = this.sqlHelper.pagerNativeSQL(sql, params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("STATUS", "DATA_STATUS");
        dicmapper.put("IS_USE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

